/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.ui.adapter.invite;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.kvo.FindFriend;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.game.R;
import com.yy.hiyo.game.base.teamgame.IInviteCallback;
import com.yy.hiyo.game.base.teamgame.ITeamInviteAdapter;
import com.yy.hiyo.game.base.teamgame.InviteEntrance;
import com.yy.hiyo.game.base.teamgame.InviteEntranceItem;
import com.yy.hiyo.game.base.teamgame.InviteFriendData;
import com.yy.hiyo.game.base.teamgame.InviteFriendItem;
import com.yy.hiyo.game.base.teamgame.InviteItem;
import java.util.ArrayList;
import java.util.List;

public class InviteAdapter
extends RecyclerView.Adapter<VH>
implements ITeamInviteAdapter {
    private final List<InviteItem> datas = new ArrayList<InviteItem>();
    private IInviteCallback mCallback;
    private boolean isLandscape = false;

    public InviteAdapter() {
        this.isLandscape = false;
    }

    public InviteAdapter(boolean isLandscape) {
        this.isLandscape = isLandscape;
    }

    @NonNull
    public VH onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == 0) {
            int layoutId = this.isLandscape ? R.layout.item_user_invite_land : R.layout.item_user_invite;
            return new FriendVH(this.mCallback, LayoutInflater.from((Context)parent.getContext()).inflate(layoutId, parent, false), this.isLandscape);
        }
        if (viewType == 1) {
            int layoutId = this.isLandscape ? R.layout.item_user_invite_land : R.layout.item_user_invite;
            return new EntranceVH(this.mCallback, LayoutInflater.from((Context)parent.getContext()).inflate(layoutId, parent, false));
        }
        return null;
    }

    public void onBindViewHolder(@NonNull VH holder, int position) {
        if (position < this.datas.size()) {
            holder.bindView(position, this.datas.get(position), this.mCallback);
        }
    }

    public int getItemViewType(int position) {
        return position < this.datas.size() ? this.datas.get(position).type() : -1;
    }

    public int getItemCount() {
        return this.datas.size();
    }

    public void setCallback(IInviteCallback mCallback) {
        this.mCallback = mCallback;
    }

    public RecyclerView.Adapter getAdapter() {
        return this;
    }

    public void setDatas(List<InviteItem> list) {
        this.datas.clear();
        if (list != null) {
            this.datas.addAll(list);
        }
        this.notifyDataSetChanged();
    }

    private static final class EntranceVH
    extends VH<InviteEntranceItem> {
        EntranceVH(final IInviteCallback callback2, View itemView) {
            super(callback2, itemView);
            this.ivAvatar = (CircleImageView)itemView.findViewById(R.id.iv_avatar);
            this.vStatus = (YYView)itemView.findViewById(R.id.iv_status);
            this.tvName = (YYTextView)itemView.findViewById(R.id.tv_name);
            this.tvInvite = (YYTextView)itemView.findViewById(R.id.tv_invite);
            this.tvInvite.setEnabled(false);
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (mData != null && ((InviteEntranceItem)mData).data != null && callback2 != null) {
                        if (((InviteEntrance)((InviteEntranceItem)mData).data).platForm == 0) {
                            callback2.onHagoClick();
                        } else {
                            callback2.onSharePlatformClick(((InviteEntrance)((InviteEntranceItem)mData).data).platForm);
                        }
                    }
                }
            });
            FontUtils.setFontType((TextView)this.tvInvite, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        }

        @Override
        void bindView(int position, InviteEntranceItem inviteEntranceItem, IInviteCallback callback2) {
            InviteEntrance data;
            this.mData = inviteEntranceItem;
            this.callback = callback2;
            this.vStatus.setVisibility(8);
            if (this.mData != null && (data = (InviteEntrance)((InviteEntranceItem)this.mData).data) != null) {
                this.ivAvatar.setImageDrawable(ResourceUtils.getDrawable((int)data.drawableRes));
                this.tvName.setText((CharSequence)data.name);
                if (TextUtils.isEmpty((CharSequence)data.desc)) {
                    this.tvInvite.setVisibility(4);
                } else {
                    this.tvInvite.setVisibility(0);
                    this.tvInvite.setText((CharSequence)data.desc);
                }
            }
        }
    }

    public static final class FriendVH
    extends VH<InviteFriendItem> {
        private boolean isLandscape = false;

        public FriendVH(final IInviteCallback callback2, View itemView, boolean isLandscape) {
            super(callback2, itemView);
            this.isLandscape = isLandscape;
            this.ivAvatar = (CircleImageView)itemView.findViewById(R.id.iv_avatar);
            this.vStatus = (YYView)itemView.findViewById(R.id.iv_status);
            this.tvName = (YYTextView)itemView.findViewById(R.id.tv_name);
            this.tvInvite = (YYTextView)itemView.findViewById(R.id.tv_invite);
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (mData == null || ((InviteFriendItem)mData).data == null || ((InviteFriendData)((InviteFriendItem)mData).data).mFriends == null) {
                        return;
                    }
                    if (!((InviteFriendData)((InviteFriendItem)mData).data).mFriends.isMatching() && !((InviteFriendData)((InviteFriendItem)mData).data).mFriends.isInGame() && ((InviteFriendData)((InviteFriendItem)mData).data).inviteState == 0) {
                        if (callback2 != null) {
                            callback2.onInviteClick((InviteFriendData)((InviteFriendItem)mData).data);
                        }
                    } else if (((InviteFriendData)((InviteFriendItem)mData).data).mFriends.isMatching()) {
                        ToastUtils.showToast((Context)v.getContext(), (String)ResourceUtils.getString((int)R.string.short_tips_in_team_can_not_invite), (int)0);
                    } else if (((InviteFriendData)((InviteFriendItem)mData).data).mFriends.isInGame()) {
                        ToastUtils.showToast((Context)v.getContext(), (String)ResourceUtils.getString((int)R.string.short_tips_in_game_can_not_invite), (int)0);
                    }
                }
            });
        }

        @Override
        void bindView(int position, InviteFriendItem inviteFriendItem, IInviteCallback callback2) {
            this.mData = inviteFriendItem;
            this.callback = callback2;
            if (this.mData != null) {
                FindFriend friend = ((InviteFriendData)((InviteFriendItem)this.mData).data).mFriends;
                if (friend != null) {
                    ImageLoader.loadBitmap((RecycleImageView)this.ivAvatar, (String)(friend.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)friend.getSex()));
                    this.tvName.setText((CharSequence)friend.getNick());
                    Drawable drawable2 = null;
                    if (friend.isInGame()) {
                        drawable2 = ResourceUtils.getDrawable((int)R.drawable.shape_in_game_no_border);
                    } else if (friend.isMatching()) {
                        drawable2 = ResourceUtils.getDrawable((int)R.drawable.shape_in_team_no_border);
                    } else if (friend.isOnline()) {
                        drawable2 = ResourceUtils.getDrawable((int)R.drawable.shape_online_no_border);
                    }
                    this.vStatus.setBackgroundDrawable(drawable2);
                }
                Kvo.removeKvoBinding((KvoSource)((KvoSource)((InviteFriendItem)this.mData).data), (Object)((Object)this), (String)"onInviteChange");
                Kvo.addKvoBinding((KvoSource)((KvoSource)((InviteFriendItem)this.mData).data), (Object)((Object)this), (String)"onInviteChange");
            }
        }

        @KvoMethodAnnotation(name="inviteState", sourceClass=InviteFriendData.class, thread=1)
        public void onInviteChange(KvoEventIntent event) {
            this.tvInvite.setVisibility(0);
            boolean invitable = ((InviteFriendData)((InviteFriendItem)this.mData).data).inviteState == 0;
            this.tvInvite.setVisibility(0);
            if (this.isLandscape) {
                this.tvInvite.setTextColor(invitable ? ResourceUtils.getColor((int)R.color.invite_text_color) : -6710887);
            } else {
                this.tvInvite.setTextColor(ResourceUtils.getColor((int)R.color.invite_text_color));
            }
            this.tvInvite.setBackgroundDrawable(invitable ? ResourceUtils.getDrawable((int)R.drawable.shape_invite_text_enable) : null);
            this.tvInvite.setText((CharSequence)ResourceUtils.getString((int)(invitable ? R.string.invite : R.string.invited)));
        }
    }

    public static abstract class VH<Data extends InviteItem>
    extends RecyclerView.ViewHolder {
        protected Data mData;
        protected CircleImageView ivAvatar;
        protected YYView vStatus;
        protected YYTextView tvName;
        protected YYTextView tvInvite;
        protected YYTextView tvContent;
        protected IInviteCallback callback;

        public VH(IInviteCallback callback2, View itemView) {
            super(itemView);
            this.callback = callback2;
        }

        abstract void bindView(int var1, Data var2, IInviteCallback var3);
    }
}

