/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.ui.adapter.invite;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.kvo.FindFriend;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.game.R;
import com.yy.game.gamemodule.teamgame.teammatch.ui.adapter.invite.InviteFriendPopItem;
import com.yy.hiyo.game.base.teamgame.InviteFriendData;
import com.yy.hiyo.game.base.teamgame.InviteItem;
import java.util.ArrayList;
import java.util.List;

public class HagoInviteAdapter
extends RecyclerView.Adapter<VH> {
    private final List<InviteItem> datas = new ArrayList<InviteItem>();
    private IInviteCallback mCallback;
    @LayoutRes
    private int mItemLayout;

    public HagoInviteAdapter(@LayoutRes int layoutId) {
        this.mItemLayout = layoutId;
    }

    @NonNull
    public VH onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == 2) {
            return new PopFriendVH(this.mCallback, LayoutInflater.from((Context)parent.getContext()).inflate(this.mItemLayout, parent, false));
        }
        return null;
    }

    public void onBindViewHolder(@NonNull VH holder, int position) {
        if (position < this.datas.size()) {
            holder.bindView(position, this.datas.get(position), this.mCallback);
        }
    }

    public int getItemViewType(int position) {
        return position < this.datas.size() ? this.datas.get(position).type() : -1;
    }

    public int getItemCount() {
        return this.datas.size();
    }

    public void setCallback(IInviteCallback mCallback) {
        this.mCallback = mCallback;
    }

    public void setDatas(List<InviteItem> list) {
        this.datas.clear();
        if (list != null) {
            this.datas.addAll(list);
        }
        this.notifyDataSetChanged();
    }

    public static interface IInviteCallback {
        public void onInviteClick(InviteFriendData var1);
    }

    private static final class PopFriendVH
    extends VH<InviteFriendPopItem> {
        PopFriendVH(final IInviteCallback callback2, View itemView) {
            super(callback2, itemView);
            this.ivAvatar = (CircleImageView)itemView.findViewById(R.id.iv_avatar);
            this.vStatus = (YYView)itemView.findViewById(R.id.v_status);
            this.tvName = (YYTextView)itemView.findViewById(R.id.tv_name);
            this.tvContent = (YYTextView)itemView.findViewById(R.id.tv_desc);
            this.tvInvite = (YYTextView)itemView.findViewById(R.id.tv_invite);
            this.tvInvite.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (callback2 != null && ((InviteFriendPopItem)mData).data != null && ((InviteFriendData)((InviteFriendPopItem)mData).data).mFriends != null && !((InviteFriendData)((InviteFriendPopItem)mData).data).mFriends.isMatching() && !((InviteFriendData)((InviteFriendPopItem)mData).data).mFriends.isInGame() && ((InviteFriendData)((InviteFriendPopItem)mData).data).inviteState == 0) {
                        callback2.onInviteClick((InviteFriendData)((InviteFriendPopItem)mData).data);
                    }
                }
            });
        }

        @Override
        void bindView(int position, InviteFriendPopItem inviteFriendItem, IInviteCallback callback2) {
            this.mData = inviteFriendItem;
            this.callback = callback2;
            if (this.mData != null) {
                FindFriend friend = ((InviteFriendData)((InviteFriendPopItem)this.mData).data).mFriends;
                if (friend != null) {
                    ImageLoader.loadBitmap((RecycleImageView)this.ivAvatar, (String)(friend.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)friend.getSex()));
                    this.tvName.setText((CharSequence)friend.getNick());
                    Drawable drawable2 = null;
                    if (friend.isInGame()) {
                        drawable2 = ResourceUtils.getDrawable((int)R.drawable.shape_in_game);
                    } else if (friend.isMatching()) {
                        drawable2 = ResourceUtils.getDrawable((int)R.drawable.shape_in_team);
                    } else if (friend.isOnline()) {
                        drawable2 = ResourceUtils.getDrawable((int)R.drawable.shape_online);
                    }
                    this.vStatus.setBackgroundDrawable(drawable2);
                    long type = friend.getType();
                    if (type == 0L) {
                        String nick = friend.getAlias();
                        if (nick != null && nick.length() > 12) {
                            nick = nick.substring(0, 12) + "...";
                        }
                        this.tvContent.setVisibility(0);
                        this.setString((TextView)this.tvContent, ResourceUtils.getString((int)R.string.xx_on_fb, (Object[])new Object[]{nick}));
                    } else if (type == 1L) {
                        String nick = friend.getAlias();
                        this.tvContent.setVisibility(0);
                        this.setString((TextView)this.tvContent, ResourceUtils.getString((int)R.string.xx_on_contact, (Object[])new Object[]{nick}));
                    } else {
                        this.tvContent.setVisibility(8);
                    }
                }
                Kvo.removeKvoBinding((KvoSource)((KvoSource)((InviteFriendPopItem)this.mData).data), (Object)((Object)this), (String)"onInviteChange");
                Kvo.addKvoBinding((KvoSource)((KvoSource)((InviteFriendPopItem)this.mData).data), (Object)((Object)this), (String)"onInviteChange");
            }
        }

        private void setString(TextView tvContent, String text) {
            TextPaint textPaint = tvContent.getPaint();
            textPaint.setTextSize(tvContent.getTextSize());
            float textLong = textPaint.measureText(text);
            int minWidth = ResolutionUtils.dip2Px((float)50.0f);
            int maxWidth = ResolutionUtils.dip2Px((float)89.0f);
            if (textLong > (float)maxWidth) {
                float curDip = ResolutionUtils.convertPixelsToDp((float)tvContent.getTextSize(), (Context)tvContent.getContext());
                for (float i = curDip - 1.0f; i > 0.0f; i -= 1.0f) {
                    float textSize = ResolutionUtils.dip2Px((float)i);
                    textPaint.setTextSize(textSize);
                    float curLong = textPaint.measureText(text);
                    if (!(curLong < (float)maxWidth)) continue;
                    int width = (int)((double)curLong + 0.5);
                    tvContent.setWidth(width);
                    break;
                }
            } else if (textLong < (float)minWidth) {
                tvContent.setWidth(minWidth);
            } else {
                tvContent.setWidth((int)textLong);
            }
            tvContent.setText((CharSequence)text);
        }

        @KvoMethodAnnotation(name="inviteState", sourceClass=InviteFriendData.class, thread=1)
        public void onInviteChange(KvoEventIntent event) {
            this.tvInvite.setVisibility(0);
            boolean invatable = ((InviteFriendData)((InviteFriendPopItem)this.mData).data).inviteState == 0;
            FindFriend friend = ((InviteFriendData)((InviteFriendPopItem)this.mData).data).mFriends;
            if (friend.isInGame() || friend.isMatching()) {
                this.tvInvite.setVisibility(4);
            } else {
                this.tvInvite.setVisibility(0);
                boolean online = ((InviteFriendData)((InviteFriendPopItem)this.mData).data).mFriends.getOnlineStatus() == 1L;
                this.tvInvite.setEnabled(invatable);
                if (invatable) {
                    this.setString((TextView)this.tvInvite, ResourceUtils.getString((int)(online ? R.string.invite : R.string.notify)));
                    this.tvInvite.setTextColor(ResourceUtils.getColor((int)R.color.white));
                    this.tvInvite.setBackgroundDrawable(ResourceUtils.getDrawable((int)(online ? R.drawable.shape_invite : R.drawable.shape_notify)));
                } else {
                    this.setString((TextView)this.tvInvite, ResourceUtils.getString((int)(online ? R.string.invited : R.string.notified)));
                    this.tvInvite.setTextColor(ResourceUtils.getColor((int)(online ? R.color.invite_text_color : R.color.blue_14c5ff)));
                    this.tvInvite.setBackgroundDrawable(null);
                }
            }
        }
    }

    public static abstract class VH<Data extends InviteItem>
    extends RecyclerView.ViewHolder {
        protected Data mData;
        protected CircleImageView ivAvatar;
        protected YYView vStatus;
        protected YYTextView tvName;
        protected YYTextView tvInvite;
        protected YYTextView tvContent;
        protected IInviteCallback callback;

        public VH(IInviteCallback callback2, View itemView) {
            super(itemView);
            this.callback = callback2;
        }

        abstract void bindView(int var1, Data var2, IInviteCallback var3);
    }
}

