/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.ui.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.game.R;
import com.yy.hiyo.game.base.gamemode.GameModeInfo;
import java.util.ArrayList;
import java.util.List;

public class ModeChangeListAdapter
extends RecyclerView.Adapter<ModeViewHolder>
implements View.OnClickListener {
    private List<GameModeInfo> modeList = new ArrayList<GameModeInfo>();
    private OnModeClickListener modeClickListener;
    private int currentTeamMemberCount = 0;

    @NonNull
    public ModeViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.view_mode_change_list_item, parent, false);
        return new ModeViewHolder(itemView);
    }

    public void onBindViewHolder(@NonNull ModeViewHolder holder, int position) {
        if (position < 0 || position >= this.modeList.size()) {
            return;
        }
        GameModeInfo modeInfo = this.modeList.get(position);
        holder.bind(modeInfo, this.currentTeamMemberCount);
        holder.itemView.setTag((Object)position);
        holder.itemView.setOnClickListener((View.OnClickListener)this);
    }

    public int getItemCount() {
        return this.modeList.size();
    }

    public void setData(List<GameModeInfo> data) {
        this.modeList.clear();
        if (data != null) {
            this.modeList.addAll(data);
        }
        this.notifyDataSetChanged();
    }

    public void setModeClickListener(OnModeClickListener modeClickListener) {
        this.modeClickListener = modeClickListener;
    }

    public void setCurrentTeamMemberCount(int currentTeamMemberCount) {
        this.currentTeamMemberCount = currentTeamMemberCount;
    }

    public void onClick(View v) {
        if (v.getTag() instanceof Integer) {
            Integer position = (Integer)v.getTag();
            if (position < 0 || position >= this.modeList.size()) {
                return;
            }
            if (this.modeClickListener != null) {
                GameModeInfo modeInfo = this.modeList.get(position);
                this.modeClickListener.onModeClick(modeInfo);
            }
        }
    }

    public static interface OnModeClickListener {
        public void onModeClick(GameModeInfo var1);
    }

    public static class ModeViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvName;

        public ModeViewHolder(View itemView) {
            super(itemView);
            this.tvName = (TextView)itemView.findViewById(R.id.tv_name);
        }

        public void bind(GameModeInfo modeInfo, int teamMemCount) {
            this.tvName.setText((CharSequence)modeInfo.getName());
            if (teamMemCount > modeInfo.getPlayerCount()) {
                this.tvName.setTextColor(-6710887);
            } else if (!modeInfo.isAvail()) {
                this.tvName.setTextColor(-6710887);
            } else {
                this.tvName.setTextColor(-16055035);
            }
        }
    }
}

