/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.ui;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bumptech.glide.load.DataSource;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.util.KeyboardHelper;
import com.yy.appbase.widget.barrage.Barrage;
import com.yy.appbase.widget.barrage.BarrageShowView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ImeUtil;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.game.DR;
import com.yy.game.R;
import com.yy.game.gamemodule.teamgame.teammatch.model.TeamInfo;
import com.yy.game.gamemodule.teamgame.teammatch.module.TeamInviteServicesController;
import com.yy.game.gamemodule.teamgame.teammatch.ui.AbsTeamMatchWindow;
import com.yy.game.gamemodule.teamgame.teammatch.ui.adapter.invite.HagoInviteAdapter;
import com.yy.game.gamemodule.teamgame.teammatch.ui.base.IBottomView;
import com.yy.game.gamemodule.teamgame.teammatch.ui.base.ISeatView;
import com.yy.game.gamemodule.teamgame.teammatch.ui.base.ITopView;
import com.yy.game.gamemodule.teamgame.teammatch.ui.base.IUserView;
import com.yy.game.gamemodule.teamgame.teammatch.ui.component.lanscape.LandscapeBottomView;
import com.yy.game.gamemodule.teamgame.teammatch.ui.dialog.BarrageInputDialog;
import com.yy.game.gamemodule.teamgame.teammatch.ui.popview.HagoInviteRightPopView;
import com.yy.game.gamemodule.teamgame.teammatch.ui.widget.BarrageInputView;
import com.yy.game.gamemodule.teamgame.teammatch.ui.widget.BarragePanel;
import com.yy.game.gamemodule.teamgame.teammatch.ui.widget.BarragePanelView;
import com.yy.game.gamemodule.teamgame.teammatch.ui.widget.InviteListView;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.game.base.teamgame.IInviteCallback;
import com.yy.hiyo.game.base.teamgame.InviteItem;
import com.yy.hiyo.game.base.widget.IMatchSuccessView;
import java.util.List;

public class TeamMatchLandWindow
extends AbsTeamMatchWindow {
    private static final String TAG = "WereWolfWindow";
    private static final int MATCHICON_ANIM_DURATION = 1500;
    private View rootView;
    private RecycleImageView ivBg;
    private SVGAImageView mSVGAImageView;
    private RecycleImageView mGifImageView;
    private ISeatView seatView;
    private IUserView userView;
    private IBottomView bottomView;
    private ITopView topView;
    private IMatchSuccessView matchSuccessView;
    private BarragePanel barragePanel;
    private BarrageShowView barrageShowView;
    private BarrageInputView barrageInputView;
    private TextView tvStatusTips;
    private TextView tvWaitingHostTips;
    private TextView mModeSelectTips;
    private long keyboardShowTimeMillis;
    private KeyboardHelper.OnKeyboardShowListener keyboardShowListener;
    private MatchingTimerRunable matchingTimerRunable;
    private int currentPage = 0;
    private boolean isHomeOwner = false;
    private boolean hasRuleEnter = false;
    private long seatMoveAnimDuration = 300L;
    private MatchGuideShowRunable matchGuideShowRunable;
    private Animation mModeSelectTipsAnim;
    private Runnable mModeSelectTipsAutoHideTimer;
    private InviteListView inviteListView;
    private SVGAImageView matchingSvga;
    private View mainView;
    private YYRelativeLayout mViewContaier;
    private View mGoldEntryView;
    private HagoInviteRightPopView mHagoInvitePopView;
    private SVGAImageView svgaCoinSuccess;
    private boolean hasMiddlePageSvgaOrGifStarted = false;
    private static final String SVGA_URL_SUFFIX = ".svga";
    private static final String GIF_URL_SUFFIX = ".gif";
    private Dialog barrageInputDialog;

    public TeamMatchLandWindow(Context context, UICallBacks callBacks, AbstractWindow.WindowLayerType useLayerType, String name) {
        super(context, callBacks, useLayerType, name);
        this.createView(context);
        this.setUiCallbacks();
        this.setWindowType(106);
        this.setScreenOrientationType(0);
    }

    @Override
    public void setGameInfo(String title, String mode, int playerCount) {
        int maxWidth;
        this.topView.setTitle(title);
        this.topView.setMode(mode);
        int width = ResolutionUtils.getScreenWidth((Context)this.getContext());
        int height = ResolutionUtils.getScreenHeight((Context)this.getContext());
        int screenWidth = width > height ? width : height;
        int availSeatItemWidth = (screenWidth - ResourceUtils.getDimen((int)R.dimen.right_invite_width) - ResolutionUtils.dip2Px((float)20.0f) * 2) / 6;
        this.seatView.initSeatCount(playerCount, availSeatItemWidth);
        int seatItemWidth = this.seatView.getSeatItemWidth();
        if (playerCount < 6) {
            maxWidth = seatItemWidth * playerCount + ResolutionUtils.dip2Px((float)10.0f);
        } else {
            int count = playerCount > 12 ? 12 : playerCount;
            maxWidth = (count + 1) / 2 * seatItemWidth + ResolutionUtils.dip2Px((float)10.0f);
        }
        this.seatView.getView().getLayoutParams().width = maxWidth;
    }

    @Override
    public void setHasRulesEnter(boolean isShow) {
        this.hasRuleEnter = isShow;
        this.topView.setRulesIconShow(this.hasRuleEnter);
    }

    @Override
    public void setGameBackgroundImage(String url, boolean ninePng, Drawable deaultDrawable) {
        if (ninePng) {
            this.ivBg.setBackgroundDrawable(deaultDrawable);
        } else {
            this.ivBg.setBackgroundDrawable(deaultDrawable);
            this.ivBg.setAutoTransforToWebpFlag(false);
            ImageLoader.loadImage((RecycleImageView)this.ivBg, (String)url, (Drawable)deaultDrawable, (Drawable)deaultDrawable, (ImageLoader.ImageLoadListener)new ImageLoader.ImageLoadListener(){

                public void onLoadFailed(Exception e) {
                }

                public void onResourceReady(Object resource, boolean isFromMemoryCache, DataSource dataSource) {
                    TeamMatchLandWindow.this.ivBg.setBackgroundDrawable(null);
                }
            });
        }
    }

    private void createView(Context context) {
        this.rootView = LayoutInflater.from((Context)context).inflate(R.layout.layout_team_room_land, this.getBaseLayer(), true);
        this.ivBg = (RecycleImageView)this.findViewById(R.id.iv_bg);
        this.mViewContaier = (YYRelativeLayout)this.rootView.findViewById(R.id.rl_container);
        this.mSVGAImageView = (SVGAImageView)this.findViewById(R.id.svga_bg);
        this.mGifImageView = (RecycleImageView)this.findViewById(R.id.gif_bg);
        this.topView = (ITopView)this.findViewById(R.id.view_top);
        this.seatView = (ISeatView)this.findViewById(R.id.view_seats);
        this.matchSuccessView = (IMatchSuccessView)this.findViewById(R.id.view_match_success);
        this.userView = (IUserView)this.findViewById(R.id.view_record);
        this.barrageShowView = (BarrageShowView)this.findViewById(R.id.view_barrage_show);
        this.barrageInputView = (BarrageInputView)this.findViewById(R.id.view_barrage_input);
        this.tvStatusTips = (TextView)this.findViewById(R.id.tv_status_tips);
        this.tvWaitingHostTips = (TextView)this.findViewById(R.id.tv_waiting_host_tips);
        this.mModeSelectTips = (TextView)this.findViewById(R.id.tv_mode_select_guide_tips);
        this.inviteListView = (InviteListView)this.findViewById(R.id.view_invite);
        this.matchingSvga = (SVGAImageView)this.findViewById(R.id.svga_matching);
        this.mainView = this.findViewById(R.id.rl_main);
        View matchingCancelView = this.findViewById(R.id.iv_matching_cancel);
        LandscapeBottomView landBottomView = (LandscapeBottomView)this.findViewById(R.id.view_bottom);
        landBottomView.setMatchingCancelView(matchingCancelView);
        this.bottomView = landBottomView;
        this.svgaCoinSuccess = (SVGAImageView)this.findViewById(R.id.svg_coin_success);
        this.svgaCoinSuccess.setFillMode(SVGAImageView.FillMode.Forward);
        this.svgaCoinSuccess.setClearsAfterStop(false);
        this.barragePanel = new BarragePanel(this.getContext());
        this.barragePanel.setLayoutStrategy(new BarragePanel.LayoutStrategy(){

            @Override
            public int getPanelWidth(View view) {
                int screenWidth = TeamMatchLandWindow.this.rootView.getMeasuredWidth();
                int rightInviteWidth = ResourceUtils.getDimen((int)R.dimen.right_invite_width);
                int width = (int)((double)(screenWidth - rightInviteWidth - view.getWidth()) - (double)screenWidth * 0.1 - (double)ResolutionUtils.dip2Px((float)10.0f));
                return width;
            }

            @Override
            public int getPanelLeft(View view) {
                if (LanguageUtils.isLtr()) {
                    int screenWidth = TeamMatchLandWindow.this.rootView.getMeasuredWidth();
                    int left = (int)((double)screenWidth * 0.1);
                    return left;
                }
                int rightInviteWidth = ResourceUtils.getDimen((int)R.dimen.right_invite_width);
                int left = rightInviteWidth + view.getWidth() + ResolutionUtils.dip2Px((float)10.0f);
                return left;
            }
        });
    }

    private void setUiCallbacks() {
        this.topView.setUiCallback(new ITopView.UiCallback(){

            @Override
            public void onBackClick() {
                if (TeamMatchLandWindow.this.mTeamWindowUIcallBack != null) {
                    TeamMatchLandWindow.this.mTeamWindowUIcallBack.onBackClicked();
                }
            }

            @Override
            public void onRulesClick() {
                if (TeamMatchLandWindow.this.mTeamWindowUIcallBack != null) {
                    TeamMatchLandWindow.this.mTeamWindowUIcallBack.onRuleClicked();
                    TeamMatchLandWindow.this.hideTip();
                }
            }

            @Override
            public void onTipClick() {
                TeamMatchLandWindow.this.hideTip();
            }

            @Override
            public void onModeClick() {
                if (TeamMatchLandWindow.this.mTeamWindowUIcallBack != null) {
                    TeamMatchLandWindow.this.mTeamWindowUIcallBack.onModeSelectClicked();
                }
            }
        });
        this.seatView.setUiCallback(new ISeatView.UiCallback(){

            @Override
            public void onSeatClick(int position) {
                if (TeamMatchLandWindow.this.mTeamWindowUIcallBack != null) {
                    TeamMatchLandWindow.this.mTeamWindowUIcallBack.onSeatClick(position);
                }
            }
        });
        this.bottomView.setUiCallback(new IBottomView.UiCallback(){

            @Override
            public void onChatBtnClick() {
                if (TeamMatchLandWindow.this.barragePanel.getView().getParent() == null) {
                    TeamMatchLandWindow.this.getExtLayer().addView(TeamMatchLandWindow.this.barragePanel.getView(), -1, -1);
                }
                if (!TeamMatchLandWindow.this.barragePanel.isShowing()) {
                    TeamMatchLandWindow.this.barragePanel.show(TeamMatchLandWindow.this.bottomView.getChatBtn());
                }
                if (TeamMatchLandWindow.this.mTeamWindowUIcallBack != null) {
                    TeamMatchLandWindow.this.mTeamWindowUIcallBack.onBarrageChatBtnClicked();
                }
            }

            @Override
            public void onBtnClick() {
                if (TeamMatchLandWindow.this.mTeamWindowUIcallBack != null) {
                    TeamMatchLandWindow.this.mTeamWindowUIcallBack.onMatchClicked();
                }
                TeamMatchLandWindow.this.removeIfHasMatchGuideShowRunable();
                TeamMatchLandWindow.this.hideMatchGuideIfShow();
            }

            @Override
            public void onMatchCancelClick() {
                if (TeamMatchLandWindow.this.mTeamWindowUIcallBack != null) {
                    TeamMatchLandWindow.this.mTeamWindowUIcallBack.onMatchCancelClicked();
                }
            }

            @Override
            public void onTestPlay() {
                if (TeamMatchLandWindow.this.mTeamWindowUIcallBack != null) {
                    TeamMatchLandWindow.this.mTeamWindowUIcallBack.onTestPlay();
                }
            }

            @Override
            public void onTestAddPlayer() {
                if (TeamMatchLandWindow.this.mTeamWindowUIcallBack != null) {
                    TeamMatchLandWindow.this.mTeamWindowUIcallBack.onTestAddPlayer();
                }
            }
        });
        this.barrageInputView.setUiCallback(new BarrageInputView.UiCallback(){

            @Override
            public void onMsgSend(String msg, int bgColor) {
                if (TeamMatchLandWindow.this.mTeamWindowUIcallBack != null) {
                    TeamMatchLandWindow.this.mTeamWindowUIcallBack.onSendCustomBarrageClicked(msg, bgColor);
                }
                ImeUtil.hideIME((Activity)((Activity)TeamMatchLandWindow.this.getContext()));
            }
        });
        this.barragePanel.setUiCallback(new BarragePanelView.UiCallback(){

            @Override
            public void onMsgClick(String msg, int bgColor) {
                if (TeamMatchLandWindow.this.mTeamWindowUIcallBack != null) {
                    TeamMatchLandWindow.this.mTeamWindowUIcallBack.onSendQuickBarrageClicked(msg, bgColor);
                }
            }

            @Override
            public void onInputBtnClick() {
                TeamMatchLandWindow.this.showBarrageInputViewV2();
                if (TeamMatchLandWindow.this.mTeamWindowUIcallBack != null) {
                    TeamMatchLandWindow.this.mTeamWindowUIcallBack.onCustomBarrageInputBtnClicked();
                }
            }
        });
    }

    private void showBarrageInputViewV2() {
        if (this.keyboardShowListener == null) {
            this.keyboardShowListener = new KeyboardHelper.OnKeyboardShowListener((View)this){

                public void onShow(boolean isShowing, int keyboardHeight) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamMatchLandWindow.TAG, (String)"keyboard: isShowing = %b, height = %d", (Object[])new Object[]{isShowing, keyboardHeight});
                    }
                    if (!isShowing) {
                        if (TeamMatchLandWindow.this.barrageInputDialog != null && TeamMatchLandWindow.this.barrageInputDialog.isShowing()) {
                            TeamMatchLandWindow.this.barrageInputDialog.dismiss();
                        }
                        KeyboardHelper.unwatchKeyboardStatus((View)TeamMatchLandWindow.this, (KeyboardHelper.OnKeyboardShowListener)TeamMatchLandWindow.this.keyboardShowListener);
                    }
                }
            };
        }
        KeyboardHelper.watchKeyboardStatus((View)this, (KeyboardHelper.OnKeyboardShowListener)this.keyboardShowListener);
        if (this.barrageInputDialog == null) {
            final BarrageInputView dialogView = new BarrageInputView(this.getContext());
            this.barrageInputDialog = new BarrageInputDialog(this.getContext(), (View)dialogView);
            dialogView.setUiCallback(new BarrageInputView.UiCallback(){

                @Override
                public void onMsgSend(String msg, int bgColor) {
                    if (TeamMatchLandWindow.this.mTeamWindowUIcallBack != null) {
                        TeamMatchLandWindow.this.mTeamWindowUIcallBack.onSendCustomBarrageClicked(msg, bgColor);
                    }
                    ImeUtil.hideIME((Context)TeamMatchLandWindow.this.barrageInputDialog.getContext(), (View)dialogView.getEditText());
                }
            });
        }
        this.barrageInputDialog.show();
    }

    private void stopBackgroundAnim() {
        if (this.mSVGAImageView != null && this.mSVGAImageView.isAnimating()) {
            this.mSVGAImageView.stopAnimation();
            this.mSVGAImageView.setVisibility(8);
            this.hasMiddlePageSvgaOrGifStarted = false;
        }
        if (this.mGifImageView != null) {
            ImageLoader.clear((RecycleImageView)this.mGifImageView);
            this.mGifImageView.setVisibility(8);
            this.hasMiddlePageSvgaOrGifStarted = false;
        }
        if (this.ivBg != null && this.ivBg.getVisibility() == 8) {
            this.ivBg.setVisibility(0);
        }
    }

    private void changePage(int page) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"changePage %d", (Object[])new Object[]{page});
        }
        if (page == 0) {
            if (this.currentPage == 1) {
                this.changePageToRecordWithAnim();
            } else {
                this.changePageToRecordWithoutAnim();
            }
        } else if (page == 1) {
            this.changePageToMatching();
        } else if (page == 2) {
            if (this.currentPage == 1) {
                this.changePageToTeamWithAnim();
            } else if (this.currentPage == 0) {
                this.changePageToTeamWithoutAnim();
            }
        }
        if (!this.isHomeOwner && page == 2) {
            this.waitingHostTipsVisible(true);
        } else {
            this.waitingHostTipsVisible(false);
        }
        this.currentPage = page;
        if (this.currentPage == 0) {
            if (!this.hasMiddlePageSvgaOrGifStarted) {
                this.setGameMiddlePageBackground();
            }
        } else {
            this.stopBackgroundAnim();
        }
        if (this.mGoldEntryView != null) {
            if (page == 1) {
                this.mGoldEntryView.setVisibility(0);
            } else {
                this.mGoldEntryView.setVisibility(8);
            }
        }
    }

    @Override
    public void addGameCoinsEntryView(Context context, int count) {
        if (this.mViewContaier != null && context != null) {
            this.mGoldEntryView = LayoutInflater.from((Context)context).inflate(R.layout.layout_gold_matcher_entry, null);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.addRule(14);
            layoutParams.addRule(12);
            layoutParams.bottomMargin = ResolutionUtils.dip2Px((float)20.0f);
            this.mGoldEntryView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            ((TextView)this.mGoldEntryView.findViewById(R.id.tv_coins_entry)).setText((CharSequence)String.valueOf(count));
            this.mViewContaier.addView(this.mGoldEntryView);
            this.mGoldEntryView.setVisibility(8);
        }
    }

    @Override
    public void hideViewWhenMatchedOthersSuccess() {
        this.stopMatchingTimer();
        this.stopMatchIconAnim();
        this.hideMatchStatusTips();
        this.bottomView.setVisibility(4);
        this.seatView.setVisibility(4);
    }

    @Override
    public void showMatchSuccessWithMatchedInfo(List<UserInfoKS> matchedUserList) {
        this.matchSuccessView.setVisibility(0);
        this.matchSuccessView.setData(matchedUserList);
    }

    @Override
    public void setInviteCallback(IInviteCallback callback2) {
        this.inviteListView.setCallback(callback2);
    }

    @Override
    public void setInviteDatas(List<InviteItem> datas) {
        this.inviteListView.setDatas(datas);
    }

    @Override
    public void showPageMatching() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"set currentPage matching", (Object[])new Object[0]);
        }
        this.removeIfHasMatchGuideShowRunable();
        ImeUtil.hideIME((Activity)((Activity)this.getContext()));
        this.changePage(1);
    }

    @Override
    public void showPageTeam() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"set currentPage team", (Object[])new Object[0]);
        }
        this.changePage(2);
        boolean needShow = SettingFlags.getBoolean((String)"team_game_match_guide_shown", (boolean)true);
        if (needShow) {
            if (this.matchGuideShowRunable == null) {
                this.matchGuideShowRunable = new MatchGuideShowRunable();
            }
            this.postDelayed(this.matchGuideShowRunable, 20000L);
        }
    }

    private void removeIfHasMatchGuideShowRunable() {
        if (this.matchGuideShowRunable == null) {
            return;
        }
        this.removeCallbacks(this.matchGuideShowRunable);
    }

    @Override
    public void showPageRecord() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"set currentPage user info", (Object[])new Object[0]);
        }
        this.removeIfHasMatchGuideShowRunable();
        this.changePage(0);
    }

    @Override
    public void showMatchSuccess() {
        this.stopMatchingTimer();
        this.stopMatchIconAnim();
        this.showMatchStatusTips(ResourceUtils.getString((int)R.string.team_game_room_match_success), -16126);
    }

    @Override
    public void showInviteTips() {
        if (this.bottomView == null) {
            return;
        }
        this.bottomView.showInviteTips();
    }

    @Override
    public void hideInviteTips() {
        if (this.bottomView == null) {
            return;
        }
        this.bottomView.hideInviteTips();
    }

    @Override
    public void setMatchGuideShow(boolean isShow) {
        if (this.bottomView == null) {
            return;
        }
        this.bottomView.setMatchGuideVisible(isShow);
    }

    @Override
    public int getPageType() {
        return this.currentPage;
    }

    @Override
    public void startTipAnim() {
        this.topView.stratRuleTipAnim();
    }

    @Override
    public void hideTip() {
        this.topView.hideRuleTip();
    }

    @Override
    public void setModeClickable(boolean clickable) {
        this.topView.setModeClickable(clickable);
    }

    @Override
    public void setModeClickEnable(boolean enable) {
        this.topView.setModeClickEnable(enable);
    }

    @Override
    public void showModeSelectTips() {
        if (this.mModeSelectTips == null) {
            return;
        }
        this.mModeSelectTips.setVisibility(0);
        this.mModeSelectTipsAnim = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f, 1, 0.5f, 1, 0.0f);
        this.mModeSelectTipsAnim.setDuration(200L);
        this.mModeSelectTipsAnim.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        this.mModeSelectTips.setAnimation(this.mModeSelectTipsAnim);
        this.mModeSelectTipsAnim.start();
        if (this.mModeSelectTipsAutoHideTimer == null) {
            this.mModeSelectTipsAutoHideTimer = new Runnable(){

                @Override
                public void run() {
                    TeamMatchLandWindow.this.hideModeSelectTips();
                    TeamMatchLandWindow.this.mModeSelectTipsAutoHideTimer = null;
                }
            };
        }
        YYTaskExecutor.postToMainThread((Runnable)this.mModeSelectTipsAutoHideTimer, (long)5000L);
    }

    @Override
    public void hideModeSelectTips() {
        if (this.mModeSelectTips == null) {
            return;
        }
        if (this.mModeSelectTipsAutoHideTimer != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mModeSelectTipsAutoHideTimer);
        }
        if (this.mModeSelectTipsAnim != null) {
            this.mModeSelectTipsAnim.cancel();
        }
        this.mModeSelectTips.setVisibility(8);
    }

    @Override
    public boolean handleKeyBack() {
        if (this.mHagoInvitePopView != null && this.mHagoInvitePopView.isShowing()) {
            this.mHagoInvitePopView.dismiss();
            return true;
        }
        if (this.barragePanel.isShowing()) {
            this.barragePanel.hide(true);
            return true;
        }
        return false;
    }

    @Override
    public void showHagoInvitePopView(TeamInviteServicesController.InviteFriendContainer container, TeamInfo teamInfo, HagoInviteAdapter.IInviteCallback callback2) {
        this.mHagoInvitePopView = new HagoInviteRightPopView(this.getContext(), callback2);
        this.mHagoInvitePopView.setDatas(container, teamInfo);
        this.mHagoInvitePopView.show((AbstractWindow)this);
    }

    @Override
    public void updateGoldConfig(String tips, long totalAmount, long changeAmount, boolean animate) {
        if (this.topView != null) {
            this.topView.updateGoldConfig(tips, totalAmount, changeAmount, animate);
        }
    }

    @Override
    public void updateGoldViewVisibility(boolean visibility) {
        if (this.topView != null) {
            this.topView.updateGoldViewVisibility(visibility);
        }
    }

    @Override
    public void setInviteListTotalGone(boolean totalGone) {
        if (this.inviteListView != null) {
            this.inviteListView.setTotalGone(totalGone);
        }
    }

    @Override
    public void updateCoinSuccessSvga() {
        if (this.svgaCoinSuccess != null) {
            this.svgaCoinSuccess.setVisibility(0);
            DyResLoader.INSTANCE.loadSvga(this.svgaCoinSuccess, DR.game_result_win_coins, new ISvgaLoadCallback(){

                public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                    if (TeamMatchLandWindow.this.svgaCoinSuccess != null) {
                        TeamMatchLandWindow.this.svgaCoinSuccess.startAnimation();
                    }
                }

                public void onFailed(Exception e) {
                }
            });
        }
    }

    private void setGameMiddlePageBackground() {
        if (this.mTeamWindowUIcallBack == null || StringUtils.isEmpty((String)this.mTeamWindowUIcallBack.getMatchMiddlePageDynamicUrl())) {
            return;
        }
        String url = this.mTeamWindowUIcallBack.getMatchMiddlePageDynamicUrl();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"setGameMiddlePageBackground svga url: %s", (Object[])new Object[]{url});
        }
        if (StringUtils.isEmpty((String)url) || this.hasMiddlePageSvgaOrGifStarted) {
            return;
        }
        if (url.endsWith(SVGA_URL_SUFFIX)) {
            this.loadSvga(url);
        } else if (url.endsWith(GIF_URL_SUFFIX)) {
            this.loadGif(url);
        }
    }

    private void loadSvga(String url) {
        if (this.mSVGAImageView == null) {
            return;
        }
        SvgaLoader.load((SVGAImageView)this.mSVGAImageView, (String)url, (ISvgaLoadCallback)new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                if (svgaVideoEntity == null || TeamMatchLandWindow.this.mSVGAImageView == null) {
                    return;
                }
                if (TeamMatchLandWindow.this.currentPage != 0) {
                    return;
                }
                TeamMatchLandWindow.this.mSVGAImageView.setVisibility(0);
                TeamMatchLandWindow.this.mSVGAImageView.startAnimation();
                TeamMatchLandWindow.this.hasMiddlePageSvgaOrGifStarted = true;
                if (TeamMatchLandWindow.this.ivBg != null && TeamMatchLandWindow.this.ivBg.getVisibility() == 0) {
                    TeamMatchLandWindow.this.ivBg.setVisibility(8);
                }
            }

            public void onFailed(Exception e) {
                MLog.error((Object)TeamMatchLandWindow.TAG, (String)"load svga failed: %s", (Object[])new Object[]{e.getMessage()});
                TeamMatchLandWindow.this.hasMiddlePageSvgaOrGifStarted = false;
            }
        });
    }

    private void loadGif(String url) {
        if (this.mGifImageView == null) {
            return;
        }
        this.mGifImageView.setVisibility(0);
        ImageLoader.loadImage((RecycleImageView)this.mGifImageView, (String)url, null, null, (ImageLoader.ImageLoadListener)new ImageLoader.ImageLoadListener(){

            public void onLoadFailed(Exception e) {
                MLog.error((Object)TeamMatchLandWindow.TAG, (String)"load gif failed: %s", (Object[])new Object[]{e.getMessage()});
                TeamMatchLandWindow.this.hasMiddlePageSvgaOrGifStarted = false;
                TeamMatchLandWindow.this.mGifImageView.setVisibility(8);
            }

            public void onResourceReady(Object resource, boolean isFromMemoryCache, DataSource dataSource) {
                if (TeamMatchLandWindow.this.currentPage != 0) {
                    TeamMatchLandWindow.this.mGifImageView.setVisibility(8);
                    return;
                }
                TeamMatchLandWindow.this.hasMiddlePageSvgaOrGifStarted = true;
                if (TeamMatchLandWindow.this.ivBg != null && TeamMatchLandWindow.this.ivBg.getVisibility() == 0) {
                    TeamMatchLandWindow.this.ivBg.setVisibility(8);
                }
            }
        });
    }

    private void waitingHostTipsVisible(boolean visible) {
        if (visible) {
            this.tvWaitingHostTips.setVisibility(0);
        } else {
            this.tvWaitingHostTips.setVisibility(8);
        }
    }

    private void moveSeatViewAccordingToPage(int page, boolean withAnim) {
        int currentTranslationX = (int)this.inviteListView.getTranslationX();
        int toTranslationX = 0;
        toTranslationX = page == 1 ? this.inviteListView.getMeasuredWidth() : 0;
        if (currentTranslationX == toTranslationX) {
            return;
        }
        if (withAnim) {
            boolean isLtr = LanguageUtils.isLtr();
            ObjectAnimator mainAnim = ObjectAnimator.ofFloat((Object)this.mainView, (String)"translationX", (float[])new float[]{isLtr ? (float)(toTranslationX / 2) : (float)(-toTranslationX / 2)});
            ObjectAnimator invite = ObjectAnimator.ofFloat((Object)((Object)this.inviteListView), (String)"translationX", (float[])new float[]{isLtr ? (float)toTranslationX : (float)(-toTranslationX)});
            AnimatorSet animatorSet = new AnimatorSet();
            animatorSet.setDuration(this.seatMoveAnimDuration);
            animatorSet.playTogether(new Animator[]{mainAnim, invite});
            animatorSet.start();
        } else {
            this.mainView.setTranslationX((float)toTranslationX);
            this.inviteListView.setTranslationX(toTranslationX);
        }
    }

    private void startMatchingTimer() {
        if (this.matchingTimerRunable == null) {
            this.matchingTimerRunable = new MatchingTimerRunable();
        }
        this.matchingTimerRunable.setSeconds(1);
        this.postDelayed(this.matchingTimerRunable, 1000L);
    }

    private void stopMatchingTimer() {
        if (this.matchingTimerRunable != null) {
            this.removeCallbacks(this.matchingTimerRunable);
        }
    }

    private void updateMatchTimePerSecond(int seconds) {
        if (this.bottomView == null) {
            return;
        }
        String formatStr = ResourceUtils.getString((int)R.string.team_game_room_match_timer_tips);
        this.showMatchStatusTips(String.format(formatStr, seconds), -1);
        if (seconds == 5) {
            this.bottomView.showMatchCancelBtn();
            this.bottomView.showInviteTips();
        }
        this.matchingTimerRunable.setSeconds(seconds + 1);
        this.postDelayed(this.matchingTimerRunable, 1000L);
    }

    private void showMatchStatusTips(String content, int textColor) {
        if (this.tvStatusTips == null) {
            return;
        }
        this.tvStatusTips.setVisibility(0);
        this.tvStatusTips.setTextColor(textColor);
        this.tvStatusTips.setText((CharSequence)content);
    }

    private void hideMatchStatusTips() {
        if (this.tvStatusTips == null) {
            return;
        }
        this.stopMatchingTimer();
        this.tvStatusTips.setVisibility(8);
    }

    public void onAttach() {
        this.barrageShowView.initBarrageView(2);
        super.onAttach();
    }

    public void onDetached() {
        this.barrageShowView.clear();
        this.topView.hideRuleTip();
        super.onDetached();
    }

    @Override
    public void setUserInfo(String avatar, int sex) {
        this.userView.setUserAvatar(avatar, sex);
    }

    @Override
    public void setWinCount(int winCount) {
        this.userView.setWinCount(winCount);
    }

    @Override
    public void setPlayCount(int playCount) {
        this.userView.setPlayCount(playCount);
    }

    @Override
    public void closeBarrageViewIfShow() {
        if (this.barragePanel != null && this.barragePanel.isShowing()) {
            this.barragePanel.hide(false);
        }
        if (this.barrageInputDialog != null && this.barrageInputDialog.isShowing()) {
            this.barrageInputDialog.dismiss();
        }
    }

    @Override
    public void setSeatReady(int position, UserInfoKS userInfo) {
        this.seatView.setSeatReady(position, userInfo);
    }

    @Override
    public void setSeatUnready(int position) {
        if (this.currentPage == 1) {
            this.seatView.setSeatMatching(position);
        } else {
            this.seatView.setSeatNone(position);
        }
    }

    @Override
    public void setDefaultBarrages(List<String> barrages) {
        this.barragePanel.setQuickMsgList(barrages);
    }

    @Override
    public void showBarrage(String avatar, String msg, int bgColor) {
        this.barrageShowView.addBarrage(Barrage.builder().avatar(avatar).msg(msg).bgColor(bgColor).build());
    }

    private void changePageToTeamWithoutAnim() {
        this.topView.setRulesIconShow(this.hasRuleEnter);
        this.topView.setBackIconShow(true);
        this.userView.setVisibility(8);
        this.seatView.setVisibility(0);
        this.seatView.setNameShow(true);
        this.stopMatchIconAnim();
        this.updateBottomViewAccordingToPage(2);
        this.updateChatViewAccordingToPage(2);
        this.moveSeatViewAccordingToPage(2, false);
    }

    private void changePageToTeamWithAnim() {
        this.hideMatchStatusTips();
        this.bottomView.hideInviteTips();
        this.userView.setVisibility(8);
        this.seatView.setVisibility(0);
        this.seatView.setNameShow(true);
        this.stopMatchIconAnim();
        this.moveSeatViewAccordingToPage(2, true);
        this.updateBottomViewAccordingToPage(2);
        this.updateChatViewAccordingToPage(2);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (TeamMatchLandWindow.this.topView != null) {
                    TeamMatchLandWindow.this.topView.setRulesIconShow(TeamMatchLandWindow.this.hasRuleEnter);
                    TeamMatchLandWindow.this.topView.setBackIconShow(true);
                }
            }
        }, (long)this.seatMoveAnimDuration);
    }

    private void changePageToMatching() {
        if (this.currentPage == 1) {
            return;
        }
        this.topView.setRulesIconShow(false);
        this.topView.setBackIconShow(false);
        this.hideMatchStatusTips();
        this.closeBarrageViewIfShow();
        this.bottomView.hideInviteTips();
        this.startMatchIconAnim();
        this.userView.setVisibility(8);
        this.seatView.setVisibility(0);
        this.seatView.setNameShow(false);
        this.moveSeatViewAccordingToPage(1, true);
        this.updateBottomViewAccordingToPage(1);
        this.updateChatViewAccordingToPage(1);
        this.startMatchingTimer();
    }

    private void changePageToRecordWithoutAnim() {
        if (this.currentPage == 1) {
            this.hideMatchStatusTips();
            this.bottomView.hideInviteTips();
        }
        this.topView.setRulesIconShow(this.hasRuleEnter);
        this.topView.setBackIconShow(true);
        this.seatView.setVisibility(8);
        this.userView.setVisibility(0);
        this.stopMatchIconAnim();
        this.updateBottomViewAccordingToPage(0);
        this.updateChatViewAccordingToPage(0);
    }

    private void changePageToRecordWithAnim() {
        if (this.currentPage == 1) {
            this.hideMatchStatusTips();
            this.bottomView.hideInviteTips();
        }
        this.stopMatchIconAnim();
        this.updateBottomViewAccordingToPage(0);
        this.updateChatViewAccordingToPage(0);
        this.moveSeatViewAccordingToPage(0, true);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (TeamMatchLandWindow.this.topView != null) {
                    TeamMatchLandWindow.this.topView.setRulesIconShow(TeamMatchLandWindow.this.hasRuleEnter);
                    TeamMatchLandWindow.this.topView.setBackIconShow(true);
                }
                if (TeamMatchLandWindow.this.seatView != null) {
                    TeamMatchLandWindow.this.seatView.setVisibility(8);
                }
                if (TeamMatchLandWindow.this.userView != null) {
                    TeamMatchLandWindow.this.userView.setVisibility(0);
                }
            }
        }, (long)this.seatMoveAnimDuration);
    }

    private void updateBottomViewAccordingToPage(int page) {
        if (page == 1) {
            this.bottomView.setMatching(true);
            this.bottomView.setCenterBtnShow(false);
        } else {
            this.bottomView.setMatching(false);
            if (this.isHomeOwner) {
                this.bottomView.setCenterBtnShow(true);
            } else {
                this.bottomView.setCenterBtnShow(false);
            }
        }
    }

    private void updateChatViewAccordingToPage(int toPage) {
        if (toPage == 2) {
            this.bottomView.setBarrageBtnShow(true);
        } else {
            this.bottomView.setBarrageBtnShow(false);
        }
    }

    @Override
    public void showPlayBtn() {
        this.bottomView.showPlayBtn();
    }

    @Override
    public void showMatchBtn() {
        this.bottomView.showMatchBtn();
    }

    @Override
    public void setHomeOwner(boolean homeOwner) {
        this.isHomeOwner = homeOwner;
        if (homeOwner) {
            if (this.currentPage != 1) {
                this.bottomView.setCenterBtnShow(true);
            } else {
                this.bottomView.setCenterBtnShow(false);
            }
            this.waitingHostTipsVisible(false);
        } else {
            this.bottomView.setCenterBtnShow(false);
            if (this.currentPage == 2) {
                this.waitingHostTipsVisible(true);
            } else {
                this.waitingHostTipsVisible(false);
            }
        }
    }

    private void hideMatchGuideIfShow() {
        if (this.bottomView != null) {
            this.bottomView.setMatchGuideVisible(false);
        }
    }

    public void startMatchIconAnim() {
        this.matchingSvga.setVisibility(0);
        SvgaLoader.load((SVGAImageView)this.matchingSvga, (String)"matching.svga", (ISvgaLoadCallback)new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                if (TeamMatchLandWindow.this.matchingSvga != null) {
                    TeamMatchLandWindow.this.matchingSvga.startAnimation();
                }
            }

            public void onFailed(Exception e) {
            }
        });
    }

    public void stopMatchIconAnim() {
        this.matchingSvga.setVisibility(8);
        this.matchingSvga.stopAnimation();
    }

    class MatchGuideShowRunable
    implements Runnable {
        MatchGuideShowRunable() {
        }

        @Override
        public void run() {
            if (TeamMatchLandWindow.this.bottomView == null || !TeamMatchLandWindow.this.bottomView.isCenterBtnShow()) {
                return;
            }
            TeamMatchLandWindow.this.bottomView.setMatchGuideVisible(true);
            SettingFlags.setBoolean((String)"team_game_match_guide_shown", (boolean)false);
            TeamMatchLandWindow.this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    TeamMatchLandWindow.this.hideMatchGuideIfShow();
                }
            }, 5000L);
        }
    }

    class MatchingTimerRunable
    implements Runnable {
        private int seconds;

        MatchingTimerRunable() {
        }

        public void setSeconds(int seconds) {
            this.seconds = seconds;
        }

        @Override
        public void run() {
            TeamMatchLandWindow.this.updateMatchTimePerSecond(this.seconds);
        }
    }

    class ShowKeyBoardRunable
    implements Runnable {
        private long id;
        private int height;

        ShowKeyBoardRunable(long showTimeMillis, int height) {
            this.id = showTimeMillis;
            this.height = height;
        }

        @Override
        public void run() {
            if (this.id != TeamMatchLandWindow.this.keyboardShowTimeMillis) {
                return;
            }
            if (TeamMatchLandWindow.this.barrageInputView == null) {
                return;
            }
            TeamMatchLandWindow.this.barrageInputView.setVisibility(0);
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)TeamMatchLandWindow.this.barrageInputView.getLayoutParams();
            lp.bottomMargin = this.height;
            TeamMatchLandWindow.this.barrageInputView.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
    }
}

