/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.ui;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.text.style.ImageSpan;
import android.view.View;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.game.R;

public class TeamCoinTipsHelper {
    public void updateCoinGameConfig(String tips, YYTextView tvTips, YYTextView tvChange, YYLinearLayout container, long total, long changeAmount, boolean anim) {
        if (anim) {
            this.setResultTextAnim(tips, tvTips, tvChange, container, total, changeAmount);
        } else {
            this.setResultText(tips, tvTips, tvChange, container, total);
        }
    }

    private void setResultText(String tips, YYTextView tvTips, YYTextView tvChange, YYLinearLayout container, long total) {
        if (tvTips == null || tvChange == null || container == null) {
            return;
        }
        container.setVisibility(0);
        String myCoinStr = tips;
        String img = "IMG";
        String totalStr = "" + total;
        String str = myCoinStr + img + totalStr;
        SpannableString spannableString = new SpannableString((CharSequence)str);
        Drawable drawable2 = ResourceUtils.getDrawable((int)R.drawable.bg_single_coin);
        drawable2.setBounds(0, 0, (int)((float)drawable2.getIntrinsicWidth() / 1.5f), (int)((float)drawable2.getIntrinsicHeight() / 1.5f));
        spannableString.setSpan((Object)new ImageSpan(drawable2, 1), myCoinStr.length(), myCoinStr.length() + img.length(), 17);
        tvTips.setVisibility(0);
        tvChange.setVisibility(8);
        container.setBackgroundToNull();
        tvTips.setText((CharSequence)spannableString);
    }

    private void setResultTextAnim(final String tips, final YYTextView tvTips, final YYTextView tvChange, final YYLinearLayout container, final long total, long changeAmount) {
        if (tvTips == null || tvChange == null || container == null) {
            return;
        }
        this.setResultText(tips, tvTips, tvChange, container, total - changeAmount);
        container.setBackgroundResource(changeAmount >= 0L ? R.drawable.streak_win_bk : R.drawable.streak_lose_bk);
        tvChange.setVisibility(0);
        tvChange.setTextColor(Color.parseColor((String)(changeAmount >= 0L ? "#FFFFD700" : "#80FFFFFF")));
        tvChange.setText((CharSequence)(changeAmount >= 0L ? "+" + changeAmount : "" + changeAmount));
        ObjectAnimator xAnim = ObjectAnimator.ofFloat((Object)tvChange, (String)View.SCALE_X.getName(), (float[])new float[]{1.0f, 1.5f, 0.6f, 1.0f});
        xAnim.setDuration(1000L);
        ObjectAnimator yAnim = ObjectAnimator.ofFloat((Object)tvChange, (String)View.SCALE_Y.getName(), (float[])new float[]{1.0f, 1.5f, 0.6f, 1.0f});
        yAnim.setDuration(1000L);
        ObjectAnimator alphAnim = ObjectAnimator.ofFloat((Object)tvChange, (String)View.ALPHA.getName(), (float[])new float[]{1.0f, 0.0f});
        alphAnim.setDuration(500L);
        alphAnim.setStartDelay(1000L);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{xAnim, yAnim, alphAnim});
        animatorSet.start();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                TeamCoinTipsHelper.this.setResultText(tips, tvTips, tvChange, container, total);
            }
        }, (long)1500L);
    }
}

