/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.provider;

import android.text.TextUtils;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.logger.MLog;
import com.yy.game.gamemodule.teamgame.teammatch.model.TeamInfo;
import com.yy.hiyo.game.base.TeamUserInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum TeamRoomDataModel {
    instance;

    private static final String TAG = "TeamRoomDataModel";
    private Map<String, TeamInfo> mTeamInfoMap = new ConcurrentHashMap<String, TeamInfo>();

    public TeamInfo initTeamInfo(boolean isCreator, String gameId, int teamTemplate, String teamId, int playerNumber) {
        TeamInfo teamInfo = this.checkTeamInfo(teamId);
        teamInfo.setGameId(gameId);
        teamInfo.setTeamTemplate(teamTemplate);
        teamInfo.setPlayerNumber(playerNumber);
        teamInfo.setTeamId(teamId);
        if (isCreator) {
            teamInfo.setCaptainUid(AccountUtil.getUid());
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("\u8bbe\u7f6eTeam\u4fe1\u606f\u6210\u529f:" + (Object)((Object)teamInfo)), (Object[])new Object[0]);
        }
        if (this.mTeamInfoMap != null && !TextUtils.isEmpty((CharSequence)teamId)) {
            this.mTeamInfoMap.put(teamId, teamInfo);
        }
        return teamInfo;
    }

    public TeamInfo initTeamInfo(boolean canPlay, String gameId, int teamTemplate, String teamId, int playerNumber, long captainUid, List<TeamUserInfo> teamUserInfoList) {
        TeamInfo teamInfo = this.checkTeamInfo(teamId);
        teamInfo.setCanPlay(canPlay);
        teamInfo.setGameId(gameId);
        teamInfo.setTeamTemplate(teamTemplate);
        teamInfo.setPlayerNumber(playerNumber);
        teamInfo.setTeamId(teamId);
        teamInfo.setCaptainUid(captainUid);
        teamInfo.setTeamUserInfoList(teamUserInfoList);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("\u8bbe\u7f6eTeam\u4fe1\u606f\u6210\u529f:" + (Object)((Object)teamInfo)), (Object[])new Object[0]);
        }
        if (this.mTeamInfoMap != null && !TextUtils.isEmpty((CharSequence)teamId)) {
            this.mTeamInfoMap.put(teamId, teamInfo);
        }
        return teamInfo;
    }

    public TeamInfo initTeamInfo(String gameId, int teamTemplate, String teamId, long captainUid, List<TeamUserInfo> teamUserInfoList, String roomId, String url, boolean isGoldGame) {
        TeamInfo teamInfo = this.checkTeamInfo(teamId);
        teamInfo.setGameId(gameId);
        teamInfo.setTeamTemplate(teamTemplate);
        teamInfo.setTeamId(teamId);
        teamInfo.setTeamUserInfoList(teamUserInfoList);
        teamInfo.setRoomId(roomId);
        teamInfo.setUrl(url);
        teamInfo.setCaptainUid(captainUid);
        teamInfo.setGoldGame(isGoldGame);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("\u8bbe\u7f6eTeam\u4fe1\u606f\u6210\u529f:" + (Object)((Object)teamInfo)), (Object[])new Object[0]);
        }
        if (this.mTeamInfoMap != null && !TextUtils.isEmpty((CharSequence)teamId)) {
            this.mTeamInfoMap.put(teamId, teamInfo);
        }
        return teamInfo;
    }

    public void setTeamTemplete(String teamId, int template) {
        if (TextUtils.isEmpty((CharSequence)teamId)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"setTeamTemplete:TeamId\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        TeamInfo teamInfo = this.checkTeamInfo(teamId);
        int originTemplate = teamInfo.getTeamTemplate();
        teamInfo.setTeamTemplate(template);
        if (this.mTeamInfoMap != null) {
            this.mTeamInfoMap.put(teamId, teamInfo);
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("TeamId:" + teamId + "\u4ece\u4e4b\u524d\u7684\u6a21\u5f0f:" + originTemplate + "\u4fee\u6539\u4e3a:" + template), (Object[])new Object[0]);
        }
    }

    public void setTeamStatus(String teamId, int status) {
        if (TextUtils.isEmpty((CharSequence)teamId)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"setTeamStatus:TeamId\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        TeamInfo teamInfo = this.checkTeamInfo(teamId);
        int originStatus = teamInfo.getStatus();
        teamInfo.setStatus(status);
        if (this.mTeamInfoMap != null) {
            this.mTeamInfoMap.put(teamId, teamInfo);
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("TeamId:" + teamId + "\u4ece\u4e4b\u524d\u7684\u72b6\u6001:" + originStatus + "\u4fee\u6539\u4e3a:" + status), (Object[])new Object[0]);
        }
    }

    public TeamInfo getTeamInfo(String teamId) {
        if (this.mTeamInfoMap != null && teamId != null && this.mTeamInfoMap.containsKey(teamId)) {
            return this.mTeamInfoMap.get(teamId);
        }
        return null;
    }

    public void clearTeamInfo(String teamId) {
        if (this.mTeamInfoMap != null && teamId != null && this.mTeamInfoMap.containsKey(teamId)) {
            TeamInfo teamInfo = this.mTeamInfoMap.remove(teamId);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)("\u6e05\u9664Team\u6210\u529f:" + (Object)((Object)teamInfo)), (Object[])new Object[0]);
            }
        } else if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("\u6e05\u9664Team\u5931\u8d25\uff0c\u6ca1\u6709\u8be5Team:" + teamId), (Object[])new Object[0]);
        }
    }

    public TeamInfo changeTeamInfo(boolean canPlay, String gameId, int teamTemplate, int playerNumber, String teamId, long captainUid, List<TeamUserInfo> teamUserInfoList) {
        return this.initTeamInfo(canPlay, gameId, teamTemplate, teamId, playerNumber, captainUid, teamUserInfoList);
    }

    public void removeTeamNumber(String teamId, TeamUserInfo teamUserInfo) {
        if (TextUtils.isEmpty((CharSequence)teamId)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"removeTeamNumber:teamId\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        if (teamUserInfo == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)("removeTeamNumber:teamId:" + teamId + ", remove\u7684teamUserInfo\u4e3a\u7a7a"), (Object[])new Object[0]);
            }
            return;
        }
        TeamInfo teamInfo = this.checkTeamInfo(teamId);
        teamInfo.removeTeamUserInfo(teamUserInfo);
    }

    private TeamInfo checkTeamInfo(String teamId) {
        if (this.mTeamInfoMap == null) {
            this.mTeamInfoMap = new HashMap<String, TeamInfo>();
        }
        if (TextUtils.isEmpty((CharSequence)teamId)) {
            return new TeamInfo();
        }
        if (!this.mTeamInfoMap.containsKey(teamId)) {
            return new TeamInfo();
        }
        return this.mTeamInfoMap.get(teamId);
    }
}

