/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.provider;

import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.TeamGameConfigData;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.URLUtils;
import com.yy.framework.core.Environment;
import com.yy.game.bean.GameDataModel;
import com.yy.game.bean.GamePlayCountBean;
import com.yy.game.bean.GameWinData;
import com.yy.game.bean.MultiModePlayBean;
import com.yy.game.gamemodule.teamgame.teammatch.model.invite.GameShareData;
import com.yy.game.gamemodule.teamgame.teammatch.services.IGameDataProvider;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.gamemode.GameModeInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import java.util.HashMap;
import okhttp3.Call;

public class TeamGameDataModel
extends DefaultController
implements IGameDataProvider {
    private static final String TAG = "TeamGameDataModel";
    String gid = "";
    GameShareData gameShareData = null;
    private int mGameMatchBgRes = -1;

    public TeamGameDataModel(Environment env, String gid, int bgRes) {
        super(env);
        this.gid = gid;
        this.mGameMatchBgRes = bgRes;
    }

    public TeamGameDataModel(Environment env, String gid) {
        super(env);
        this.gid = gid;
    }

    @Override
    public GameInfo getGameInfo() {
        return ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(this.gid);
    }

    @Override
    public String getCurrentGid() {
        return this.gid;
    }

    @Override
    public boolean isTeamGameGuideShow(String gid) {
        TeamGameConfigData.GameConfigItem item = this.getGameConfig(gid);
        if (item != null) {
            return item.getGuideSwitch();
        }
        return false;
    }

    @Override
    public String getTeamGameBG(String gid) {
        GameInfo gameInfo = ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gid);
        TeamGameConfigData.GameConfigItem item = this.getGameConfig(gid);
        if (item != null) {
            if (gameInfo != null && gameInfo.getScreenDire() == 2) {
                return item.getBgUrlLandscape();
            }
            return item.getBgUrl();
        }
        return "";
    }

    @Override
    public boolean isTeamGameBGNinePatch(String gid) {
        TeamGameConfigData.GameConfigItem item = this.getGameConfig(gid);
        if (item != null) {
            return item.getBgUrlNinePatch();
        }
        return false;
    }

    @Override
    public String getTeamGuideUrl(String gid) {
        TeamGameConfigData.GameConfigItem item = this.getGameConfig(gid);
        if (item != null) {
            return item.getGuideUrl();
        }
        return "";
    }

    @Override
    public boolean getTeamBackShow(String gid) {
        TeamGameConfigData.GameConfigItem item = this.getGameConfig(gid);
        if (item != null) {
            return item.ismGameBackShow();
        }
        return true;
    }

    public String getShareUrl() {
        TeamGameConfigData.GameConfigItem item = this.getGameConfig(this.gid);
        if (item != null) {
            return URLUtils.replaceUrl((String)item.getShareUrl());
        }
        return "";
    }

    public String getShareTitle() {
        TeamGameConfigData.GameConfigItem item = this.getGameConfig(this.gid);
        if (item != null) {
            return item.getShareTitle();
        }
        return "";
    }

    public String getShareSubtitle() {
        TeamGameConfigData.GameConfigItem item = this.getGameConfig(this.gid);
        if (item != null) {
            return item.getShareSubtitle();
        }
        return "";
    }

    public String getShareImg() {
        TeamGameConfigData.GameConfigItem item = this.getGameConfig(this.gid);
        if (item != null) {
            return item.getShareImageUrl();
        }
        return "";
    }

    public String getShareContent() {
        TeamGameConfigData.GameConfigItem item = this.getGameConfig(this.gid);
        if (item != null) {
            return item.getShareContent();
        }
        return "";
    }

    @Override
    public GameShareData getGameShareData() {
        if (this.gameShareData == null) {
            this.gameShareData = GameShareData.newBuilder().mShareContent(this.getShareContent()).mShareImageUrl(this.getShareImg()).mShareUrl(this.getShareUrl()).mShareTitle(this.getShareTitle()).mShareSubtitle(this.getShareSubtitle()).build();
        }
        return this.gameShareData;
    }

    public TeamGameConfigData.GameConfigItem getGameConfig(String gid) {
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.TEAM_GAME_CONFIG);
        TeamGameConfigData.GameConfigItem gameConfig = null;
        if (config instanceof TeamGameConfigData && StringUtils.isNotEmpty((String)gid)) {
            gameConfig = ((TeamGameConfigData)config).getGame(gid);
            return gameConfig;
        }
        return null;
    }

    @Override
    public void updataGameWinData(final String gamdId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("gid", gamdId);
        HttpUtil.httpReq((String)UriProvider.GAME_GET_GAME_WIN_DATA, map, (int)1, (INetRespCallback)new INetRespCallback<GameWinData>(){

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponse(String response, BaseResponseBean<GameWinData> res, int id2) {
                if (res.isSuccess()) {
                    GamePlayCountBean playCountBean = GameDataModel.mGamePlayedMap.get(gamdId);
                    if (res.data == null) {
                        MLog.error((Object)TeamGameDataModel.TAG, (String)"\u7ec4\u961f\u6e38\u620f\u83b7\u53d6\u6e38\u620f\u6218\u7ee9\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
                        return;
                    }
                    if (playCountBean == null) {
                        playCountBean = new GamePlayCountBean();
                        playCountBean.setGid(gamdId);
                        playCountBean.setTotalCount(((GameWinData)res.data).getTotalCount());
                        playCountBean.setWinCount(((GameWinData)res.data).getWinCount());
                        GameDataModel.mGamePlayedMap.put(gamdId, playCountBean);
                    } else {
                        playCountBean.setTotalCount(((GameWinData)res.data).getTotalCount());
                        playCountBean.setWinCount(((GameWinData)res.data).getWinCount());
                    }
                }
            }
        });
    }

    @Override
    public GamePlayCountBean getPlayCount(String gid) {
        if (GameDataModel.mGamePlayedMap.get(gid) == null) {
            GamePlayCountBean gamePlayCountBean = new GamePlayCountBean();
            gamePlayCountBean.setGid(gid);
            GameDataModel.mGamePlayedMap.put(gid, gamePlayCountBean);
        }
        return GameDataModel.mGamePlayedMap.get(gid);
    }

    @Override
    public Drawable getTeamGameDefaultBG() {
        if (this.mGameMatchBgRes <= 0) {
            return new ColorDrawable(-16510942);
        }
        return ResourceUtils.getDrawable((int)this.mGameMatchBgRes);
    }

    @Override
    public GameModeInfo getCurrentMode() {
        return null;
    }

    @Override
    public void setCurrentModeId(int modeId) {
    }

    @Override
    public String getTeamModeGameBG(String gid, int teamMode) {
        return null;
    }

    @Override
    public boolean isTeamGameModeBGNinePatch(String gid, int teamMode) {
        return false;
    }

    @Override
    public MultiModePlayBean getModePlayCount(String gid, int teamMode) {
        return null;
    }

    @Override
    public void updataModeWinData(String gid, int multiMode) {
    }

    @Override
    public String getModeCenterGuide(String gid) {
        return null;
    }
}

