/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.provider;

import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.TeamMultiGameConfigData;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.URLUtils;
import com.yy.framework.core.Environment;
import com.yy.game.bean.GameDataModel;
import com.yy.game.bean.GameMultiModeBean;
import com.yy.game.bean.GamePlayCountBean;
import com.yy.game.bean.GameWinData;
import com.yy.game.bean.MultiModePlayBean;
import com.yy.game.gamemodule.teamgame.teammatch.model.invite.GameShareData;
import com.yy.game.gamemodule.teamgame.teammatch.services.IGameDataProvider;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.gamemode.GameModeInfo;
import com.yy.hiyo.game.base.gamemode.MultiModeInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ModeGameDataProvider
extends DefaultController
implements IGameDataProvider {
    private static final String TAG = "ModeGameDataProvider";
    String gid = "";
    int mMultiMode = 0;
    GameShareData gameShareData = null;
    private int mGameMatchBgRes = -1;

    public ModeGameDataProvider(Environment env, String gid, int bgRes, int multiMode) {
        super(env);
        this.gid = gid;
        this.mGameMatchBgRes = bgRes;
        this.mMultiMode = multiMode;
    }

    public ModeGameDataProvider(Environment env, String gid) {
        super(env);
        this.gid = gid;
    }

    @Override
    public GameInfo getGameInfo() {
        return ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(this.gid);
    }

    @Override
    public String getCurrentGid() {
        return this.gid;
    }

    @Override
    public boolean isTeamGameGuideShow(String gid) {
        TeamMultiGameConfigData.GameConfigItem item = this.getGameConfig(gid);
        if (item != null) {
            return item.getGuideswitch() == 1;
        }
        return false;
    }

    @Override
    public String getTeamGameBG(String gid) {
        GameInfo gameInfo = ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gid);
        TeamMultiGameConfigData.GameConfigItem.TemplateListBean item = this.getGameModeConfig(gid, this.mMultiMode);
        if (item != null) {
            if (gameInfo != null && gameInfo.getScreenDire() == 2) {
                return item.getBgurlLandscape();
            }
            return item.getBgurl();
        }
        return "";
    }

    @Override
    public boolean isTeamGameBGNinePatch(String gid) {
        TeamMultiGameConfigData.GameConfigItem.TemplateListBean item = this.getGameModeConfig(gid, this.mMultiMode);
        if (item != null) {
            return item.getBgurlninepatch() == 1;
        }
        return false;
    }

    @Override
    public String getTeamGuideUrl(String gid) {
        TeamMultiGameConfigData.GameConfigItem.TemplateListBean item = this.getGameModeConfig(gid, this.mMultiMode);
        if (item != null) {
            return item.getGuideurl();
        }
        return "";
    }

    @Override
    public boolean getTeamBackShow(String gid) {
        TeamMultiGameConfigData.GameConfigItem item = this.getGameConfig(gid);
        if (item != null) {
            return item.getGamebackbtnshow() == 1;
        }
        return true;
    }

    public String getShareUrl() {
        TeamMultiGameConfigData.GameConfigItem.TemplateListBean item = this.getGameModeConfig(this.gid, this.mMultiMode);
        if (item != null) {
            return URLUtils.replaceUrl((String)item.getShareurl());
        }
        return "";
    }

    public String getShareTitle() {
        TeamMultiGameConfigData.GameConfigItem.TemplateListBean item = this.getGameModeConfig(this.gid, this.mMultiMode);
        if (item != null) {
            return item.getSharetitle();
        }
        return "";
    }

    public String getShareSubtitle() {
        TeamMultiGameConfigData.GameConfigItem.TemplateListBean item = this.getGameModeConfig(this.gid, this.mMultiMode);
        if (item != null) {
            return item.getSharesubtitle();
        }
        return "";
    }

    public String getShareImg() {
        TeamMultiGameConfigData.GameConfigItem.TemplateListBean item = this.getGameModeConfig(this.gid, this.mMultiMode);
        if (item != null) {
            return item.getShareimage();
        }
        return "";
    }

    public String getShareContent() {
        TeamMultiGameConfigData.GameConfigItem.TemplateListBean item = this.getGameModeConfig(this.gid, this.mMultiMode);
        if (item != null) {
            return item.getSharecontent();
        }
        return "";
    }

    @Override
    public GameShareData getGameShareData() {
        if (this.gameShareData == null) {
            this.gameShareData = GameShareData.newBuilder().mShareContent(this.getShareContent()).mShareImageUrl(this.getShareImg()).mShareUrl(this.getShareUrl()).mShareTitle(this.getShareTitle()).mShareSubtitle(this.getShareSubtitle()).build();
        }
        return this.gameShareData;
    }

    public TeamMultiGameConfigData.GameConfigItem getGameConfig(String gid) {
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.TEAM_GAME_MULTI_CONFIG);
        TeamMultiGameConfigData.GameConfigItem gameConfig = null;
        if (config instanceof TeamMultiGameConfigData && StringUtils.isNotEmpty((String)gid)) {
            gameConfig = ((TeamMultiGameConfigData)config).getGame(gid);
            return gameConfig;
        }
        return null;
    }

    public TeamMultiGameConfigData.GameConfigItem.TemplateListBean getGameModeConfig(String gid, int modeId) {
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.TEAM_GAME_MULTI_CONFIG);
        TeamMultiGameConfigData.GameConfigItem gameConfig = null;
        if (config instanceof TeamMultiGameConfigData && StringUtils.isNotEmpty((String)gid)) {
            gameConfig = ((TeamMultiGameConfigData)config).getGame(gid);
            if (gameConfig == null) {
                return null;
            }
            if (gameConfig.getTemplateList() == null) {
                return null;
            }
            for (TeamMultiGameConfigData.GameConfigItem.TemplateListBean templateListBean : gameConfig.getTemplateList()) {
                if (templateListBean.getId() != modeId) continue;
                return templateListBean;
            }
            return (TeamMultiGameConfigData.GameConfigItem.TemplateListBean)gameConfig.getTemplateList().get(0);
        }
        return null;
    }

    @Override
    public void updataGameWinData(final String gameId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("gid", gameId);
        map.put("submode", String.valueOf(this.mMultiMode));
        HttpUtil.httpReq((String)UriProvider.GAME_GET_GAME_WIN_DATA, map, (int)1, (INetRespCallback)new INetRespCallback<GameWinData>(){

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponse(String response, BaseResponseBean<GameWinData> res, int id2) {
                if (res.isSuccess()) {
                    GamePlayCountBean playCountBean = GameDataModel.mGamePlayedMap.get(gameId);
                    if (res == null || res.data == null) {
                        return;
                    }
                    if (playCountBean == null) {
                        playCountBean = new GamePlayCountBean();
                        playCountBean.setGid(gameId);
                        playCountBean.setTotalCount(((GameWinData)res.data).getTotalCount());
                        playCountBean.setWinCount(((GameWinData)res.data).getWinCount());
                        GameDataModel.mGamePlayedMap.put(gameId, playCountBean);
                    } else {
                        playCountBean.setTotalCount(((GameWinData)res.data).getTotalCount());
                        playCountBean.setWinCount(((GameWinData)res.data).getWinCount());
                    }
                }
            }
        });
    }

    @Override
    public GamePlayCountBean getPlayCount(String gid) {
        if (GameDataModel.mGamePlayedMap.get(gid) == null) {
            GamePlayCountBean gamePlayCountBean = new GamePlayCountBean();
            gamePlayCountBean.setGid(gid);
            GameDataModel.mGamePlayedMap.put(gid, gamePlayCountBean);
        }
        return GameDataModel.mGamePlayedMap.get(gid);
    }

    @Override
    public Drawable getTeamGameDefaultBG() {
        if (this.mGameMatchBgRes <= 0) {
            return new ColorDrawable(-16510942);
        }
        return ResourceUtils.getDrawable((int)this.mGameMatchBgRes);
    }

    @Override
    public GameModeInfo getCurrentMode() {
        GameInfo gameInfo = this.getGameInfo();
        if (gameInfo == null) {
            return null;
        }
        MultiModeInfo multiModeInfo = gameInfo.getMultiModeInfo();
        if (multiModeInfo == null || multiModeInfo.getModeList() == null || multiModeInfo.getModeList().size() == 0) {
            return null;
        }
        GameModeInfo gameModeInfo = multiModeInfo.findModeById(this.mMultiMode);
        if (gameModeInfo == null) {
            gameModeInfo = (GameModeInfo)multiModeInfo.getModeList().get(0);
        }
        return gameModeInfo;
    }

    @Override
    public void setCurrentModeId(int modeId) {
        if (modeId != this.mMultiMode) {
            this.gameShareData = null;
        }
        this.mMultiMode = modeId;
    }

    @Override
    public String getTeamModeGameBG(String gid, int multiMode) {
        TeamMultiGameConfigData.GameConfigItem.TemplateListBean item = this.getGameModeConfig(gid, multiMode);
        if (item != null) {
            return item.getBgurl();
        }
        return "";
    }

    @Override
    public boolean isTeamGameModeBGNinePatch(String gid, int teamMode) {
        TeamMultiGameConfigData.GameConfigItem.TemplateListBean item = this.getGameModeConfig(gid, this.mMultiMode);
        if (item != null) {
            return item.getBgurlninepatch() == 1;
        }
        return false;
    }

    @Override
    public MultiModePlayBean getModePlayCount(String gid, int multiMode) {
        GameMultiModeBean gameMultiModeBean = GameDataModel.mModePlayedMap.get(gid);
        if (gameMultiModeBean == null) {
            gameMultiModeBean = new GameMultiModeBean();
            gameMultiModeBean.setGid(gid);
            ArrayList<MultiModePlayBean> multiModePlayBeanList = new ArrayList<MultiModePlayBean>();
            MultiModePlayBean multiModePlayBean = new MultiModePlayBean();
            multiModePlayBean.setMultiModeId(multiMode);
            multiModePlayBeanList.add(multiModePlayBean);
            gameMultiModeBean.setListPlayBean(multiModePlayBeanList);
            GameDataModel.mModePlayedMap.put(gid, gameMultiModeBean);
            return multiModePlayBean;
        }
        if (FP.empty(gameMultiModeBean.getListPlayBean())) {
            ArrayList<MultiModePlayBean> multiModePlayBeanList = new ArrayList<MultiModePlayBean>();
            MultiModePlayBean multiModePlayBean = new MultiModePlayBean();
            multiModePlayBean.setMultiModeId(multiMode);
            multiModePlayBeanList.add(multiModePlayBean);
            gameMultiModeBean.setListPlayBean(multiModePlayBeanList);
            return multiModePlayBean;
        }
        for (MultiModePlayBean multiModePlayBean : gameMultiModeBean.getListPlayBean()) {
            if (multiModePlayBean.getMultiModeId() != multiMode) continue;
            return multiModePlayBean;
        }
        MultiModePlayBean multiModePlayBean = new MultiModePlayBean();
        multiModePlayBean.setMultiModeId(multiMode);
        gameMultiModeBean.getListPlayBean().add(multiModePlayBean);
        return multiModePlayBean;
    }

    @Override
    public void updataModeWinData(final String gid, final int multiMode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("gid", gid);
        map.put("submode", String.valueOf(multiMode));
        HttpUtil.httpReq((String)UriProvider.GAME_GET_GAME_WIN_DATA, map, (int)1, (INetRespCallback)new INetRespCallback<GameWinData>(){

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponse(String response, BaseResponseBean<GameWinData> res, int id2) {
                if (res.isSuccess()) {
                    GameMultiModeBean gameMultiModeBean = GameDataModel.mModePlayedMap.get(gid);
                    if (res == null || res.data == null) {
                        MLog.error((Object)ModeGameDataProvider.TAG, (String)"updataModeWinData RES = %s", (Object[])new Object[]{response});
                        return;
                    }
                    if (gameMultiModeBean == null) {
                        gameMultiModeBean = new GameMultiModeBean();
                        gameMultiModeBean.setGid(gid);
                        ArrayList<MultiModePlayBean> multiModePlayBeanList = new ArrayList<MultiModePlayBean>();
                        MultiModePlayBean multiModePlayBean = new MultiModePlayBean();
                        multiModePlayBean.setMultiModeId(multiMode);
                        multiModePlayBean.setTotalCount(((GameWinData)res.data).getTotalCount());
                        multiModePlayBean.setWinCount(((GameWinData)res.data).getWinCount());
                        multiModePlayBeanList.add(multiModePlayBean);
                        gameMultiModeBean.setListPlayBean(multiModePlayBeanList);
                        GameDataModel.mModePlayedMap.put(gid, gameMultiModeBean);
                    } else if (FP.empty(gameMultiModeBean.getListPlayBean())) {
                        ArrayList<MultiModePlayBean> multiModePlayBeanList = new ArrayList<MultiModePlayBean>();
                        MultiModePlayBean multiModePlayBean = new MultiModePlayBean();
                        multiModePlayBean.setMultiModeId(multiMode);
                        multiModePlayBean.setTotalCount(((GameWinData)res.data).getTotalCount());
                        multiModePlayBean.setWinCount(((GameWinData)res.data).getWinCount());
                        multiModePlayBeanList.add(multiModePlayBean);
                        gameMultiModeBean.setListPlayBean(multiModePlayBeanList);
                    } else {
                        for (MultiModePlayBean multiModePlayBean : gameMultiModeBean.getListPlayBean()) {
                            if (multiModePlayBean.getMultiModeId() != multiMode) continue;
                            multiModePlayBean.setTotalCount(((GameWinData)res.data).getTotalCount());
                            multiModePlayBean.setWinCount(((GameWinData)res.data).getWinCount());
                            return;
                        }
                        MultiModePlayBean multiModePlayBean = new MultiModePlayBean();
                        multiModePlayBean.setMultiModeId(multiMode);
                        multiModePlayBean.setTotalCount(((GameWinData)res.data).getTotalCount());
                        multiModePlayBean.setWinCount(((GameWinData)res.data).getWinCount());
                        gameMultiModeBean.getListPlayBean().add(multiModePlayBean);
                    }
                }
            }
        });
    }

    @Override
    public String getModeCenterGuide(String gid) {
        TeamMultiGameConfigData.GameConfigItem gameConfigItem = this.getGameConfig(gid);
        if (gameConfigItem == null) {
            return null;
        }
        return gameConfigItem.getModeCenterGuide();
    }
}

