/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.protocol;

import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.data.UserInfoBean;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.game.gamemodule.teamgame.teammatch.model.TeamInfo;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.RoomStatusDataModel;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamGameHeartbeatCallback;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamGetGameInfoCallback;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamGetTeamInfoCallback;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamImCancelCreateCallback;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamImInviteAcceptCallback;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamLeaveCallback;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamMatchCallback;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamMatchCancelCallback;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamPlayAgainCallback;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamTempletehangeCallback;
import com.yy.game.gamemodule.teamgame.teammatch.provider.TeamRoomDataModel;
import com.yy.game.gamemodule.teamgame.teammatch.services.IJoinTeamCallback;
import com.yy.game.gamemodule.teamgame.teammatch.services.ITeamCreateCallback;
import com.yy.game.metric.GameMetricCode;
import com.yy.game.metric.GameMetricHelper;
import com.yy.hiyo.game.base.TeamUserInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import common.Header;
import ikxd.pkgame.CreateTeamReq;
import ikxd.pkgame.CreateTeamRes;
import ikxd.pkgame.IKXDPKGameUri;
import ikxd.pkgame.IKXDPkGameProto;
import ikxd.pkgame.ImCancelCreateTeamReq;
import ikxd.pkgame.ImInviteCreateTeamReq;
import ikxd.pkgame.ImInviteCreateTeamRes;
import ikxd.pkgame.JoinTeamReq;
import ikxd.pkgame.JoinTeamRes;
import ikxd.pkgame.LeaveTeamReq;
import ikxd.pkgame.LeaveTeamRes;
import ikxd.pkgame.TeamChangeTemplateReq;
import ikxd.pkgame.TeamGetGameInfoReq;
import ikxd.pkgame.TeamGetGameInfoRes;
import ikxd.pkgame.TeamGetTeamInfoReq;
import ikxd.pkgame.TeamGetTeamInfoRes;
import ikxd.pkgame.TeamHeartbeatReq;
import ikxd.pkgame.TeamImInviteAcceptReq;
import ikxd.pkgame.TeamImInviteAcceptRes;
import ikxd.pkgame.TeamMatchCancelReq;
import ikxd.pkgame.TeamMatchCancelRes;
import ikxd.pkgame.TeamMatchReq;
import ikxd.pkgame.TeamMatchRes;
import ikxd.pkgame.TeamPlayAgainReq;
import ikxd.pkgame.TeamPlayAgainRes;
import ikxd.pkgame.UserInfo;
import java.util.ArrayList;
import java.util.List;

public class TeamGameProtocolHelper {
    private static final String TAG = "TeamGameProtocolHelper";

    public static void createTeam(@NonNull GameInfo gameInfo, @NonNull int teamTempalte, boolean isGoldGame, final @NonNull TeamUserInfo teamUserInfo, final @NonNull ITeamCreateCallback callback2) {
        if (teamUserInfo == null || teamUserInfo.getUserInfoKS() == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"CreateTeam:\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        if (gameInfo == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"CreateTeam:\u6e38\u620f\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"createTeam userinfo :%s", (Object[])new Object[]{teamUserInfo.toString()});
                }
            }
        });
        CreateTeamReq createTeamReq = new CreateTeamReq.Builder().game_id(gameInfo.gid).team_template(Integer.valueOf(teamTempalte)).nick(teamUserInfo.getUserInfoKS().getNick() == null ? "" : teamUserInfo.getUserInfoKS().getNick()).sex(Integer.valueOf(teamUserInfo.getUserInfoKS().getSex())).is_gold(Boolean.valueOf(gameInfo.isGoldMode())).from_type(Long.valueOf(isGoldGame ? 1L : 0L)).game_ver(Long.valueOf(StringUtils.parseLong((String)gameInfo.getModulerVer()))).avatar(teamUserInfo.getUserInfoKS().getAvatar()).supported_tpls(gameInfo.getMutiModeIdList()).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_pkgame_d");
        IKXDPkGameProto teamGameProto = new IKXDPkGameProto.Builder().header(header).uri(IKXDPKGameUri.kUriCreateTeamReq).create_team_req(createTeamReq).build();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("CreateTeam:seqId:" + header.seqid), (Object[])new Object[0]);
        }
        ProtoManager.getInstance().send((AndroidMessage)teamGameProto, (IProtoCallback)new IProtoCallback<IKXDPkGameProto>(){

            public void onResponse(@Nullable IKXDPkGameProto message) {
                if (message == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"CreateTeam:\u8bf7\u6c42\u7684IKXDPkGameProto\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    return;
                }
                Header header = message.header;
                if (header == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"CreateTeam:\u8bf7\u6c42\u7684Header\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    return;
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("CreateTeam:seqId:" + header.seqid), (Object[])new Object[0]);
                }
                if (header.code == 0L) {
                    CreateTeamRes createTeamRes = message.create_team_res;
                    if (createTeamRes == null) {
                        return;
                    }
                    String gameId = createTeamRes.game_id;
                    int teamTemplate = createTeamRes.team_template;
                    String teamId = createTeamRes.team_id;
                    int playerNumber = createTeamRes.player_number;
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("CreateTeam:\u521b\u5efa\u6210\u529f:" + teamId), (Object[])new Object[0]);
                    }
                    long teamHeartbeatTime = createTeamRes.heartbeat_interval_seconds;
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("CreateTeam:\u83b7\u53d6\u5230\u7684\u5fc3\u8df3\u65f6\u95f4:" + teamHeartbeatTime + ", \u521b\u5efa\u7684team:" + teamId), (Object[])new Object[0]);
                    }
                    TeamInfo teamInfo = TeamRoomDataModel.instance.initTeamInfo(true, gameId, teamTemplate, teamId, playerNumber);
                    TeamRoomDataModel.instance.setTeamStatus(teamInfo.getTeamId(), 1);
                    if (callback2 != null) {
                        callback2.onTeamCreateSuccess(teamInfo, teamHeartbeatTime);
                    }
                } else {
                    if (header.code == 2003L) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"CreateTeam:\u6b63\u5728\u6e38\u620f\u4e2d", (Object[])new Object[0]);
                        }
                    } else if (header.code == 2005L && MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"CreateTeam:\u6b63\u5728\u961f\u4f0d\u4e2d", (Object[])new Object[0]);
                    }
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("CreateTeam:\u5931\u8d25:" + header.code), (Object[])new Object[0]);
                    }
                    if (callback2 != null) {
                        callback2.onTeamCreateFailed(header.code);
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"createTeam:\u8d85\u65f6", (Object[])new Object[0]);
                            }
                            callback2.onTeamCreateFailed(10000L);
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("createTeam:\u5931\u8d25\u539f\u56e0:" + reason + ", code:" + code), (Object[])new Object[0]);
                            }
                            callback2.onTeamCreateFailed(code);
                        }
                    }
                });
                return false;
            }
        });
    }

    public static void imInviteCreateTeam(@NonNull GameInfo gameInfo, @NonNull int teamTemplate, @NonNull UserInfoBean userInfo, @NonNull long targetUid, final @NonNull ITeamCreateCallback teamCreateCallback) {
        if (userInfo == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"ImInviteCreateTeam:\u7528\u6237\u60f3\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        if (gameInfo == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"imInviteCreateTeam:\u6e38\u620f\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        ImInviteCreateTeamReq.Builder builder = new ImInviteCreateTeamReq.Builder();
        builder.game_id(gameInfo.getGid()).team_template(Integer.valueOf(teamTemplate)).nick(userInfo.getNick()).sex(Integer.valueOf(userInfo.getSex())).avatar(userInfo.getAvatar()).target_uid(Long.valueOf(targetUid)).supported_tpls(gameInfo.getMutiModeIdList()).game_ver(Long.valueOf(StringUtils.parseLong((String)gameInfo.getModulerVer())));
        Header header = ProtoManager.getInstance().getHeader("ikxd_pkgame_d");
        IKXDPkGameProto teamGameProto = new IKXDPkGameProto.Builder().header(header).uri(IKXDPKGameUri.kUriImInviteCreateTeamReq).im_invite_create_team_req(builder.build()).build();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("ImInviteCreateTeam:seqId:" + header.seqid), (Object[])new Object[0]);
        }
        ProtoManager.getInstance().send((AndroidMessage)teamGameProto, (IProtoCallback)new IProtoCallback<IKXDPkGameProto>(){

            public void onResponse(@Nullable IKXDPkGameProto message) {
                if (message == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"CreateTeam:\u8bf7\u6c42\u7684IKXDPkGameProto\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    return;
                }
                Header header = message.header;
                if (header == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"ImInviteCreateTeam:\u8bf7\u6c42\u7684Header\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    return;
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("ImInviteCreateTeam:seqId:" + header.seqid), (Object[])new Object[0]);
                }
                if (header.code != 0L) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"ImInviteCreateTeam not success %d", (Object[])new Object[]{header.code});
                    }
                    if (teamCreateCallback != null) {
                        teamCreateCallback.onTeamCreateFailed(header.code);
                    }
                    return;
                }
                if (header.code == 0L) {
                    ImInviteCreateTeamRes imInviteCreateTeamRes = message.im_invite_create_team_res;
                    if (imInviteCreateTeamRes == null) {
                        return;
                    }
                    String gameId = imInviteCreateTeamRes.game_id;
                    int teamTemplate = imInviteCreateTeamRes.team_template;
                    String teamId = imInviteCreateTeamRes.team_id;
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("ImInviteCreateTeam:\u521b\u5efa\u6210\u529f:" + teamId), (Object[])new Object[0]);
                    }
                    TeamInfo teamInfo = TeamRoomDataModel.instance.initTeamInfo(true, gameId, teamTemplate, teamId, 0);
                    TeamRoomDataModel.instance.setTeamStatus(teamInfo.getTeamId(), 1);
                    if (teamCreateCallback != null) {
                        teamCreateCallback.onImInviteCreateSuccess(teamInfo);
                    }
                } else if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("ImInviteCreateTeam:\u5931\u8d25:" + header.code), (Object[])new Object[0]);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (teamCreateCallback != null) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"ImInviteCreateTeam:\u8d85\u65f6", (Object[])new Object[0]);
                            }
                            teamCreateCallback.onTeamCreateFailed(10000L);
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (teamCreateCallback != null) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("ImInviteCreateTeam:\u5931\u8d25\u539f\u56e0:" + reason + ", code:" + code), (Object[])new Object[0]);
                            }
                            teamCreateCallback.onTeamCreateFailed(code);
                        }
                    }
                });
                return false;
            }
        });
    }

    public static void imCancelCreateTeam(final String teamId, final long targetUid, final @NonNull ITeamImCancelCreateCallback callback2) {
        if (TextUtils.isEmpty((CharSequence)teamId)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"ImCancelCreateTeam:TeamId\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        ImCancelCreateTeamReq imCancelCreateTeamReq = new ImCancelCreateTeamReq.Builder().team_id(teamId).target_uid(Long.valueOf(targetUid)).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_pkgame_d");
        IKXDPkGameProto teamGameProto = new IKXDPkGameProto.Builder().header(header).uri(IKXDPKGameUri.kUriImCancelCreateTeamReq).im_cancel_create_team_req(imCancelCreateTeamReq).build();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("ImCancelCreateTeam:seqId:" + header.seqid), (Object[])new Object[0]);
        }
        ProtoManager.getInstance().send((AndroidMessage)teamGameProto, (IProtoCallback)new IProtoCallback<IKXDPkGameProto>(){

            public void onResponse(@Nullable IKXDPkGameProto message) {
                if (message == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"CreateTeam:\u8bf7\u6c42\u7684IKXDPkGameProto\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    return;
                }
                Header header = message.header;
                if (header == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"ImCancelCreateTeam:\u8bf7\u6c42\u7684Header\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    return;
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("ImCancelCreateTeam:seqId:" + header.seqid), (Object[])new Object[0]);
                }
                if (header.code == 0L) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("ImCancelCreateTeam:\u53d6\u6d88\u6210\u529f:" + teamId), (Object[])new Object[0]);
                    }
                    if (callback2 != null) {
                        callback2.onTeamImCancelCreateSuccess(teamId, targetUid);
                    }
                } else {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("ImCancelCreateTeam:\u5931\u8d25:" + header.code + ", teamId:" + teamId), (Object[])new Object[0]);
                    }
                    if (callback2 != null) {
                        callback2.onTeamImCancelCreateFailed(header.code);
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"ImCancelCreateTeam:\u8d85\u65f6", (Object[])new Object[0]);
                            }
                            callback2.onTeamImCancelCreateFailed(10000L);
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("ImCancelCreateTeam:\u5931\u8d25\u539f\u56e0:" + reason + ", code:" + code), (Object[])new Object[0]);
                            }
                            callback2.onTeamImCancelCreateFailed(code);
                        }
                    }
                });
                return false;
            }
        });
    }

    public static void joinTeam(@NonNull GameInfo gameInfo, final @NonNull int teamTemplate, final @NonNull String teamId, @NonNull TeamUserInfo userInfo, @NonNull long inviteUid, final IJoinTeamCallback callback2) {
        String avatar;
        if (userInfo == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"JoinTeam:\u7528\u6237\u60f3\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        if (gameInfo == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"CreateTeam:\u6e38\u620f\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)teamId)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"JoinTeam:teamId\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        String name = userInfo.getUserInfoKS().getNick();
        if (StringUtils.isEmpty((String)name)) {
            name = "";
        }
        if (StringUtils.isEmpty((String)(avatar = userInfo.getUserInfoKS().getAvatar()))) {
            avatar = "";
        }
        JoinTeamReq.Builder builder = new JoinTeamReq.Builder();
        builder.avatar(avatar).game_id(gameInfo.gid).game_ver(Long.valueOf(StringUtils.parseLong((String)gameInfo.getModulerVer()))).team_template(Integer.valueOf(teamTemplate)).invite_uid(Long.valueOf(inviteUid)).nick(name).sex(Integer.valueOf(userInfo.getUserInfoKS().getSex())).team_id(teamId).supported_tpls(gameInfo.getMutiModeIdList());
        Header header = ProtoManager.getInstance().getHeader("ikxd_pkgame_d");
        IKXDPkGameProto teamGameProto = new IKXDPkGameProto.Builder().header(header).uri(IKXDPKGameUri.kUriJoinTeamReq).join_team_req(builder.build()).build();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("JoinTeam:seqId:" + header.seqid), (Object[])new Object[0]);
        }
        ProtoManager.getInstance().send((AndroidMessage)teamGameProto, (IProtoCallback)new IProtoCallback<IKXDPkGameProto>(){

            public void onResponse(@Nullable IKXDPkGameProto message) {
                if (message == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"CreateTeam:\u8bf7\u6c42\u7684IKXDPkGameProto\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    return;
                }
                Header header = message.header;
                if (header == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"JoinTeam:\u8bf7\u6c42\u7684Header\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    return;
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("JoinTeam:seqId:" + header.seqid), (Object[])new Object[0]);
                }
                if (header.code == 0L) {
                    JoinTeamRes joinTeamRes = message.join_team_res;
                    if (joinTeamRes == null) {
                        return;
                    }
                    String gameId = joinTeamRes.game_id;
                    int teamTemplate2 = joinTeamRes.team_template;
                    String teamId2 = joinTeamRes.team_id;
                    int playerNumber = joinTeamRes.player_number;
                    long teamHeartbeatTime = joinTeamRes.heartbeat_interval_seconds;
                    boolean canPlay = joinTeamRes.can_play;
                    List userInfoList = joinTeamRes.players;
                    ArrayList<TeamUserInfo> teamUserInfoList = new ArrayList<TeamUserInfo>();
                    long captainUid = 0L;
                    for (UserInfo info : userInfoList) {
                        TeamUserInfo teamUserInfo = new TeamUserInfo();
                        teamUserInfo.setCaptain(info.b_captain.booleanValue());
                        teamUserInfo.setSeatNumber(info.seat_number.intValue());
                        teamUserInfo.setUid(info.uid.longValue());
                        teamUserInfoList.add(teamUserInfo);
                        if (!info.b_captain.booleanValue()) continue;
                        captainUid = info.uid;
                    }
                    long teamCaptainUid = captainUid;
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("JoinTeam:\u52a0\u5165\u6210\u529f:" + teamId2), (Object[])new Object[0]);
                    }
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("JoinTeam:\u83b7\u53d6\u5230\u7684\u5fc3\u8df3\u65f6\u95f4:" + teamHeartbeatTime + "\uff0c\u52a0\u5165\u7684team:" + teamId2), (Object[])new Object[0]);
                    }
                    TeamInfo teamInfo = TeamRoomDataModel.instance.initTeamInfo(canPlay, gameId, teamTemplate2, teamId2, playerNumber, teamCaptainUid, teamUserInfoList);
                    TeamRoomDataModel.instance.setTeamStatus(teamId2, 4);
                    if (callback2 != null) {
                        callback2.onJoinTeamSuccess(teamInfo, teamHeartbeatTime);
                    }
                } else {
                    if (header.code == 2003L) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"JoinTeam:\u6b63\u5728\u6e38\u620f\u4e2d", (Object[])new Object[0]);
                        }
                        RoomStatusDataModel.instance.setStatus(0);
                    } else if (header.code == 2002L) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("JoinTeam:\u6e38\u620f\u5df2\u7ecf\u5f00\u59cb\u4e86:" + teamId), (Object[])new Object[0]);
                        }
                    } else if (header.code == 2000L) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("JoinTeam:\u961f\u4f0d\u6ee1\u5458\u4e86:" + teamId), (Object[])new Object[0]);
                        }
                    } else if (header.code == 2001L) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("JoinTeam:\u7ec4\u961f\u5931\u6548:" + teamId), (Object[])new Object[0]);
                        }
                    } else if (header.code == 2004L && MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("JoinTeam:\u9080\u8bf7\u8005\u5df2\u7ecf\u79bb\u5f00:" + teamId), (Object[])new Object[0]);
                    }
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("JoinTeam:\u5931\u8d25:" + header.code + ", teamId:" + teamId), (Object[])new Object[0]);
                    }
                    if (callback2 != null) {
                        callback2.onJoinTeamFail(header.code, teamTemplate);
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"JoinTeam:\u8d85\u65f6", (Object[])new Object[0]);
                            }
                            callback2.onJoinTeamFail(10000L, teamTemplate);
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("JoinTeam:\u5931\u8d25\u539f\u56e0:" + reason + ", code:" + code), (Object[])new Object[0]);
                            }
                            callback2.onJoinTeamFail(code, teamTemplate);
                        }
                    }
                });
                return false;
            }
        });
    }

    public static void leaveTeam(final String teamId, final ITeamLeaveCallback callback2) {
        if (TextUtils.isEmpty((CharSequence)teamId)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"LeaveTeam:teamId\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        LeaveTeamReq leaveTeamReq = new LeaveTeamReq.Builder().team_id(teamId).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_pkgame_d");
        IKXDPkGameProto teamGameProto = new IKXDPkGameProto.Builder().header(header).uri(IKXDPKGameUri.kUriLeaveTeamReq).leave_team_req(leaveTeamReq).build();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("LeaveTeam:seqId:" + header.seqid), (Object[])new Object[0]);
        }
        ProtoManager.getInstance().send((AndroidMessage)teamGameProto, (IProtoCallback)new IProtoCallback<IKXDPkGameProto>(){

            public void onResponse(@Nullable IKXDPkGameProto message) {
                if (message == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"CreateTeam:\u8bf7\u6c42\u7684IKXDPkGameProto\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    return;
                }
                Header header = message.header;
                if (header == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"LeaveTeam:\u8bf7\u6c42\u7684Header\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    return;
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("LeaveTeam:seqId:" + header.seqid), (Object[])new Object[0]);
                }
                if (header.code == 0L) {
                    LeaveTeamRes leaveTeamRes = message.leave_team_res;
                    if (leaveTeamRes == null) {
                        return;
                    }
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("LeaveTeam:\u79bb\u5f00\u6210\u529f:" + teamId), (Object[])new Object[0]);
                    }
                    if (callback2 != null) {
                        callback2.onLeaveTeamSuccess(teamId);
                    }
                } else {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("LeaveTeam:\u5931\u8d25:" + header.code + ", teamId:" + teamId), (Object[])new Object[0]);
                    }
                    if (callback2 != null) {
                        callback2.onLeaveTeamFailed(teamId, header.code);
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (callback2 != null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("LeaveTeam:\u8d85\u65f6:teamId:" + teamId), (Object[])new Object[0]);
                    }
                    callback2.onLeaveTeamFailed(teamId, 10000L);
                }
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("LeaveTeam:\u5931\u8d25\u539f\u56e0:" + reason + ", code:" + code + ", teamId:" + teamId), (Object[])new Object[0]);
                            }
                            callback2.onLeaveTeamFailed(teamId, code);
                        }
                    }
                });
                return false;
            }
        });
    }

    public static void teamMatch(final String teamId, GameInfo gameInfo, int teamTemplate, final boolean isStart, boolean isGoldGame, final ITeamMatchCallback callback2) {
        if (TextUtils.isEmpty((CharSequence)teamId)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"TeamMatch:\u8bf7\u6c42\u7684teamId\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        if (gameInfo == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"CreateTeam:\u6e38\u620f\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        GameMetricCode.USE_MATCH_TIME = 0L;
        final long startTime = SystemClock.elapsedRealtime();
        TeamMatchReq teamMatchReq = new TeamMatchReq.Builder().team_id(teamId).game_id(gameInfo.gid).team_template(Integer.valueOf(teamTemplate)).b_start(Boolean.valueOf(isStart)).is_gold(Boolean.valueOf(isGoldGame)).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_pkgame_d");
        IKXDPkGameProto teamGameProto = new IKXDPkGameProto.Builder().header(header).uri(IKXDPKGameUri.kUriTeamMatchReq).team_match_req(teamMatchReq).build();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("TeamMatch:seqId:" + header.seqid), (Object[])new Object[0]);
        }
        ProtoManager.getInstance().send((AndroidMessage)teamGameProto, (IProtoCallback)new IProtoCallback<IKXDPkGameProto>(){

            public void onResponse(@Nullable IKXDPkGameProto message) {
                long time = SystemClock.elapsedRealtime() - startTime;
                if (message == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"CreateTeam:\u8bf7\u6c42\u7684IKXDPkGameProto\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    GameMetricHelper.reportToMetric("pkGame/kUriTeamMatchReq", time, "2004");
                    return;
                }
                Header header = message.header;
                if (header == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"TeamMatch:\u8bf7\u6c42\u7684Header\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    GameMetricHelper.reportToMetric("pkGame/kUriTeamMatchReq", time, "2001");
                    return;
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamMatch:seqId:" + header.seqid), (Object[])new Object[0]);
                }
                if (header.code == 0L) {
                    TeamMatchRes teamMatchRes = message.team_match_res;
                    if (teamMatchRes == null) {
                        GameMetricHelper.reportToMetric("pkGame/kUriTeamMatchReq", time, "2002");
                        return;
                    }
                    if (isStart) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamMatch:\u5f00\u59cb\u6e38\u620f\u6210\u529f:" + teamId), (Object[])new Object[0]);
                        }
                    } else {
                        TeamInfo teamInfo;
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamMatch:\u53d1\u9001\u5339\u914d\u8bf7\u6c42\u6210\u529f:" + teamId + " ,isGoldGame:" + teamMatchRes.is_gold), (Object[])new Object[0]);
                        }
                        if ((teamInfo = TeamRoomDataModel.instance.getTeamInfo(teamId)) == null) {
                            GameMetricHelper.reportToMetric("pkGame/kUriTeamMatchReq", time, "2003");
                            return;
                        }
                        teamInfo.setGoldGame(teamMatchRes.is_gold);
                        if (teamInfo.getStatus() == 4) {
                            TeamRoomDataModel.instance.setTeamStatus(teamId, 5);
                        } else if (teamInfo.getStatus() == 1) {
                            TeamRoomDataModel.instance.setTeamStatus(teamId, 2);
                        } else if (teamInfo.getStatus() == 0) {
                            if (teamInfo.getTeamUserInfoList().size() <= 1) {
                                TeamRoomDataModel.instance.setTeamStatus(teamId, 2);
                            } else {
                                TeamRoomDataModel.instance.setTeamStatus(teamId, 5);
                            }
                        }
                    }
                    GameMetricCode.USE_MATCH_TIME = SystemClock.elapsedRealtime();
                    GameMetricHelper.reportToMetric("pkGame/kUriTeamMatchReq", time, "0");
                    if (callback2 != null) {
                        callback2.onTeamMatchSuccess(teamId, isStart);
                    }
                } else {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamMatch:\u53d1\u9001\u5339\u914d\u8bf7\u6c42\u5931\u8d25:" + header.code), (Object[])new Object[0]);
                    }
                    GameMetricHelper.reportToMetric("pkGame/kUriTeamMatchReq", time, String.valueOf(header.code));
                    if (callback2 != null) {
                        callback2.onTeamMatchFail(header.code);
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (callback2 != null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"TeamMatch:\u8d85\u65f6", (Object[])new Object[0]);
                    }
                    long time = SystemClock.elapsedRealtime() - startTime;
                    GameMetricHelper.reportToMetric("pkGame/kUriTeamMatchReq", time, "2005");
                    callback2.onTeamMatchFail(10000L);
                }
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            long time = SystemClock.elapsedRealtime() - startTime;
                            GameMetricHelper.reportToMetric("pkGame/kUriTeamMatchReq", time, "99999");
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamMatch:\u5931\u8d25\u539f\u56e0:" + reason + ", code:" + code), (Object[])new Object[0]);
                            }
                            callback2.onTeamMatchFail(code);
                        }
                    }
                });
                return false;
            }
        });
    }

    public static void teamMatchCancel(final String teamId, final ITeamMatchCancelCallback callback2) {
        if (TextUtils.isEmpty((CharSequence)teamId)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"TeamMatchCancel:teamId\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        TeamMatchCancelReq teamMatchCancelReq = new TeamMatchCancelReq.Builder().team_id(teamId).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_pkgame_d");
        IKXDPkGameProto teamGameProto = new IKXDPkGameProto.Builder().header(header).uri(IKXDPKGameUri.kUriTeamMatchCancelReq).team_match_cancel_req(teamMatchCancelReq).build();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("TeamMatchCancel:seqId:" + header.seqid), (Object[])new Object[0]);
        }
        ProtoManager.getInstance().send((AndroidMessage)teamGameProto, (IProtoCallback)new IProtoCallback<IKXDPkGameProto>(){

            public void onResponse(@Nullable IKXDPkGameProto message) {
                if (message == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"CreateTeam:\u8bf7\u6c42\u7684IKXDPkGameProto\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    return;
                }
                Header header = message.header;
                if (header == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"TeamMatchCancel:\u8bf7\u6c42\u7684Header\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    return;
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamMatchCancel:seqId:" + header.seqid), (Object[])new Object[0]);
                }
                if (header.code == 0L) {
                    TeamMatchCancelRes teamMatchCancelRes = message.team_match_cancel_res;
                    if (teamMatchCancelRes == null) {
                        return;
                    }
                    if (callback2 != null) {
                        callback2.onTeamMatchCancelSuccess(teamId);
                    }
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamMatchCancel:\u5339\u914d\u53d6\u6d88Team\u6210\u529f:" + teamId), (Object[])new Object[0]);
                    }
                } else {
                    TeamInfo teamInfo;
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamMatchCancel:\u5339\u914d\u53d6\u6d88Team\u5931\u8d25:" + header.code), (Object[])new Object[0]);
                    }
                    if (callback2 != null) {
                        callback2.onTeamMatchCancelFailed(teamId, header.code);
                    }
                    if (header.code == 2002L && (teamInfo = TeamRoomDataModel.instance.getTeamInfo(teamId)) != null && teamInfo.getStatus() != 7) {
                        TeamRoomDataModel.instance.setTeamStatus(teamId, 8);
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (callback2 != null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamMatchCancel:\u8d85\u65f6:teamId:" + teamId), (Object[])new Object[0]);
                    }
                    callback2.onTeamMatchCancelFailed(teamId, 10000L);
                }
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamMatchCancel:teamId:" + teamId + "\uff0c\u5931\u8d25\u539f\u56e0:" + reason + ", code:" + code), (Object[])new Object[0]);
                            }
                            callback2.onTeamMatchCancelFailed(teamId, 10000L);
                        }
                    }
                });
                return false;
            }
        });
    }

    public static void teamPlayAgain(GameInfo gameInfo, int teamTemplate, TeamUserInfo userInfo, final String roomId, int seatNumber, final ITeamPlayAgainCallback callback2) {
        if (userInfo == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"TeamPlayAgain:\u7528\u6237\u60f3\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        if (gameInfo == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"TeamPlayAgain:gameinfo\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        final GameInfo gameInfoInner = gameInfo;
        TeamPlayAgainReq teamPlayAgainReq = new TeamPlayAgainReq.Builder().game_id(gameInfo.getGid()).avatar(userInfo.getUserInfoKS().getAvatar()).team_template(Integer.valueOf(teamTemplate)).nick(userInfo.getUserInfoKS().getNick()).room_id(roomId).seat_number(Integer.valueOf(seatNumber)).sex(Integer.valueOf(userInfo.getUserInfoKS().getSex())).game_ver(Long.valueOf(StringUtils.parseLong((String)gameInfo.getModulerVer()))).supported_tpls(gameInfoInner.getMutiModeIdList()).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_pkgame_d");
        IKXDPkGameProto teamGameProto = new IKXDPkGameProto.Builder().header(header).uri(IKXDPKGameUri.kUriTeamPlayAgainReq).team_play_again_req(teamPlayAgainReq).build();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("TeamPlayAgain:seqId:" + header.seqid), (Object[])new Object[0]);
        }
        ProtoManager.getInstance().send((AndroidMessage)teamGameProto, (IProtoCallback)new IProtoCallback<IKXDPkGameProto>(){

            public void onResponse(@Nullable IKXDPkGameProto message) {
                if (message == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"CreateTeam:\u8bf7\u6c42\u7684IKXDPkGameProto\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    return;
                }
                Header header = message.header;
                if (header == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"TeamPlayAgain:\u8bf7\u6c42\u7684Header\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    return;
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamPlayAgain:seqId:" + header.seqid), (Object[])new Object[0]);
                }
                if (header.code == 0L) {
                    TeamPlayAgainRes teamPlayAgainRes = message.team_play_again_res;
                    if (teamPlayAgainRes == null) {
                        return;
                    }
                    String teamId = teamPlayAgainRes.team_id;
                    boolean canPlay = teamPlayAgainRes.can_play;
                    List userInfoList = teamPlayAgainRes.players;
                    ArrayList<TeamUserInfo> teamUserInfoList = new ArrayList<TeamUserInfo>();
                    long captainUid = 0L;
                    for (UserInfo info : userInfoList) {
                        TeamUserInfo teamUserInfo = new TeamUserInfo();
                        teamUserInfo.setCaptain(info.b_captain.booleanValue());
                        teamUserInfo.setSeatNumber(info.seat_number.intValue());
                        teamUserInfo.setUid(info.uid.longValue());
                        teamUserInfoList.add(teamUserInfo);
                        if (!info.b_captain.booleanValue()) continue;
                        captainUid = info.uid;
                    }
                    long teamCaptainUid = captainUid;
                    String gameId = teamPlayAgainRes.game_id;
                    int teamTemplate = teamPlayAgainRes.team_template;
                    int playerNumber = teamPlayAgainRes.player_number;
                    long heartbeatTime = teamPlayAgainRes.heartbeat_interval_seconds;
                    TeamInfo teamInfo = TeamRoomDataModel.instance.changeTeamInfo(canPlay, gameId, teamTemplate, playerNumber, teamId, teamCaptainUid, teamUserInfoList);
                    if (callback2 != null) {
                        callback2.onPlayAgainSuccess(teamInfo, heartbeatTime);
                    }
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamPlayAgain:\u91cd\u73a9\u6210\u529f:" + gameId + ", roomId:" + roomId + ", teamId:" + teamId), (Object[])new Object[0]);
                    }
                    if (teamInfo == null) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamPlayAgain:teamId:" + teamId + "\u4e3a\u7a7a"), (Object[])new Object[0]);
                        }
                        return;
                    }
                    if (userInfoList.size() <= 1) {
                        TeamRoomDataModel.instance.setTeamStatus(teamId, 1);
                    } else {
                        TeamRoomDataModel.instance.setTeamStatus(teamId, 4);
                    }
                } else {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamPlayAgain:\u91cd\u73a9\u5931\u8d25:" + header.code), (Object[])new Object[0]);
                    }
                    if (callback2 != null) {
                        callback2.onPlayAgainFailed(gameInfoInner.getGid(), roomId, header.code);
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (callback2 != null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamPlayAgain:\u8d85\u65f6:gameId:" + gameInfoInner.getGid() + "roomId:" + roomId), (Object[])new Object[0]);
                    }
                    callback2.onPlayAgainFailed(gameInfoInner.getGid(), roomId, 10000L);
                }
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamPlayAgain::gameId:" + gameInfoInner.getGid() + "roomId:" + roomId + "\uff0c\u5931\u8d25\u539f\u56e0:" + reason + ", code:" + code), (Object[])new Object[0]);
                            }
                            callback2.onPlayAgainFailed(gameInfoInner.getGid(), roomId, 10000L);
                        }
                    }
                });
                return false;
            }
        });
    }

    public static void teamGetTeamInfo(final ITeamGetTeamInfoCallback callback2) {
        TeamGetTeamInfoReq teamGetTeamInfoReq = new TeamGetTeamInfoReq.Builder().build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_pkgame_d");
        IKXDPkGameProto teamGameProto = new IKXDPkGameProto.Builder().header(header).uri(IKXDPKGameUri.kUriTeamGetTeamInfoReq).team_get_team_info_req(teamGetTeamInfoReq).build();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("TeamGetTeamInfo:seqId:" + header.seqid), (Object[])new Object[0]);
        }
        ProtoManager.getInstance().send((AndroidMessage)teamGameProto, (IProtoCallback)new IProtoCallback<IKXDPkGameProto>(){

            public void onResponse(@Nullable IKXDPkGameProto message) {
                if (message == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"CreateTeam:\u8bf7\u6c42\u7684IKXDPkGameProto\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    return;
                }
                Header header = message.header;
                if (header == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"TeamGetTeamInfo:\u8bf7\u6c42\u7684Header\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    return;
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamGetTeamInfo:seqId:" + header.seqid), (Object[])new Object[0]);
                }
                if (header.code == 0L) {
                    TeamInfo teamInfo;
                    TeamGetTeamInfoRes teamGetTeamInfoRes = message.team_get_team_info_res;
                    String gameId = teamGetTeamInfoRes.game_id;
                    String teamId = teamGetTeamInfoRes.team_id;
                    int teamTemplate = teamGetTeamInfoRes.team_template;
                    int playerNumber = teamGetTeamInfoRes.player_number;
                    long heartbeatTime = teamGetTeamInfoRes.heartbeat_interval_seconds;
                    boolean isMatching = teamGetTeamInfoRes.is_matching;
                    boolean canPlay = teamGetTeamInfoRes.can_play;
                    List userInfoList = teamGetTeamInfoRes.players;
                    ArrayList<TeamUserInfo> teamUserInfoList = new ArrayList<TeamUserInfo>();
                    long captainUid = 0L;
                    for (UserInfo userInfo : userInfoList) {
                        TeamUserInfo teamUserInfo = new TeamUserInfo();
                        teamUserInfo.setUid(userInfo.uid.longValue());
                        teamUserInfo.setCaptain(userInfo.b_captain.booleanValue());
                        teamUserInfo.setSeatNumber(userInfo.seat_number.intValue());
                        teamUserInfoList.add(teamUserInfo);
                        if (!userInfo.b_captain.booleanValue()) continue;
                        captainUid = userInfo.uid;
                    }
                    long teamCaptainUid = captainUid;
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamGetTeamInfo:\u83b7\u53d6\u6210\u529f:" + teamGetTeamInfoRes), (Object[])new Object[0]);
                    }
                    if ((teamInfo = TeamRoomDataModel.instance.initTeamInfo(canPlay, gameId, teamTemplate, teamId, playerNumber, teamCaptainUid, teamUserInfoList)) == null) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamGetTeamInfo:teamId:" + teamId + "\u4e3a\u7a7a"), (Object[])new Object[0]);
                        }
                    } else if (isMatching) {
                        TeamRoomDataModel.instance.setTeamStatus(teamInfo.getTeamId(), 5);
                    } else {
                        TeamRoomDataModel.instance.setTeamStatus(teamInfo.getTeamId(), 4);
                    }
                    if (callback2 != null) {
                        callback2.onGetTeamInfoSuccess(teamInfo, heartbeatTime);
                    }
                } else {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamGetTeamInfo:\u5931\u8d25:" + header.code), (Object[])new Object[0]);
                    }
                    if (callback2 != null) {
                        callback2.onGetTeamInfoFail(header.code);
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (callback2 != null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"TeamGetTeamInfo:\u8d85\u65f6", (Object[])new Object[0]);
                    }
                    callback2.onGetTeamInfoFail(10000L);
                }
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamGetTeamInfo:\u5931\u8d25\u539f\u56e0:" + reason + ", code:" + code), (Object[])new Object[0]);
                            }
                            callback2.onGetTeamInfoFail(code);
                        }
                    }
                });
                return false;
            }
        });
    }

    public static void teamGetGameInfo(final ITeamGetGameInfoCallback callback2) {
        TeamGetGameInfoReq teamGetGameInfoReq = new TeamGetGameInfoReq.Builder().build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_pkgame_d");
        IKXDPkGameProto teamGameProto = new IKXDPkGameProto.Builder().header(header).uri(IKXDPKGameUri.kUriTeamGetGameInfoReq).team_get_game_info_req(teamGetGameInfoReq).build();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("TeamGetGameInfo:seqId:" + header.seqid), (Object[])new Object[0]);
        }
        ProtoManager.getInstance().send((AndroidMessage)teamGameProto, (IProtoCallback)new IProtoCallback<IKXDPkGameProto>(){

            public void onResponse(@Nullable IKXDPkGameProto message) {
                if (message == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"CreateTeam:\u8bf7\u6c42\u7684IKXDPkGameProto\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    return;
                }
                Header header = message.header;
                if (header == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"TeamGetGameInfo:\u8bf7\u6c42\u7684Header\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    return;
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamGetGameInfo:seqId:" + header.seqid), (Object[])new Object[0]);
                }
                if (header.code == 0L) {
                    TeamGetGameInfoRes teamGetGameInfoRes = message.team_get_game_info_res;
                    String gameId = teamGetGameInfoRes.game_id;
                    String roomId = teamGetGameInfoRes.room_id;
                    int teamTemplate = teamGetGameInfoRes.team_template;
                    String url = teamGetGameInfoRes.url;
                    List userInfoList = teamGetGameInfoRes.players;
                    ArrayList<TeamUserInfo> teamUserInfoList = new ArrayList<TeamUserInfo>();
                    for (UserInfo userInfo : userInfoList) {
                        TeamUserInfo teamUserInfo = new TeamUserInfo();
                        teamUserInfo.setUid(userInfo.uid.longValue());
                        teamUserInfo.setCaptain(userInfo.b_captain.booleanValue());
                        teamUserInfo.setSeatNumber(userInfo.seat_number.intValue());
                        teamUserInfoList.add(teamUserInfo);
                    }
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamGetGameInfo:\u6210\u529f:gameId:" + gameId + ", roomId:" + roomId), (Object[])new Object[0]);
                    }
                    if (callback2 != null) {
                        callback2.onGetGameInfoSuccess(gameId, roomId, teamTemplate, url, teamUserInfoList);
                    }
                } else {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamGetGameInfo:\u5931\u8d25:" + header.code), (Object[])new Object[0]);
                    }
                    if (callback2 != null) {
                        callback2.onGetGameInfoFailed(header.code);
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (callback2 != null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"TeamGetGameInfo:\u8d85\u65f6", (Object[])new Object[0]);
                    }
                    callback2.onGetGameInfoFailed(10000L);
                }
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamGetGameInfo:\u5931\u8d25\u539f\u56e0:" + reason + ", code:" + code), (Object[])new Object[0]);
                            }
                            callback2.onGetGameInfoFailed(code);
                        }
                    }
                });
                return false;
            }
        });
    }

    public static void teamImInviteAccept(final String teamId, final boolean accept, final long inviteUid, int teamTemplate, long gameVersion, GameInfo gameInfo, final ITeamImInviteAcceptCallback callback2) {
        if (TextUtils.isEmpty((CharSequence)teamId)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"TeamImInviteAccept:teamId\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        TeamImInviteAcceptReq teamImInviteAcceptReq = new TeamImInviteAcceptReq.Builder().team_id(teamId).accept(Boolean.valueOf(accept)).invite_uid(Long.valueOf(inviteUid)).team_template(Integer.valueOf(teamTemplate)).game_ver(Long.valueOf(gameVersion)).supported_tpls(gameInfo.getMutiModeIdList()).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_pkgame_d");
        IKXDPkGameProto teamGameProto = new IKXDPkGameProto.Builder().header(header).uri(IKXDPKGameUri.kUriTeamImInviteAcceptReq).team_im_invite_accept_req(teamImInviteAcceptReq).build();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("TeamImInviteAccept:seqId:" + header.seqid), (Object[])new Object[0]);
        }
        ProtoManager.getInstance().send((AndroidMessage)teamGameProto, (IProtoCallback)new IProtoCallback<IKXDPkGameProto>(){

            public void onResponse(@Nullable IKXDPkGameProto message) {
                if (message == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"CreateTeam:\u8bf7\u6c42\u7684IKXDPkGameProto\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    return;
                }
                Header header = message.header;
                if (header == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"TeamImInviteAccept:\u8bf7\u6c42\u7684Header\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    return;
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamImInviteAccept:seqId:" + header.seqid), (Object[])new Object[0]);
                }
                if (header.code == 0L) {
                    TeamImInviteAcceptRes teamImInviteAcceptRes = message.team_im_invite_accept_res;
                    String teamId2 = teamImInviteAcceptRes.team_id;
                    int teamTemplete = teamImInviteAcceptRes.team_template;
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamImInviteAccept:\u6210\u529f:" + teamId2), (Object[])new Object[0]);
                    }
                    if (callback2 != null) {
                        callback2.onImInviteAcceptSuccess(teamId2, inviteUid, accept, teamTemplete);
                    }
                } else {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamImInviteAccept:\u5931\u8d25:" + header.code), (Object[])new Object[0]);
                    }
                    if (callback2 != null) {
                        callback2.onImInviteAcceptFailed(teamId, inviteUid, accept, header.code);
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (callback2 != null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamImInviteAccept:\u8d85\u65f6:teamId:" + teamId + "inviteUid:" + inviteUid + "accept:" + accept), (Object[])new Object[0]);
                    }
                    callback2.onImInviteAcceptFailed(teamId, inviteUid, accept, 10000L);
                }
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamImInviteAccept:\u5931\u8d25\u539f\u56e0:" + reason + ", code:" + code + ",teamId:" + teamId + "inviteUid:" + inviteUid + "accept:" + accept), (Object[])new Object[0]);
                            }
                            callback2.onImInviteAcceptFailed(teamId, inviteUid, accept, code);
                        }
                    }
                });
                return false;
            }
        });
    }

    public static void startTeamHeartbeat(final String teamId, final ITeamGameHeartbeatCallback callback2) {
        if (TextUtils.isEmpty((CharSequence)teamId)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"TeamHeartbeat:teamId\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        TeamHeartbeatReq teamHeartbeatReq = new TeamHeartbeatReq.Builder().team_id(teamId).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_pkgame_d");
        IKXDPkGameProto teamGameProto = new IKXDPkGameProto.Builder().header(header).uri(IKXDPKGameUri.kUriTeamHeartbeatReq).team_heartbeat_req(teamHeartbeatReq).build();
        ProtoManager.getInstance().send((AndroidMessage)teamGameProto, (IProtoCallback)new IProtoCallback<IKXDPkGameProto>(){

            public void onResponse(@Nullable IKXDPkGameProto message) {
                if (message == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"CreateTeam:\u8bf7\u6c42\u7684IKXDPkGameProto\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    return;
                }
                Header header = message.header;
                if (header == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)"TeamHeartbeat:\u8bf7\u6c42\u7684Header\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    return;
                }
                if (callback2 != null) {
                    callback2.onHeartbeatCallback(header.code);
                }
                if (header.code == 0L) {
                    if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamHeartbeat:\u5f00\u59cb\u5fc3\u8df3:" + teamId), (Object[])new Object[0]);
                    }
                } else {
                    TeamInfo teamInfo;
                    if (header.code == 2001L && (teamInfo = TeamRoomDataModel.instance.getTeamInfo(teamId)) != null && teamInfo.getStatus() != 7) {
                        TeamRoomDataModel.instance.setTeamStatus(teamId, 8);
                    }
                    if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameProtocolHelper.TAG, (String)("TeamHeartbeat:\u5f00\u59cb\u5fc3\u8df3\u5931\u8d25:" + header.code), (Object[])new Object[0]);
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            callback2.onHeartbeatTimeOut();
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            callback2.onHeartbeatTimeOut();
                        }
                    }
                });
                return false;
            }
        });
    }

    public static void changeTeamTemplateReq(final String teamId, int targetTemplate, final ITeamTempletehangeCallback callback2) {
        if (TextUtils.isEmpty((CharSequence)teamId)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"changeTeamTemplateReq:teamId\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        TeamChangeTemplateReq teamChangeTemplateReq = new TeamChangeTemplateReq.Builder().team_id(teamId).target_template(Integer.valueOf(targetTemplate)).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_pkgame_d");
        IKXDPkGameProto teamGameProto = new IKXDPkGameProto.Builder().header(header).uri(IKXDPKGameUri.kUriTeamChangeTemplateReq).team_change_template_req(teamChangeTemplateReq).build();
        ProtoManager.getInstance().send((AndroidMessage)teamGameProto, (IProtoCallback)new IProtoCallback<IKXDPkGameProto>(){

            public void onResponse(@Nullable IKXDPkGameProto message) {
                if (message == null) {
                    MLog.error((Object)TeamGameProtocolHelper.TAG, (String)"changeTeamTemplateReq:\u8bf7\u6c42\u7684IKXDPkGameProto\u4e3a\u7a7a", (Object[])new Object[0]);
                    return;
                }
                Header header = message.header;
                if (header.code == 0L) {
                    callback2.onTeamChangeSuccess(teamId);
                } else {
                    callback2.onTeamChangeFail(teamId, header.code);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                return false;
            }
        });
    }
}

