/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.protocol;

import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.game.gamemodule.teamgame.teammatch.model.TeamInfo;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamGameInviteNotifyListener;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamGameNotifyListener;
import com.yy.game.gamemodule.teamgame.teammatch.provider.TeamRoomDataModel;
import com.yy.game.metric.GameMetricCode;
import com.yy.game.metric.GameMetricHelper;
import com.yy.hiyo.game.base.TeamUserInfo;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoNotify;
import ikxd.pkgame.IKXDPKGameUri;
import ikxd.pkgame.IKXDPkGameProto;
import ikxd.pkgame.TeamChangeNotify;
import ikxd.pkgame.TeamImInviteAcceptNotify;
import ikxd.pkgame.TeamMatchCancelNotify;
import ikxd.pkgame.TeamMatchNotify;
import ikxd.pkgame.TeamMatchStartNotify;
import ikxd.pkgame.UserInfo;
import java.util.ArrayList;
import java.util.List;

public class TeamGameNotifyHandler {
    private TeamGameProtoNotify mTeamGameProtoNotify;
    private static final String TAG = "TeamGameNotifyHandler";
    private ITeamGameNotifyListener mTeamGameNotifyListener;
    private ITeamGameInviteNotifyListener mTeamGameInviteNotifyListener;

    public void startTeamGameNotify() {
        if (this.mTeamGameProtoNotify == null) {
            this.mTeamGameProtoNotify = new TeamGameProtoNotify();
        }
        ProtoManager.getInstance().registerNotify((IProtoNotify)this.mTeamGameProtoNotify);
    }

    public void register(ITeamGameNotifyListener iTeamGameNotifyListener) {
        this.mTeamGameNotifyListener = iTeamGameNotifyListener;
    }

    public void register(ITeamGameInviteNotifyListener iTeamGameInviteNotifyListener) {
        this.mTeamGameInviteNotifyListener = iTeamGameInviteNotifyListener;
    }

    public void unregister() {
        if (this.mTeamGameProtoNotify != null) {
            ProtoManager.getInstance().unregisterNotify((IProtoNotify)this.mTeamGameProtoNotify);
        }
    }

    private TeamUserInfo initUserInfo(UserInfo userInfo) {
        TeamUserInfo teamUserInfo = new TeamUserInfo();
        teamUserInfo.setUid(userInfo.uid.longValue());
        teamUserInfo.setSeatNumber(userInfo.seat_number.intValue());
        teamUserInfo.setCaptain(userInfo.b_captain.booleanValue());
        return teamUserInfo;
    }

    private void handleTeamMatchStartNotify(IKXDPkGameProto gameProto) {
        TeamMatchStartNotify teamMatchStartNotify;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"TeamMatchStartNotify:\u6536\u5230\u6d88\u606f\u901a\u77e5", (Object[])new Object[0]);
        }
        if ((teamMatchStartNotify = gameProto.team_match_start_notify) == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"TeamMatchStartNotify:\u6ca1\u6709\u5185\u5bb9", (Object[])new Object[0]);
            }
            return;
        }
        if (gameProto.header != null && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("TeamMatchStartNotify:\u8bf7\u6c42\u7684seqId:" + gameProto.header.seqid), (Object[])new Object[0]);
        }
        final String gameId = teamMatchStartNotify.game_id;
        final String teamId = teamMatchStartNotify.team_id;
        final int teamTemplate = teamMatchStartNotify.team_template;
        this.executeInMain(new Runnable(){

            @Override
            public void run() {
                TeamInfo teamInfo;
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamGameNotifyHandler.TAG, (String)("TeamMatchStartNotify:teamId:" + teamMatchStartNotify.team_id), (Object[])new Object[0]);
                }
                if ((teamInfo = TeamRoomDataModel.instance.getTeamInfo(teamId)) == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameNotifyHandler.TAG, (String)("TeamMatchStartNotify:teamId:" + teamId + "\u5185\u5bb9\u7a7a"), (Object[])new Object[0]);
                    }
                    return;
                }
                if (teamInfo.getStatus() == 1) {
                    TeamRoomDataModel.instance.setTeamStatus(teamId, 2);
                } else if (teamInfo.getStatus() == 4) {
                    TeamRoomDataModel.instance.setTeamStatus(teamId, 5);
                }
                if (TeamGameNotifyHandler.this.mTeamGameNotifyListener != null) {
                    TeamGameNotifyHandler.this.mTeamGameNotifyListener.onTeamMatchStartNotify(gameId, teamId, teamTemplate);
                }
            }
        });
    }

    private void handleTeamChangeNotify(IKXDPkGameProto gameProto) {
        TeamChangeNotify teamChangeNotify;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"TeamChangeNotify:\u6536\u5230\u6d88\u606f\u901a\u77e5", (Object[])new Object[0]);
        }
        if ((teamChangeNotify = gameProto.team_change_notify) == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"TeamChangeNotify:\u6ca1\u6709\u5185\u5bb9", (Object[])new Object[0]);
            }
            return;
        }
        if (gameProto.header != null && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("TeamChangeNotify:\u8bf7\u6c42\u7684seqId:" + gameProto.header.seqid), (Object[])new Object[0]);
        }
        final boolean canPlay = teamChangeNotify.can_play;
        final String gameId = teamChangeNotify.game_id;
        final int teamTemplate = teamChangeNotify.team_template;
        final int playerNumber = teamChangeNotify.player_number;
        List userInfoList = teamChangeNotify.players;
        final ArrayList<TeamUserInfo> teamUserInfoList = new ArrayList<TeamUserInfo>();
        long captainUid = 0L;
        for (UserInfo userInfo : userInfoList) {
            TeamUserInfo teamUserInfo = this.initUserInfo(userInfo);
            teamUserInfoList.add(teamUserInfo);
            if (!userInfo.b_captain.booleanValue()) continue;
            captainUid = userInfo.uid;
        }
        final long teamCaptainUid = captainUid;
        final String teamId = teamChangeNotify.team_id;
        this.executeInMain(new Runnable(){

            @Override
            public void run() {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamGameNotifyHandler.TAG, (String)("TeamChangeNotify:teamId:" + teamChangeNotify.team_id + ", gameId:" + teamChangeNotify.game_id), (Object[])new Object[0]);
                }
                TeamInfo teamInfo = TeamRoomDataModel.instance.changeTeamInfo(canPlay, gameId, teamTemplate, playerNumber, teamId, teamCaptainUid, teamUserInfoList);
                if (canPlay) {
                    if (teamInfo != null && teamInfo.getStatus() == 2) {
                        TeamRoomDataModel.instance.setTeamStatus(teamId, 3);
                    } else if (teamInfo != null && teamInfo.getStatus() == 5) {
                        TeamRoomDataModel.instance.setTeamStatus(teamId, 6);
                    }
                } else if (teamInfo != null && teamInfo.getStatus() != 5) {
                    TeamRoomDataModel.instance.setTeamStatus(teamId, 4);
                }
                if (TeamGameNotifyHandler.this.mTeamGameNotifyListener != null) {
                    TeamGameNotifyHandler.this.mTeamGameNotifyListener.onTeamChangedNotify(teamInfo);
                }
            }
        });
    }

    private void handleTeamMatchNotify(IKXDPkGameProto gameProto) {
        long time;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"TeamMatchNotify:\u6536\u5230\u6d88\u606f\u901a\u77e5", (Object[])new Object[0]);
        }
        final TeamMatchNotify teamMatchNotify = gameProto.team_match_notify;
        long l = time = GameMetricCode.USE_MATCH_TIME > 0L ? SystemClock.elapsedRealtime() - GameMetricCode.USE_MATCH_TIME : 0L;
        if (teamMatchNotify == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"TeamMatchNotify:\u6ca1\u6709\u5185\u5bb9", (Object[])new Object[0]);
            }
            GameMetricCode.USE_MATCH_TIME = 0L;
            GameMetricHelper.reportToMetric("pkGame/TeamMatchNotify", time, "2002");
            return;
        }
        if (gameProto.header != null && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("TeamMatchNotify:\u8bf7\u6c42\u7684seqId:" + gameProto.header.seqid), (Object[])new Object[0]);
        }
        final String gameId = teamMatchNotify.game_id;
        final int teamTemplate = teamMatchNotify.team_template;
        List userInfoList = teamMatchNotify.players;
        final ArrayList<TeamUserInfo> teamUserInfoList = new ArrayList<TeamUserInfo>();
        long captainUid = 0L;
        for (UserInfo userInfo : userInfoList) {
            TeamUserInfo teamUserInfo = this.initUserInfo(userInfo);
            teamUserInfoList.add(teamUserInfo);
            if (!userInfo.b_captain.booleanValue()) continue;
            captainUid = userInfo.uid;
        }
        final long teamCaptainUid = captainUid;
        final String roomId = teamMatchNotify.room_id;
        final String teamId = teamMatchNotify.team_id;
        final String url = teamMatchNotify.url;
        final boolean isGoldGame = teamMatchNotify.is_gold;
        this.executeInMain(new Runnable(){

            @Override
            public void run() {
                TeamInfo teamInfo = TeamRoomDataModel.instance.initTeamInfo(gameId, teamTemplate, teamId, teamCaptainUid, teamUserInfoList, roomId, url, isGoldGame);
                TeamRoomDataModel.instance.setTeamStatus(teamId, 7);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamGameNotifyHandler.TAG, (String)("TeamMatchNotify:\u901a\u77e5\u7684\u662f:teamId:" + teamMatchNotify.team_id + ", gameId:" + teamMatchNotify.game_id + ", isGoldGame: " + isGoldGame), (Object[])new Object[0]);
                }
                if (TeamGameNotifyHandler.this.mTeamGameNotifyListener != null) {
                    TeamGameNotifyHandler.this.mTeamGameNotifyListener.onTeamMatchNotify(teamInfo);
                }
            }
        });
    }

    private void handleTeamMatchCancelNotify(IKXDPkGameProto gameProto) {
        TeamMatchCancelNotify teamMatchCancelNotify;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"TeamMatchCancelNotify:\u6536\u5230\u6d88\u606f\u901a\u77e5", (Object[])new Object[0]);
        }
        if ((teamMatchCancelNotify = gameProto.team_match_cancel_notify) == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"TeamMatchCancelNotify:\u6ca1\u6709\u5185\u5bb9", (Object[])new Object[0]);
            }
            return;
        }
        if (gameProto.header != null && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("TeamMatchCancelNotify:\u8bf7\u6c42\u7684seqId:" + gameProto.header.seqid), (Object[])new Object[0]);
        }
        UserInfo userInfo = teamMatchCancelNotify.cancel_user;
        final TeamUserInfo teamUserInfo = this.initUserInfo(userInfo);
        final String gameId = teamMatchCancelNotify.game_id;
        final int teamTemplate = teamMatchCancelNotify.team_template;
        final String teamId = teamMatchCancelNotify.team_id;
        this.executeInMain(new Runnable(){

            @Override
            public void run() {
                TeamInfo teamInfo;
                TeamRoomDataModel.instance.removeTeamNumber(teamId, teamUserInfo);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamGameNotifyHandler.TAG, (String)("TeamMatchCancelNotify:\u53d6\u6d88\u5339\u914d:teamId:" + teamMatchCancelNotify.team_id + ", gameId:" + teamMatchCancelNotify.game_id), (Object[])new Object[0]);
                }
                if ((teamInfo = TeamRoomDataModel.instance.getTeamInfo(teamId)) == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamGameNotifyHandler.TAG, (String)("\u5339\u914d\u53d6\u6d88\u901a\u77e5\u65f6\u5019\uff0c\u6536\u5230\u7684teamId:" + teamId + "\u6ca1\u6709\u5bf9\u5e94\u6d88\u606f"), (Object[])new Object[0]);
                    }
                    return;
                }
                int size = teamInfo.getTeamUserInfoList().size();
                if (size <= 1) {
                    if (teamInfo.getStatus() == 5) {
                        TeamRoomDataModel.instance.setTeamStatus(teamId, 4);
                    } else if (teamInfo.getStatus() == 2) {
                        TeamRoomDataModel.instance.setTeamStatus(teamId, 1);
                    }
                } else {
                    TeamRoomDataModel.instance.setTeamStatus(teamId, 4);
                }
                if (TeamGameNotifyHandler.this.mTeamGameNotifyListener != null) {
                    TeamGameNotifyHandler.this.mTeamGameNotifyListener.onTeamMatchCancelNotify(teamId, gameId, teamUserInfo, teamTemplate);
                }
            }
        });
    }

    private void handlerTeamImInviteAcceptNotify(IKXDPkGameProto gameProto) {
        TeamImInviteAcceptNotify teamImInviteAcceptNotify;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"handlerTeamImInviteAcceptNotify:\u6536\u5230\u6d88\u606f\u901a\u77e5", (Object[])new Object[0]);
        }
        if ((teamImInviteAcceptNotify = gameProto.team_im_invite_accept_notify) == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"handlerTeamImInviteAcceptNotify:\u6ca1\u6709\u5185\u5bb9", (Object[])new Object[0]);
            }
            return;
        }
        if (gameProto.header != null && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("handlerTeamImInviteAcceptNotify:\u8bf7\u6c42\u7684seqId:" + gameProto.header.seqid), (Object[])new Object[0]);
        }
        final String teamId = teamImInviteAcceptNotify.team_id;
        final String gameId = teamImInviteAcceptNotify.game_id;
        final int template = teamImInviteAcceptNotify.team_template;
        final boolean isAccept = teamImInviteAcceptNotify.accept;
        this.executeInMain(new Runnable(){

            @Override
            public void run() {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamGameNotifyHandler.TAG, (String)("handlerTeamImInviteAcceptNotify:teamId:" + teamImInviteAcceptNotify.team_id + ", gameId:" + teamImInviteAcceptNotify.game_id), (Object[])new Object[0]);
                }
                if (TeamGameNotifyHandler.this.mTeamGameInviteNotifyListener != null) {
                    TeamGameNotifyHandler.this.mTeamGameInviteNotifyListener.onTeamImInviteAccept(gameId, teamId, template, isAccept);
                }
            }
        });
    }

    private void executeInMain(Runnable runnable2) {
        if (YYTaskExecutor.isMainThread()) {
            runnable2.run();
        } else {
            YYTaskExecutor.postToMainThread((Runnable)runnable2);
        }
    }

    private class TeamGameProtoNotify
    implements IProtoNotify<IKXDPkGameProto> {
        private TeamGameProtoNotify() {
        }

        public String serviceName() {
            return "ikxd_pkgame_d";
        }

        public void onNotify(@NonNull IKXDPkGameProto gameProto) {
            if (gameProto.uri == IKXDPKGameUri.kUriTeamMatchCancelNotify) {
                TeamGameNotifyHandler.this.handleTeamMatchCancelNotify(gameProto);
            } else if (gameProto.uri == IKXDPKGameUri.kUriTeamChangeNotify) {
                TeamGameNotifyHandler.this.handleTeamChangeNotify(gameProto);
            } else if (gameProto.uri == IKXDPKGameUri.kUriTeamMatchNotify) {
                TeamGameNotifyHandler.this.handleTeamMatchNotify(gameProto);
            } else if (gameProto.uri == IKXDPKGameUri.kUriTeamMatchStartNotify) {
                TeamGameNotifyHandler.this.handleTeamMatchStartNotify(gameProto);
            } else if (gameProto.uri == IKXDPKGameUri.kUriTeamImInviteAcceptNotify) {
                TeamGameNotifyHandler.this.handlerTeamImInviteAcceptNotify(gameProto);
            }
        }
    }
}

