/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.module;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.game.gamemodule.teamgame.teammatch.model.TeamInfo;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.ITeamInfoRefreshListener;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.TeamGameNotifyHandler;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.TeamGameProtocolHelper;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamGameHeartbeatCallback;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamGameNotifyListener;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamGetGameInfoCallback;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamGetGameInfoListener;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamGetInfoListener;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamGetTeamInfoCallback;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamImCancelCreateCallback;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamJoinListener;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamLeaveCallback;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamMatchCallback;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamMatchCancelCallback;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamMatchCancelListener;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamMatchCancelNotifyListener;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamMatchStartListener;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamPlayAgainCallback;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamPlayAgainListener;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamTempletehangeCallback;
import com.yy.game.gamemodule.teamgame.teammatch.provider.TeamRoomDataModel;
import com.yy.game.gamemodule.teamgame.teammatch.services.IJoinTeamCallback;
import com.yy.game.gamemodule.teamgame.teammatch.services.IRoomCreateCallback;
import com.yy.game.gamemodule.teamgame.teammatch.services.ITeamChangeListener;
import com.yy.game.gamemodule.teamgame.teammatch.services.ITeamCreateCallback;
import com.yy.game.gamemodule.teamgame.teammatch.services.ITeamMatchListener;
import com.yy.game.gamemodule.teamgame.teammatch.services.ITeamRoomService;
import com.yy.hiyo.game.base.TeamUserInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import java.util.List;

public class TeamRoomController
extends DefaultController
implements ITeamRoomService,
ITeamGameNotifyListener {
    private static final String TAG = "TeamRoomController";
    private static final long DEFAULT_HEARTBEAT_TIME = 15L;
    private long mTeamHeartbeatTime = 15L;
    private volatile String mTeamId;
    private ITeamMatchListener mTeamMatchListener;
    private ITeamChangeListener mTeamChangeListener;
    private ITeamMatchStartListener mTeamMatchStartListener;
    private ITeamMatchCancelNotifyListener mTeamMatchCancelNotifyListener;
    private long mPreRequestTeamInfoTime = 0L;
    private int mHeartbeatFailTime = 0;
    private TeamGameNotifyHandler mTeamGameNotifyHandler;
    private Runnable mTeamHeartbeatRunnable = new Runnable(){

        @Override
        public void run() {
            TeamRoomController.this.executeTeamHeartbeat();
            TeamGameProtocolHelper.startTeamHeartbeat(TeamRoomController.this.mTeamId, new ITeamGameHeartbeatCallback(){

                @Override
                public void onHeartbeatTimeOut() {
                    TeamRoomController.this.mHeartbeatFailTime++;
                    if (TeamRoomController.this.mHeartbeatFailTime == 3) {
                        TeamInfo teamInfo;
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)TeamRoomController.TAG, (String)"\u5fc3\u8df3\u8d85\u65f6\uff0c\u81ea\u52a8\u9000\u51fa", (Object[])new Object[0]);
                        }
                        if ((teamInfo = TeamRoomDataModel.instance.getTeamInfo(TeamRoomController.this.mTeamId)) != null && teamInfo.getStatus() != 7) {
                            TeamRoomDataModel.instance.setTeamStatus(TeamRoomController.this.mTeamId, 8);
                        }
                    }
                }

                @Override
                public void onHeartbeatCallback(long code) {
                    TeamRoomController.this.mHeartbeatFailTime = 0;
                    if (code == 2001L) {
                        TeamRoomController.this.stopTeamHeartbeat();
                    }
                }
            });
        }
    };
    private Runnable mRefreshTeamInfoRunnable = new Runnable(){

        @Override
        public void run() {
            long currentTime = System.currentTimeMillis();
            if (TeamRoomController.this.mPreRequestTeamInfoTime == 0L || currentTime - TeamRoomController.this.mPreRequestTeamInfoTime >= TeamRoomController.this.mTeamHeartbeatTime * 1000L) {
                TeamGameProtocolHelper.teamGetTeamInfo(new ITeamGetTeamInfoCallback(){

                    @Override
                    public void onGetTeamInfoSuccess(TeamInfo teamInfo, long heartbeatTime) {
                        if (teamInfo == null) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)TeamRoomController.TAG, (String)"refreshTeamInfo\u83b7\u53d6\u5230\u7684\u961f\u4f0d\u4fe1\u606f\u662f\u7a7a\u7684", (Object[])new Object[0]);
                            }
                            return;
                        }
                        TeamRoomController.this.mPreRequestTeamInfoTime = System.currentTimeMillis();
                        TeamRoomController.this.mTeamId = teamInfo.getTeamId();
                        TeamRoomController.this.mTeamHeartbeatTime = heartbeatTime;
                        TeamRoomController.this.startTeamHeartbeat();
                    }

                    @Override
                    public void onGetTeamInfoFail(long code) {
                        if (code == 2001L) {
                            TeamRoomController.this.stopTeamHeartbeat();
                            TeamRoomController.this.destroyTeamStatus();
                        }
                    }
                });
            }
        }
    };

    public TeamRoomController(Environment env) {
        super(env);
        this.mTeamGameNotifyHandler = new TeamGameNotifyHandler();
        this.mTeamGameNotifyHandler.register(this);
        this.mTeamGameNotifyHandler.startTeamGameNotify();
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.WEBSOCKET_CONNECT, (INotify)this);
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == NotificationIdDef.WEBSOCKET_CONNECT) {
            this.refreshTeamInfo(new ITeamInfoRefreshListener(){

                @Override
                public void onRefreshSuccess(TeamInfo teamInfo, long heartTime) {
                    if (teamInfo != null && MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamRoomController.TAG, (String)("refreshTeamInfo:" + (Object)((Object)teamInfo)), (Object[])new Object[0]);
                    }
                }

                @Override
                public void onRefreshFailed(long code) {
                }
            });
        }
    }

    @Override
    public String getTeamID() {
        return this.mTeamId;
    }

    @Override
    public void createRoom(GameInfo gameInfo, int gameTemplate, boolean isGoldGame, UserInfoKS userInfo, final IRoomCreateCallback roomCreateCallback) {
        if (userInfo == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"createRoom:\u4f20\u8fdb\u7684\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        TeamGameProtocolHelper.createTeam(gameInfo, gameTemplate, isGoldGame, TeamUserInfo.createFromUserInfo((UserInfoKS)userInfo), new ITeamCreateCallback(){

            @Override
            public void onTeamCreateSuccess(TeamInfo teamInfo, long teamHeartbeatTime) {
                TeamRoomController.this.createTeamSuccess(teamInfo, teamHeartbeatTime, roomCreateCallback);
            }

            @Override
            public void onImInviteCreateSuccess(TeamInfo teamInfo) {
            }

            @Override
            public void onTeamCreateFailed(final long code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (roomCreateCallback != null) {
                            roomCreateCallback.onRoomCreateFail(code);
                        }
                    }
                });
            }
        });
    }

    @Override
    public TeamInfo getTeamInfo(String teamId) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("\u83b7\u53d6TeamId:" + teamId + "\u7684\u961f\u4f0d\u4fe1\u606f"), (Object[])new Object[0]);
        }
        return TeamRoomDataModel.instance.getTeamInfo(teamId);
    }

    private void createTeamSuccess(TeamInfo teamInfo, long teamHeartbeatTime, final IRoomCreateCallback roomCreateCallback) {
        if (teamInfo == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"createTeamSuccess:\u961f\u4f0d\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        this.mTeamId = teamInfo.getTeamId();
        this.mTeamHeartbeatTime = this.checkHeartbeatTime(teamHeartbeatTime);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("createTeamSuccess:teamId:" + this.mTeamId + ", \u5fc3\u8df3\u65f6\u95f4:" + this.mTeamHeartbeatTime), (Object[])new Object[0]);
        }
        this.startTeamHeartbeat();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (roomCreateCallback != null) {
                    roomCreateCallback.onRoomCreateSuccess(TeamRoomController.this.mTeamId);
                }
            }
        });
    }

    @Override
    public void imCreateRoomCancel(String teamId, long targetUid) {
        if (TextUtils.isEmpty((CharSequence)teamId)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"imCreateRoomCancel:teamId\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        TeamGameProtocolHelper.imCancelCreateTeam(teamId, targetUid, new ITeamImCancelCreateCallback(){

            @Override
            public void onTeamImCancelCreateSuccess(String teamId, long targetUid) {
                TeamRoomController.this.mTeamId = "";
                TeamRoomController.this.stopTeamHeartbeat();
            }

            @Override
            public void onTeamImCancelCreateFailed(long teamId) {
            }
        });
    }

    private void startTeamHeartbeat() {
        if (!TextUtils.isEmpty((CharSequence)this.mTeamId)) {
            this.executeTeamHeartbeat();
        }
    }

    private void stopTeamHeartbeat() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"\u505c\u6b62\u5fc3\u8df3", (Object[])new Object[0]);
        }
        this.mTeamHeartbeatTime = 15L;
        YYTaskExecutor.removeTask((Runnable)this.mTeamHeartbeatRunnable);
    }

    public void executeTeamHeartbeat() {
        YYTaskExecutor.removeTask((Runnable)this.mTeamHeartbeatRunnable);
        YYTaskExecutor.execute((Runnable)this.mTeamHeartbeatRunnable, (long)(this.mTeamHeartbeatTime * 1000L));
    }

    @Override
    public void getGameInfo(final ITeamGetGameInfoListener listener) {
        TeamGameProtocolHelper.teamGetGameInfo(new ITeamGetGameInfoCallback(){

            @Override
            public void onGetGameInfoSuccess(final String gameId, final String roomId, final int teamTemplate, final String url, final List<TeamUserInfo> teamUserInfoList) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onGetGameInfoSuccess(gameId, roomId, teamTemplate, url, teamUserInfoList);
                        }
                    }
                });
            }

            @Override
            public void onGetGameInfoFailed(final long code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onGetGameInfoFailed(code);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void leaveRoom(String teamId, ITeamLeaveCallback callback2) {
        this.mTeamId = "";
        this.stopTeamHeartbeat();
        TeamRoomDataModel.instance.clearTeamInfo(teamId);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("LeaveTeam:\u6e05\u9664Team\u4fe1\u606f:" + teamId), (Object[])new Object[0]);
        }
        TeamGameProtocolHelper.leaveTeam(teamId, callback2);
    }

    @Override
    public void playAgain(GameInfo gameInfo, int gameTemplate, UserInfoKS userInfoBean, String roomId, int seatNumber, final ITeamPlayAgainListener listener) {
        if (userInfoBean == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"playAgain:\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"playAgain:roomId\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        TeamGameProtocolHelper.teamPlayAgain(gameInfo, gameTemplate, TeamUserInfo.createFromUserInfo((UserInfoKS)userInfoBean), roomId, seatNumber, new ITeamPlayAgainCallback(){

            @Override
            public void onPlayAgainSuccess(final TeamInfo teamInfo, final long heartbeatTime) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null && teamInfo != null) {
                            TeamRoomController.this.mTeamId = teamInfo.getTeamId();
                            TeamRoomController.this.mTeamHeartbeatTime = TeamRoomController.this.checkHeartbeatTime(heartbeatTime);
                            TeamRoomController.this.startTeamHeartbeat();
                            listener.onPlayAgainSuccess(teamInfo.getGameId(), teamInfo.getTeamTemplate(), teamInfo.getRoomId(), teamInfo.getTeamId());
                        }
                    }
                });
            }

            @Override
            public void onPlayAgainFailed(final String gameId, final String roomId, final long code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onPlayAgainFailed(gameId, roomId, code);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void teamMatchStart(final String teamId, GameInfo gameInfo, int teamTemplate, boolean isStart, boolean isGoldGame) {
        if (TextUtils.isEmpty((CharSequence)teamId)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"teamMatchStart:teamId\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        TeamInfo teamInfo = TeamRoomDataModel.instance.getTeamInfo(teamId);
        if (teamInfo != null) {
            if (teamInfo.getStatus() == 1) {
                TeamRoomDataModel.instance.setTeamStatus(teamId, 2);
            } else if (teamInfo.getStatus() == 4) {
                TeamRoomDataModel.instance.setTeamStatus(teamId, 5);
            }
        }
        TeamGameProtocolHelper.teamMatch(teamId, gameInfo, teamTemplate, isStart, isGoldGame, new ITeamMatchCallback(){

            @Override
            public void onTeamMatchSuccess(String teamId2, boolean isPlay) {
            }

            @Override
            public void onTeamMatchFail(final long code) {
                TeamInfo teamInfo = TeamRoomDataModel.instance.getTeamInfo(teamId);
                if (teamInfo != null) {
                    if (teamInfo.getStatus() == 5) {
                        TeamRoomDataModel.instance.setTeamStatus(teamId, 4);
                    } else if (teamInfo.getStatus() == 2) {
                        TeamRoomDataModel.instance.setTeamStatus(teamId, 1);
                    }
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (TeamRoomController.this.mTeamMatchListener != null) {
                            TeamRoomController.this.mTeamMatchListener.onTeamMatchFailed(code);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void teamMatchCancel(String teamId, final ITeamMatchCancelListener listener) {
        if (TextUtils.isEmpty((CharSequence)teamId)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"teamMatchCancel:teamId\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        TeamGameProtocolHelper.teamMatchCancel(teamId, new ITeamMatchCancelCallback(){

            @Override
            public void onTeamMatchCancelSuccess(final String teamId) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onTeamMatchCancelSuccess(teamId);
                        }
                    }
                });
            }

            @Override
            public void onTeamMatchCancelFailed(final String teamId, final long code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onTeamMatchCancelFailed(teamId, code);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void registerTeamMatchListener(ITeamMatchListener teamMatchListener) {
        this.mTeamMatchListener = teamMatchListener;
    }

    @Override
    public void unRegisterTeamMatchListener(ITeamMatchListener teamMatchListener) {
        this.mTeamMatchListener = null;
    }

    @Override
    public void registerTeamChangeListener(ITeamChangeListener teamChangeListener) {
        this.mTeamChangeListener = teamChangeListener;
    }

    @Override
    public void unRegisterTeamChangeListener(ITeamChangeListener teamChangeListener) {
        this.mTeamChangeListener = null;
    }

    @Override
    public void registerTeamMatchStartListener(ITeamMatchStartListener teamMatchStartListener) {
        this.mTeamMatchStartListener = teamMatchStartListener;
    }

    @Override
    public void unRegisterTeamMatchStartListener(ITeamMatchStartListener teamMatchStartListener) {
        this.mTeamMatchStartListener = null;
    }

    @Override
    public void registerTeamMatchCancelListener(ITeamMatchCancelNotifyListener teamMatchCancelNotifyListener) {
        this.mTeamMatchCancelNotifyListener = teamMatchCancelNotifyListener;
    }

    @Override
    public void unRegisterTeamMatchCancelListener(ITeamMatchCancelNotifyListener teamMatchCancelNotifyListener) {
        this.mTeamMatchCancelNotifyListener = null;
    }

    @Override
    public void joinTeam(GameInfo gameInfo, @NonNull int teamTemplate, final @NonNull String teamId, @NonNull UserInfoKS userInfo, final @NonNull long inviteUid, final ITeamJoinListener listener) {
        final GameInfo gameInfoInner = gameInfo;
        TeamGameProtocolHelper.joinTeam(gameInfo, teamTemplate, teamId, TeamUserInfo.createFromUserInfo((UserInfoKS)userInfo), inviteUid, new IJoinTeamCallback(){

            @Override
            public void onJoinTeamSuccess(final TeamInfo teamInfo, long teamHeartbeatTime) {
                if (teamInfo != null) {
                    TeamRoomController.this.mTeamId = teamInfo.getTeamId();
                }
                TeamRoomController.this.mTeamHeartbeatTime = TeamRoomController.this.checkHeartbeatTime(teamHeartbeatTime);
                TeamRoomController.this.startTeamHeartbeat();
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onJoinTeamSuccess(teamInfo);
                        }
                    }
                });
            }

            @Override
            public void onJoinTeamFail(final long code, final int teamTemplate) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onJoinTeamFailed(teamId, gameInfoInner.gid, inviteUid, code, teamTemplate);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void getPlayingTeam(final ITeamGetInfoListener listener) {
        TeamGameProtocolHelper.teamGetTeamInfo(new ITeamGetTeamInfoCallback(){

            @Override
            public void onGetTeamInfoSuccess(final TeamInfo teamInfo, long heartbeatTime) {
                if (teamInfo != null) {
                    TeamRoomController.this.mTeamId = teamInfo.getTeamId();
                }
                TeamRoomController.this.mTeamHeartbeatTime = TeamRoomController.this.checkHeartbeatTime(heartbeatTime);
                TeamRoomController.this.startTeamHeartbeat();
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onTeamInfoGetSuccess(teamInfo);
                        }
                    }
                });
            }

            @Override
            public void onGetTeamInfoFail(final long code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onTeamInfoGetFailed(code);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void onInviteSend(String teamId) {
        TeamRoomDataModel.instance.setTeamStatus(teamId, 4);
    }

    @Override
    public void refreshTeamInfo(final ITeamInfoRefreshListener listener) {
        if (this.getCurrentWindow() != null && this.getCurrentWindow().getWindowType() != 106) {
            return;
        }
        YYTaskExecutor.removeTask((Runnable)this.mRefreshTeamInfoRunnable);
        YYTaskExecutor.execute((Runnable)this.mRefreshTeamInfoRunnable, (long)(this.mTeamHeartbeatTime * 1000L));
        long currentTime = System.currentTimeMillis();
        if (this.mPreRequestTeamInfoTime == 0L || currentTime - this.mPreRequestTeamInfoTime > this.mTeamHeartbeatTime * 1000L) {
            TeamGameProtocolHelper.teamGetTeamInfo(new ITeamGetTeamInfoCallback(){

                @Override
                public void onGetTeamInfoSuccess(TeamInfo teamInfo, long heartbeatTime) {
                    if (teamInfo == null) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)TeamRoomController.TAG, (String)"refreshTeamInfo\u83b7\u53d6\u5230\u7684\u961f\u4f0d\u4fe1\u606f\u662f\u7a7a\u7684", (Object[])new Object[0]);
                        }
                        return;
                    }
                    TeamRoomController.this.mPreRequestTeamInfoTime = System.currentTimeMillis();
                    TeamRoomController.this.mTeamId = teamInfo.getTeamId();
                    TeamRoomController.this.mTeamHeartbeatTime = heartbeatTime;
                    TeamRoomController.this.startTeamHeartbeat();
                    if (listener != null) {
                        listener.onRefreshSuccess(teamInfo, heartbeatTime);
                    }
                }

                @Override
                public void onGetTeamInfoFail(long code) {
                    if (code == 2001L) {
                        TeamRoomController.this.stopTeamHeartbeat();
                        TeamRoomController.this.destroyTeamStatus();
                    }
                    if (listener != null) {
                        listener.onRefreshFailed(code);
                    }
                }
            });
        }
    }

    private void destroyTeamStatus() {
        TeamInfo teamInfo;
        if (!TextUtils.isEmpty((CharSequence)this.mTeamId) && (teamInfo = TeamRoomDataModel.instance.getTeamInfo(this.mTeamId)) != null && teamInfo.getStatus() != 7) {
            TeamRoomDataModel.instance.setTeamStatus(this.mTeamId, 8);
        }
    }

    @Override
    public void onRelase() {
        this.stopTeamHeartbeat();
        YYTaskExecutor.removeTask((Runnable)this.mRefreshTeamInfoRunnable);
        if (this.mTeamGameNotifyHandler != null) {
            this.mTeamGameNotifyHandler.unregister();
        }
    }

    @Override
    public void changeTeamTemplete(String teamId, int targetTemplete, final ITeamTempletehangeCallback teamTempletehangeCallback) {
        TeamGameProtocolHelper.changeTeamTemplateReq(teamId, targetTemplete, new ITeamTempletehangeCallback(){

            @Override
            public void onTeamChangeSuccess(String teamId) {
                if (teamTempletehangeCallback != null) {
                    teamTempletehangeCallback.onTeamChangeSuccess(teamId);
                }
            }

            @Override
            public void onTeamChangeFail(String teamId, long code) {
                if (teamTempletehangeCallback != null) {
                    teamTempletehangeCallback.onTeamChangeFail(teamId, code);
                }
            }
        });
    }

    @Override
    public void onTeamMatchNotify(TeamInfo teamInfo) {
        this.stopTeamHeartbeat();
        if (this.mTeamMatchListener != null) {
            this.mTeamMatchListener.onTeamMatchSuccess(teamInfo);
        }
    }

    @Override
    public void onTeamChangedNotify(TeamInfo teamInfo) {
        List<TeamUserInfo> teamUserInfoList;
        if (teamInfo == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"onTeamChangedNotify:teamInfo\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("onTeamChangedNotify:" + (Object)((Object)teamInfo)), (Object[])new Object[0]);
        }
        if ((teamUserInfoList = teamInfo.getTeamUserInfoList()) != null) {
            for (TeamUserInfo userInfo : teamUserInfoList) {
                if (userInfo == null || !MLog.isLogLevelBlowInfo()) continue;
                MLog.info((Object)TAG, (String)("\u961f\u4f0d\u6210\u5458\u4fe1\u606f:" + userInfo), (Object[])new Object[0]);
            }
        }
        if (this.mTeamChangeListener != null) {
            this.mTeamChangeListener.onTeamChanged(teamInfo);
        }
    }

    @Override
    public void onTeamMatchCancelNotify(String teamId, String gameId, TeamUserInfo teamUserInfo, int teamTemplate) {
        if (this.mTeamMatchCancelNotifyListener != null) {
            this.mTeamMatchCancelNotifyListener.onTeamMatchCancelSuccess(teamId, gameId, teamUserInfo);
        }
    }

    @Override
    public void onTeamMatchStartNotify(String gameId, String teamId, int teamTemplate) {
        if (this.mTeamMatchStartListener != null) {
            this.mTeamMatchStartListener.onTeamMatchStart(gameId, teamId, teamTemplate);
        }
    }

    private long checkHeartbeatTime(long heartbeatTime) {
        if (heartbeatTime < 15L) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)("\u540e\u53f0\u8fd4\u56de\u7684\u5fc3\u8df3\u6709\u95ee\u9898:" + heartbeatTime), (Object[])new Object[0]);
            }
            heartbeatTime = 15L;
        }
        return heartbeatTime;
    }
}

