/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.module;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.graphics.Paint;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.http.INetRespOriginJsonParseCallback;
import com.yy.appbase.kvo.FindFriend;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.appbase.util.KeepScreenOnTask;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.event.kvo.list.KvoListHelper;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.BasePanel;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.game.R;
import com.yy.game.bean.GamePlayCountBean;
import com.yy.game.gamemodule.teamgame.teammatch.factory.TeamMatchWindowFactory;
import com.yy.game.gamemodule.teamgame.teammatch.interfaces.ITeamMatchCallback;
import com.yy.game.gamemodule.teamgame.teammatch.model.TeamInfo;
import com.yy.game.gamemodule.teamgame.teammatch.module.ITeamWindowUICallBack;
import com.yy.game.gamemodule.teamgame.teammatch.module.TeamGameBarrageController;
import com.yy.game.gamemodule.teamgame.teammatch.module.TeamInviteServicesController;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamGetGameInfoListener;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamGetInfoListener;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamJoinListener;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamMatchCancelListener;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamMatchCancelNotifyListener;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamPlayAgainListener;
import com.yy.game.gamemodule.teamgame.teammatch.provider.TeamRoomDataModel;
import com.yy.game.gamemodule.teamgame.teammatch.services.IGameBarrageListener;
import com.yy.game.gamemodule.teamgame.teammatch.services.IGameDataProvider;
import com.yy.game.gamemodule.teamgame.teammatch.services.IRoomCreateCallback;
import com.yy.game.gamemodule.teamgame.teammatch.services.ITeamInviteServices;
import com.yy.game.gamemodule.teamgame.teammatch.services.ITeamMatchListener;
import com.yy.game.gamemodule.teamgame.teammatch.services.ITeamServiceManager;
import com.yy.game.gamemodule.teamgame.teammatch.ui.AbsTeamMatchWindow;
import com.yy.game.gamemodule.teamgame.teammatch.ui.TeamMatchLandWindow;
import com.yy.game.metric.GameMetricCode;
import com.yy.game.metric.GameMetricHelper;
import com.yy.game.module.gameinvite.panel.GameSharePanel;
import com.yy.game.module.gameinvite.panel.bean.GameShareChannelInfo;
import com.yy.game.module.gameinvite.panel.bean.GameShareFriendInfo;
import com.yy.game.module.gameinvite.panel.view.IGameShareItemClick;
import com.yy.game.msg.GameMsgDef;
import com.yy.game.utils.GameReportHelper;
import com.yy.game.utils.GameStateDef;
import com.yy.hiyo.channel.base.bean.JoinedChannelInfo;
import com.yy.hiyo.game.base.BarrageInfo;
import com.yy.hiyo.game.base.GameModel;
import com.yy.hiyo.game.base.GameNotificationDef;
import com.yy.hiyo.game.base.TeamUserInfo;
import com.yy.hiyo.game.base.bean.CheckGoinConifg;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.config.GameShareConfig;
import com.yy.hiyo.game.base.gamemode.GameModeInfo;
import com.yy.hiyo.game.base.teamgame.GameGroupInviteInfo;
import com.yy.hiyo.game.base.teamgame.IInviteCallback;
import com.yy.hiyo.game.base.teamgame.InviteEntrance;
import com.yy.hiyo.game.base.teamgame.InviteEntranceItem;
import com.yy.hiyo.game.base.teamgame.InviteFriendData;
import com.yy.hiyo.game.base.teamgame.InviteFriendItem;
import com.yy.hiyo.game.base.teamgame.InviteItem;
import com.yy.hiyo.game.coins.GameCoinResult;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameInviteService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GameTeamMatchContext;
import com.yy.hiyo.user.base.profilesource.ProfileReportBean;
import com.yy.webservice.WebEnvSettings;
import com.yy.webservice.client.IWebBusinessCallBack;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.ihago.act.api.goldcoingame.GameResultState;
import okhttp3.Call;

public class TeamMatchWindowController
extends DefaultWindowController
implements ITeamWindowUICallBack {
    private static final String TAG = "TeamMatchWindowController";
    private static final String LANGRENSHA_GAMEID = "langrensha7_yn";
    public ITeamServiceManager mTeamServiceManager;
    public AbsTeamMatchWindow mTeamMatchWindow;
    public volatile String mTeamId;
    public UserInfoKS mUserInfo;
    public List<UserInfoKS> mSeatUserList = new ArrayList<UserInfoKS>();
    protected int playerCount;
    public boolean rulesIconShow = false;
    private KeepScreenOnTask mKeepScreenOnTask;
    public int mOpenScene = GameContextDef.JoinFrom.FROM_HOME.getId();
    private long mCurrentStart = 0L;
    public long mCurrentMatchStart = 0L;
    private boolean mGotoGame = false;
    private ITeamMatchCallback mTeamMatchCallback;
    public volatile boolean mIsInit = false;
    public GameInfo mGameInfo;
    protected List<TeamUserInfo> mTeamUserList;
    protected boolean isGoldGame = false;
    protected int mEntryCount = 0;
    protected boolean isShowCoinsUI;
    protected GameTeamMatchContext teamMatchContext;
    protected boolean isFromGame = false;
    protected List<Long> mSeatUserIdList = new ArrayList<Long>();
    private List<Long> mSeatUserBeforeMatchinng = new ArrayList<Long>();
    protected long matchSuccessDelay = 2000L;
    protected long teamSuccessDelay = 500L;
    protected int lastRoomStatus = 0;
    private static final int MAX_SHOW_SUM = 6;
    private boolean bindedInvoke = true;
    private IInviteCallback inviteCallback = new IInviteCallback(){

        public void onInviteClick(InviteFriendData data) {
            TeamMatchWindowController.this.handleInviteFriend(data);
        }

        public void onSharePlatformClick(int platForm) {
            TeamMatchWindowController.this.handlePlatformShare(platForm);
        }

        public void onHagoClick() {
            if (TeamMatchWindowController.this.mTeamServiceManager == null || TeamMatchWindowController.this.mTeamServiceManager.getTeamRoomService() == null || TeamMatchWindowController.this.mTeamServiceManager.getGameDataProvider() == null || TeamMatchWindowController.this.mTeamServiceManager.getGameDataProvider().getGameInfo() == null) {
                return;
            }
            if (TeamMatchWindowController.this.mTeamMatchWindow == null) {
                return;
            }
            boolean isLand = TeamMatchWindowController.this.mTeamMatchWindow instanceof TeamMatchLandWindow;
            GameSharePanel mGameSharePanel = TeamMatchWindowController.this.mTeamServiceManager.getTeamGameInviteService().getTeamMatcherSharePanel(isLand, (Context)TeamMatchWindowController.this.mContext, TeamMatchWindowController.this.mGameInfo.gid, true);
            mGameSharePanel.setItemClick(new IGameShareItemClick(){

                @Override
                public void onFriendInviteClick(GameShareFriendInfo info) {
                    TeamMatchWindowController.this.inviteCallback.onInviteClick(info.mInviteFriendData);
                }

                @Override
                public void onChannelItemInviteClick(GameShareChannelInfo info) {
                    TeamMatchWindowController.this.handlerInviteChannel(info.mChannelInfo);
                }
            });
            ((DefaultWindow)TeamMatchWindowController.this.getCurrentWindow()).getPanelLayer().showPanel((BasePanel)mGameSharePanel, true);
        }
    };
    private ITeamMatchCancelNotifyListener teamMatchCancelNotifyListener = new ITeamMatchCancelNotifyListener(){

        @Override
        public void onTeamMatchCancelSuccess(String teamId, String gameId, TeamUserInfo teamUserInfo) {
            if (teamUserInfo == null || teamUserInfo.getUid() == AccountUtil.getUid()) {
                return;
            }
            ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(teamUserInfo.getUid(), new OnProfileCallback(){

                public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                    if (TeamMatchWindowController.this.mTeamMatchWindow == null) {
                        return;
                    }
                    if (userInfoKSList == null || userInfoKSList.size() <= 0) {
                        return;
                    }
                    UserInfoKS userInfoKS = userInfoKSList.get(0);
                    String toastMsg = TeamMatchWindowController.this.measureCancelToastMsg(userInfoKS);
                    TopToastUtils.showErrorToast((CharSequence)toastMsg, (int)0);
                }

                public void onFail(int id2, String msg, String response) {
                    if (TeamMatchWindowController.this.mTeamMatchWindow == null) {
                        return;
                    }
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamMatchWindowController.TAG, (String)"get cancelled match userinfo failed", (Object[])new Object[0]);
                    }
                }

                public int id() {
                    return 0;
                }
            });
        }
    };
    private IGameBarrageListener mBarrageListener = new IGameBarrageListener(){

        @Override
        public void onReceiveBarrage(List<BarrageInfo> info) {
        }
    };
    private ITeamMatchListener mMatchListener = new ITeamMatchListener(){

        @Override
        public void onTeamMatchSuccess(final TeamInfo teamInfo) {
            long time = GameMetricCode.USE_MATCH_TIME > 0L ? SystemClock.elapsedRealtime() - GameMetricCode.USE_MATCH_TIME : 0L;
            GameMetricCode.USE_MATCH_TIME = 0L;
            if (TeamMatchWindowController.this.mTeamMatchWindow == null) {
                return;
            }
            if (teamInfo == null) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamMatchWindowController.TAG, (String)"onTeamMatchSuccess teamInfo=null", (Object[])new Object[0]);
                }
                GameMetricHelper.reportToMetric("pkGame/TeamMatchNotify", time, "2006");
                return;
            }
            GameMetricHelper.reportToMetric("pkGame/TeamMatchNotify", time, "0");
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (TeamMatchWindowController.this.mTeamMatchWindow != null) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)TeamMatchWindowController.TAG, (String)"onTeamMatchSuccess=unbind -mTeamId=%s", (Object[])new Object[]{TeamMatchWindowController.this.mTeamId});
                        }
                        TeamMatchWindowController.this.roomDataUnBinding(TeamMatchWindowController.this.mTeamId);
                        TeamMatchWindowController.this.mTeamId = teamInfo.getTeamId();
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)TeamMatchWindowController.TAG, (String)"onTeamMatchSuccess=bind -mTeamId=%s", (Object[])new Object[]{TeamMatchWindowController.this.mTeamId});
                        }
                        if (StringUtils.isNotEmpty((String)TeamMatchWindowController.this.mTeamId)) {
                            TeamMatchWindowController.this.roomDataBinding(TeamMatchWindowController.this.mTeamId);
                        }
                    }
                }
            });
            int size = teamInfo.getTeamUserInfoList() != null ? teamInfo.getTeamUserInfoList().size() : 0;
            StringBuilder uids = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                uids.append(teamInfo.getTeamUserInfoList().get(i).getUid());
                if (i == size - 1) continue;
                uids.append(",");
            }
            HiidoEvent hiidoEvent = TeamMatchWindowController.this.teamMatchEvnet("match_success");
            hiidoEvent.put("member_num", String.valueOf(TeamMatchWindowController.this.mPlayerNumberBeforMatch));
            hiidoEvent.put("match_time", String.valueOf(System.currentTimeMillis() - TeamMatchWindowController.this.mCurrentMatchStart));
            hiidoEvent.put("team_time", String.valueOf(TeamMatchWindowController.this.mCurrentMatchStart - TeamMatchWindowController.this.mCurrentStart));
            hiidoEvent.put("opponent_uid", uids.toString());
            if (TeamMatchWindowController.this.playerCount > 0 && size == TeamMatchWindowController.this.playerCount) {
                hiidoEvent.put("open_time", String.valueOf(System.currentTimeMillis() - TeamMatchWindowController.this.mCurrentStart));
            }
            HiidoStatis.reportEvent((HiidoEvent)hiidoEvent);
        }

        @Override
        public void onTeamMatchFailed(long code) {
        }
    };
    private volatile int mUserInfoReoadTime = 0;
    protected final KvoBinder mBinder = new KvoBinder((Object)this);
    public int mPlayerNumberBeforMatch = 1;
    String[] pageType = new String[]{"middle_page", "match_page", "team_page"};

    public TeamMatchWindowController(Environment env, ITeamServiceManager mTeamServiceManager, ITeamMatchCallback teamMatchCallback) {
        super(env);
        this.mTeamServiceManager = mTeamServiceManager;
        this.mKeepScreenOnTask = new KeepScreenOnTask();
        this.mTeamMatchCallback = teamMatchCallback;
    }

    public boolean initWindow(GameTeamMatchContext teamMatchContext) {
        if (teamMatchContext == null || teamMatchContext.getGameInfo() == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"teamMatchContext gameinfo=null", (Object[])new Object[0]);
            }
            return false;
        }
        this.teamMatchContext = teamMatchContext;
        this.isGoldGame = teamMatchContext.isGoldMode();
        this.mEntryCount = teamMatchContext.getGoldEntryCoins();
        this.isFromGame = teamMatchContext.mFrom == GameContextDef.JoinFrom.FROM_GAME || teamMatchContext.mFrom == GameContextDef.JoinFrom.FROM_PLAY_AGAIN;
        this.isShowCoinsUI = (Boolean)teamMatchContext.getExtendValue("coins_game_show_flag_ui", (Object)false);
        if (this.mTeamServiceManager == null || this.mTeamServiceManager.getTeamRoomService() == null || this.mTeamServiceManager.getGameDataProvider() == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"mTeamServiceManager=null", (Object[])new Object[0]);
            }
            return false;
        }
        this.mTeamId = teamMatchContext.getTeamId();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"initWindow=mTeamId=%s", (Object[])new Object[]{this.mTeamId});
        }
        this.mUserInfo = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(AccountUtil.getUid(), null);
        this.mGameInfo = this.mTeamServiceManager.getGameDataProvider().getGameInfo();
        if (this.mGameInfo == null) {
            TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.game_info_error), (int)0);
            return false;
        }
        if (this.mUserInfo == null) {
            return false;
        }
        this.mOpenScene = teamMatchContext.getFrom().getId();
        this.mTeamMatchWindow = TeamMatchWindowFactory.getInstance().getWindowByGame(teamMatchContext.getGameInfo(), (Context)this.mContext, (UICallBacks)this);
        this.mTeamMatchWindow.updateGoldViewVisibility(this.isShowCoinsUI);
        this.mWindowMgr.pushWindow((AbstractWindow)this.mTeamMatchWindow, teamMatchContext.isWithAnim());
        this.rulesIconShow = this.mTeamServiceManager.getGameDataProvider().isTeamGameGuideShow(this.mGameInfo.gid);
        this.mTeamMatchWindow.setHasRulesEnter(this.rulesIconShow);
        this.mTeamServiceManager.getTeamGameBarrageService().setGameId(this.mGameInfo.gid);
        if (this.mUserInfo != null) {
            this.mTeamMatchWindow.setUserInfo(this.mUserInfo.avatar, this.mUserInfo.sex);
            this.mSeatUserList.add(this.mUserInfo);
            this.mSeatUserIdList.add(this.mUserInfo.uid);
        }
        this.onUpdateGameInfo();
        this.initTeam(teamMatchContext);
        this.addGoldEntryView();
        if (this.isGoldGame) {
            Object coins = this.sendMessageSync(GameMsgDef.MSG_GET_MY_COINS);
            if (coins instanceof Long && this.isShowCoinsUI) {
                this.mTeamMatchWindow.updateGoldConfig(ResourceUtils.getString((int)R.string.tips_my_coins), (Long)coins, 0L, false);
            }
            this.mTeamMatchWindow.setInviteListTotalGone(true);
        }
        return true;
    }

    private void getGoldGameResult() {
        if (this.isGoldGame && this.teamMatchContext != null && this.teamMatchContext.getFrom() == GameContextDef.JoinFrom.FROM_GAME || this.teamMatchContext.getFrom() == GameContextDef.JoinFrom.FROM_PLAY_AGAIN) {
            this.sendMessage(GameMsgDef.MSG_GET_GOLD_GAME_RESULT, -1, -1, new ICommonCallback<GameCoinResult>(){

                public void onSuccess(GameCoinResult result, Object ... ext) {
                    if (TeamMatchWindowController.this.mTeamMatchWindow != null && result != null) {
                        TeamMatchWindowController.this.mTeamMatchWindow.updateGoldConfig(ResourceUtils.getString((int)(result.getState() == GameResultState.kStateReachLimit.getValue() ? R.string.tips_up_to_limit : R.string.tips_my_coins)), result.getCurrentCoins(), result.getChangeCoins(), true);
                        if (result.getChangeCoins() > 0L) {
                            TeamMatchWindowController.this.mTeamMatchWindow.updateCoinSuccessSvga();
                        }
                    }
                }

                public void onFail(int errCode, String msg, Object ... ext) {
                }
            });
        }
    }

    private void addGoldEntryView() {
        if (!this.isShowCoinsUI || this.mEntryCount <= 0 || this.mTeamMatchWindow == null || this.mContext == null) {
            return;
        }
        this.mTeamMatchWindow.addGameCoinsEntryView((Context)this.mContext, this.mEntryCount);
    }

    public void initTeam(GameTeamMatchContext teamMatchContext) {
        if (StringUtils.isEmpty((String)this.mTeamId)) {
            if (teamMatchContext.getFrom() == GameContextDef.JoinFrom.FROM_PLAY_AGAIN) {
                this.playAgain(teamMatchContext.getRoomId(), teamMatchContext.getSeatNumber());
            } else {
                this.createTeam(this.mTeamServiceManager.getGameDataProvider().getGameInfo(), this.mUserInfo, teamMatchContext);
            }
        } else {
            this.joinTeam(this.mTeamId, teamMatchContext.getInviteUid());
        }
    }

    public void onUpdateGameInfo() {
        GameInfo gameInfo = this.mTeamServiceManager.getGameDataProvider().getGameInfo();
        if (this.mTeamMatchWindow == null || gameInfo == null) {
            return;
        }
        this.playerCount = this.mGameInfo.getPlayerCount();
        String gameMode = String.format(ResourceUtils.getString((int)R.string.team_game_room_player_count_tips), this.playerCount);
        this.mTeamMatchWindow.setGameInfo(gameInfo.getGname(), gameMode, this.playerCount);
        if (StringUtils.isEmpty((String)gameInfo.getTeamTmpStaticUrl())) {
            String bgUrl = this.mTeamServiceManager.getGameDataProvider().getTeamGameBG(gameInfo.gid);
            boolean isNinePng = this.mTeamServiceManager.getGameDataProvider().isTeamGameBGNinePatch(gameInfo.gid);
            this.mTeamMatchWindow.setGameBackgroundImage(bgUrl, isNinePng, this.mTeamServiceManager.getGameDataProvider().getTeamGameDefaultBG());
        } else {
            this.mTeamMatchWindow.setGameBackgroundImage(gameInfo.getTeamTmpStaticUrl(), false, this.mTeamServiceManager.getGameDataProvider().getTeamGameDefaultBG());
        }
    }

    private void setupInvite() {
        if (this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamGameInviteService() != null) {
            ITeamInviteServices iTeamInviteServices = this.mTeamServiceManager.getTeamGameInviteService();
            TeamInviteServicesController.InviteFriendContainer inviteFriendContainer = iTeamInviteServices.getInviteFriendContainer();
            Kvo.removeKvoBinding((KvoSource)inviteFriendContainer, (Object)this, (String)"onInviteFriendsChange");
            Kvo.addKvoBinding((KvoSource)inviteFriendContainer, (Object)this, (String)"onInviteFriendsChange");
            this.mTeamMatchWindow.setInviteCallback(this.inviteCallback);
        }
    }

    private void handlerGameGroupInviteData() {
        if (this.teamMatchContext != null && this.inviteCallback != null) {
            Object inviteData = this.teamMatchContext.getExtendValue("coins_game_invite_data", null);
            if (inviteData == null) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTGameCoins", (String)"handlerGameGroupInviteData inviteData is null", (Object[])new Object[0]);
                }
                return;
            }
            if (inviteData instanceof GameGroupInviteInfo) {
                GameGroupInviteInfo inviteInfo = (GameGroupInviteInfo)inviteData;
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTGameCoins", (String)"handlerGameGroupInviteData get inviteData: %s", (Object[])new Object[]{inviteInfo});
                }
                if (inviteInfo.inviteType == 2) {
                    this.inviteCallback.onHagoClick();
                } else if (inviteInfo.inviteType == 3) {
                    this.inviteCallback.onSharePlatformClick(inviteInfo.platform);
                } else if (inviteInfo.inviteType == 1) {
                    this.inviteCallback.onInviteClick(inviteInfo.mInviteFriendData);
                }
            }
        }
    }

    @KvoMethodAnnotation(name="friends", sourceClass=TeamInviteServicesController.InviteFriendContainer.class, thread=1)
    public void onInviteFriendsChange(KvoEventIntent kvoEvent) {
        this.handlerInviteFriends();
        if (this.bindedInvoke) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    TeamInfo teamInfo;
                    HiidoEvent event1 = TeamMatchWindowController.this.teamMatchEvnet("show");
                    if (TeamMatchWindowController.this.mTeamServiceManager != null && TeamMatchWindowController.this.mTeamServiceManager.getTeamRoomService() != null && (teamInfo = TeamMatchWindowController.this.mTeamServiceManager.getTeamRoomService().getTeamInfo(TeamMatchWindowController.this.mTeamId)) != null) {
                        int size = teamInfo.getTeamUserInfoList() != null ? teamInfo.getTeamUserInfoList().size() : 0;
                        event1.put("member_num", String.valueOf(size));
                    }
                    ArrayList<FindFriend> friends = new ArrayList<FindFriend>(TeamMatchWindowController.this.mTeamServiceManager.getTeamGameInviteService().getInviteFriendContainer().rawFriends);
                    String friendInfo = TeamMatchWindowController.this.getFriendsStaticInfo(friends);
                    event1.put("friend_info", friendInfo);
                    HiidoStatis.reportEvent((HiidoEvent)event1);
                }
            });
        }
        this.bindedInvoke = false;
        if (!this.mTeamServiceManager.getTeamGameInviteService().getInviteFriendContainer().rawFriends.isEmpty()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    HiidoEvent event = TeamMatchWindowController.this.teamMatchEvnet("online_friends");
                    ArrayList<FindFriend> friends = new ArrayList<FindFriend>(TeamMatchWindowController.this.mTeamServiceManager.getTeamGameInviteService().getInviteFriendContainer().rawFriends);
                    String friendInfo = TeamMatchWindowController.this.getFriendsStaticInfo(friends);
                    event.put("friend_info", friendInfo);
                    HiidoStatis.reportEvent((HiidoEvent)event);
                }
            });
        }
    }

    public void handlerInviteFriends() {
        GameSharePanel panel;
        if (this.mTeamMatchWindow == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"handleInviteFriends window null", (Object[])new Object[0]);
            }
            return;
        }
        if (this.mTeamServiceManager == null || this.mTeamServiceManager.getTeamRoomService() == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"getTeamRoomService null", (Object[])new Object[0]);
            }
            return;
        }
        ITeamInviteServices mInviteService = this.mTeamServiceManager.getTeamGameInviteService();
        if (mInviteService == null) {
            return;
        }
        List<InviteFriendData> datas = mInviteService.getInviteFriendContainer().friends;
        GameShareConfig config = mInviteService.getSharePlatforms();
        TeamInfo teamInfo = this.mTeamServiceManager.getTeamRoomService().getTeamInfo(this.mTeamId);
        HashSet<Long> mSeatUsers = new HashSet<Long>();
        if (teamInfo != null && teamInfo.getTeamUserInfoList() != null) {
            ArrayList<TeamUserInfo> list = new ArrayList<TeamUserInfo>(teamInfo.getTeamUserInfoList());
            for (TeamUserInfo info : list) {
                if (info == null) continue;
                mSeatUsers.add(info.getUid());
            }
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"seat users:%s", (Object[])new Object[]{mSeatUsers});
        }
        if ((panel = this.mTeamServiceManager.getTeamGameInviteService().getTeamMatcherSharePanel(false, (Context)this.mContext, this.mGameInfo.gid, false)) != null) {
            panel.onSeatChanged(mSeatUsers);
        }
        mInviteService.getInviteFriendContainer().resetInviteState(mSeatUsers);
        ArrayList<InviteItem> items = new ArrayList<InviteItem>();
        int onlineSum = 0;
        for (int i = 0; i < datas.size(); ++i) {
            InviteFriendData data = datas.get(i);
            if (!data.mFriends.isOnline() || mSeatUsers.contains(data.mFriends.getUid()) || data.mFriends.getUid() == AccountUtil.getUid() || ++onlineSum > 6) continue;
            items.add((InviteItem)new InviteFriendItem(data));
        }
        items.add((InviteItem)new InviteEntranceItem(new InviteEntrance(0, onlineSum > 6 ? ResourceUtils.getString((int)R.string.x_online, (Object[])new Object[]{onlineSum}) : "")));
        if (config != null && config.shareType != null && !config.shareType.isEmpty()) {
            List platforms = config.shareType;
            for (String platform : platforms) {
                if (platform.equals("Whatsapp")) {
                    items.add((InviteItem)new InviteEntranceItem(new InviteEntrance(3)));
                    continue;
                }
                if (platform.equals("Messenger")) {
                    items.add((InviteItem)new InviteEntranceItem(new InviteEntrance(4)));
                    continue;
                }
                if (platform.equals("Line")) {
                    items.add((InviteItem)new InviteEntranceItem(new InviteEntrance(2)));
                    continue;
                }
                if (platform.equals("Facebook")) {
                    items.add((InviteItem)new InviteEntranceItem(new InviteEntrance(1)));
                    continue;
                }
                if (!platform.equals("vk")) continue;
                items.add((InviteItem)new InviteEntranceItem(new InviteEntrance(5)));
            }
        }
        this.mTeamMatchWindow.setInviteDatas(items);
    }

    protected void handleInviteFriend(InviteFriendData data) {
        if (this.mTeamMatchWindow != null) {
            this.mTeamMatchWindow.hideInviteTips();
            this.mTeamMatchWindow.hideTip();
        }
        if (data == null) {
            return;
        }
        if (this.mTeamServiceManager == null || this.mTeamServiceManager.getGameDataProvider() == null || this.mTeamServiceManager.getTeamRoomService() == null) {
            return;
        }
        GameInfo info = this.mTeamServiceManager.getGameDataProvider().getGameInfo();
        String teamId = this.mTeamServiceManager.getTeamRoomService().getTeamID();
        this.inviteTeamGame(teamId, info, data);
        HiidoEvent event = this.teamMatchEvnet("invite");
        ArrayList<FindFriend> datas = new ArrayList<FindFriend>();
        datas.add(data.mFriends);
        event.put("friend_info", this.getFriendsStaticInfo(datas));
        event.put("opponent_uid", String.valueOf(data.mFriends.getUid()));
        HiidoStatis.reportEvent((HiidoEvent)event);
    }

    protected void handlerInviteChannel(JoinedChannelInfo channelInfo) {
        if (this.mTeamMatchWindow != null) {
            this.mTeamMatchWindow.hideInviteTips();
            this.mTeamMatchWindow.hideTip();
        }
        if (channelInfo == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"handlerInviteChannel channel is null", (Object[])new Object[0]);
            }
            return;
        }
        if (this.mTeamServiceManager == null || this.mTeamServiceManager.getTeamRoomService() == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"handlerInviteChannel getTeamRoomService null", (Object[])new Object[0]);
            }
            return;
        }
        GameInfo info = this.mTeamServiceManager.getGameDataProvider().getGameInfo();
        String teamId = this.mTeamServiceManager.getTeamRoomService().getTeamID();
        if (info == null || FP.empty((CharSequence)teamId)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"info or teamId is empty: %s", (Object[])new Object[]{teamId});
            }
            return;
        }
        ((IGameInviteService)ServiceManagerProxy.getServiceManager().getService(IGameInviteService.class)).getGameInviteToChannelService().sendGameInviteToChannel(this.mTeamId, info.gid, channelInfo.cid, channelInfo.name);
    }

    protected void handlePlatformShare(int platform) {
        if (this.mTeamMatchWindow != null) {
            this.mTeamMatchWindow.hideInviteTips();
        }
        if (this.mTeamServiceManager == null || this.mTeamServiceManager.getTeamGameInviteService() == null || this.mTeamServiceManager.getGameDataProvider() == null) {
            return;
        }
        this.mTeamServiceManager.getTeamGameInviteService().shareTo((Context)this.mContext, platform, this.mTeamServiceManager.getGameDataProvider().getGameInfo(), this.mTeamId);
        HiidoEvent event = this.teamMatchEvnet("share");
        int reportType = 0;
        if (platform == 1) {
            event.put("channel_id", "Facebook");
            reportType = 1;
        } else if (platform == 2) {
            event.put("channel_id", "Line");
            reportType = 2;
        } else if (platform == 4) {
            event.put("channel_id", "Messenger");
            reportType = 7;
        } else if (platform == 3) {
            event.put("channel_id", "Whatsapp");
            reportType = 3;
        } else if (platform == 5) {
            reportType = 6;
        }
        if (this.mTeamServiceManager.getGameDataProvider() != null && this.mTeamServiceManager.getGameDataProvider().getGameInfo() != null && this.mTeamServiceManager.getGameDataProvider().getGameInfo().getGid() != null) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023801").put("function_id", "1").put("page_id", "8").put("share_channel", String.valueOf(reportType)).put("gid", this.mTeamServiceManager.getGameDataProvider().getGameInfo().getGid()));
        }
        HiidoStatis.reportEvent((HiidoEvent)event);
    }

    public void inviteTeamGame(String teamId, GameInfo gameInfo, InviteFriendData inviteFriendData) {
        if (!TextUtils.isEmpty((CharSequence)teamId)) {
            this.mTeamServiceManager.getTeamGameInviteService().invite(((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).getGameTeamInviteService(), teamId, gameInfo, inviteFriendData);
        }
    }

    private synchronized void createTeam(final GameInfo gameInfo, UserInfoKS userInfo, final GameTeamMatchContext teamMatchContext) {
        if (gameInfo == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"createTeam:gameinfo = null", (Object[])new Object[0]);
            }
            return;
        }
        if (userInfo == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"createTeam:userInfo = null", (Object[])new Object[0]);
            }
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"createTeam:gameinfo = %s,userinfo = %s", (Object[])new Object[]{gameInfo.toString(), userInfo.toString()});
        }
        if (this.mTeamServiceManager == null || this.mTeamServiceManager.getTeamRoomService() == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"createTeam getTeamRoomService null", (Object[])new Object[0]);
            }
            return;
        }
        this.mTeamServiceManager.getTeamRoomService().createRoom(gameInfo, gameInfo.getTeamTemplate(), this.isGoldGame, userInfo, new IRoomCreateCallback(){

            @Override
            public void onRoomCreateSuccess(String teamId) {
                TeamMatchWindowController.this.onRoomCreateSuccessInner(teamId, gameInfo.getTeamTemplate());
                TeamMatchWindowController.this.handlerGameGroupInviteData();
                if (teamMatchContext != null && teamMatchContext.isAutoMatch()) {
                    TeamMatchWindowController.this.startMatch(false);
                }
            }

            @Override
            public void onRoomCreateFail(long code) {
                TeamMatchWindowController.this.onRoomCreateFailInner(code);
            }
        });
    }

    synchronized void onRoomCreateSuccessInner(String teamId, int multiMode) {
        this.mIsInit = true;
        this.onTeamReadyInner();
        if (this.mTeamMatchCallback != null) {
            this.mTeamMatchCallback.onTeamReady(teamId);
        }
        if (this.mTeamMatchWindow != null) {
            this.dismissDialog();
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"create room success, team id = %s", (Object[])new Object[]{teamId});
            }
            this.mTeamId = teamId;
            this.roomDataBinding(teamId);
            this.autoJoinGameForTest();
            if (GameContextDef.JoinFrom.FROM_HAGO_GROUP.equals((Object)this.teamMatchContext.mFrom)) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"join from group send invite link", (Object[])new Object[0]);
                }
                String channelId = this.teamMatchContext.getChannelId();
                String channelName = this.teamMatchContext.getChannelName();
                ((IGameInviteService)ServiceManagerProxy.getServiceManager().getService(IGameInviteService.class)).getGameInviteToChannelService().sendGameInviteToChannel(this.mTeamId, this.mGameInfo.gid, channelId, channelName);
            }
            if (this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamGameInviteService() != null) {
                this.mTeamServiceManager.getTeamGameInviteService().onTeamDataReady(teamId, this.mGameInfo, multiMode);
            }
        }
    }

    synchronized void onRoomCreateFailInner(long code) {
        this.mIsInit = true;
        if (this.mTeamMatchWindow != null) {
            this.dismissDialog();
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"create room failed, code = %d", (Object[])new Object[]{code});
            }
            if (code == 2003L) {
                if (RuntimeContext.sIsDebuggable) {
                    boolean isGameRandom = SettingFlags.getBoolean((String)"gameautofirstpagerandom", (boolean)false);
                    boolean mEnableAutoTouch = SettingFlags.getBoolean((String)"gameautofirstpage", (boolean)false);
                    boolean isGameAutoOpen = SettingFlags.getBoolean((String)"gameautoopen", (boolean)false);
                    if (mEnableAutoTouch || isGameAutoOpen || isGameRandom) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)"qiantao", (String)"retry game", (Object[])new Object[0]);
                        }
                        this.getPlayingGameInfo();
                    } else {
                        this.handleRoomCreateGameing();
                    }
                    return;
                }
                this.handleRoomCreateGameing();
            } else if (code == 2005L) {
                if (RuntimeContext.sIsDebuggable) {
                    boolean isGameRandom = SettingFlags.getBoolean((String)"gameautofirstpagerandom", (boolean)false);
                    boolean mEnableAutoTouch = SettingFlags.getBoolean((String)"gameautofirstpage", (boolean)false);
                    boolean isGameAutoOpen = SettingFlags.getBoolean((String)"gameautoopen", (boolean)false);
                    if (mEnableAutoTouch || isGameAutoOpen || isGameRandom) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)"qiantao", (String)"retry game", (Object[])new Object[0]);
                        }
                        this.getPlayingTeamInfo();
                    } else {
                        this.handleRoomCreateInTeam();
                    }
                    return;
                }
                this.handleRoomCreateInTeam();
            } else if (code == 2010L) {
                if (RuntimeContext.sIsDebuggable) {
                    boolean isGameRandom = SettingFlags.getBoolean((String)"gameautofirstpagerandom", (boolean)false);
                    boolean mEnableAutoTouch = SettingFlags.getBoolean((String)"gameautofirstpage", (boolean)false);
                    boolean isGameAutoOpen = SettingFlags.getBoolean((String)"gameautoopen", (boolean)false);
                    if (mEnableAutoTouch || isGameAutoOpen || isGameRandom) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)"qiantao", (String)"retry game", (Object[])new Object[0]);
                        }
                        this.getPlayingTeamInfo();
                    } else {
                        this.handleRoomCreateInTeam();
                    }
                    return;
                }
                this.handleRoomCreateInTeam();
            } else if (code == 10000L) {
                ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.team_creat_fail), (int)0);
                this.closeTeamMatchWindow(false);
            } else {
                ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.team_creat_fail), (int)0);
                this.closeTeamMatchWindow(false);
            }
        }
    }

    public void autoJoinGameForTest() {
        if (RuntimeContext.sIsDebuggable) {
            boolean isGameRandom = SettingFlags.getBoolean((String)"gameautofirstpagerandom", (boolean)false);
            boolean mEnableAutoTouch = SettingFlags.getBoolean((String)"gameautofirstpage", (boolean)false);
            boolean isGameAutoOpen = SettingFlags.getBoolean((String)"gameautoopen", (boolean)false);
            if (mEnableAutoTouch || isGameAutoOpen || isGameRandom) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"qiantao", (String)"autoJoinGameForTest", (Object[])new Object[0]);
                }
                this.onTestPlay();
            }
        }
    }

    public void joinTeam(String teamId, long inviteUid) {
        if (this.mTeamServiceManager == null || this.mTeamServiceManager.getGameDataProvider() == null || this.mTeamServiceManager.getGameDataProvider().getGameInfo() == null || this.mTeamServiceManager.getTeamRoomService() == null) {
            return;
        }
        GameInfo gameInfo = this.mTeamServiceManager.getGameDataProvider().getGameInfo();
        this.mTeamServiceManager.getTeamRoomService().joinTeam(gameInfo, gameInfo.getTeamTemplate(), teamId, this.mUserInfo, inviteUid, new ITeamJoinListener(){

            @Override
            public void onJoinTeamSuccess(TeamInfo teamInfo) {
                TeamMatchWindowController.this.onJoinTeamSuccessInner(teamInfo, TeamMatchWindowController.this.mGameInfo);
            }

            @Override
            public void onJoinTeamFailed(String teamId, String gameId, long inviteUid, long code, int teamTemplate) {
                TeamMatchWindowController.this.onJoinTeamFailedInner(teamId, gameId, inviteUid, code, teamTemplate);
            }
        });
    }

    public void onJoinTeamSuccessInner(TeamInfo teamInfo, GameInfo gameInfo) {
        this.mIsInit = true;
        this.dismissDialog();
        this.onTeamReadyInner();
        if (this.mTeamMatchCallback != null) {
            this.mTeamMatchCallback.onTeamReady(teamInfo.getTeamId());
        }
        if (this.mTeamMatchWindow != null) {
            if (teamInfo == null) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"join team success, teamInfo = null", (Object[])new Object[0]);
                }
                return;
            }
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"join team success, team id = %s", (Object[])new Object[]{teamInfo.getTeamId()});
            }
            this.roomDataBinding(teamInfo);
            this.mTeamServiceManager.getTeamGameInviteService().onTeamDataReady(teamInfo.getTeamId(), gameInfo, teamInfo.getTeamTemplate());
        }
    }

    public void onJoinTeamFailedInner(String teamId, String gameId, long inviteUid, long code, int teamTemplate) {
        this.mIsInit = true;
        if (this.mTeamMatchWindow != null) {
            this.dismissDialog();
            if (code == 2001L) {
                TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.team_invalid), (int)0);
                this.createTeam(this.mTeamServiceManager.getGameDataProvider().getGameInfo(), this.mUserInfo, null);
            } else if (code == 2005L) {
                this.handleRoomCreateInTeam();
            } else if (code == 2004L) {
                TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.error_invite_leaved), (int)0);
                this.createTeam(this.mTeamServiceManager.getGameDataProvider().getGameInfo(), this.mUserInfo, null);
            } else if (code == 2003L) {
                this.handleRoomCreateGameing();
            } else if (code == 2010L) {
                TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.team_in_matching), (int)0);
                this.createTeam(this.mTeamServiceManager.getGameDataProvider().getGameInfo(), this.mUserInfo, null);
            } else if (code == 10000L) {
                ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.team_join_fail), (int)0);
                this.closeTeamMatchWindow(false);
            } else if (code == 2000L) {
                TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.error_team_game_full), (int)0);
                this.createTeam(this.mTeamServiceManager.getGameDataProvider().getGameInfo(), this.mUserInfo, null);
            } else if (code == 2000L) {
                ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.game_maintening), (int)0);
                this.closeTeamMatchWindow(false);
            }
        }
    }

    public void getPlayingTeamInfo() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"getPlayingTeamInfo", (Object[])new Object[0]);
        }
        if (this.mTeamServiceManager == null || this.mTeamServiceManager.getTeamRoomService() == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"\u83b7\u53d6\u6e38\u620f\u623f\u95f4\u4fe1\u606fnull", (Object[])new Object[0]);
            }
            return;
        }
        this.mTeamServiceManager.getTeamRoomService().getPlayingTeam(new ITeamGetInfoListener(){

            @Override
            public void onTeamInfoGetSuccess(TeamInfo teamInfo) {
                if (TeamMatchWindowController.this.mTeamMatchWindow == null) {
                    return;
                }
                if (teamInfo == null) {
                    MLog.error((Object)TeamMatchWindowController.TAG, (String)"getPlayingTeamInfo teamino=null", (Object[])new Object[0]);
                    return;
                }
                if (TeamMatchWindowController.this.mTeamServiceManager != null && TeamMatchWindowController.this.mTeamServiceManager.getGameDataProvider() != null && TeamMatchWindowController.this.mTeamServiceManager.getGameDataProvider().getGameInfo() != null) {
                    if (!teamInfo.getGameId().equals(TeamMatchWindowController.this.mTeamServiceManager.getGameDataProvider().getGameInfo().getGid())) {
                        TeamMatchWindowController.this.gotoNewTeam(teamInfo);
                    }
                } else {
                    return;
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamMatchWindowController.TAG, (String)"getPlayingTeamInfo teamino=%s", (Object[])new Object[]{teamInfo});
                }
                TeamMatchWindowController.this.mTeamId = teamInfo.getTeamId();
                TeamMatchWindowController.this.roomDataBinding(teamInfo);
                if (RuntimeContext.sIsDebuggable) {
                    boolean isGameRandom = SettingFlags.getBoolean((String)"gameautofirstpagerandom", (boolean)false);
                    boolean mEnableAutoTouch = SettingFlags.getBoolean((String)"gameautofirstpage", (boolean)false);
                    boolean isGameAutoOpen = SettingFlags.getBoolean((String)"gameautoopen", (boolean)false);
                    if (mEnableAutoTouch || isGameAutoOpen || isGameRandom) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)"qiantao", (String)"retry game", (Object[])new Object[0]);
                        }
                        TeamMatchWindowController.this.autoJoinGameForTest();
                    }
                    return;
                }
            }

            @Override
            public void onTeamInfoGetFailed(long code) {
                if (TeamMatchWindowController.this.mTeamMatchWindow == null) {
                    return;
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamMatchWindowController.TAG, (String)"onTeamInfoGetFailed teamino=%d", (Object[])new Object[]{code});
                }
                if (code == 10000L) {
                    ToastUtils.showToast((Context)TeamMatchWindowController.this.mContext, (String)ResourceUtils.getString((int)R.string.team_info_get_fail), (int)0);
                    TeamMatchWindowController.this.closeTeamMatchWindow(false);
                }
            }
        });
    }

    public void getPlayingGameInfo() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"\u83b7\u53d6\u6e38\u620f\u623f\u95f4\u4fe1\u606f", (Object[])new Object[0]);
        }
        this.showLoadingDialog();
        if (this.mTeamServiceManager == null || this.mTeamServiceManager.getTeamRoomService() == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"\u83b7\u53d6\u6e38\u620f\u623f\u95f4\u4fe1\u606fnull", (Object[])new Object[0]);
            }
            return;
        }
        this.mTeamServiceManager.getTeamRoomService().getGameInfo(new ITeamGetGameInfoListener(){

            @Override
            public void onGetGameInfoSuccess(String gameId, String roomId, int teamTemplate, String url, List<TeamUserInfo> teamUserInfoList) {
                if (TeamMatchWindowController.this.mTeamMatchWindow == null) {
                    return;
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamMatchWindowController.TAG, (String)"\u83b7\u53d6\u6e38\u620f\u623f\u95f4\u4fe1\u606f\u6210\u529f\uff0cgameid=%s,roomid=%s", (Object[])new Object[]{gameId, roomId});
                }
                TeamMatchWindowController.this.dismissDialog();
                TeamMatchWindowController.this.enterGame(gameId, roomId, url, teamUserInfoList);
            }

            @Override
            public void onGetGameInfoFailed(long code) {
                if (TeamMatchWindowController.this.mTeamMatchWindow == null) {
                    return;
                }
                TeamMatchWindowController.this.dismissDialog();
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamMatchWindowController.TAG, (String)"\u83b7\u53d6\u6e38\u620f\u623f\u95f4\u4fe1\u606f\u5931\u8d25\uff0ccode=%d", (Object[])new Object[]{code});
                }
                ToastUtils.showToast((Context)TeamMatchWindowController.this.mContext, (String)ResourceUtils.getString((int)R.string.game_info_get_fail), (int)0);
                TeamMatchWindowController.this.closeTeamMatchWindow(false);
            }
        });
    }

    public void playAgain(String roomId, int seatNumber) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"playAgain\uff0croomId=%s,seatNumber=%d", (Object[])new Object[]{roomId, seatNumber});
        }
        if (this.mTeamServiceManager == null || this.mTeamServiceManager.getGameDataProvider() == null || this.mTeamServiceManager.getGameDataProvider().getGameInfo() == null || this.mTeamServiceManager.getTeamRoomService() == null) {
            return;
        }
        GameInfo gameInfo = this.mTeamServiceManager.getGameDataProvider().getGameInfo();
        this.mTeamServiceManager.getTeamRoomService().playAgain(gameInfo, gameInfo.getTeamTemplate(), this.mUserInfo, roomId, seatNumber, new ITeamPlayAgainListener(){

            @Override
            public void onPlayAgainSuccess(String gameId, int gameTemplate, String roomId, String teamId) {
                TeamMatchWindowController.this.onPlayAgainSuccessInner(gameId, gameTemplate, roomId, teamId, TeamMatchWindowController.this.mGameInfo);
            }

            @Override
            public void onPlayAgainFailed(String gameId, String roomId, long code) {
                TeamMatchWindowController.this.onPlayAgainFailedInner(gameId, roomId, code);
            }
        });
    }

    public void onPlayAgainSuccessInner(String gameId, int gameTemplate, String roomId, String teamId, GameInfo gameInfo) {
        if (this.mTeamMatchWindow == null) {
            return;
        }
        this.mIsInit = true;
        this.dismissDialog();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onPlayAgainSuccessInner\uff0cteamId=%s", (Object[])new Object[]{teamId});
        }
        this.mTeamId = teamId;
        this.roomDataBinding(teamId);
        this.autoJoinGameForTest();
        this.onTeamReadyInner();
        if (this.mTeamMatchCallback != null) {
            this.mTeamMatchCallback.onTeamReady(teamId);
        }
        this.mTeamServiceManager.getTeamGameInviteService().onTeamDataReady(teamId, gameInfo, gameTemplate);
    }

    public void onPlayAgainFailedInner(String gameId, String roomId, long code) {
        if (this.mTeamMatchWindow == null) {
            return;
        }
        this.dismissDialog();
        this.mIsInit = true;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onPlayAgainFailedInner\uff0cteamId=%s", (Object[])new Object[]{code});
        }
        TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.error_team_game_full), (int)0);
        this.closeTeamMatchWindow(false);
    }

    private void handleRoomCreateGameing() {
        if (this.mTeamMatchWindow != null) {
            OkCancelDialog dialog2 = new OkCancelDialog((CharSequence)ResourceUtils.getString((int)R.string.team_game_game_in_progress), (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_yes), (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_no), true, false, new OkCancelDialogListener(){

                public void onCancel() {
                    TeamMatchWindowController.this.closeTeamMatchWindow(false);
                }

                public void onOk() {
                    TeamMatchWindowController.this.getPlayingGameInfo();
                }
            });
            dialog2.setCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog2) {
                    TeamMatchWindowController.this.closeTeamMatchWindow(false);
                }
            });
            this.mDialogLinkManager.showDialog((BaseDialog)dialog2);
        }
    }

    private void handleRoomCreateInTeam() {
        if (this.mTeamMatchWindow != null) {
            OkCancelDialog dialog2 = new OkCancelDialog((CharSequence)ResourceUtils.getString((int)R.string.team_game_game_in_team), (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_yes), (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_no), true, false, new OkCancelDialogListener(){

                public void onCancel() {
                    TeamMatchWindowController.this.closeTeamMatchWindow(false);
                }

                public void onOk() {
                    TeamMatchWindowController.this.getPlayingTeamInfo();
                }
            });
            dialog2.setCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog2) {
                    TeamMatchWindowController.this.closeTeamMatchWindow(false);
                }
            });
            this.mDialogLinkManager.showDialog((BaseDialog)dialog2);
        }
    }

    protected boolean onWindowBackKeyEvent() {
        if (this.mTeamMatchWindow != null && this.mTeamMatchWindow.handleKeyBack()) {
            return true;
        }
        this.onBackClicked();
        return true;
    }

    @Override
    public void closeTeamMatchWindow(boolean withAnim) {
        if (this.mTeamMatchWindow != null) {
            AbsTeamMatchWindow teamMatchWindow = this.mTeamMatchWindow;
            this.mTeamMatchWindow = null;
            teamMatchWindow.closeBarrageViewIfShow();
            this.mWindowMgr.popWindow(withAnim, (AbstractWindow)teamMatchWindow);
        }
    }

    @Override
    public String getMatchMiddlePageDynamicUrl() {
        return this.mGameInfo == null ? "" : this.mGameInfo.getTeamTmpDynamicUrl();
    }

    private String measureCancelToastMsg(UserInfoKS userInfoKS) {
        String toastMsg;
        String name = userInfoKS != null && userInfoKS.nick != null ? userInfoKS.nick : "";
        StringBuilder nameBuilder = new StringBuilder(name);
        int topToastTextSize = ResourceUtils.getDimen((int)R.dimen.global_toast_text_size);
        Paint paint = new Paint();
        paint.setTextSize((float)topToastTextSize);
        int screenWidth = ResolutionUtils.getScreenWidth((Context)this.getCurrentWindow().getContext());
        int margin = ResolutionUtils.dip2Px((float)10.0f);
        int step = 2;
        String originToastMsg = String.format(ResourceUtils.getString((int)R.string.team_game_cancel_match_toast), nameBuilder.toString());
        try {
            int len;
            toastMsg = originToastMsg;
            while (paint.measureText(toastMsg) + (float)(margin * 2) > (float)screenWidth && (len = nameBuilder.length()) >= step) {
                nameBuilder.delete(len - step, len);
                toastMsg = String.format(ResourceUtils.getString((int)R.string.team_game_cancel_match_toast), nameBuilder.toString() + "...");
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)("measureCancelToastMsg exception: " + e.getMessage()), (Object[])new Object[0]);
            toastMsg = originToastMsg;
        }
        return toastMsg;
    }

    public void onWindowAttach(AbstractWindow abstractWindow) {
        super.onWindowAttach(abstractWindow);
        ((IGameService)this.getServiceManager().getService(IGameService.class)).pauseAllDownload("team_match_game");
        this.mCurrentStart = System.currentTimeMillis();
        this.mCurrentMatchStart = System.currentTimeMillis();
        if (this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamRoomService() != null) {
            this.mTeamServiceManager.getTeamRoomService().registerTeamMatchListener(this.mMatchListener);
            this.mTeamServiceManager.getTeamRoomService().registerTeamMatchCancelListener(this.teamMatchCancelNotifyListener);
        }
        if (this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamGameBarrageService() != null) {
            this.mTeamServiceManager.getTeamGameBarrageService().registerBarrageNotify(this.mBarrageListener);
        }
        this.setupInvite();
        this.getGoldGameResult();
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)GameNotificationDef.TEAM_GAME_START));
    }

    protected void checkIfShowGuides() {
        this.checkIfShowRuleGuide();
    }

    protected boolean checkIfShowRuleGuide() {
        if (this.mTeamMatchWindow != null && this.mTeamServiceManager != null && this.mTeamServiceManager.getGameDataProvider() != null && this.mTeamServiceManager.getGameDataProvider().isTeamGameGuideShow(this.mGameInfo.getGid()) && this.mGameInfo != null && this.mGameInfo.getGid().equals(LANGRENSHA_GAMEID) && SettingFlags.getBoolean((String)"team_tip_show", (boolean)true)) {
            this.mTeamMatchWindow.startTipAnim();
            SettingFlags.setBoolean((String)"team_tip_show", (boolean)false);
            return true;
        }
        return false;
    }

    public void onWindowShown(AbstractWindow abstractWindow) {
        super.onWindowShown(abstractWindow);
        if (!this.mIsInit) {
            this.showLoadingDialog();
        }
        this.updatePlayCount();
    }

    public void updatePlayCount() {
        if (this.mTeamServiceManager.getGameDataProvider() != null && this.mTeamServiceManager.getGameDataProvider().getGameInfo() != null) {
            this.mTeamServiceManager.getGameDataProvider().updataGameWinData(this.mTeamServiceManager.getGameDataProvider().getGameInfo().gid);
        }
    }

    public void onWindowHidden(AbstractWindow abstractWindow) {
        super.onWindowHidden(abstractWindow);
    }

    public void updateSeatView(final List<UserInfoKS> seatUserList) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                TeamMatchWindowController.this.updateSeatViewReal(seatUserList);
            }
        });
    }

    private void updateSeatViewReal(List<UserInfoKS> seatUserList) {
        int i;
        int count;
        if (this.mTeamMatchWindow == null) {
            return;
        }
        int n = count = seatUserList != null ? seatUserList.size() : 0;
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"updateSeatView, user count = %d, seat count = %d", (Object[])new Object[]{count, this.playerCount});
        }
        for (i = 0; i < count; ++i) {
            UserInfoKS seatUser = seatUserList.get(i);
            this.mTeamMatchWindow.setSeatReady(i, seatUser);
        }
        for (i = count; i < this.playerCount; ++i) {
            this.mTeamMatchWindow.setSeatUnready(i);
        }
    }

    public void loadUserInfoAndUpdateSeatView(final List<TeamUserInfo> teamUserInfoList) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"start load user info", (Object[])new Object[0]);
        }
        if (teamUserInfoList == null) {
            return;
        }
        this.mSeatUserIdList.clear();
        for (TeamUserInfo userInfo : teamUserInfoList) {
            this.mSeatUserIdList.add(userInfo.getUid());
        }
        ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(this.mSeatUserIdList, new OnProfileCallback(){

            public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamMatchWindowController.TAG, (String)"load user info success", (Object[])new Object[0]);
                }
                if (TeamMatchWindowController.this.mTeamMatchWindow != null) {
                    TeamMatchWindowController.this.mUserInfoReoadTime = 0;
                    if (userInfoKSList == null) {
                        return;
                    }
                    TeamMatchWindowController.this.mSeatUserList.clear();
                    for (int i = 0; i < teamUserInfoList.size(); ++i) {
                        TeamUserInfo user = (TeamUserInfo)teamUserInfoList.get(i);
                        UserInfoKS equalUser = null;
                        for (UserInfoKS userInfoKS : userInfoKSList) {
                            if (user.getUid() != userInfoKS.getUid()) continue;
                            equalUser = userInfoKS;
                            break;
                        }
                        if (equalUser == null) {
                            equalUser = new UserInfoKS();
                            equalUser.uid = user.getUid();
                        }
                        TeamMatchWindowController.this.mSeatUserList.add(equalUser);
                    }
                    TeamMatchWindowController.this.updateSeatView(TeamMatchWindowController.this.mSeatUserList);
                }
            }

            public void onFail(int id2, String msg, String response) {
                if (TeamMatchWindowController.this.mTeamMatchWindow != null) {
                    List<TeamUserInfo> teamUserInfoLists;
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TeamMatchWindowController.TAG, (String)"load user info failed, msg = %s", (Object[])new Object[]{msg});
                    }
                    if (teamUserInfoList.size() > 0 && TeamMatchWindowController.this.mTeamServiceManager != null && TeamMatchWindowController.this.mTeamServiceManager.getTeamRoomService() != null && TeamMatchWindowController.this.mTeamServiceManager.getTeamRoomService().getTeamInfo(TeamMatchWindowController.this.mTeamId) != null && (teamUserInfoLists = TeamMatchWindowController.this.mTeamServiceManager.getTeamRoomService().getTeamInfo(TeamMatchWindowController.this.mTeamId).getTeamUserInfoList()) != null && teamUserInfoList.equals(teamUserInfoLists)) {
                        TeamMatchWindowController.this.mSeatUserList.clear();
                        for (int i = 0; i < teamUserInfoLists.size(); ++i) {
                            TeamUserInfo user = teamUserInfoLists.get(i);
                            UserInfoKS userInfoKS = new UserInfoKS();
                            userInfoKS.uid = user.getUid();
                            TeamMatchWindowController.this.mSeatUserList.add(userInfoKS);
                        }
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TeamMatchWindowController.this.updateSeatView(TeamMatchWindowController.this.mSeatUserList);
                            }
                        });
                        if (TeamMatchWindowController.this.mUserInfoReoadTime == 0) {
                            TeamMatchWindowController.this.mUserInfoReoadTime++;
                            TeamMatchWindowController.this.loadUserInfoAndUpdateSeatView(teamUserInfoList);
                        }
                    }
                }
            }

            public int id() {
                return 0;
            }
        });
    }

    private void enterGame(String gameId, String roomId, String url, List<TeamUserInfo> teamList) {
        if (this.mTeamMatchWindow == null) {
            return;
        }
        GameInfo gameInfo = ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
        if (gameInfo == null) {
            TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.game_info_get_fail), (int)0);
            this.closeTeamMatchWindow(false);
            return;
        }
        this.mGotoGame = true;
        if (this.mTeamMatchCallback != null) {
            this.mTeamMatchCallback.onTeamMatchSuccess(this.mTeamId, gameId, roomId, url, teamList);
        }
        this.closeTeamMatchWindow(false);
    }

    public void gotoNewTeam(TeamInfo teamInfo) {
        if (this.mTeamMatchWindow == null) {
            return;
        }
        GameInfo gameInfo = ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(teamInfo.getGameId());
        if (gameInfo == null) {
            TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.game_info_get_fail), (int)0);
            this.closeTeamMatchWindow(false);
            return;
        }
        this.closeTeamMatchWindow(false);
        GameTeamMatchContext teamMatchContext = new GameTeamMatchContext(GameContextDef.JoinFrom.FROM_HOME);
        teamMatchContext.setGameInfo(gameInfo);
        teamMatchContext.setMultiModeCode(teamInfo.getTeamTemplate());
        teamMatchContext.setTeamId(teamInfo.getTeamId());
        teamMatchContext.setInviteUid(AccountUtil.getUid());
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).teamMatchGame(gameInfo, teamMatchContext);
    }

    private void roomDataBinding(String mTeamId) {
        if (this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamRoomService() != null) {
            this.roomDataBinding(this.mTeamServiceManager.getTeamRoomService().getTeamInfo(mTeamId));
        }
    }

    public void roomDataBinding(TeamInfo teamInfo) {
        if (teamInfo == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"roomDataBinding teamino =null", (Object[])new Object[0]);
            }
            return;
        }
        this.mBinder.singleBindSourceTo((KvoSource)teamInfo);
        if (this.mTeamServiceManager != null && this.mTeamServiceManager.getGameDataProvider() != null && this.mTeamServiceManager.getGameDataProvider().getGameInfo() != null) {
            this.mBinder.singleBindSourceTo((KvoSource)this.mTeamServiceManager.getGameDataProvider().getPlayCount(this.mTeamServiceManager.getGameDataProvider().getGameInfo().gid));
        }
        if (this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamGameBarrageService() != null) {
            TeamGameBarrageController.DefaultBarrages defBarrages = this.mTeamServiceManager.getTeamGameBarrageService().getDefaultBarrages();
            Kvo.removeKvoBinding((KvoSource)defBarrages, (Object)this, (String)"defaultBarragesChange");
            Kvo.addKvoBinding((KvoSource)defBarrages, (Object)this, (String)"defaultBarragesChange");
            TeamGameBarrageController.BarrageData newBarrages = this.mTeamServiceManager.getTeamGameBarrageService().getReceiveBarrages();
            Kvo.removeKvoBinding((KvoSource)newBarrages, (Object)this, (String)"reveiveBarrageMsg");
            Kvo.addKvoBinding((KvoSource)newBarrages, (Object)this, (String)"reveiveBarrageMsg");
        }
    }

    public void roomDataUnBinding(String mTeamId) {
        TeamInfo teamInfo;
        if (StringUtils.isNotEmpty((String)mTeamId) && this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamRoomService() != null && (teamInfo = this.mTeamServiceManager.getTeamRoomService().getTeamInfo(mTeamId)) != null) {
            this.mBinder.clearKvoConnection(TeamInfo.class.getName());
        }
        this.mBinder.clearKvoConnection(GamePlayCountBean.class.getName());
        if (this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamGameBarrageService() != null) {
            TeamGameBarrageController.DefaultBarrages defBarrages = this.mTeamServiceManager.getTeamGameBarrageService().getDefaultBarrages();
            Kvo.removeKvoBinding((KvoSource)defBarrages, (Object)this, (String)"defaultBarragesChange");
            TeamGameBarrageController.BarrageData newBarrages = this.mTeamServiceManager.getTeamGameBarrageService().getReceiveBarrages();
            Kvo.removeKvoBinding((KvoSource)newBarrages, (Object)this, (String)"reveiveBarrageMsg");
        }
    }

    @KvoMethodAnnotation(sourceClass=GamePlayCountBean.class, name="winCount", thread=1)
    void winCountChange(KvoEventIntent kvoEvent) {
        int winCount = (Integer)kvoEvent.caseNewValue((Object)0);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"win count changed : %d", (Object[])new Object[]{winCount});
        }
        if (this.mTeamMatchWindow != null) {
            this.mTeamMatchWindow.setWinCount(winCount);
        }
    }

    @KvoMethodAnnotation(sourceClass=GamePlayCountBean.class, name="totalCount", thread=1)
    void playCountChange(KvoEventIntent kvoEvent) {
        if (this.mTeamMatchWindow == null) {
            return;
        }
        int playCount = (Integer)kvoEvent.caseNewValue((Object)0);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"play count changed : %d", (Object[])new Object[]{playCount});
        }
        if (this.mTeamMatchWindow != null) {
            this.mTeamMatchWindow.setPlayCount(playCount);
        }
    }

    @KvoMethodAnnotation(name="captainUid", sourceClass=TeamInfo.class, thread=1)
    void homeOwnerChange(KvoEventIntent kvoEvent) {
        boolean isRoomOwner;
        if (this.mTeamMatchWindow == null) {
            return;
        }
        if (kvoEvent.newValue() == null) {
            return;
        }
        long roomOwnerId = (Long)kvoEvent.newValue();
        boolean bl = isRoomOwner = roomOwnerId == AccountUtil.getUid();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"home owner changed %b", (Object[])new Object[]{isRoomOwner});
        }
        if (this.mTeamMatchWindow != null) {
            this.mTeamMatchWindow.setHomeOwner(isRoomOwner);
        }
    }

    @KvoMethodAnnotation(name="teamUserInfoList", sourceClass=TeamInfo.class, thread=1)
    void roomPlayerChange(KvoEventIntent kvoEvent) {
        if (this.mTeamMatchWindow == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"roomPlayerChange but window null", (Object[])new Object[0]);
            }
            return;
        }
        List teamUserInfoList = (List)kvoEvent.newValue();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"team user list changed : %s", (Object[])new Object[]{teamUserInfoList});
        }
        if (teamUserInfoList == null) {
            return;
        }
        if (teamUserInfoList.size() > 0) {
            this.loadUserInfoAndUpdateSeatView(teamUserInfoList);
        }
        this.handlerInviteFriends();
        ArrayList newTeamUserList = new ArrayList();
        newTeamUserList.addAll(teamUserInfoList);
        if (this.mTeamUserList != null && this.mTeamUserList.size() > 0) {
            block0: for (int i = newTeamUserList.size() - 1; i >= 0; --i) {
                TeamUserInfo teamUser = (TeamUserInfo)newTeamUserList.get(i);
                for (TeamUserInfo exisitTeamUser : this.mTeamUserList) {
                    if (teamUser.getUid() != exisitTeamUser.getUid()) continue;
                    newTeamUserList.remove(i);
                    continue block0;
                }
            }
        }
        int num = teamUserInfoList != null ? teamUserInfoList.size() : 0;
        for (TeamUserInfo teamUser : newTeamUserList) {
            HiidoEvent event = this.teamMatchEvnet("new_mumber");
            event.put("mumber_num", "" + num);
            event.put("opponent_uid", "" + teamUser.getUid());
            HiidoStatis.reportEvent((HiidoEvent)event);
        }
        this.mTeamUserList = teamUserInfoList;
    }

    @KvoMethodAnnotation(name="status", sourceClass=TeamInfo.class, thread=1)
    void roomStatChange(KvoEventIntent kvoEvent) {
        if (this.mTeamMatchWindow == null) {
            return;
        }
        if (kvoEvent.newValue() == null || kvoEvent.oldValue() == null) {
            return;
        }
        int newStatus = (Integer)kvoEvent.newValue();
        int oldStatus = (Integer)kvoEvent.oldValue();
        this.updateMyGameCoinView(true);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"room status changed, current = %d, old = %d", (Object[])new Object[]{newStatus, oldStatus});
        }
        if (newStatus == 1) {
            TeamInviteServicesController.InviteFriendContainer inviteFriendContainer;
            this.mTeamMatchWindow.showPageRecord();
            if (oldStatus == 2 && (inviteFriendContainer = this.mTeamServiceManager.getTeamGameInviteService().getInviteFriendContainer()) != null && inviteFriendContainer.hasOnlineCanInviteFriends) {
                this.mTeamMatchWindow.showInviteTips();
            }
            this.updateSeatView(this.mSeatUserList);
        } else if (newStatus == 2) {
            this.updateMyGameCoinView(false);
            this.mTeamMatchWindow.hideTip();
            this.mTeamMatchWindow.showPageMatching();
            this.updateSeatView(this.mSeatUserList);
            this.recordTeamUserOnSeat();
        } else if (newStatus == 4) {
            TeamInviteServicesController.InviteFriendContainer inviteFriendContainer;
            this.mTeamMatchWindow.showPageTeam();
            if (oldStatus == 5 && (inviteFriendContainer = this.mTeamServiceManager.getTeamGameInviteService().getInviteFriendContainer()) != null && inviteFriendContainer.hasOnlineCanInviteFriends) {
                this.mTeamMatchWindow.showInviteTips();
            }
            this.updateSeatView(this.mSeatUserList);
        } else if (newStatus == 5) {
            this.updateMyGameCoinView(false);
            this.mTeamMatchWindow.hideTip();
            this.mTeamMatchWindow.showPageMatching();
            this.updateSeatView(this.mSeatUserList);
            this.recordTeamUserOnSeat();
        } else if (newStatus == 6) {
            this.mTeamMatchWindow.showPlayBtn();
        } else if (newStatus == 7) {
            long delayEnterGame;
            if (this.lastRoomStatus == 7) {
                return;
            }
            if (this.lastRoomStatus == 2 || this.lastRoomStatus == 5) {
                delayEnterGame = this.matchSuccessDelay;
                this.onMatchedUserOnMatchSuccess();
            } else {
                delayEnterGame = this.teamSuccessDelay;
                this.mTeamMatchWindow.showMatchSuccess();
            }
            if (this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamRoomService() != null) {
                TeamInfo teamInfo = this.mTeamServiceManager.getTeamRoomService().getTeamInfo(this.mTeamId);
                if (this.mTeamServiceManager != null && this.mTeamServiceManager.getGameDataProvider() != null && this.mTeamServiceManager.getGameDataProvider().getGameInfo() != null && teamInfo != null) {
                    GameModel gameModel = GameModel.newBuilder().gameInfo(this.mTeamServiceManager.getGameDataProvider().getGameInfo()).roomid(teamInfo.getRoomId()).build();
                    GameReportHelper.reportGameInfo(gameModel, (int)(System.currentTimeMillis() - this.mCurrentMatchStart), this.mOpenScene, GameStateDef.GAME_FINISH_REASON.FINISH.value(), 1, teamInfo.isGoldGame());
                }
                if (teamInfo != null) {
                    GotoGameRoomRunable gotoGameRoomRunable = new GotoGameRoomRunable(teamInfo.getRoomId(), teamInfo.getUrl(), teamInfo.getTeamUserInfoList());
                    YYTaskExecutor.postToMainThread((Runnable)gotoGameRoomRunable, (long)delayEnterGame);
                } else {
                    TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.game_info_get_fail), (int)0);
                    this.closeTeamMatchWindow(false);
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"TeamStatus.SUCCESS,mTeamId=%s,TeamInfo = null", (Object[])new Object[]{this.mTeamId});
                    }
                }
            }
        } else if (newStatus == 8) {
            ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.error_team_invalid), (int)0);
            this.closeTeamMatchWindow(false);
        }
        this.changeKeepScreenOn(5 == newStatus || 2 == newStatus);
        if (newStatus == 2 || newStatus == 5) {
            TeamInfo teamInfo;
            this.mCurrentMatchStart = System.currentTimeMillis();
            HiidoEvent hiidoEvent = this.teamMatchEvnet("match");
            if (this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamRoomService() != null && (teamInfo = this.mTeamServiceManager.getTeamRoomService().getTeamInfo(this.mTeamId)) != null) {
                int size = teamInfo.getTeamUserInfoList() != null ? teamInfo.getTeamUserInfoList().size() : 0;
                hiidoEvent.put("member_num", String.valueOf(size));
                hiidoEvent.put("opponent_uid", this.transformUid2Event(teamInfo).toString());
            }
            HiidoStatis.reportEvent((HiidoEvent)hiidoEvent);
        }
        this.lastRoomStatus = newStatus;
    }

    protected void recordTeamUserOnSeat() {
        this.mSeatUserBeforeMatchinng.clear();
        this.mSeatUserBeforeMatchinng.addAll(this.mSeatUserIdList);
    }

    protected void onMatchedUserOnMatchSuccess() {
        if (this.mTeamMatchWindow == null) {
            return;
        }
        this.mTeamMatchWindow.hideViewWhenMatchedOthersSuccess();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                TeamMatchWindowController.this.showMatchedUserOnMatchSuccess();
            }
        }, (long)500L);
    }

    protected void showMatchedUserOnMatchSuccess() {
        if (this.mTeamMatchWindow == null) {
            return;
        }
        final ArrayList<Long> matchedUsers = new ArrayList<Long>();
        for (Long uid : this.mSeatUserIdList) {
            if (this.mSeatUserBeforeMatchinng.contains(uid)) continue;
            matchedUsers.add(uid);
        }
        ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(matchedUsers, new OnProfileCallback(){

            public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                if (TeamMatchWindowController.this.mTeamMatchWindow == null) {
                    return;
                }
                ArrayList<UserInfoKS> matchedUserInfoList = new ArrayList<UserInfoKS>();
                if (userInfoKSList != null) {
                    Iterator iterator = matchedUsers.iterator();
                    block0: while (iterator.hasNext()) {
                        long uid = (Long)iterator.next();
                        for (UserInfoKS userInfoKS : userInfoKSList) {
                            if (userInfoKS.uid != uid) continue;
                            matchedUserInfoList.add(userInfoKS);
                            continue block0;
                        }
                    }
                }
                TeamMatchWindowController.this.mTeamMatchWindow.showMatchSuccessWithMatchedInfo(matchedUserInfoList);
            }

            public void onFail(int id2, String msg, String response) {
            }

            public int id() {
                return 0;
            }
        });
    }

    @KvoMethodAnnotation(name="canPlay", sourceClass=TeamInfo.class, thread=1)
    void roomCanPlayChange(KvoEventIntent kvoEvent) {
        if (this.mTeamMatchWindow == null) {
            return;
        }
        if (kvoEvent.newValue() == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"roomCanPlayChange=null", (Object[])new Object[0]);
            }
            return;
        }
        boolean canPlay = (Boolean)kvoEvent.newValue();
        if (canPlay) {
            this.mTeamMatchWindow.showPlayBtn();
        } else {
            this.mTeamMatchWindow.showMatchBtn();
        }
    }

    @KvoMethodAnnotation(name="mDefBarrages", thread=1, sourceClass=TeamGameBarrageController.DefaultBarrages.class)
    public void defaultBarragesChange(KvoEventIntent event) {
        if (this.mTeamMatchWindow == null) {
            return;
        }
        List barrages = (List)event.newValue();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"update default barrages : %s", (Object[])new Object[]{barrages});
        }
        if (barrages != null) {
            this.mTeamMatchWindow.setDefaultBarrages(barrages);
        }
    }

    @KvoMethodAnnotation(name="barrages", sourceClass=TeamGameBarrageController.BarrageData.class)
    public void reveiveBarrageMsg(KvoEventIntent event) {
        if (this.mTeamMatchWindow == null) {
            return;
        }
        KvoListHelper.KvoListChangeType type = KvoListHelper.getNotifyType((KvoEventIntent)event);
        if (type == KvoListHelper.KvoListChangeType.KvoEventArg_Type_Insert) {
            List list = (List)event.newValue();
            KvoListHelper.NSRange range = KvoListHelper.getNotifyRange((KvoEventIntent)event);
            List barrages = list.subList(range.position, range.length + range.position);
            for (BarrageInfo barrageInfo : barrages) {
                int bgColor;
                String avatar = barrageInfo.user != null ? barrageInfo.user.avatar : "";
                String msg = barrageInfo.mDanmu != null ? barrageInfo.mDanmu.txt : "";
                try {
                    String colorString;
                    String string2 = colorString = barrageInfo.mDanmu != null ? barrageInfo.mDanmu.color : null;
                    bgColor = !TextUtils.isEmpty((CharSequence)colorString) ? (colorString.startsWith("#") ? Color.parseColor((String)colorString) : Integer.parseInt(colorString, 16) | 0xFF000000) : -16126;
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, (String)"parse color exception", (Object[])new Object[0]);
                    bgColor = -16126;
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"reveive barrage: %s", (Object[])new Object[]{msg});
                }
                this.mTeamMatchWindow.showBarrage(avatar, msg, bgColor);
            }
        }
    }

    @Override
    public void onMatchClicked() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("\u70b9\u51fb\u5339\u914d\u7684\u65f6\u5019\u7684teamId:" + this.mTeamId), (Object[])new Object[0]);
        }
        if (this.isGoldGame && this.mGameInfo != null) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTGameCoins", (String)"TeamMatchWindowController onMatchClicked gid: %s is isGoldGame", (Object[])new Object[]{this.mGameInfo.getGid()});
            }
            this.sendMessage(BaseMsgDef.MSG_CHECK_SELF_COIN_ENOUGH, -1, -1, new CheckGoinConifg((ICommonCallback)new ICommonCallback<CheckGoinConifg>(){

                public void onSuccess(CheckGoinConifg o, Object ... ext) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTGameCoins", (String)"TeamMatchWindowController onMatchClicked MSG_CHECK_SELF_COIN_ENOUGH success state: %s", (Object[])new Object[]{o == null ? 0 : o.status});
                    }
                    if (TeamMatchWindowController.this.mTeamMatchWindow == null) {
                        if (FeatureLog.isLogLevelBlowInfo()) {
                            FeatureLog.i((String)"FTGameCoins", (String)"TeamMatchWindowController onMatchClicked MSG_CHECK_SELF_COIN_ENOUGH, mTeamMatchWindow = null", (Object[])new Object[0]);
                        }
                        return;
                    }
                    Object coins = TeamMatchWindowController.this.sendMessageSync(GameMsgDef.MSG_GET_MY_COINS);
                    if (coins instanceof Long && TeamMatchWindowController.this.isShowCoinsUI) {
                        TeamMatchWindowController.this.mTeamMatchWindow.updateGoldConfig(ResourceUtils.getString((int)R.string.tips_my_coins), (Long)coins, 0L, false);
                    }
                    if (o != null && o.status == 1) {
                        TeamInfo teamInfo = TeamRoomDataModel.instance.getTeamInfo(TeamMatchWindowController.this.mTeamId);
                        if (teamInfo != null) {
                            List<TeamUserInfo> teamUserInfos = teamInfo.getTeamUserInfoList();
                            ArrayList<Long> teamUids = new ArrayList<Long>();
                            for (TeamUserInfo info : teamUserInfos) {
                                if (info == null) continue;
                                teamUids.add(info.getUid());
                            }
                            if (teamUids.size() == 1 && teamUids.contains(AccountUtil.getUid())) {
                                TeamMatchWindowController.this.onHandlerMatchClicked();
                            } else {
                                teamUids.remove(AccountUtil.getUid());
                                MLog.error((Object)TeamMatchWindowController.TAG, (String)"check other coins:%s", (Object[])new Object[]{teamUids});
                                if (teamUids.isEmpty()) {
                                    TeamMatchWindowController.this.onHandlerMatchClicked();
                                    return;
                                }
                                TeamMatchWindowController.this.sendMessage(GameMsgDef.MSG_CHECK_USER_COINS, -1, -1, new CheckGoinConifg((ICommonCallback)new ICommonCallback<CheckGoinConifg>(){

                                    public void onSuccess(CheckGoinConifg checkGoinConifg, Object ... ext) {
                                        if (checkGoinConifg != null) {
                                            if (MLog.isLogLevelBlowInfo()) {
                                                MLog.info((Object)TeamMatchWindowController.TAG, (String)"check opponent user coins back,status:%d", (Object[])new Object[]{checkGoinConifg.status});
                                            }
                                            if (checkGoinConifg.status == 1) {
                                                TeamMatchWindowController.this.onHandlerMatchClicked();
                                            } else {
                                                ToastUtils.showToast((Context)TeamMatchWindowController.this.mContext, (String)ResourceUtils.getString((int)R.string.tips_someone_coin_not_enought), (int)0);
                                            }
                                        }
                                    }

                                    public void onFail(int errCode, String msg, Object ... ext) {
                                    }
                                }, TeamMatchWindowController.this.mGameInfo, teamUids));
                            }
                        } else {
                            MLog.error((Object)TeamMatchWindowController.TAG, (String)"team info null, match fail!", (Object[])new Object[0]);
                        }
                    }
                }

                public void onFail(int errCode, String msg, Object ... ext) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTGameCoins", (String)"TeamMatchWindowController onMatchClicked MSG_CHECK_SELF_COIN_ENOUGH failed", (Object[])new Object[0]);
                    }
                }
            }, this.mGameInfo, 2));
        } else {
            this.onHandlerMatchClicked();
        }
    }

    private void onHandlerMatchClicked() {
        if (this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamRoomService() != null && !TextUtils.isEmpty((CharSequence)this.mTeamId) && this.mTeamServiceManager.getTeamRoomService().getTeamInfo(this.mTeamId) != null) {
            int status = this.mTeamServiceManager.getTeamRoomService().getTeamInfo(this.mTeamId).getStatus();
            if (status != 6) {
                HiidoEvent hiidoEvent = this.teamMatchEvnet("click_match");
                TeamInfo teamInfo = this.mTeamServiceManager.getTeamRoomService().getTeamInfo(this.mTeamId);
                if (teamInfo != null) {
                    int size = teamInfo.getTeamUserInfoList() != null ? teamInfo.getTeamUserInfoList().size() : 0;
                    hiidoEvent.put("member_num", String.valueOf(size));
                    hiidoEvent.put("opponent_uid", this.transformUid2Event(teamInfo).toString());
                }
                HiidoStatis.reportEvent((HiidoEvent)hiidoEvent);
            }
            if (this.mTeamServiceManager.getGameDataProvider() != null && this.mTeamServiceManager.getGameDataProvider().getGameInfo() != null) {
                if (this.mTeamServiceManager.getTeamRoomService().getTeamInfo(this.mTeamId).getTeamUserInfoList() != null) {
                    this.mPlayerNumberBeforMatch = this.mTeamServiceManager.getTeamRoomService().getTeamInfo(this.mTeamId).getTeamUserInfoList().size();
                }
                if (status == 6) {
                    this.startMatch(true);
                } else {
                    this.startMatch(false);
                }
            }
        }
    }

    public void startMatch(boolean isStart) {
        if (!this.isTeamServiceValid()) {
            return;
        }
        GameInfo gameInfo = this.mTeamServiceManager.getGameDataProvider().getGameInfo();
        if (gameInfo == null) {
            return;
        }
        this.mTeamServiceManager.getTeamRoomService().teamMatchStart(this.mTeamId, gameInfo, gameInfo.getTeamTemplate(), isStart, this.isGoldGame);
    }

    public boolean isTeamServiceValid() {
        return this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamGameInviteService() != null && this.mTeamServiceManager.getGameDataProvider() != null && this.mTeamServiceManager.getTeamRoomService() != null && this.mTeamServiceManager.getTeamGameBarrageService() != null;
    }

    private void directQuickGame() {
        if (this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamRoomService() != null) {
            if (!TextUtils.isEmpty((CharSequence)this.mTeamId)) {
                this.mTeamServiceManager.getTeamRoomService().teamMatchStart(this.mTeamId, this.mTeamServiceManager.getGameDataProvider().getGameInfo(), this.mTeamServiceManager.getGameDataProvider().getGameInfo().getTeamTemplate(), true, this.isGoldGame);
            } else if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"directQuickGame mteamid=null", (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void onBackClicked() {
        if (StringUtils.isEmpty((String)this.mTeamId)) {
            this.onCancelMatch();
            this.closeTeamMatchWindow(true);
        } else if (this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamRoomService() != null) {
            TeamInfo teamInfo = this.mTeamServiceManager.getTeamRoomService().getTeamInfo(this.mTeamId);
            if (teamInfo == null) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"onBackClicked==teamInfo=null", (Object[])new Object[0]);
                }
                this.closeTeamMatchWindow(true);
            } else {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"onBackClicked==teamInfo=%s", (Object[])new Object[]{teamInfo});
                }
                this.backRoom(teamInfo.getStatus());
            }
        }
    }

    private void backRoom(int status) {
        switch (status) {
            case 0: 
            case 1: {
                this.closeTeamMatchWindow(true);
                break;
            }
            case 4: {
                this.leaveRoomConfirm();
                break;
            }
            case 2: 
            case 5: {
                this.cancelMatchConfirm();
                break;
            }
            default: {
                this.closeTeamMatchWindow(true);
            }
        }
    }

    private void leaveRoomConfirm() {
        this.mDialogLinkManager.showDialog((BaseDialog)new OkCancelDialog((CharSequence)ResourceUtils.getString((int)R.string.confirm_leave_room), (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_yes), (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_no), true, new OkCancelDialogListener(){

            public void onCancel() {
            }

            public void onOk() {
                TeamMatchWindowController.this.closeTeamMatchWindow(true);
            }
        }));
    }

    private void cancelMatchConfirm() {
        this.mDialogLinkManager.showDialog((BaseDialog)new OkCancelDialog((CharSequence)ResourceUtils.getString((int)R.string.confirm_cancel_match), (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_yes), (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_no), true, new OkCancelDialogListener(){

            public void onCancel() {
            }

            public void onOk() {
                TeamMatchWindowController.this.onMatchCancelClicked();
            }
        }));
    }

    @Override
    public void onRuleClicked() {
        if (this.mTeamServiceManager == null || this.mTeamServiceManager.getGameDataProvider() == null) {
            return;
        }
        GameInfo gameInfo = this.mTeamServiceManager.getGameDataProvider().getGameInfo();
        if (gameInfo == null) {
            return;
        }
        final String url = this.mTeamServiceManager.getGameDataProvider().getTeamGuideUrl(gameInfo.gid);
        if (StringUtils.isEmpty((String)url)) {
            return;
        }
        final int orientation = gameInfo.getScreenDire() == 2 ? 0 : 3;
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                WebEnvSettings wes = new WebEnvSettings();
                wes.url = url;
                wes.usePageTitle = true;
                wes.isFullScreen = false;
                wes.disablePullRefresh = true;
                wes.backBtnResId = R.drawable.icon_nav_back;
                wes.webviewFeature = 1;
                wes.orientation = orientation;
                IWebService iWebService = (IWebService)TeamMatchWindowController.this.getServiceManager().getService(IWebService.class);
                if (iWebService != null) {
                    iWebService.loadUrl(wes);
                    iWebService.registerWebBusiness(new IWebBusinessCallBack(){

                        public void onWebBusinessCreated(IWebBusinessHandler businessHandler) {
                        }

                        public void onWebBusinessDestroyed(IWebBusinessHandler businessHandler) {
                            HiidoEvent hiidoEvent = TeamMatchWindowController.this.teamMatchEvnet("click_return_game_rule");
                            HiidoStatis.reportEvent((HiidoEvent)hiidoEvent);
                        }
                    });
                }
            }
        });
        HiidoEvent hiidoEvent = this.teamMatchEvnet("click_game_rule");
        HiidoStatis.reportEvent((HiidoEvent)hiidoEvent);
    }

    @Override
    public void onSendQuickBarrageClicked(String barrageMsg, int bgColor) {
        this.sendBarrage(barrageMsg, bgColor);
        HiidoEvent hiidoEvent = this.teamMatchEvnet("click_quick_mes");
        HiidoStatis.reportEvent((HiidoEvent)hiidoEvent);
    }

    @Override
    public void onSendCustomBarrageClicked(String barrageMsg, int color2) {
        this.sendBarrage(barrageMsg, color2);
        HiidoEvent hiidoEvent = this.teamMatchEvnet("send_diybarrage");
        HiidoStatis.reportEvent((HiidoEvent)hiidoEvent);
    }

    private void sendBarrage(String barrageMsg, int bgColor) {
        if (this.mUserInfo == null) {
            this.mUserInfo = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(AccountUtil.getUid(), null);
        }
        String colorStr = Integer.toHexString(bgColor & 0xFFFFFF);
        BarrageInfo info = new BarrageInfo(new BarrageInfo.User(this.mUserInfo.uid, this.mUserInfo.avatar, this.mUserInfo.nick, this.mUserInfo.sex), new BarrageInfo.Barrage(barrageMsg, System.currentTimeMillis(), colorStr));
        this.mTeamServiceManager.getTeamGameBarrageService().sendBarrage(this.mTeamId, info);
    }

    @Override
    public void onMatchCancelClicked() {
        this.onCancelMatch();
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTGameCoins", (String)"onMatchCancel isGoldGame: %s isFromGame: %s", (Object[])new Object[]{this.isGoldGame, this.isFromGame});
        }
        if (this.isGoldGame && !this.isFromGame) {
            this.closeTeamMatchWindow(true);
        }
    }

    private void onCancelMatch() {
        if (this.mTeamMatchWindow == null) {
            return;
        }
        if (StringUtils.isEmpty((String)this.mTeamId)) {
            return;
        }
        if (this.mTeamServiceManager == null || this.mTeamServiceManager.getTeamRoomService() == null) {
            return;
        }
        if (this.mTeamServiceManager != null && this.mTeamServiceManager.getGameDataProvider() != null && this.mTeamServiceManager.getGameDataProvider().getGameInfo() != null) {
            GameModel gameModel = GameModel.newBuilder().gameInfo(this.mTeamServiceManager.getGameDataProvider().getGameInfo()).roomid(this.mTeamId).build();
            GameReportHelper.reportGameInfo(gameModel, (int)(System.currentTimeMillis() - this.mCurrentMatchStart), this.mOpenScene, GameStateDef.GAME_FINISH_REASON.FORCE_FINISH.value(), 1, gameModel.getGameInfo().isGoldMode());
        }
        this.showLoadingDialog();
        this.mTeamServiceManager.getTeamRoomService().teamMatchCancel(this.mTeamId, new ITeamMatchCancelListener(){

            @Override
            public void onTeamMatchCancelSuccess(String teamId) {
                if (TeamMatchWindowController.this.mTeamMatchWindow == null) {
                    return;
                }
                TeamMatchWindowController.this.dismissDialog();
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamMatchWindowController.TAG, (String)"team match cancel success", (Object[])new Object[0]);
                }
            }

            @Override
            public void onTeamMatchCancelFailed(String teamId, long code) {
                if (TeamMatchWindowController.this.mTeamMatchWindow == null) {
                    return;
                }
                TeamMatchWindowController.this.dismissDialog();
                ToastUtils.showToast((Context)TeamMatchWindowController.this.mContext, (String)ResourceUtils.getString((int)R.string.cancel_match_fail), (int)0);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamMatchWindowController.TAG, (String)"team match cancel failed, code = %d", (Object[])new Object[]{code});
                }
            }
        });
        HiidoEvent hiidoEvent = this.teamMatchEvnet("cancle_match");
        HiidoStatis.reportEvent((HiidoEvent)hiidoEvent);
    }

    @Override
    public void onSeatClick(int position) {
        if (this.mTeamMatchWindow == null) {
            return;
        }
        if (this.mTeamServiceManager == null || this.mTeamServiceManager.getTeamRoomService() == null) {
            MLog.error((Object)TAG, (String)"onSeatClick getTeamRoomService null", (Object[])new Object[0]);
            return;
        }
        TeamInfo teamInfo = this.mTeamServiceManager.getTeamRoomService().getTeamInfo(this.mTeamId);
        if (teamInfo == null) {
            return;
        }
        int status = teamInfo.getStatus();
        if (status == 2 || status == 5) {
            return;
        }
        if (position < 0 || position >= this.mSeatUserList.size()) {
            return;
        }
        UserInfoKS clickSeatUser = this.mSeatUserList.get(position);
        if (clickSeatUser != null) {
            this.mTeamMatchWindow.closeBarrageViewIfShow();
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"open profile window:%s", (Object[])new Object[]{String.valueOf(clickSeatUser.uid)});
            }
            ProfileReportBean bean = new ProfileReportBean();
            bean.setUid(Long.valueOf(clickSeatUser.uid));
            bean.setShowSource(Integer.valueOf(ProfileReportBean.ShowSource.getGame()));
            bean.setGid(teamInfo.getGameId());
            bean.setSource(11);
            this.sendMessage(BaseMsgDef.MSG_OPEN_PROFILE_NEW_WINDOW, 6, -1, bean);
            HiidoEvent hiidoEvent = this.teamMatchEvnet("click_photo");
            hiidoEvent.put("opponent_uid", String.valueOf(clickSeatUser.getUid()));
            HiidoStatis.reportEvent((HiidoEvent)hiidoEvent);
        }
    }

    @Override
    public void onTestPlay() {
        this.directQuickGame();
    }

    @Override
    public void onTestAddPlayer() {
        String url = StringUtils.formatWitUSLocal((String)"http://i-test-863.ihago.net/pkgame/team_add_ai?data={\"tid\":\"%s\"}", (Object[])new Object[]{this.mTeamId});
        HttpUtil.httpReq((String)url, null, (int)1, (INetRespCallback)new INetRespOriginJsonParseCallback<String>(){

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponse(String response, BaseResponseBean<String> res, int id2) {
            }
        });
    }

    @Override
    public void onBarrageChatBtnClicked() {
        HiidoEvent hiidoEvent = this.teamMatchEvnet("click_barrage");
        HiidoStatis.reportEvent((HiidoEvent)hiidoEvent);
    }

    @Override
    public void onCustomBarrageInputBtnClicked() {
    }

    @Override
    public void onModeSelectClicked() {
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (StringUtils.isNotEmpty((String)this.mTeamId) && this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamRoomService() != null) {
            this.mTeamServiceManager.getTeamRoomService().leaveRoom(this.mTeamId, null);
        }
        this.mBinder.clearAllKvoConnections();
        this.roomDataUnBinding(this.mTeamId);
        if (this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamRoomService() != null) {
            this.mTeamServiceManager.getTeamRoomService().unRegisterTeamMatchListener(this.mMatchListener);
            this.mTeamServiceManager.getTeamRoomService().unRegisterTeamMatchCancelListener(this.teamMatchCancelNotifyListener);
        }
        if (this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamGameBarrageService() != null) {
            this.mTeamServiceManager.getTeamGameBarrageService().unRegisterBarrageNotify(this.mBarrageListener);
        }
        this.dismissDialog();
        if (this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamGameInviteService() != null && this.mTeamServiceManager.getTeamGameInviteService().getInviteFriendContainer() != null) {
            TeamInviteServicesController.InviteFriendContainer inviteFriendContainer = this.mTeamServiceManager.getTeamGameInviteService().getInviteFriendContainer();
            Kvo.removeKvoBinding((KvoSource)inviteFriendContainer, (Object)this, (String)"onInviteFriendsChange");
        }
        if (this.mTeamMatchCallback != null) {
            this.mTeamMatchCallback.onTeamMatchDestroy(this.lastRoomStatus);
            this.mTeamMatchCallback = null;
        }
        if (this.mTeamMatchWindow != null) {
            this.mTeamMatchWindow = null;
        }
        this.changeKeepScreenOn(false);
        if (!this.mGotoGame) {
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)GameNotificationDef.TEAM_GAME_DESTORY));
        }
        ((IGameService)this.getServiceManager().getService(IGameService.class)).restartAllDownload("team_match_game");
    }

    public HiidoEvent teamMatchEvnet(String functionId) {
        HiidoEvent hiidoEvent = HiidoEvent.obtain().eventId("20025731");
        if (this.mTeamServiceManager != null && this.mTeamServiceManager.getGameDataProvider() != null) {
            IGameDataProvider gameDataProvider = this.mTeamServiceManager.getGameDataProvider();
            hiidoEvent.put("functionId", functionId).put("page_source", String.valueOf(this.mOpenScene));
            if (gameDataProvider.getGameInfo() != null) {
                hiidoEvent.put("gid", gameDataProvider.getGameInfo().getGid());
                GameModeInfo modeInfo = gameDataProvider.getCurrentMode();
                if (modeInfo != null) {
                    hiidoEvent.put("mid", "" + modeInfo.getId());
                }
            }
        }
        if (this.mTeamMatchWindow != null) {
            hiidoEvent.put("page_id", this.pageType[this.mTeamMatchWindow.getPageType()]);
        }
        return hiidoEvent;
    }

    private String getFriendsStaticInfo(List<FindFriend> datas) {
        JsonArray array2 = new JsonArray();
        int fbOnline = 0;
        int fbOffline = 0;
        int contactOnline = 0;
        int contactOffline = 0;
        int hagoOnline = 0;
        int hagoOffline = 0;
        int nearbyOnline = 0;
        int nearbyOffline = 0;
        if (datas != null && !datas.isEmpty()) {
            JsonObject jsonObject;
            for (FindFriend friend : datas) {
                long type = friend.getType();
                boolean online = friend.isOnline();
                if (type == 0L) {
                    if (online) {
                        ++fbOnline;
                        continue;
                    }
                    ++fbOffline;
                    continue;
                }
                if (type == 1L) {
                    if (online) {
                        ++contactOnline;
                        continue;
                    }
                    ++contactOffline;
                    continue;
                }
                if (type == 2L) {
                    if (online) {
                        ++nearbyOnline;
                        continue;
                    }
                    ++nearbyOffline;
                    continue;
                }
                if (type != 3L) continue;
                if (online) {
                    ++hagoOnline;
                    continue;
                }
                ++hagoOffline;
            }
            if (fbOnline > 0) {
                jsonObject = new JsonObject();
                jsonObject.addProperty("friend_type", "facebook");
                jsonObject.addProperty("friends_num", (Number)fbOnline);
                jsonObject.addProperty("online_flag", (Number)1);
                array2.add((JsonElement)jsonObject);
            }
            if (fbOffline > 0) {
                jsonObject = new JsonObject();
                jsonObject.addProperty("friend_type", "facebook");
                jsonObject.addProperty("friends_num", (Number)fbOffline);
                jsonObject.addProperty("online_flag", (Number)0);
                array2.add((JsonElement)jsonObject);
            }
            if (contactOnline > 0) {
                jsonObject = new JsonObject();
                jsonObject.addProperty("friend_type", "contact");
                jsonObject.addProperty("friends_num", (Number)contactOnline);
                jsonObject.addProperty("online_flag", (Number)1);
                array2.add((JsonElement)jsonObject);
            }
            if (contactOffline > 0) {
                jsonObject = new JsonObject();
                jsonObject.addProperty("friend_type", "contact");
                jsonObject.addProperty("friends_num", (Number)contactOffline);
                jsonObject.addProperty("online_flag", (Number)0);
                array2.add((JsonElement)jsonObject);
            }
            if (nearbyOnline > 0) {
                jsonObject = new JsonObject();
                jsonObject.addProperty("friend_type", "nearby");
                jsonObject.addProperty("friends_num", (Number)nearbyOnline);
                jsonObject.addProperty("online_flag", (Number)1);
                array2.add((JsonElement)jsonObject);
            }
            if (nearbyOffline > 0) {
                jsonObject = new JsonObject();
                jsonObject.addProperty("friend_type", "nearby");
                jsonObject.addProperty("friends_num", (Number)nearbyOffline);
                jsonObject.addProperty("online_flag", (Number)0);
                array2.add((JsonElement)jsonObject);
            }
            if (hagoOnline > 0) {
                jsonObject = new JsonObject();
                jsonObject.addProperty("friend_type", "hago");
                jsonObject.addProperty("friends_num", (Number)hagoOnline);
                jsonObject.addProperty("online_flag", (Number)1);
                array2.add((JsonElement)jsonObject);
            }
            if (hagoOffline > 0) {
                jsonObject = new JsonObject();
                jsonObject.addProperty("friend_type", "hago");
                jsonObject.addProperty("friends_num", (Number)hagoOffline);
                jsonObject.addProperty("online_flag", (Number)0);
                array2.add((JsonElement)jsonObject);
            }
        }
        return array2.toString();
    }

    public ITeamServiceManager getTeamService() {
        return this.mTeamServiceManager;
    }

    public void changeKeepScreenOn(boolean keepOn) {
        if (keepOn) {
            this.mKeepScreenOnTask.keepScreenOn((Activity)this.mContext);
        } else {
            this.mKeepScreenOnTask.unDoKeepScreenOn((Activity)this.mContext);
        }
    }

    public StringBuilder transformUid2Event(TeamInfo teamInfo) {
        StringBuilder uids = new StringBuilder();
        if (teamInfo == null || teamInfo.getTeamUserInfoList() == null) {
            return uids;
        }
        ArrayList<TeamUserInfo> teamUserInfos = new ArrayList<TeamUserInfo>(teamInfo.getTeamUserInfoList());
        for (int i = 0; i < teamUserInfos.size(); ++i) {
            uids.append(((TeamUserInfo)teamUserInfos.get(i)).getUid());
            if (i == teamUserInfos.size() - 1) continue;
            uids.append(",");
        }
        return uids;
    }

    protected void onTeamReadyInner() {
        this.checkIfShowGuides();
    }

    protected void dismissDialog() {
        if (this.mDialogLinkManager == null) {
            return;
        }
        this.mDialogLinkManager.dismissDialog();
    }

    protected void showLoadingDialog() {
        if (this.mDialogLinkManager == null) {
            return;
        }
        this.mDialogLinkManager.showDialog((BaseDialog)new ProgressDialog());
    }

    protected void updateMyGameCoinView(boolean show2) {
        if (this.isShowCoinsUI && this.mTeamMatchWindow != null) {
            this.mTeamMatchWindow.updateGoldViewVisibility(show2);
        }
    }

    class GotoGameRoomRunable
    implements Runnable {
        private String roomId;
        private String url;
        private List<TeamUserInfo> teamList;

        GotoGameRoomRunable(String roomId, String url, List<TeamUserInfo> teamList) {
            this.roomId = roomId;
            this.url = url;
            this.teamList = new ArrayList<TeamUserInfo>(teamList);
        }

        @Override
        public void run() {
            if (TeamMatchWindowController.this.mTeamServiceManager != null && TeamMatchWindowController.this.mTeamServiceManager.getGameDataProvider() != null && TeamMatchWindowController.this.mTeamServiceManager.getGameDataProvider().getGameInfo() != null) {
                TeamMatchWindowController.this.enterGame(TeamMatchWindowController.this.mTeamServiceManager.getGameDataProvider().getGameInfo().getGid(), this.roomId, this.url, this.teamList);
            }
        }
    }
}

