/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.module;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.kvo.FindFriend;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoFieldAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.game.R;
import com.yy.game.gamemodule.teamgame.teammatch.interfaces.IGetShareData;
import com.yy.game.gamemodule.teamgame.teammatch.interfaces.IInviteNotify;
import com.yy.game.gamemodule.teamgame.teammatch.model.invite.GameShareData;
import com.yy.game.gamemodule.teamgame.teammatch.services.ITeamInviteServices;
import com.yy.game.module.gameinvite.panel.GameSharePanel;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.config.GameShareConfig;
import com.yy.hiyo.game.base.helper.ShortUrlUtil;
import com.yy.hiyo.game.base.teamgame.InviteFriendData;
import com.yy.hiyo.game.service.IGameInviteService;
import com.yy.hiyo.game.service.IGameTeamInviteService;
import com.yy.hiyo.game.service.callback.IIMGameInviteListener;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.socialplatformbase.data.ShareData;
import common.Header;
import ikxd.apigateway.ApiGateway;
import ikxd.apigateway.GetHFAFriendsReq;
import ikxd.apigateway.GetHFAFriendsRes;
import ikxd.apigateway.Uri;
import ikxd.apigateway.UserInfo;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class TeamInviteServicesController
implements ITeamInviteServices {
    private static final String TAG = "TeamInviteServicesContr";
    private static final long LOAD_FRIENDS_INTERVAL = 60000L;
    public final List<InviteFriendData> friends = new ArrayList<InviteFriendData>();
    private final List<WeakReference<IInviteNotify>> mInviteNotifys = new ArrayList<WeakReference<IInviteNotify>>();
    private InviteFriendContainer mFriendContainers = new InviteFriendContainer();
    private volatile boolean hasExitRoom = true;
    private GameShareData mGameShareData;
    private IIntlShareService mShareService;
    private final IGetShareData iGetShareData;
    private String shortShareUrl = null;
    private IServiceManager iServiceManager;
    private GameSharePanel mGameSharePanel;
    private IIMGameInviteListener.IGameInviteInvalidListener inviteInvalidListener = new IIMGameInviteListener.IGameInviteInvalidListener(){

        public void onGameInviteInvalid(final long uid, String gameId, String pkId) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_game_friend_not_support), (int)1);
                    HashSet<Long> uids = new HashSet<Long>();
                    uids.add(uid);
                    TeamInviteServicesController.this.mFriendContainers.resetInviteState(uids);
                }
            });
        }
    };
    private Runnable mLoadTask = new Runnable(){

        @Override
        public void run() {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)TeamInviteServicesController.this.mLoadTask);
            if (!TeamInviteServicesController.this.hasExitRoom) {
                TeamInviteServicesController.this.getFriends();
                YYTaskExecutor.postToMainThread((Runnable)TeamInviteServicesController.this.mLoadTask, (long)60000L);
            }
        }
    };

    public TeamInviteServicesController(IGetShareData callback2, IServiceManager serviceManager) {
        this.iGetShareData = callback2;
        this.iServiceManager = serviceManager;
        if (this.iGetShareData != null) {
            this.mGameShareData = this.iGetShareData.shareData();
            this.mShareService = this.iGetShareData.getShareService();
        }
    }

    private List<InviteFriendData> getFriends() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"on load friends data,ts:%d", (Object[])new Object[]{System.currentTimeMillis()});
        }
        GetHFAFriendsReq req = new GetHFAFriendsReq.Builder().limit(Long.valueOf(40L)).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_apigateway_d");
        ApiGateway gateway = new ApiGateway.Builder().header(header).get_hfa_friends_req(req).uri(Uri.kUriGetHFAFriendsReq).build();
        ProtoManager.getInstance().send((AndroidMessage)gateway, (IProtoCallback)new IProtoCallback<ApiGateway>(){

            public void onResponse(@Nullable ApiGateway apiGateway) {
                if (apiGateway == null) {
                    MLog.error((Object)TeamInviteServicesController.TAG, (String)"getFriends error, proto is null", (Object[])new Object[0]);
                    return;
                }
                GetHFAFriendsRes getHFAFriendsRes = apiGateway.get_hfa_friends_res;
                List userInfos = getHFAFriendsRes.users;
                StringBuilder uidStr = new StringBuilder();
                uidStr.append("[");
                ArrayList<FindFriend> list = new ArrayList<FindFriend>();
                for (UserInfo userInfo : userInfos) {
                    FindFriend friend = FindFriend.transform((UserInfo)userInfo);
                    list.add(friend);
                    uidStr.append("" + userInfo.uid + ", ");
                }
                uidStr.append("]");
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamInviteServicesController.TAG, (String)"on get friends success,size:%d, uids = %s", (Object[])new Object[]{list.size(), uidStr.toString()});
                }
                TeamInviteServicesController.this.mFriendContainers.setValue("rawFriends", list);
                TeamInviteServicesController.this.mFriendContainers.setFriends(list);
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamInviteServicesController.TAG, (String)("on load friends timeout:" + canRetry), (Object[])new Object[0]);
                }
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamInviteServicesController.TAG, (String)"on load friends error:%s ,code:%d", (Object[])new Object[]{reason, code});
                }
                return false;
            }
        });
        return this.mFriendContainers.friends;
    }

    @Override
    public InviteFriendContainer getInviteFriendContainer() {
        return this.mFriendContainers;
    }

    @Override
    public GameShareConfig getSharePlatforms() {
        AConfigData data = UnifyConfig.INSTANCE.getConfigData(BssCode.GAME_SHARE_CONFIG);
        if (data instanceof GameShareConfig) {
            return (GameShareConfig)data;
        }
        return null;
    }

    @Override
    public GameSharePanel getTeamMatcherSharePanel(boolean isLand, Context context, String gid, boolean forceCreate) {
        if (!forceCreate) {
            return this.mGameSharePanel;
        }
        if (this.mGameSharePanel == null) {
            this.mGameSharePanel = new GameSharePanel(context, isLand, gid);
            this.mGameSharePanel.setInviteFriendContainer(this.mFriendContainers);
        }
        return this.mGameSharePanel;
    }

    @Override
    public void onEnterRoom() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"on enter room", (Object[])new Object[0]);
        }
        this.hasExitRoom = false;
        YYTaskExecutor.postToMainThread((Runnable)this.mLoadTask);
        if (this.iServiceManager != null) {
            ((IGameInviteService)this.iServiceManager.getService(IGameInviteService.class)).registerGameInviteInvalidListener(this.inviteInvalidListener);
        }
    }

    @Override
    public void onExitRoom() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"on exit room", (Object[])new Object[0]);
        }
        this.hasExitRoom = true;
        this.shortShareUrl = null;
        this.mGameSharePanel = null;
        this.mFriendContainers.clear();
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mLoadTask);
        if (this.iServiceManager != null) {
            ((IGameInviteService)this.iServiceManager.getService(IGameInviteService.class)).unRegisterGameInviteInvalidListener(this.inviteInvalidListener);
        }
    }

    @Override
    public void invite(IGameTeamInviteService service, String teamId, GameInfo info, InviteFriendData friendData) {
        this.invite(service, teamId, info, friendData, info.getTeamTemplate());
    }

    @Override
    public void invite(IGameTeamInviteService service, String teamId, GameInfo info, InviteFriendData friendData, int multiMode) {
        this.mFriendContainers.invite(friendData);
        if (service != null && !TextUtils.isEmpty((CharSequence)teamId) && info != null) {
            service.teamInviteByIm(info.getGid(), teamId, multiMode, friendData.mFriends.getUid());
            this.notifyInvite(friendData.mFriends.getUid(), teamId, info);
        }
    }

    @Override
    public void shareTo(Context ctx, int platform, GameInfo info, String teamId) {
        this.shareTo(ctx, platform, info, teamId, info.getTeamTemplate());
    }

    @Override
    public void shareTo(Context ctx, int platform, GameInfo info, String teamId, int multiMode) {
        if (platform == 1) {
            this.shareFacebook(teamId, info, multiMode);
        } else if (platform == 2) {
            this.shareLine(teamId, info, multiMode);
        } else if (platform == 4) {
            this.shareMessager(teamId, info, multiMode);
        } else if (platform == 3) {
            this.shareWhatsApp(teamId, info, multiMode);
        } else if (platform == 5) {
            this.shareVK(teamId, info, multiMode);
        }
    }

    @Override
    public synchronized void registerInviteFriendNotify(IInviteNotify notify) {
        if (notify == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"register invite notify err,notify null", (Object[])new Object[0]);
            }
            return;
        }
        Iterator<WeakReference<IInviteNotify>> iterator = this.mInviteNotifys.iterator();
        while (iterator.hasNext()) {
            WeakReference<IInviteNotify> item = iterator.next();
            if (item == null || item.get() == null) {
                iterator.remove();
                continue;
            }
            if (item.get() != notify) continue;
            return;
        }
        this.mInviteNotifys.add(new WeakReference<IInviteNotify>(notify));
    }

    @Override
    public void onTeamDataReady(String teamId, GameInfo info, int multiMode) {
        if (StringUtils.isEmpty((String)teamId) || info == null) {
            MLog.error((Object)TAG, (String)"onTeamDataReady error.teamId:%s, info:%s", (Object[])new Object[]{teamId, info});
            return;
        }
        this.shortShareUrl = "";
        this.getShortShareUrl(teamId, info, multiMode);
    }

    @Override
    public void onShareDataChange(GameShareData gameShareData) {
        this.mGameShareData = gameShareData;
    }

    private void getShortShareUrl(String teamId, GameInfo info, int multiMode) {
        if (!FP.empty((CharSequence)this.shortShareUrl)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"short share url:%s", (Object[])new Object[]{this.shortShareUrl});
            }
            return;
        }
        ShortUrlUtil.getShortUrl((String)this.getShareLink(this.mGameShareData.getmShareUrl(), info, teamId, multiMode), (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

            public void onSuccess(String input, String shortUrl) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamInviteServicesController.TAG, (String)"input :%s, shortUrl:%s", (Object[])new Object[]{input, shortUrl});
                }
                TeamInviteServicesController.this.shortShareUrl = shortUrl;
            }

            public void onError(String input, int code, String msg) {
            }
        });
    }

    private synchronized void notifyInvite(long uid, String teamId, GameInfo info) {
        if (this.mInviteNotifys.isEmpty()) {
            return;
        }
        Iterator<WeakReference<IInviteNotify>> iterator = this.mInviteNotifys.iterator();
        while (iterator.hasNext()) {
            WeakReference<IInviteNotify> iInviteNotifyWeakReference = iterator.next();
            if (iInviteNotifyWeakReference == null || iInviteNotifyWeakReference.get() == null) {
                iterator.remove();
                continue;
            }
            ((IInviteNotify)iInviteNotifyWeakReference.get()).onInvite(uid, teamId, info);
        }
    }

    private void shareWhatsApp(String teamId, GameInfo info) {
        this.shareWhatsApp(teamId, info, info.getTeamTemplate());
    }

    private void shareWhatsApp(String teamId, GameInfo info, int multiMode) {
        if (this.isDataReady()) {
            ShareData data = ShareData.builder().to(1).type(0).text(this.getShareText(teamId, info, multiMode)).systemShare(true).build();
            this.mShareService.share(2, data);
        }
    }

    private void shareFacebook(String teamId, GameInfo info) {
        this.shareFacebook(teamId, info, info.getTeamTemplate());
    }

    private void shareFacebook(String teamId, GameInfo info, int multiMode) {
        if (this.isDataReady()) {
            ShareData data = ShareData.builder().to(2).type(2).text(this.getShareText(teamId, info, multiMode)).gotoUrl(this.getShareLink(this.mGameShareData.getmShareUrl(), info, teamId, multiMode)).build();
            this.mShareService.share(5, data);
        }
    }

    private void shareLine(String teamId, GameInfo info) {
        this.shareLine(teamId, info, info.getTeamTemplate());
    }

    private void shareLine(String teamId, GameInfo info, int multiMode) {
        if (this.isDataReady()) {
            ShareData data = ShareData.builder().type(0).to(1).text(this.getShareText(teamId, info, multiMode)).systemShare(true).build();
            this.mShareService.share(1, data);
        }
    }

    private void shareMessager(String teamId, GameInfo info) {
        this.shareMessager(teamId, info, info.getTeamTemplate());
    }

    private void shareMessager(String teamId, GameInfo info, int multiMode) {
        if (this.isDataReady()) {
            ShareData data = ShareData.builder().type(2).title(this.mGameShareData.getmShareTitle()).imgPath(this.mGameShareData.getmShareImageUrl()).text(this.mGameShareData.getmShareSubtitle()).gotoUrl(this.getShareLink(this.mGameShareData.getmShareUrl(), info, teamId, multiMode)).build();
            this.mShareService.share(6, data);
        }
    }

    private void shareVK(String teamId, GameInfo info) {
        this.shareVK(teamId, info, info.getTeamTemplate());
    }

    private void shareVK(String teamId, GameInfo info, int multiMode) {
        if (this.isDataReady()) {
            ShareData data = ShareData.builder().to(2).type(2).text(this.getShareText(teamId, info, multiMode)).gotoUrl(this.getShareLink(this.mGameShareData.getmShareUrl(), info, teamId, multiMode)).build();
            this.mShareService.share(9, data);
        }
    }

    private boolean isDataReady() {
        if (this.mGameShareData != null) {
            return true;
        }
        if (this.iGetShareData != null) {
            this.mGameShareData = this.iGetShareData.shareData();
            if (this.mGameShareData != null) {
                return true;
            }
        }
        MLog.error((Object)TAG, (String)"game share data is null", (Object[])new Object[0]);
        return false;
    }

    private String getShareText(String teamId, GameInfo info, int multiMode) {
        String content;
        if (this.mGameShareData != null && info != null && !TextUtils.isEmpty((CharSequence)(content = this.mGameShareData.getmShareContent()))) {
            int first = content.indexOf("##");
            int last = content.lastIndexOf("##");
            if (first >= 0 && last > first) {
                String parseContent = content.substring(0, first) + this.getShareLink(this.mGameShareData.getmShareUrl(), info, teamId, multiMode) + " " + content.substring(last + 2);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"share content:%s", (Object[])new Object[]{parseContent});
                }
                return parseContent;
            }
        }
        return this.mGameShareData != null ? this.mGameShareData.getmShareContent() : "";
    }

    private String getShareLink(String link, GameInfo info, String teamId, int multiMode) {
        if (!StringUtils.isEmpty((String)this.shortShareUrl)) {
            return this.shortShareUrl;
        }
        if (!TextUtils.isEmpty((CharSequence)link) && info != null && !TextUtils.isEmpty((CharSequence)teamId)) {
            String url = link;
            if (!url.contains("?")) {
                url = url + "?";
            }
            url = url + StringUtils.formatWitUSLocal((String)"&uid=%d&langCode=%s&game_id=%s&team_template=%d&team_id=%s&invite_uid=%d&h=%d", (Object[])new Object[]{AccountUtil.getUid(), SystemUtils.getLangAndCountry(), info.getGid(), multiMode, teamId, AccountUtil.getUid(), UriProvider.getIdc()});
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"parse share link:%s", (Object[])new Object[]{url});
            }
            return url;
        }
        return link;
    }

    public static final class InviteFriendContainer
    extends KvoSource {
        private static final long INVITE_TIMEOUT_INTERVAL = 30000L;
        public static final String Kvo_friends = "friends";
        @KvoFieldAnnotation(name="friends")
        public final List<InviteFriendData> friends = new ArrayList<InviteFriendData>();
        public static final String Kvo_rawFriends = "rawFriends";
        @KvoFieldAnnotation(name="rawFriends")
        public final List<FindFriend> rawFriends = new ArrayList<FindFriend>();
        public static final String Kvo_hasOnlineCanInviteFriends = "hasOnlineCanInviteFriends";
        @KvoFieldAnnotation(name="hasOnlineCanInviteFriends")
        public boolean hasOnlineCanInviteFriends = false;
        private LinkedHashMap<Long, InviteFriendData> inviteFriendDataMap = new LinkedHashMap();
        private Runnable mCheckTask = new Runnable(){

            @Override
            public void run() {
                YYTaskExecutor.removeRunnableFromMainThread((Runnable)mCheckTask);
                if (!inviteFriendDataMap.isEmpty()) {
                    ArrayList list = new ArrayList(inviteFriendDataMap.values());
                    for (InviteFriendData data : list) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)TeamInviteServicesController.TAG, (String)("uid:" + data.mFriends.getUid() + " cur:" + System.currentTimeMillis() + " record:" + data.inviteTs), (Object[])new Object[0]);
                        }
                        if (!this.isInviteStateValid(data.inviteTs)) {
                            data.inviteTs = 0L;
                            data.setValue("inviteState", (Object)0);
                            inviteFriendDataMap.remove(data.mFriends.getUid());
                            if (!MLog.isLogLevelBlowInfo()) continue;
                            MLog.info((Object)TeamInviteServicesController.TAG, (String)"remove timeout invite:%d", (Object[])new Object[]{data.mFriends.getUid()});
                            continue;
                        }
                        long rest = 30000L - (System.currentTimeMillis() - data.inviteTs);
                        if (rest > 0L) {
                            YYTaskExecutor.postToMainThread((Runnable)mCheckTask, (long)rest);
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)TeamInviteServicesController.TAG, (String)"start next invite check:%d,rest time:%d", (Object[])new Object[]{data.mFriends.getUid(), rest});
                            }
                            return;
                        }
                        if (!MLog.isLogLevelBlowInfo()) continue;
                        MLog.info((Object)TeamInviteServicesController.TAG, (String)"next invite timeout:%d,rest time:%d", (Object[])new Object[]{data.mFriends.getUid(), rest});
                    }
                } else if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamInviteServicesController.TAG, (String)"cache timeout task empty", (Object[])new Object[0]);
                }
            }
        };

        public boolean invite(InviteFriendData friend) {
            if (friend != null && friend.mFriends != null && friend.inviteState == 0) {
                this.inviteFriendDataMap.put(friend.mFriends.getUid(), friend);
                friend.setValue("inviteState", (Object)1);
                friend.inviteTs = System.currentTimeMillis();
                YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mCheckTask);
                YYTaskExecutor.postToMainThread((Runnable)this.mCheckTask);
                return true;
            }
            return false;
        }

        public void resetInviteState(Set<Long> uids) {
            for (Long uid : uids) {
                InviteFriendData data = this.inviteFriendDataMap.get(uid);
                if (data == null) continue;
                data.inviteTs = 0L;
                data.setValue("inviteState", (Object)0);
                this.inviteFriendDataMap.remove(uid);
            }
        }

        public void setFriends(List<FindFriend> datas) {
            if (datas == null) {
                datas = new ArrayList<FindFriend>();
            }
            CopyOnWriteArrayList<FindFriend> copy = new CopyOnWriteArrayList<FindFriend>(datas);
            ArrayList<InviteFriendData> result = new ArrayList<InviteFriendData>();
            LinkedHashMap<Long, InviteFriendData> mNewInvites = new LinkedHashMap<Long, InviteFriendData>();
            boolean hasOnlineCanInvite = false;
            for (FindFriend friend : copy) {
                InviteFriendData cache;
                InviteFriendData f = new InviteFriendData(friend);
                if (friend.isOnline() && !friend.isInGame() && !friend.isMatching()) {
                    hasOnlineCanInvite = true;
                }
                long uid = friend.getUid();
                if (!this.inviteFriendDataMap.isEmpty() && this.inviteFriendDataMap.containsKey(uid) && (cache = this.inviteFriendDataMap.get(uid)) != null && this.isInviteStateValid(cache.inviteTs)) {
                    f.inviteState = cache.inviteState;
                    f.inviteTs = cache.inviteTs;
                    mNewInvites.put(uid, f);
                }
                result.add(f);
            }
            this.inviteFriendDataMap.clear();
            this.inviteFriendDataMap = mNewInvites;
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mCheckTask);
            YYTaskExecutor.postToMainThread((Runnable)this.mCheckTask);
            this.setValue(Kvo_friends, result);
            this.setValue(Kvo_hasOnlineCanInviteFriends, hasOnlineCanInvite);
        }

        private boolean isInviteStateValid(long ts) {
            return System.currentTimeMillis() - ts < 30000L;
        }

        private void clear() {
            this.inviteFriendDataMap.clear();
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mCheckTask);
        }
    }
}

