/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.module;

import android.content.Context;
import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.gson.annotations.SerializedName;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.DataStatus;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.TeamGameMatchMsgsConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoFieldAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.list.KvoList;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.game.R;
import com.yy.game.gamemodule.teamgame.teammatch.interfaces.IBarrageOnDataResp;
import com.yy.game.gamemodule.teamgame.teammatch.services.IGameBarrageListener;
import com.yy.game.gamemodule.teamgame.teammatch.services.ITeamGameBarrageService;
import com.yy.hiyo.game.base.BarrageInfo;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoNotify;
import common.Header;
import ikxd.through.KxdThrough;
import ikxd.through.SendMessageNotify;
import ikxd.through.SendMessageReq;
import ikxd.through.ThroughType;
import ikxd.through.Uri;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import okio.ByteString;

public class TeamGameBarrageController
implements ITeamGameBarrageService,
IBarrageOnDataResp {
    private static final String TAG = "TeamGameBarrageController";
    private List<WeakReference<IGameBarrageListener>> mListener = new ArrayList<WeakReference<IGameBarrageListener>>();
    private DefaultBarrages mDefBarrages = new DefaultBarrages();
    private BarrageData mReceiveBarrages = new BarrageData();
    private volatile boolean hasRegisterNotify = false;
    private String mGameId;
    private long mLastSendTs;
    private ProtoNotify mNotify = new ProtoNotify(){

        @Override
        void onReceiveNotify(String teamId, BarrageInfo info) {
            TeamGameBarrageController.this.notifyOnReceiveBarrage(info);
        }
    };

    public TeamGameBarrageController() {
        this.registerNotifyLocal();
    }

    @Override
    public void setGameId(String gameId) {
        this.mGameId = gameId;
        if (!TextUtils.isEmpty((CharSequence)gameId)) {
            this.mDefBarrages.loadData(this.mGameId);
        }
    }

    @Override
    public void sendBarrage(final String teamId, final BarrageInfo danmuInfo) {
        if (danmuInfo == null || TextUtils.isEmpty((CharSequence)teamId)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)("danmu params is not valid,teamId:" + teamId + " danmu:" + danmuInfo), (Object[])new Object[0]);
            }
            return;
        }
        long ts = SystemClock.elapsedRealtime();
        if (ts - this.mLastSendTs < 2000L) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.barrage_send_too_fast), (int)0);
            return;
        }
        this.mLastSendTs = SystemClock.elapsedRealtime();
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                SendMessageReq req = new SendMessageReq.Builder().type(ThroughType.ThroughTypeBroadcast).data_type(Long.valueOf(3L)).data(ByteString.encodeUtf8((String)danmuInfo.toJson())).broadcast_id(teamId).build();
                Header header = ProtoManager.getInstance().getHeader("ikxd_through_d");
                KxdThrough kxdThrough = new KxdThrough.Builder().header(header).uri(Uri.kUriSendMessageReq).send_message_req(req).build();
                ProtoManager.getInstance().send((AndroidMessage)kxdThrough, null);
                TeamGameBarrageController.this.notifyOnReceiveBarrage(danmuInfo);
            }
        });
    }

    @Override
    public synchronized void registerBarrageNotify(IGameBarrageListener gameBarrageListener) {
        if (gameBarrageListener != null) {
            Iterator<WeakReference<IGameBarrageListener>> iterator = this.mListener.iterator();
            while (iterator.hasNext()) {
                WeakReference<IGameBarrageListener> ref = iterator.next();
                if (ref == null || ref.get() == null) {
                    iterator.remove();
                    continue;
                }
                if (ref.get() != gameBarrageListener) continue;
                return;
            }
            this.mListener.add(new WeakReference<IGameBarrageListener>(gameBarrageListener));
        }
    }

    @Override
    public synchronized void unRegisterBarrageNotify(IGameBarrageListener gameBarrageListener) {
        if (gameBarrageListener != null) {
            Iterator<WeakReference<IGameBarrageListener>> iterator = this.mListener.iterator();
            while (iterator.hasNext()) {
                WeakReference<IGameBarrageListener> ref = iterator.next();
                if (ref == null || ref.get() == null) {
                    iterator.remove();
                    continue;
                }
                if (ref.get() != gameBarrageListener) continue;
                iterator.remove();
                return;
            }
        }
    }

    @Override
    public DefaultBarrages getDefaultBarrages() {
        if (!TextUtils.isEmpty((CharSequence)this.mGameId)) {
            this.mDefBarrages.loadData(this.mGameId);
        }
        return this.mDefBarrages;
    }

    @Override
    public BarrageData getReceiveBarrages() {
        return this.mReceiveBarrages;
    }

    @Override
    public void onRelase() {
        ProtoManager.getInstance().unregisterNotify((IProtoNotify)this.mNotify);
    }

    private synchronized void registerNotifyLocal() {
        if (this.hasRegisterNotify) {
            return;
        }
        this.hasRegisterNotify = true;
        ProtoManager.getInstance().registerNotify((IProtoNotify)this.mNotify);
    }

    private synchronized void notifyOnReceiveBarrage(final BarrageInfo danmuInfo) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ((TeamGameBarrageController)TeamGameBarrageController.this).mReceiveBarrages.barrages.add((Object)danmuInfo);
                if (!TeamGameBarrageController.this.mListener.isEmpty()) {
                    Iterator iterator = TeamGameBarrageController.this.mListener.iterator();
                    while (iterator.hasNext()) {
                        WeakReference ref = (WeakReference)iterator.next();
                        if (ref == null || ref.get() == null) {
                            iterator.remove();
                            continue;
                        }
                        IGameBarrageListener listen = (IGameBarrageListener)ref.get();
                        if (listen == null) continue;
                        ArrayList<BarrageInfo> list = new ArrayList<BarrageInfo>();
                        list.add(danmuInfo);
                        listen.onReceiveBarrage(list);
                    }
                }
            }
        });
    }

    @Override
    public void onBarrageResponse(DefaultBarrageRet config) {
    }

    public static final class BarrageData
    extends KvoSource {
        public static final String Kvo_barrages = "barrages";
        @KvoFieldAnnotation(name="barrages")
        public final KvoList<BarrageInfo> barrages = new KvoList((KvoSource)this, "barrages");
    }

    public static final class DefaultBarrageRet {
        @SerializedName(value="gid")
        public String gid;
        @SerializedName(value="msgs")
        public List<String> msgs;
    }

    public static final class DefaultBarrages
    extends KvoSource {
        public static final String Kvo_defBarrages = "mDefBarrages";
        @KvoFieldAnnotation(name="mDefBarrages")
        public final List<String> mDefBarrages = new ArrayList<String>();
        public final DataStatus mBarrageState = new DataStatus();

        public void loadData(String gameid) {
            AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.TEAM_GAME_MATCH_MSGS);
            if (configData instanceof TeamGameMatchMsgsConfig) {
                TeamGameMatchMsgsConfig.TeamMatchMsgs msgs = ((TeamGameMatchMsgsConfig)configData).getTeamMsgs(gameid, true);
                if (msgs != null) {
                    this.setValue(Kvo_defBarrages, msgs.getMsgs());
                    this.mBarrageState.success();
                } else {
                    this.mBarrageState.fail();
                }
            } else {
                this.mBarrageState.fail();
            }
        }
    }

    private static abstract class ProtoNotify
    implements IProtoNotify<KxdThrough> {
        private ProtoNotify() {
        }

        public String serviceName() {
            return "ikxd_through_d";
        }

        public void onNotify(final @NonNull KxdThrough kxdThrough) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        SendMessageNotify notify = kxdThrough.send_message_notify;
                        ThroughType sendType = notify.type;
                        long dataType = notify.data_type;
                        if (kxdThrough.uri != Uri.kUriSendMessageNotify) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)TeamGameBarrageController.TAG, (String)("uri not match:" + kxdThrough.uri), (Object[])new Object[0]);
                            }
                            return;
                        }
                        if (sendType != ThroughType.ThroughTypeBroadcast) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)TeamGameBarrageController.TAG, (String)("send type not match:" + sendType), (Object[])new Object[0]);
                            }
                            return;
                        }
                        if (dataType != 3L) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)TeamGameBarrageController.TAG, (String)("dataType not match:" + dataType), (Object[])new Object[0]);
                            }
                            return;
                        }
                        String data = notify.data.utf8();
                        BarrageInfo info = (BarrageInfo)JsonParser.parseJsonObject((String)data, BarrageInfo.class);
                        if (info != null) {
                            if (info.user != null && info.user.uid != AccountUtil.getUid()) {
                                this.onReceiveNotify(notify.broadcast_id, info);
                            }
                        } else if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)TeamGameBarrageController.TAG, (String)"parse danmu info null", (Object[])new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        MLog.error((Object)TeamGameBarrageController.TAG, (String)("parse broadcast err:" + e.getMessage()), (Object[])new Object[0]);
                    }
                }
            });
        }

        abstract void onReceiveNotify(String var1, BarrageInfo var2);
    }
}

