/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.module;

import android.content.Context;
import android.text.TextUtils;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.appbase.util.RepeatClickUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.game.R;
import com.yy.game.bean.GamePlayCountBean;
import com.yy.game.bean.MultiModePlayBean;
import com.yy.game.gamemodule.GameLoger;
import com.yy.game.gamemodule.teamgame.modecenter.model.ModeCenterAction;
import com.yy.game.gamemodule.teamgame.teammatch.interfaces.ITeamMatchCallback;
import com.yy.game.gamemodule.teamgame.teammatch.model.TeamInfo;
import com.yy.game.gamemodule.teamgame.teammatch.module.TeamGameBarrageController;
import com.yy.game.gamemodule.teamgame.teammatch.module.TeamInviteServicesController;
import com.yy.game.gamemodule.teamgame.teammatch.module.TeamMatchWindowController;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamGetInfoListener;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamJoinListener;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamPlayAgainListener;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamTempletehangeCallback;
import com.yy.game.gamemodule.teamgame.teammatch.services.IRoomCreateCallback;
import com.yy.game.gamemodule.teamgame.teammatch.services.ITeamChangeListener;
import com.yy.game.gamemodule.teamgame.teammatch.services.ITeamServiceManager;
import com.yy.game.gamemodule.teamgame.teammatch.ui.popview.ModeChangeListPopView;
import com.yy.game.utils.GameReportHelper;
import com.yy.game.utils.GameStateDef;
import com.yy.hiyo.game.base.GameModel;
import com.yy.hiyo.game.base.TeamUserInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.gamemode.GameModeInfo;
import com.yy.hiyo.game.base.gamemode.MultiModeInfo;
import com.yy.hiyo.game.base.teamgame.InviteFriendData;
import com.yy.hiyo.game.base.teamgame.utils.GameModeSP;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameInviteService;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GameTeamMatchContext;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.List;

public class MultiModeMatchWindowController
extends TeamMatchWindowController
implements ITeamChangeListener {
    private static final String TAG = "MultiModeMatchWindowController";
    private static final int SWITCH_MODE_LIMIT = 3000;
    int mMultiMode = -1;
    private boolean mIsHomeOwner = false;
    private ModeCenterAction mModeCenterAction;

    public MultiModeMatchWindowController(Environment env, ITeamServiceManager mTeamService, ITeamMatchCallback teamLifeCycleCallback) {
        super(env, mTeamService, teamLifeCycleCallback);
    }

    @Override
    public boolean initWindow(GameTeamMatchContext teamMatchContext) {
        if (teamMatchContext.getMultiModeCode() < 0) {
            return false;
        }
        if (teamMatchContext.getExt() != null && teamMatchContext.getExt() instanceof ModeCenterAction) {
            this.mModeCenterAction = (ModeCenterAction)teamMatchContext.getExt();
        }
        this.mMultiMode = teamMatchContext.getMultiModeCode();
        return super.initWindow(teamMatchContext);
    }

    @Override
    public void initTeam(GameTeamMatchContext teamMatchContext) {
        if (StringUtils.isEmpty((String)this.mTeamId)) {
            if (teamMatchContext.getFrom() == GameContextDef.JoinFrom.FROM_PLAY_AGAIN) {
                this.playAgain(teamMatchContext.getRoomId(), teamMatchContext.getMultiModeCode(), teamMatchContext.getSeatNumber());
            } else {
                this.createRoom(this.mTeamServiceManager.getGameDataProvider().getGameInfo(), this.mUserInfo, this.mMultiMode);
            }
        } else {
            this.joinRoom(this.mTeamId, teamMatchContext.getInviteUid(), teamMatchContext.getMultiModeCode());
        }
    }

    public void playAgain(String roomId, int multiMode, int seatNumber) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"playAgain\uff0croomId=%s,seatNumber=%d,multiMode=%d", (Object[])new Object[]{roomId, seatNumber, multiMode});
        }
        if (this.mTeamServiceManager == null || this.mTeamServiceManager.getGameDataProvider() == null || this.mTeamServiceManager.getGameDataProvider().getGameInfo() == null || this.mTeamServiceManager.getTeamRoomService() == null) {
            return;
        }
        GameInfo gameInfo = this.mTeamServiceManager.getGameDataProvider().getGameInfo();
        this.mTeamServiceManager.getTeamRoomService().playAgain(gameInfo, multiMode, this.mUserInfo, roomId, seatNumber, new ITeamPlayAgainListener(){

            @Override
            public void onPlayAgainSuccess(String gameId, int gameTemplate, String roomId, String teamId) {
                MultiModeMatchWindowController.this.onPlayAgainSuccessInner(gameId, gameTemplate, roomId, teamId, MultiModeMatchWindowController.this.mGameInfo);
            }

            @Override
            public void onPlayAgainFailed(String gameId, String roomId, long code) {
                MultiModeMatchWindowController.this.onPlayAgainFailedInner(gameId, roomId, code);
            }
        });
    }

    public void joinRoom(String teamId, long inviteUid, int multiMode) {
        if (this.mTeamServiceManager == null || this.mTeamServiceManager.getGameDataProvider() == null || this.mTeamServiceManager.getGameDataProvider().getGameInfo() == null || this.mTeamServiceManager.getTeamRoomService() == null) {
            return;
        }
        GameInfo gameInfo = this.mTeamServiceManager.getGameDataProvider().getGameInfo();
        this.mTeamServiceManager.getTeamRoomService().joinTeam(gameInfo, multiMode, teamId, this.mUserInfo, inviteUid, new ITeamJoinListener(){

            @Override
            public void onJoinTeamSuccess(TeamInfo teamInfo) {
                GameInfo gameInfo = ((IGameInfoService)MultiModeMatchWindowController.this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(teamInfo.getGameId());
                MultiModeMatchWindowController.this.onJoinTeamSuccessInner(teamInfo, gameInfo);
            }

            @Override
            public void onJoinTeamFailed(String teamId, String gameId, long inviteUid, long code, int teamTemplate) {
                MultiModeMatchWindowController.this.onJoinTeamFailedInner(teamId, gameId, inviteUid, code, teamTemplate);
            }
        });
    }

    public void changeTeamTemplete(String teamId, GameModeInfo targetMode) {
        if (targetMode == null) {
            return;
        }
        if (this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamRoomService() != null) {
            this.showLoadingDialog();
            this.mTeamServiceManager.getTeamRoomService().changeTeamTemplete(teamId, targetMode.getId(), new ITeamTempletehangeCallback(){

                @Override
                public void onTeamChangeSuccess(String teamId) {
                    MultiModeMatchWindowController.this.dismissDialog();
                }

                @Override
                public void onTeamChangeFail(String teamId, long code) {
                    MultiModeMatchWindowController.this.dismissDialog();
                    if (StringUtils.equal((String)teamId, (String)MultiModeMatchWindowController.this.mTeamId) && code == 2012L) {
                        MLog.error((Object)"teamGame", (String)"\u7ec4\u961f\u6539\u53d8\u5931\u8d25\uff0c\u4e0d\u652f\u6301", (Object[])new Object[0]);
                        MultiModeMatchWindowController.this.handleGameNotSupportChangeError();
                    }
                }
            });
        }
    }

    public void handleGameNotSupportChangeError() {
        String msg = ResourceUtils.getString((int)R.string.short_tips_mode_not_support);
        TopToastUtils.showErrorToast((CharSequence)msg, (int)0);
    }

    @Override
    public void onWindowAttach(AbstractWindow abstractWindow) {
        super.onWindowAttach(abstractWindow);
        if (this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamRoomService() != null) {
            this.mTeamServiceManager.getTeamRoomService().registerTeamChangeListener(this);
        }
    }

    @Override
    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamRoomService() != null) {
            this.mTeamServiceManager.getTeamRoomService().registerTeamChangeListener(this);
        }
    }

    @Override
    public void updatePlayCount() {
        if (this.mTeamServiceManager.getGameDataProvider() != null && this.mTeamServiceManager.getGameDataProvider().getGameInfo() != null) {
            this.mTeamServiceManager.getGameDataProvider().updataModeWinData(this.mTeamServiceManager.getGameDataProvider().getGameInfo().gid, this.mMultiMode);
        }
    }

    @Override
    public void onUpdateGameInfo() {
        GameInfo gameInfo = this.mTeamServiceManager.getGameDataProvider().getGameInfo();
        if (this.mTeamMatchWindow == null || gameInfo == null) {
            return;
        }
        GameModeInfo gameModeInfo = this.mTeamServiceManager.getGameDataProvider().getCurrentMode();
        if (gameModeInfo != null) {
            this.playerCount = gameModeInfo.getPlayerCount();
            this.mTeamMatchWindow.setGameInfo(gameInfo.getGname(), gameModeInfo.getName(), gameModeInfo.getPlayerCount());
            this.updateSeatView(this.mSeatUserList);
        }
        String bgUrl = this.mTeamServiceManager.getGameDataProvider().getTeamGameBG(gameInfo.gid);
        boolean isNinePng = this.mTeamServiceManager.getGameDataProvider().isTeamGameBGNinePatch(gameInfo.gid);
        this.mTeamMatchWindow.setGameBackgroundImage(bgUrl, isNinePng, this.mTeamServiceManager.getGameDataProvider().getTeamGameDefaultBG());
    }

    private synchronized void createRoom(GameInfo gameInfo, UserInfoKS userInfo, final int multiMode) {
        if (gameInfo == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"createRoom:gameinfo = null", (Object[])new Object[0]);
            }
            return;
        }
        if (userInfo == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"createRoom:userInfo = null", (Object[])new Object[0]);
            }
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"createRoom:gameinfo = %s,userinfo = %s", (Object[])new Object[]{gameInfo.toString(), userInfo.toString()});
        }
        if (null == this.mTeamServiceManager || this.mTeamServiceManager.getTeamRoomService() == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"createRoom teamRoomService = null", (Object[])new Object[0]);
            }
            return;
        }
        this.mTeamServiceManager.getTeamRoomService().createRoom(gameInfo, multiMode, this.isGoldGame, userInfo, new IRoomCreateCallback(){

            @Override
            public void onRoomCreateSuccess(String teamId) {
                MultiModeMatchWindowController.this.onRoomCreateSuccessInner(teamId, multiMode);
                MultiModeMatchWindowController.this.handleModeCenterAction();
            }

            @Override
            public void onRoomCreateFail(long code) {
                MultiModeMatchWindowController.this.onRoomCreateFailInner(code);
            }
        });
    }

    @Override
    public void onModeSelectClicked() {
        if (this.mTeamMatchWindow != null) {
            this.mTeamMatchWindow.hideModeSelectTips();
        }
        if (this.mTeamServiceManager == null || this.mTeamServiceManager.getTeamRoomService() == null || this.mTeamServiceManager.getTeamRoomService().getTeamInfo(this.mTeamId) == null) {
            return;
        }
        if (!this.mIsHomeOwner) {
            return;
        }
        int status = this.mTeamServiceManager.getTeamRoomService().getTeamInfo(this.mTeamId).getStatus();
        if (status != 1 && status != 4) {
            return;
        }
        GameInfo gameInfo = this.mTeamServiceManager.getGameDataProvider().getGameInfo();
        if (gameInfo == null) {
            return;
        }
        MultiModeInfo multiModeInfo = gameInfo.getMultiModeInfo();
        if (multiModeInfo == null) {
            return;
        }
        final GameModeInfo currentMode = this.mTeamServiceManager.getGameDataProvider().getCurrentMode();
        ModeChangeListPopView modeChangeListPopView = new ModeChangeListPopView((Context)this.mContext);
        modeChangeListPopView.setData(multiModeInfo.getModeList(), this.mSeatUserList.size());
        modeChangeListPopView.setModeSelectListener(new ModeChangeListPopView.OnModeSelectListener(){

            @Override
            public void onModeSelect(GameModeInfo modeInfo) {
                if (modeInfo == null) {
                    return;
                }
                if (MultiModeMatchWindowController.this.mTeamMatchWindow == null) {
                    return;
                }
                if (currentMode != null && currentMode.getId() == modeInfo.getId()) {
                    return;
                }
                if (modeInfo.getStatus() == 1) {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.game_maintening), (int)0);
                    return;
                }
                if (modeInfo.getStatus() == 2) {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_game_full), (int)0);
                    return;
                }
                if (!RepeatClickUtils.canRepeatClick((String)"switch_mode_limit_key", (long)3000L)) {
                    ToastUtils.showToast((Context)MultiModeMatchWindowController.this.mContext, (String)ResourceUtils.getString((int)R.string.short_tips_change_mode_too_frequently), (int)0);
                    return;
                }
                if (MultiModeMatchWindowController.this.mSeatUserList.size() > modeInfo.getPlayerCount()) {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.short_tips_switch_mode_too_many_member), (int)0);
                    return;
                }
                MultiModeMatchWindowController.this.changeTeamTemplete(MultiModeMatchWindowController.this.mTeamId, modeInfo);
            }
        });
        modeChangeListPopView.show((AbstractWindow)this.mTeamMatchWindow);
    }

    synchronized void onModeChange(int newMode) {
        if (!this.isTeamServiceValid()) {
            return;
        }
        this.getTeamService().getGameDataProvider().setCurrentModeId(newMode);
        this.getTeamService().getTeamGameInviteService().onShareDataChange(this.getTeamService().getGameDataProvider().getGameShareData());
        this.mMultiMode = newMode;
        this.onUpdateGameInfo();
        if (this.mTeamServiceManager != null && this.mTeamServiceManager.getGameDataProvider().getGameInfo() != null) {
            String gid = this.mTeamServiceManager.getGameDataProvider().getGameInfo().gid;
            GameModeSP.setGameSelectedMode((String)gid, (int)newMode);
        }
    }

    @Override
    public void inviteTeamGame(String teamId, GameInfo gameInfo, InviteFriendData inviteFriendData) {
        if (!TextUtils.isEmpty((CharSequence)teamId)) {
            this.mTeamServiceManager.getTeamGameInviteService().invite(((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).getGameTeamInviteService(), teamId, gameInfo, inviteFriendData, this.mMultiMode);
        }
    }

    @Override
    public void roomDataBinding(TeamInfo teamInfo) {
        if (teamInfo == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"roomDataBinding teamino =null", (Object[])new Object[0]);
            }
            return;
        }
        this.mBinder.singleBindSourceTo((KvoSource)teamInfo);
        if (this.mTeamServiceManager != null && this.mTeamServiceManager.getGameDataProvider() != null && this.mTeamServiceManager.getGameDataProvider().getGameInfo() != null) {
            this.mBinder.singleBindSourceTo((KvoSource)this.mTeamServiceManager.getGameDataProvider().getModePlayCount(this.mTeamServiceManager.getGameDataProvider().getGameInfo().gid, teamInfo.getTeamTemplate()));
        }
        if (this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamGameBarrageService() != null) {
            TeamGameBarrageController.DefaultBarrages defBarrages = this.mTeamServiceManager.getTeamGameBarrageService().getDefaultBarrages();
            Kvo.removeKvoBinding((KvoSource)defBarrages, (Object)this, (String)"defaultBarragesChange");
            Kvo.addKvoBinding((KvoSource)defBarrages, (Object)this, (String)"defaultBarragesChange");
            TeamGameBarrageController.BarrageData newBarrages = this.mTeamServiceManager.getTeamGameBarrageService().getReceiveBarrages();
            Kvo.removeKvoBinding((KvoSource)newBarrages, (Object)this, (String)"reveiveBarrageMsg");
            Kvo.addKvoBinding((KvoSource)newBarrages, (Object)this, (String)"reveiveBarrageMsg");
        }
    }

    @Override
    public void roomDataUnBinding(String mTeamId) {
        TeamInfo teamInfo;
        if (StringUtils.isNotEmpty((String)mTeamId) && this.mTeamServiceManager.getTeamRoomService() != null && (teamInfo = this.mTeamServiceManager.getTeamRoomService().getTeamInfo(mTeamId)) != null) {
            this.mBinder.clearKvoConnection(TeamInfo.class.getName());
        }
        this.mBinder.clearKvoConnection(GamePlayCountBean.class.getName());
        if (this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamGameBarrageService() != null) {
            TeamGameBarrageController.DefaultBarrages defBarrages = this.mTeamServiceManager.getTeamGameBarrageService().getDefaultBarrages();
            Kvo.removeKvoBinding((KvoSource)defBarrages, (Object)this, (String)"defaultBarragesChange");
            TeamGameBarrageController.BarrageData newBarrages = this.mTeamServiceManager.getTeamGameBarrageService().getReceiveBarrages();
            Kvo.removeKvoBinding((KvoSource)newBarrages, (Object)this, (String)"reveiveBarrageMsg");
        }
    }

    @KvoMethodAnnotation(sourceClass=MultiModePlayBean.class, name="winCount", thread=1)
    public void modeWinCountChange(KvoEventIntent kvoEvent) {
        if (this.mTeamMatchWindow == null) {
            return;
        }
        int winCount = (Integer)kvoEvent.caseNewValue((Object)0);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"win count changed : %d", (Object[])new Object[]{winCount});
        }
        if (this.mTeamMatchWindow != null) {
            this.mTeamMatchWindow.setWinCount(winCount);
        }
    }

    @KvoMethodAnnotation(sourceClass=MultiModePlayBean.class, name="totalCount", thread=1)
    public void modePlayCountChange(KvoEventIntent kvoEvent) {
        if (this.mTeamMatchWindow == null) {
            return;
        }
        int playCount = (Integer)kvoEvent.caseNewValue((Object)0);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"play count changed : %d", (Object[])new Object[]{playCount});
        }
        if (this.mTeamMatchWindow != null) {
            this.mTeamMatchWindow.setPlayCount(playCount);
        }
    }

    @Override
    @KvoMethodAnnotation(name="captainUid", sourceClass=TeamInfo.class, thread=1)
    void homeOwnerChange(KvoEventIntent kvoEvent) {
        boolean isRoomOwner;
        if (this.mTeamMatchWindow == null) {
            return;
        }
        if (kvoEvent.newValue() == null) {
            return;
        }
        long roomOwnerId = (Long)kvoEvent.newValue();
        boolean bl = isRoomOwner = roomOwnerId == AccountUtil.getUid();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"home owner changed %b", (Object[])new Object[]{isRoomOwner});
        }
        if (this.mTeamMatchWindow != null) {
            this.mTeamMatchWindow.setHomeOwner(isRoomOwner);
        }
        this.mIsHomeOwner = isRoomOwner;
        this.checkModeClickStatus();
    }

    @KvoMethodAnnotation(name="teamTemplate", sourceClass=TeamInfo.class, thread=1)
    void onTeamTemplateChange(KvoEventIntent kvoEvent) {
        if (this.mTeamMatchWindow == null) {
            return;
        }
        if (kvoEvent.newValue() == null) {
            return;
        }
        int teamTemplate = (Integer)kvoEvent.newValue();
        GameLoger.info("teamGame", "\u623f\u95f4\u6a21\u5f0f\u5df2\u66f4\u65b0\u4e3a%s", teamTemplate);
    }

    @Override
    @KvoMethodAnnotation(name="teamUserInfoList", sourceClass=TeamInfo.class, thread=1)
    void roomPlayerChange(KvoEventIntent kvoEvent) {
        if (this.mTeamMatchWindow == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"roomPlayerChange but window null", (Object[])new Object[0]);
            }
            return;
        }
        List teamUserInfoList = (List)kvoEvent.newValue();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"team user list changed : %s", (Object[])new Object[]{teamUserInfoList});
        }
        if (teamUserInfoList == null) {
            return;
        }
        if (teamUserInfoList.size() > 0) {
            this.loadUserInfoAndUpdateSeatView(teamUserInfoList);
        }
        this.handlerInviteFriends();
        ArrayList newTeamUserList = new ArrayList();
        newTeamUserList.addAll(teamUserInfoList);
        if (this.mTeamUserList != null && this.mTeamUserList.size() > 0) {
            block0: for (int i = newTeamUserList.size() - 1; i >= 0; --i) {
                TeamUserInfo teamUser = (TeamUserInfo)newTeamUserList.get(i);
                for (TeamUserInfo exisitTeamUser : this.mTeamUserList) {
                    if (teamUser.getUid() != exisitTeamUser.getUid()) continue;
                    newTeamUserList.remove(i);
                    continue block0;
                }
            }
        }
        int num = teamUserInfoList != null ? teamUserInfoList.size() : 0;
        for (TeamUserInfo teamUser : newTeamUserList) {
            HiidoEvent event = this.teamMatchEvnet("new_mumber");
            event.put("mumber_num", "" + num);
            event.put("opponent_uid", "" + teamUser.getUid());
            HiidoStatis.reportEvent((HiidoEvent)event);
        }
        this.mTeamUserList = teamUserInfoList;
    }

    @Override
    @KvoMethodAnnotation(name="status", sourceClass=TeamInfo.class, thread=1)
    void roomStatChange(KvoEventIntent kvoEvent) {
        if (this.mTeamMatchWindow == null) {
            return;
        }
        if (kvoEvent.newValue() == null || kvoEvent.oldValue() == null) {
            return;
        }
        int newStatus = (Integer)kvoEvent.newValue();
        int oldStatus = (Integer)kvoEvent.oldValue();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"room status changed, current = %d, old = %d", (Object[])new Object[]{newStatus, oldStatus});
        }
        if (newStatus == 1) {
            TeamInviteServicesController.InviteFriendContainer inviteFriendContainer;
            this.mTeamMatchWindow.showPageRecord();
            if (oldStatus == 2 && (inviteFriendContainer = this.mTeamServiceManager.getTeamGameInviteService().getInviteFriendContainer()) != null && inviteFriendContainer.hasOnlineCanInviteFriends) {
                this.mTeamMatchWindow.showInviteTips();
            }
            this.updateSeatView(this.mSeatUserList);
        } else if (newStatus == 2) {
            this.mTeamMatchWindow.hideTip();
            this.mTeamMatchWindow.showPageMatching();
            this.updateSeatView(this.mSeatUserList);
            this.recordTeamUserOnSeat();
        } else if (newStatus == 4) {
            TeamInviteServicesController.InviteFriendContainer inviteFriendContainer;
            this.mTeamMatchWindow.showPageTeam();
            if (oldStatus == 5 && (inviteFriendContainer = this.mTeamServiceManager.getTeamGameInviteService().getInviteFriendContainer()) != null && inviteFriendContainer.hasOnlineCanInviteFriends) {
                this.mTeamMatchWindow.showInviteTips();
            }
            this.updateSeatView(this.mSeatUserList);
        } else if (newStatus == 5) {
            this.mTeamMatchWindow.hideTip();
            this.mTeamMatchWindow.showPageMatching();
            this.updateSeatView(this.mSeatUserList);
            this.recordTeamUserOnSeat();
        } else if (newStatus == 6) {
            this.mTeamMatchWindow.showPlayBtn();
        } else if (newStatus == 7) {
            long delayEnterGame;
            if (this.lastRoomStatus == 7) {
                return;
            }
            if (this.lastRoomStatus == 2 || this.lastRoomStatus == 5) {
                delayEnterGame = this.matchSuccessDelay;
                this.onMatchedUserOnMatchSuccess();
            } else {
                delayEnterGame = this.teamSuccessDelay;
                this.mTeamMatchWindow.showMatchSuccess();
            }
            if (this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamRoomService() != null) {
                TeamInfo teamInfo = this.mTeamServiceManager.getTeamRoomService().getTeamInfo(this.mTeamId);
                if (this.mTeamServiceManager != null && this.mTeamServiceManager.getGameDataProvider() != null && this.mTeamServiceManager.getGameDataProvider().getGameInfo() != null && teamInfo != null) {
                    GameModel gameModel = GameModel.newBuilder().gameInfo(this.mTeamServiceManager.getGameDataProvider().getGameInfo()).roomid(teamInfo.getRoomId()).build();
                    GameReportHelper.reportGameInfo(gameModel, (int)(System.currentTimeMillis() - this.mCurrentMatchStart), this.mOpenScene, GameStateDef.GAME_FINISH_REASON.FINISH.value(), 1, teamInfo.isGoldGame());
                }
                if (teamInfo != null) {
                    TeamMatchWindowController.GotoGameRoomRunable gotoGameRoomRunable = new TeamMatchWindowController.GotoGameRoomRunable(teamInfo.getRoomId(), teamInfo.getUrl(), teamInfo.getTeamUserInfoList());
                    YYTaskExecutor.postToMainThread((Runnable)gotoGameRoomRunable, (long)delayEnterGame);
                } else {
                    TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.game_info_get_fail), (int)0);
                    this.closeTeamMatchWindow(true);
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"TeamStatus.SUCCESS,mTeamId=%s,TeamInfo = null", (Object[])new Object[]{this.mTeamId});
                    }
                }
            }
        } else if (newStatus == 8) {
            ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.error_team_invalid), (int)0);
            this.closeTeamMatchWindow(true);
        }
        this.changeKeepScreenOn(5 == newStatus || 2 == newStatus);
        if (newStatus == 2 || newStatus == 5) {
            TeamInfo teamInfo;
            this.mCurrentMatchStart = System.currentTimeMillis();
            HiidoEvent hiidoEvent = this.teamMatchEvnet("match");
            if (this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamRoomService() != null && (teamInfo = this.mTeamServiceManager.getTeamRoomService().getTeamInfo(this.mTeamId)) != null) {
                int size = teamInfo.getTeamUserInfoList() != null ? teamInfo.getTeamUserInfoList().size() : 0;
                hiidoEvent.put("member_num", String.valueOf(size));
                hiidoEvent.put("opponent_uid", this.transformUid2Event(teamInfo).toString());
            }
            HiidoStatis.reportEvent((HiidoEvent)hiidoEvent);
        }
        this.checkModeClickStatus();
        this.lastRoomStatus = newStatus;
    }

    @Override
    @KvoMethodAnnotation(name="canPlay", sourceClass=TeamInfo.class, thread=1)
    void roomCanPlayChange(KvoEventIntent kvoEvent) {
        if (this.mTeamMatchWindow == null) {
            return;
        }
        if (kvoEvent.newValue() == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"roomCanPlayChange=null", (Object[])new Object[0]);
            }
            return;
        }
        boolean canPlay = (Boolean)kvoEvent.newValue();
        if (canPlay) {
            this.mTeamMatchWindow.showPlayBtn();
        } else {
            this.mTeamMatchWindow.showMatchBtn();
        }
    }

    @Override
    @KvoMethodAnnotation(name="mDefBarrages", thread=1, sourceClass=TeamGameBarrageController.DefaultBarrages.class)
    public void defaultBarragesChange(KvoEventIntent event) {
        if (this.mTeamMatchWindow == null) {
            return;
        }
        List barrages = (List)event.newValue();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"update default barrages : %s", (Object[])new Object[]{barrages});
        }
        if (barrages != null) {
            this.mTeamMatchWindow.setDefaultBarrages(barrages);
        }
    }

    @Override
    public void getPlayingTeamInfo() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"getPlayingTeamInfo", (Object[])new Object[0]);
        }
        if (this.mTeamServiceManager == null || this.mTeamServiceManager.getTeamRoomService() == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"\u83b7\u53d6\u6e38\u620f\u623f\u95f4\u4fe1\u606fnull", (Object[])new Object[0]);
            }
            return;
        }
        this.mTeamServiceManager.getTeamRoomService().getPlayingTeam(new ITeamGetInfoListener(){

            @Override
            public void onTeamInfoGetSuccess(TeamInfo teamInfo) {
                if (MultiModeMatchWindowController.this.mTeamMatchWindow == null) {
                    return;
                }
                if (teamInfo == null) {
                    MLog.error((Object)MultiModeMatchWindowController.TAG, (String)"getPlayingTeamInfo teamino=null", (Object[])new Object[0]);
                    return;
                }
                if (MultiModeMatchWindowController.this.mTeamServiceManager != null && MultiModeMatchWindowController.this.mTeamServiceManager.getGameDataProvider() != null && MultiModeMatchWindowController.this.mTeamServiceManager.getGameDataProvider().getGameInfo() != null) {
                    if (!teamInfo.getGameId().equals(MultiModeMatchWindowController.this.mTeamServiceManager.getGameDataProvider().getGameInfo().getGid())) {
                        MultiModeMatchWindowController.this.gotoNewTeam(teamInfo);
                    }
                } else {
                    return;
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)MultiModeMatchWindowController.TAG, (String)"getPlayingTeamInfo teamino=%s", (Object[])new Object[]{teamInfo});
                }
                MultiModeMatchWindowController.this.mTeamId = teamInfo.getTeamId();
                if (MultiModeMatchWindowController.this.mMultiMode != teamInfo.getTeamTemplate()) {
                    MultiModeMatchWindowController.this.onModeChange(teamInfo.getTeamTemplate());
                }
                MultiModeMatchWindowController.this.roomDataBinding(teamInfo);
                if (RuntimeContext.sIsDebuggable) {
                    boolean isGameRandom = SettingFlags.getBoolean((String)"gameautofirstpagerandom", (boolean)false);
                    boolean mEnableAutoTouch = SettingFlags.getBoolean((String)"gameautofirstpage", (boolean)false);
                    boolean isGameAutoOpen = SettingFlags.getBoolean((String)"gameautoopen", (boolean)false);
                    if (mEnableAutoTouch || isGameAutoOpen || isGameRandom) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)"qiantao", (String)"retry game", (Object[])new Object[0]);
                        }
                        MultiModeMatchWindowController.this.autoJoinGameForTest();
                    }
                    return;
                }
            }

            @Override
            public void onTeamInfoGetFailed(long code) {
                if (MultiModeMatchWindowController.this.mTeamMatchWindow == null) {
                    return;
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)MultiModeMatchWindowController.TAG, (String)"onTeamInfoGetFailed teamino=%d", (Object[])new Object[]{code});
                }
                if (code == 10000L) {
                    ToastUtils.showToast((Context)MultiModeMatchWindowController.this.mContext, (String)ResourceUtils.getString((int)R.string.team_info_get_fail), (int)0);
                    MultiModeMatchWindowController.this.closeTeamMatchWindow(true);
                }
            }
        });
    }

    @Override
    protected void checkIfShowGuides() {
        boolean showRuleGuide = this.checkIfShowRuleGuide();
        if (!showRuleGuide) {
            this.checkIfShowModeSelectGuide();
        }
    }

    private boolean checkIfShowModeSelectGuide() {
        boolean needShow = SettingFlags.getBoolean((String)"game_mode_select_guide_show", (boolean)true);
        if (needShow && this.mTeamMatchWindow != null) {
            this.mTeamMatchWindow.showModeSelectTips();
            SettingFlags.setBoolean((String)"game_mode_select_guide_show", (boolean)false);
            return true;
        }
        return false;
    }

    @Override
    public void startMatch(boolean isStart) {
        if (!this.isTeamServiceValid()) {
            return;
        }
        GameInfo gameInfo = this.mTeamServiceManager.getGameDataProvider().getGameInfo();
        if (gameInfo == null) {
            return;
        }
        this.mTeamServiceManager.getTeamRoomService().teamMatchStart(this.mTeamId, gameInfo, this.mMultiMode, isStart, this.isGoldGame);
    }

    private void checkModeClickStatus() {
        if (this.mTeamServiceManager == null || this.mTeamServiceManager.getTeamRoomService() == null) {
            return;
        }
        if (this.mTeamServiceManager.getTeamRoomService().getTeamInfo(this.mTeamId) == null) {
            MLog.error((Object)TAG, (String)"checkModeClickStatus mTeamId = %s mteamInfo = null", (Object[])new Object[]{this.mTeamId});
            return;
        }
        int status = this.mTeamServiceManager.getTeamRoomService().getTeamInfo(this.mTeamId).getStatus();
        boolean clickable = false;
        if ((status == 1 || status == 4) && this.mIsHomeOwner) {
            clickable = true;
        }
        if (this.mTeamMatchWindow != null) {
            this.mTeamMatchWindow.setModeClickable(clickable);
        }
    }

    @Override
    public String getMatchMiddlePageDynamicUrl() {
        return "";
    }

    private void handleModeCenterAction() {
        if (this.mModeCenterAction != null) {
            if (this.mModeCenterAction.getAction() == 2) {
                this.handleInviteFriend(this.mModeCenterAction.getFriendData());
            } else if (this.mModeCenterAction.getAction() == 1) {
                this.handlePlatformShare(this.mModeCenterAction.getPlatform());
            } else if (this.mModeCenterAction.getAction() == 3) {
                this.startMatch(false);
            } else if (this.mModeCenterAction.getAction() == 4) {
                this.handlerInviteChannel(this.mModeCenterAction.getChannelInfo());
            }
            this.mModeCenterAction = null;
        }
    }

    @Override
    protected void handlePlatformShare(int platform) {
        if (this.mTeamMatchWindow != null) {
            this.mTeamMatchWindow.hideInviteTips();
        }
        if (this.mTeamServiceManager != null && this.mTeamServiceManager.getTeamGameInviteService() != null) {
            this.mTeamServiceManager.getTeamGameInviteService().shareTo((Context)this.mContext, platform, this.mTeamServiceManager.getGameDataProvider().getGameInfo(), this.mTeamId, this.mMultiMode);
        }
        HiidoEvent event = this.teamMatchEvnet("share");
        int reportType = 0;
        if (platform == 1) {
            event.put("channel_id", "Facebook");
            reportType = 1;
        } else if (platform == 2) {
            event.put("channel_id", "Line");
            reportType = 2;
        } else if (platform == 4) {
            event.put("channel_id", "Messenger");
            reportType = 7;
        } else if (platform == 3) {
            event.put("channel_id", "Whatsapp");
            reportType = 3;
        } else if (platform == 5) {
            reportType = 6;
        }
        HiidoStatis.reportEvent((HiidoEvent)event);
        if (this.mTeamServiceManager.getGameDataProvider() != null && this.mTeamServiceManager.getGameDataProvider().getGameInfo() != null && this.mTeamServiceManager.getGameDataProvider().getGameInfo().getGid() != null) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023801").put("function_id", "1").put("page_id", "8").put("share_channel", String.valueOf(reportType)).put("gid", this.mTeamServiceManager.getGameDataProvider().getGameInfo().getGid()));
        }
    }

    @Override
    protected void onTeamReadyInner() {
        super.onTeamReadyInner();
        this.checkModeClickStatus();
    }

    @Override
    public void onTeamChanged(TeamInfo teamInfo) {
        if (teamInfo == null) {
            return;
        }
        if (this.mMultiMode != teamInfo.getTeamTemplate()) {
            this.onModeChange(teamInfo.getTeamTemplate());
            GameModeInfo currentMode = this.mTeamServiceManager.getGameDataProvider().getCurrentMode();
            if (!this.mIsHomeOwner && currentMode != null) {
                String msg = ResourceUtils.getString((int)R.string.short_tips_mode_changed, (Object[])new Object[]{currentMode.getName()});
                TopToastUtils.showSucceedToast((CharSequence)msg, (int)0);
            }
        }
    }
}

