/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch.model;

import com.google.gson.annotations.SerializedName;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.base.event.kvo.KvoFieldAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.utils.DontProguardClass;
import com.yy.hiyo.game.base.TeamUserInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.teamgame.TeamModeHelper;
import com.yy.hiyo.game.kvomodule.GameInfoModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@DontProguardClass
public class TeamInfo
extends KvoSource {
    private String teamId;
    private String gameId;
    public static final String kvo_teamTemplate = "teamTemplate";
    @KvoFieldAnnotation(name="teamTemplate")
    private int teamTemplate;
    private String nick;
    private String avatar;
    private int sex;
    private long targetUid;
    private int playerNumber;
    public static final String kvo_teamUserInfoList = "teamUserInfoList";
    @KvoFieldAnnotation(name="teamUserInfoList")
    private List<TeamUserInfo> teamUserInfoList = new CopyOnWriteArrayList<TeamUserInfo>();
    public static final String kvo_status = "status";
    @KvoFieldAnnotation(name="status")
    private int status = 0;
    public static final String kvo_canPlay = "canPlay";
    @KvoFieldAnnotation(name="canPlay")
    private boolean canPlay = false;
    private String roomId;
    private String url;
    public static final String kvo_captainUid = "captainUid";
    @KvoFieldAnnotation(name="captainUid")
    @SerializedName(value="CaptainUid")
    private long captainUid;
    private boolean multiMode = false;
    private boolean isGoldGame = false;

    public void setTeamUserInfoList(List<TeamUserInfo> userInfoList) {
        if (userInfoList != null) {
            Collections.sort(userInfoList);
        }
        this.setValue(kvo_teamUserInfoList, new CopyOnWriteArrayList<TeamUserInfo>(userInfoList));
    }

    public void setGameId(String gameId) {
        GameInfo gameInfo = ((GameInfoModule)KvoModuleManager.getModule(GameInfoModule.class)).getGame(gameId);
        if (gameInfo != null) {
            this.multiMode = TeamModeHelper.isMultiMode((GameInfo)gameInfo);
        }
        this.gameId = gameId;
    }

    public int getTeamTemplate() {
        return this.teamTemplate;
    }

    public void setTeamTemplate(int teamTemplate) {
        this.setValue(kvo_teamTemplate, teamTemplate);
    }

    public void setNick(String nick) {
        this.nick = nick;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public void setSex(int sex) {
        this.sex = sex;
    }

    public void setTargetUid(long targetUid) {
        this.targetUid = targetUid;
    }

    public void setPlayerNumber(int playerNumber) {
        this.playerNumber = playerNumber;
    }

    public String getTeamId() {
        return this.teamId;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public void setStatus(int status) {
        if (this.multiMode) {
            if (status == 1) {
                status = 4;
            } else if (status == 2) {
                status = 5;
            } else if (status == 3) {
                status = 8;
            }
        }
        this.setValue(kvo_status, status);
    }

    public void setCanPlay(boolean canPlay) {
        this.setValue(kvo_canPlay, canPlay);
    }

    public String getRoomId() {
        return this.roomId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<TeamUserInfo> getTeamUserInfoList() {
        return this.teamUserInfoList;
    }

    public void removeTeamUserInfo(TeamUserInfo teamUserInfo) {
        if (this.teamUserInfoList != null && teamUserInfo != null) {
            this.teamUserInfoList.remove(teamUserInfo);
            ArrayList<TeamUserInfo> userInfoList = new ArrayList<TeamUserInfo>();
            userInfoList.addAll(this.teamUserInfoList);
            this.setTeamUserInfoList(userInfoList);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getGameId() {
        return this.gameId;
    }

    public String getNick() {
        return this.nick;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public int getSex() {
        return this.sex;
    }

    public long getTargetUid() {
        return this.targetUid;
    }

    public int getStatus() {
        return this.status;
    }

    public void setCaptainUid(long captainUid) {
        this.setValue(kvo_captainUid, captainUid);
    }

    public boolean isGoldGame() {
        return this.isGoldGame;
    }

    public void setGoldGame(boolean goldGame) {
        this.isGoldGame = goldGame;
    }

    public String toString() {
        return "TeamInfo{teamId='" + this.teamId + '\'' + ", gameId='" + this.gameId + '\'' + ", teamTemplate=" + this.teamTemplate + ", nick='" + this.nick + '\'' + ", avatar='" + this.avatar + '\'' + ", sex=" + this.sex + ", targetUid=" + this.targetUid + ", playerNumber=" + this.playerNumber + ", teamUserInfoList=" + this.teamUserInfoList + ", status=" + this.status + ", canPlay=" + this.canPlay + ", roomId='" + this.roomId + '\'' + ", url='" + this.url + '\'' + ", captainUid=" + this.captainUid + ", multiMode=" + this.multiMode + ", isGoldGame=" + this.isGoldGame + '}';
    }

    public static class TeamStatus {
        public static final int NONE = 0;
        public static final int SINGLE_WAIT = 1;
        public static final int SINGLE_MATCHING = 2;
        public static final int SINGLE_READY = 3;
        public static final int TEAM_WAIT = 4;
        public static final int TEAM_MATCHING = 5;
        public static final int TEAM_READY = 6;
        public static final int SUCCESS = 7;
        public static final int TEAM_DESTROY = 8;
    }
}

