/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.teammatch;

import android.content.Context;
import android.os.Message;
import androidx.annotation.NonNull;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.game.R;
import com.yy.game.gamemodule.GameLoger;
import com.yy.game.gamemodule.base.NormalTeamMatcher;
import com.yy.game.gamemodule.teamgame.modecenter.IModeCenterCallback;
import com.yy.game.gamemodule.teamgame.modecenter.ModeCenterContext;
import com.yy.game.gamemodule.teamgame.modecenter.ModeCenterController;
import com.yy.game.gamemodule.teamgame.modecenter.model.ModeCenterAction;
import com.yy.game.gamemodule.teamgame.teammatch.interfaces.ITeamMatchCallback;
import com.yy.game.gamemodule.teamgame.teammatch.module.AbsTeamMatchController;
import com.yy.game.gamemodule.teamgame.teammatch.module.MultiModeMatchWindowController;
import com.yy.game.gamemodule.teamgame.teammatch.module.TeamMatchWindowController;
import com.yy.game.gamemodule.teamgame.teammatch.protocol.callback.ITeamGetGameInfoListener;
import com.yy.game.gamemodule.teamgame.teammatch.provider.MultiModeMatchController;
import com.yy.game.gamemodule.teamgame.teammatch.provider.NormolMatchController;
import com.yy.game.gamemodule.teamgame.teammatch.services.IGameDataProvider;
import com.yy.game.gamemodule.teamgame.teammatch.ui.AbsTeamMatchWindow;
import com.yy.hiyo.game.base.TeamUserInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.gamemode.GameModeInfo;
import com.yy.hiyo.game.base.teamgame.TeamModeHelper;
import com.yy.hiyo.game.base.teamgame.utils.GameModeSP;
import com.yy.hiyo.game.service.IGameInviteService;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GameTeamMatchContext;
import com.yy.hiyo.game.service.protocol.ITeamMatchLifecycle;
import java.util.List;

public class TeamGameMatchController
extends NormalTeamMatcher {
    private static final String TAG = "TeamGameMatchController";
    private AbsTeamMatchController mTeamMatchController;
    private TeamMatchWindowController mTeamMatchWindowController;
    private ModeCenterController mModeCenter;
    private ITeamMatchCallback teamMatchCallback = new ITeamMatchCallback(){

        @Override
        public void onTeamReady(String teamId) {
            TeamGameMatchController.this.handleTeamReady(teamId);
        }

        @Override
        public void onTeamMatchSuccess(String teamId, String gameId, String roomId, String url, List<TeamUserInfo> teamList) {
            if (TeamGameMatchController.this.mTeamMatchController != null && TeamGameMatchController.this.mTeamMatchController.getTeamServiceManager() != null && TeamGameMatchController.this.mTeamMatchController.getTeamServiceManager().getGameDataProvider() != null) {
                int modeId = 0;
                if (TeamModeHelper.isMultiMode((GameInfo)TeamGameMatchController.this.teamMatchContext.getGameInfo())) {
                    GameModeInfo currentMode = TeamGameMatchController.this.mTeamMatchController.getTeamServiceManager().getGameDataProvider().getCurrentMode();
                    if (currentMode != null) {
                        modeId = currentMode.getId();
                    }
                } else {
                    GameInfo gameInfo = TeamGameMatchController.this.teamMatchContext.getGameInfo();
                    if (gameInfo != null) {
                        modeId = gameInfo.getTeamTemplate();
                    }
                }
                TeamGameMatchController.this.handleMatchFinish(teamId, gameId, modeId, roomId, url, teamList);
            }
            if (TeamGameMatchController.this.mModeCenter != null) {
                TeamGameMatchController.this.mModeCenter.closeModeCenter();
                TeamGameMatchController.this.mModeCenter = null;
            }
        }

        @Override
        public void onTeamMatchDestroy(int teamMatchState) {
            if (TeamGameMatchController.this.mModeCenter == null) {
                if (teamMatchState == 7) {
                    TeamGameMatchController.this.releaseTeamMatchController(false);
                } else {
                    TeamGameMatchController.this.releaseTeamMatchController();
                }
            }
        }
    };
    private IModeCenterCallback mModeCenterCallback = new IModeCenterCallback(){

        @Override
        public void onModeSelected(GameModeInfo modeInfo) {
            if (TeamGameMatchController.this.getCurrentWindow() instanceof AbsTeamMatchWindow) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamGameMatchController.TAG, (String)"\u91cd\u590d\u4ece\u6a21\u5f0f\u9009\u62e9\u9875\u8fdb\u5165\u7ec4\u961f\u9875", (Object[])new Object[0]);
                }
                return;
            }
            if (TeamGameMatchController.this.mTeamMatchController == null || TeamGameMatchController.this.mTeamMatchController.getTeamServiceManager() == null || TeamGameMatchController.this.mTeamMatchController.getTeamServiceManager().getGameDataProvider() == null || TeamGameMatchController.this.mTeamMatchController.getTeamServiceManager().getTeamGameInviteService() == null) {
                return;
            }
            TeamGameMatchController.this.teamMatchContext.setTeamId(null);
            TeamGameMatchController.this.teamMatchContext.setMultiModeCode(modeInfo.getId());
            TeamGameMatchController.this.teamMatchContext.setWithAnim(false);
            ModeCenterAction modeCenterAction = new ModeCenterAction(3);
            TeamGameMatchController.this.teamMatchContext.setExt((Object)modeCenterAction);
            IGameDataProvider modeGameDataProvider = TeamGameMatchController.this.mTeamMatchController.getTeamServiceManager().getGameDataProvider();
            modeGameDataProvider.setCurrentModeId(modeInfo.getId());
            TeamGameMatchController.this.mTeamMatchController.getTeamServiceManager().getTeamGameInviteService().onShareDataChange(modeGameDataProvider.getGameShareData());
            TeamGameMatchController.this.openTeamMatchWindow();
            GameInfo gameInfo = TeamGameMatchController.this.teamMatchContext.getGameInfo();
            GameModeSP.setGameSelectedMode((String)gameInfo.getGid(), (int)modeInfo.getId());
        }

        @Override
        public void onInviteAction(ModeCenterAction action) {
            if (action == null) {
                return;
            }
            if (TeamGameMatchController.this.getCurrentWindow() instanceof AbsTeamMatchWindow) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamGameMatchController.TAG, (String)"\u91cd\u590d\u4ece\u6a21\u5f0f\u9009\u62e9\u9875\u8fdb\u5165\u7ec4\u961f\u9875", (Object[])new Object[0]);
                }
                return;
            }
            int lastSelectedMode = GameModeSP.getGameSelectedMode((String)TeamGameMatchController.this.teamMatchContext.getGameInfo().getGid());
            GameModeInfo modeInfo = TeamGameMatchController.this.teamMatchContext.getGameInfo().getMultiModeInfo().findAvailModeById(lastSelectedMode);
            if (modeInfo == null) {
                return;
            }
            TeamGameMatchController.this.teamMatchContext.setTeamId(null);
            TeamGameMatchController.this.teamMatchContext.setMultiModeCode(modeInfo.getId());
            TeamGameMatchController.this.teamMatchContext.setExt((Object)action);
            TeamGameMatchController.this.teamMatchContext.setWithAnim(false);
            TeamGameMatchController.this.mTeamMatchController.getTeamServiceManager().getGameDataProvider().setCurrentModeId(lastSelectedMode);
            IGameDataProvider modeGameDataProvider = TeamGameMatchController.this.mTeamMatchController.getTeamServiceManager().getGameDataProvider();
            TeamGameMatchController.this.mTeamMatchController.getTeamServiceManager().getTeamGameInviteService().onShareDataChange(modeGameDataProvider.getGameShareData());
            TeamGameMatchController.this.openTeamMatchWindow();
        }

        @Override
        public void onModeCenterBackExit() {
            if (TeamGameMatchController.this.mModeCenter != null) {
                TeamGameMatchController.this.mModeCenter.closeModeCenter();
                TeamGameMatchController.this.mModeCenter = null;
            }
            TeamGameMatchController.this.releaseTeamMatchController();
        }

        @Override
        public void onModeCenterDestroy() {
        }
    };
    private TeamMatchControllerFactory mTeamMatchControllerFactory;

    public TeamGameMatchController(Environment env, ITeamMatchLifecycle teamMatchLifecycleCallback) {
        super(env, teamMatchLifecycleCallback);
    }

    private void initTeamMatchController() {
        GameInfo gameInfo = this.teamMatchContext.getGameInfo();
        this.mTeamMatchController = this.getTeamMatchControllerFactory().getTeamMatchController(gameInfo, this.teamMatchCallback);
        this.mTeamMatchController.init(this.teamMatchContext);
        this.mTeamMatchController.getTeamServiceManager().getTeamGameInviteService().onEnterRoom();
    }

    private void openTeamMatchWindow() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"openTeamMatchWindow", (Object[])new Object[0]);
        }
        if (this.getCurrentWindow() instanceof AbsTeamMatchWindow) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"\u91cd\u590d\u8fdb\u5165\u7ec4\u961f\u9875\u9762", (Object[])new Object[0]);
            }
            return;
        }
        if (this.teamMatchContext.getGameInfo() == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"onTeamMatchShowEvent game info=null", (Object[])new Object[0]);
            }
            this.releaseTeamMatchController();
            return;
        }
        this.mTeamMatchWindowController = TeamModeHelper.isMultiMode((GameInfo)this.teamMatchContext.getGameInfo()) ? new MultiModeMatchWindowController(this.getEnvironment(), this.mTeamMatchController.getTeamServiceManager(), this.teamMatchCallback) : new TeamMatchWindowController(this.getEnvironment(), this.mTeamMatchController.getTeamServiceManager(), this.teamMatchCallback);
        boolean result = this.mTeamMatchWindowController.initWindow(this.teamMatchContext);
        if (result) {
            this.handleTeamMatchStart();
        } else {
            this.releaseTeamMatchController();
        }
    }

    private void releaseTeamMatchController() {
        this.releaseTeamMatchController(true);
    }

    private void releaseTeamMatchController(boolean ischeckRecoveryChannel) {
        if (this.mTeamMatchController != null) {
            this.mTeamMatchController.onRelase();
            this.mTeamMatchController = null;
        }
        if (this.mTeamMatchWindowController != null) {
            this.mTeamMatchWindowController = null;
        }
        if (this.teamMatchContext != null && ischeckRecoveryChannel) {
            ((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).getGameInviteToChannelService().checkNeedRecoveryChannel(this.teamMatchContext.getTeamId());
        }
        this.handleDestroy();
    }

    @Override
    protected void handleTeamMatch() {
        super.handleTeamMatch();
        this.hideNotifyToast();
        GameInfo gameInfo = this.teamMatchContext.getGameInfo();
        if (this.teamMatchContext.isBackToGame()) {
            this.handleBackToGame();
        } else if (TeamModeHelper.isMultiMode((GameInfo)gameInfo)) {
            this.handleMultiModeTeamMatch();
        } else {
            this.handleSingleModeTeamMatch();
        }
    }

    public void handleBackToGame() {
        GameLoger.info("teamGameMatch", "handleBackToGame", new Object[0]);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"\u83b7\u53d6\u6e38\u620f\u623f\u95f4\u4fe1\u606f", (Object[])new Object[0]);
        }
        this.mDialogLinkManager.showDialog((BaseDialog)new ProgressDialog());
        this.initTeamMatchController();
        this.mTeamMatchController.getTeamServiceManager().getTeamRoomService().getGameInfo(new ITeamGetGameInfoListener(){

            @Override
            public void onGetGameInfoSuccess(String gameId, String roomId, int teamTemplate, String url, List<TeamUserInfo> teamUserInfoList) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamGameMatchController.TAG, (String)"\u83b7\u53d6\u6e38\u620f\u623f\u95f4\u4fe1\u606f\u6210\u529f\uff0cgameid=%s,roomid=%s,url=%s", (Object[])new Object[]{gameId, roomId, url});
                }
                TeamGameMatchController.this.mDialogLinkManager.dismissDialog();
                if (!(FP.empty((CharSequence)gameId) || FP.empty((CharSequence)roomId) || FP.empty((CharSequence)url))) {
                    TeamGameMatchController.this.teamMatchContext.setRoomId(roomId);
                    TeamGameMatchController.this.teamMatchContext.setUrl(url);
                    TeamGameMatchController.this.handleMatchFinish("", gameId, teamTemplate, roomId, url, teamUserInfoList);
                }
                TeamGameMatchController.this.releaseTeamMatchController();
            }

            @Override
            public void onGetGameInfoFailed(long code) {
                TeamGameMatchController.this.mDialogLinkManager.dismissDialog();
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TeamGameMatchController.TAG, (String)"\u83b7\u53d6\u6e38\u620f\u623f\u95f4\u4fe1\u606f\u5931\u8d25\uff0ccode=%d", (Object[])new Object[]{code});
                }
                if (code == 10000L) {
                    ToastUtils.showToast((Context)TeamGameMatchController.this.mContext, (String)ResourceUtils.getString((int)R.string.game_info_get_fail), (int)0);
                }
                TeamGameMatchController.this.releaseTeamMatchController();
            }
        });
    }

    public void handleSingleModeTeamMatch() {
        GameLoger.info("teamGameMatch", "handleSingleModeTeamMatch", new Object[0]);
        this.teamMatchContext.setMultiModeCode(this.teamMatchContext.getGameInfo().getTeamTemplate());
        this.initTeamMatchController();
        this.openTeamMatchWindow();
    }

    public void handleMultiModeTeamMatch() {
        GameLoger.info("teamGameMatch", "handleMultiModeTeamMatch", new Object[0]);
        GameInfo gameInfo = this.teamMatchContext.getGameInfo();
        int modeId = this.teamMatchContext.getMultiModeCode();
        this.initTeamMatchController();
        if (modeId == -1) {
            this.openModeCenter(this.teamMatchContext);
        } else {
            if (this.teamMatchContext.getFrom() == GameContextDef.JoinFrom.FROM_HOME) {
                GameModeInfo modeInfo = gameInfo.getMultiModeInfo().findAvailModeById(modeId);
                if (modeInfo == null) {
                    return;
                }
                modeId = modeInfo.getId();
                this.teamMatchContext.setMultiModeCode(modeId);
            }
            GameModeSP.setGameSelectedMode((String)gameInfo.gid, (int)modeId);
            this.openTeamMatchWindow();
            if (this.mModeCenter != null) {
                this.mModeCenter.closeModeCenter();
                this.mModeCenter = null;
            }
        }
    }

    private void hideNotifyToast() {
        Message message = Message.obtain();
        message.what = BaseMsgDef.MSG_HIDE_NOTIFY_TOAST;
        this.sendMessage(message);
    }

    private void openModeCenter(GameTeamMatchContext teamMatchContext) {
        ModeCenterContext modeCenterContext = new ModeCenterContext(teamMatchContext.mFrom);
        modeCenterContext.setGameInfo(teamMatchContext.getGameInfo());
        this.mModeCenter = new ModeCenterController(this.getEnvironment(), modeCenterContext, this.mTeamMatchController.getTeamServiceManager(), this.mModeCenterCallback);
        this.mModeCenter.showModeCenter();
    }

    private TeamMatchControllerFactory getTeamMatchControllerFactory() {
        if (this.mTeamMatchControllerFactory == null) {
            this.mTeamMatchControllerFactory = new TeamMatchControllerFactory();
        }
        return this.mTeamMatchControllerFactory;
    }

    @Override
    public void closeModeCenter() {
        super.closeModeCenter();
        if (this.mModeCenter != null) {
            this.mModeCenter.closeModeCenter();
            this.mModeCenter = null;
        }
    }

    public class TeamMatchControllerFactory {
        @NonNull
        AbsTeamMatchController getTeamMatchController(GameInfo gameInfo, ITeamMatchCallback lifeCycleCallback) {
            if (TeamModeHelper.isMultiMode((GameInfo)gameInfo)) {
                return new MultiModeMatchController(TeamGameMatchController.this.getEnvironment(), lifeCycleCallback);
            }
            return new NormolMatchController(TeamGameMatchController.this.getEnvironment(), lifeCycleCallback);
        }
    }
}

