/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.modecenter.ui;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.game.R;
import com.yy.game.gamemodule.teamgame.helper.RuleGuideAnimHelper;
import com.yy.game.gamemodule.teamgame.modecenter.adapter.ModeCardAdapter;
import com.yy.game.gamemodule.teamgame.modecenter.model.CardData;
import com.yy.game.gamemodule.teamgame.modecenter.model.InviteABData;
import com.yy.game.gamemodule.teamgame.modecenter.model.ModeCardData;
import com.yy.game.gamemodule.teamgame.modecenter.model.ModeLongCardData;
import com.yy.game.gamemodule.teamgame.modecenter.model.ModeShortCardData;
import com.yy.game.gamemodule.teamgame.modecenter.model.TitleCardData;
import com.yy.game.gamemodule.teamgame.modecenter.ui.AbsModeCenterWindow;
import com.yy.game.gamemodule.teamgame.modecenter.ui.IModeCenterUiCallbacks;
import com.yy.game.gamemodule.teamgame.teammatch.module.TeamInviteServicesController;
import com.yy.game.gamemodule.teamgame.teammatch.ui.adapter.invite.InviteAdapter;
import com.yy.hiyo.game.base.config.GameShareConfig;
import com.yy.hiyo.game.base.gamemode.GameModeInfo;
import com.yy.hiyo.game.base.teamgame.IInviteCallback;
import com.yy.hiyo.game.base.teamgame.InviteEntrance;
import com.yy.hiyo.game.base.teamgame.InviteEntranceItem;
import com.yy.hiyo.game.base.teamgame.InviteFriendData;
import com.yy.hiyo.game.base.teamgame.InviteFriendItem;
import com.yy.hiyo.game.base.teamgame.InviteItem;
import java.util.ArrayList;
import java.util.List;

public class ModeCenterWindow
extends AbsModeCenterWindow
implements View.OnClickListener,
IInviteCallback,
ModeCardAdapter.OnCardClickListener {
    private IModeCenterUiCallbacks mModeCenterUiCallbacks;
    private View mContentView;
    private RecycleImageView mIvBg;
    private View mViewBgColor;
    private RecyclerView mModeCardList;
    private RecyclerView mInviteList;
    private ImageView mIvBack;
    private ImageView mIvRule;
    private TextView mTvInviteTitle;
    private ImageView mIvSex;
    private TextView mTvAge;
    private TextView mTvUserName;
    private RoundImageView mIvAvatar;
    private RoundImageView mIvAvatarBg;
    private View mUserInfoView;
    private TextView mTvWinCount;
    private TextView mTvPlayCount;
    private View mRuleGuideCover;
    private View mRuleGuideTip;
    private RuleGuideAnimHelper ruleGuideAnimHelper;
    private ModeCardAdapter mModeCardAdapter;
    private InviteAdapter mInviteAdapter;
    private InviteABData mInviteABData;
    private static final int MAX_SHOW_SUM = 6;

    public ModeCenterWindow(Context context, UICallBacks callBacks, String name) {
        super(context, callBacks, name);
        if (callBacks instanceof IModeCenterUiCallbacks) {
            this.mModeCenterUiCallbacks = (IModeCenterUiCallbacks)callBacks;
        }
        this.createViews();
        this.setNeedFullScreen(true);
        this.setListeners();
    }

    private void createViews() {
        int screenWidth;
        this.mContentView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.mode_center_layout, this.getBaseLayer());
        this.mIvBg = (RecycleImageView)this.mContentView.findViewById(R.id.iv_bg);
        this.mViewBgColor = this.mContentView.findViewById(R.id.view_bg_color);
        this.mModeCardList = (RecyclerView)this.mContentView.findViewById(R.id.rv_mode_list);
        this.mInviteList = (RecyclerView)this.mContentView.findViewById(R.id.rv_invite);
        this.mIvBack = (ImageView)this.mContentView.findViewById(R.id.iv_back);
        this.mIvRule = (ImageView)this.mContentView.findViewById(R.id.iv_rules);
        this.mTvInviteTitle = (TextView)this.mContentView.findViewById(R.id.tv_invite_title);
        this.mTvUserName = (TextView)this.mContentView.findViewById(R.id.tv_name);
        this.mTvAge = (TextView)this.mContentView.findViewById(R.id.tv_age);
        this.mIvSex = (ImageView)this.mContentView.findViewById(R.id.iv_sex);
        this.mIvAvatar = (RoundImageView)this.mContentView.findViewById(R.id.iv_avatar);
        this.mIvAvatarBg = (RoundImageView)this.mContentView.findViewById(R.id.iv_avatar_bg);
        this.mUserInfoView = this.mContentView.findViewById(R.id.ll_info);
        this.mTvWinCount = (TextView)this.mContentView.findViewById(R.id.tv_win_count);
        this.mTvPlayCount = (TextView)this.mContentView.findViewById(R.id.tv_play_count);
        this.mRuleGuideTip = this.mContentView.findViewById(R.id.rule_guide_tip);
        this.mRuleGuideCover = this.mContentView.findViewById(R.id.rule_guide_cover);
        FontUtils.setFontType((TextView)this.mTvInviteTitle, (Typeface)FontUtils.getTypeFace((Context)this.getContext(), (FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.mIvBg.getLayoutParams().height = screenWidth = ResolutionUtils.getScreenWidth((Context)this.getContext());
        this.mModeCardAdapter = new ModeCardAdapter();
        this.mModeCardAdapter.setCardClickListener(this);
        this.mModeCardAdapter.attachToRecyclerView(this.mModeCardList);
    }

    public void onAttach() {
        super.onAttach();
    }

    public void onDetached() {
        super.onDetached();
        this.unbindInviteFriendsIfBind();
    }

    @Override
    public void setData(List<GameModeInfo> modeList, InviteABData inviteABData) {
        ArrayList<CardData> cardDataList = new ArrayList<CardData>();
        cardDataList.add(new TitleCardData(ResourceUtils.getString((int)R.string.short_title_match_to_play)));
        if (modeList != null) {
            for (GameModeInfo modeInfo : modeList) {
                ModeCardData modeCardData = modeInfo.getCardType() == 1 ? new ModeLongCardData(modeInfo) : (modeInfo.getCardType() == 2 ? new ModeShortCardData(modeInfo) : new ModeLongCardData(modeInfo));
                if (this.mModeCenterUiCallbacks != null) {
                    this.mModeCenterUiCallbacks.checkModeCardData(modeCardData);
                }
                cardDataList.add(modeCardData);
            }
        }
        this.mInviteABData = inviteABData;
        if (inviteABData != null) {
            this.bindInviteFriends();
        }
        this.mModeCardAdapter.setData(cardDataList);
    }

    private void setListeners() {
        this.mIvBack.setOnClickListener((View.OnClickListener)this);
        this.mIvRule.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.iv_back) {
            if (this.mModeCenterUiCallbacks != null) {
                this.mModeCenterUiCallbacks.onBackClicked();
            }
        } else if (id2 == R.id.iv_rules && this.mModeCenterUiCallbacks != null) {
            this.mModeCenterUiCallbacks.onRuleClicked();
        }
    }

    @Override
    public void setUserInfo(UserInfoKS userInfoKS) {
        int sexColor;
        if (userInfoKS == null) {
            return;
        }
        this.mTvUserName.setText((CharSequence)userInfoKS.getNick());
        this.mTvAge.setText((CharSequence)("" + DateUtils.getAge((String)userInfoKS.getBirthday())));
        if (userInfoKS.getSex() == 0) {
            sexColor = -1223571;
            this.mIvSex.setImageResource(R.drawable.ic_sex_fenale);
        } else {
            sexColor = -12749584;
            this.mIvSex.setImageResource(R.drawable.ic_sex_male);
        }
        this.mIvAvatarBg.setImageDrawable((Drawable)new ColorDrawable(sexColor));
        String avatarUrl = userInfoKS.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75);
        ImageLoader.loadImage((RecycleImageView)this.mIvAvatar, (String)avatarUrl, (int)0, (int)AvatarUtils.getDefaultAvatar((int)userInfoKS.getSex()));
        if (this.mUserInfoView.getBackground() instanceof GradientDrawable) {
            GradientDrawable userViewBg = (GradientDrawable)this.mUserInfoView.getBackground();
            userViewBg.setColor(sexColor);
        }
    }

    @Override
    public void setWinPlayData(int winCount, int playCount) {
        this.mTvPlayCount.setText((CharSequence)("" + playCount));
        this.mTvWinCount.setText((CharSequence)("" + winCount));
    }

    @Override
    public void setBackgound(String bgColor, String bgUrl) {
        int color2 = -15721400;
        try {
            color2 = Color.parseColor((String)bgColor);
        }
        catch (Exception e) {
            MLog.error((Object)"AbstractWindow", (Throwable)e);
        }
        this.mViewBgColor.setBackgroundColor(color2);
        this.mIvBg.setAutoTransforToWebpFlag(false);
        ImageLoader.loadImage((RecycleImageView)this.mIvBg, (String)bgUrl);
    }

    @Override
    public void setGuideVisiable(boolean visiable) {
        if (visiable) {
            this.mIvRule.setVisibility(0);
        } else {
            this.mIvRule.setVisibility(8);
        }
    }

    @Override
    public void startRuleGuide() {
        if (this.ruleGuideAnimHelper == null) {
            this.ruleGuideAnimHelper = new RuleGuideAnimHelper((View)this.mIvRule, this.mRuleGuideCover, this.mRuleGuideTip);
        }
        this.ruleGuideAnimHelper.startGuideAnim();
    }

    @Override
    public void stopRuleGuide() {
        if (this.ruleGuideAnimHelper != null) {
            this.ruleGuideAnimHelper.stopGuideAnim();
        }
    }

    public void onInviteClick(InviteFriendData data) {
        if (this.mModeCenterUiCallbacks != null) {
            this.mModeCenterUiCallbacks.onInviteClick(data);
        }
    }

    public void onSharePlatformClick(int platForm) {
        if (this.mModeCenterUiCallbacks != null) {
            this.mModeCenterUiCallbacks.onSharePlatformClick(platForm);
        }
    }

    public void onHagoClick() {
        if (this.mModeCenterUiCallbacks != null) {
            this.mModeCenterUiCallbacks.onHagoClick();
        }
    }

    @Override
    public void onCardClick(CardData cardData) {
        if (this.mModeCenterUiCallbacks != null) {
            this.mModeCenterUiCallbacks.onCardClick(cardData);
        }
    }

    private void bindInviteFriends() {
        if (this.mInviteABData == null) {
            return;
        }
        if (this.mInviteABData.getFriendContainer() == null) {
            return;
        }
        Kvo.addKvoBinding((KvoSource)this.mInviteABData.getFriendContainer(), (Object)this, (String)"onInviteFriendsChange");
    }

    private void unbindInviteFriendsIfBind() {
        if (this.mInviteABData == null) {
            return;
        }
        if (this.mInviteABData.getFriendContainer() == null) {
            return;
        }
        Kvo.removeKvoBinding((KvoSource)this.mInviteABData.getFriendContainer(), (Object)this, (String)"onInviteFriendsChange");
    }

    @KvoMethodAnnotation(name="friends", sourceClass=TeamInviteServicesController.InviteFriendContainer.class, thread=1)
    public void onInviteFriendsChange(KvoEventIntent kvoEvent) {
        this.handleInviteFriends();
    }

    public void handleInviteFriends() {
        if (this.mInviteABData == null) {
            return;
        }
        List<InviteFriendData> datas = this.mInviteABData.getFriendContainer().friends;
        GameShareConfig config = this.mInviteABData.getShareConfig();
        ArrayList<InviteItem> items = new ArrayList<InviteItem>();
        int onlineSum = 0;
        if (datas != null) {
            for (int i = 0; i < datas.size(); ++i) {
                InviteFriendData data = datas.get(i);
                if (!data.mFriends.isOnline() || ++onlineSum > 6) continue;
                items.add((InviteItem)new InviteFriendItem(data));
            }
        }
        items.add((InviteItem)new InviteEntranceItem(new InviteEntrance(0, onlineSum > 6 ? ResourceUtils.getString((int)R.string.x_online, (Object[])new Object[]{onlineSum}) : "")));
        if (config != null && config.shareType != null && !config.shareType.isEmpty()) {
            List platforms = config.shareType;
            for (String platform : platforms) {
                if (platform.equals("Whatsapp")) {
                    items.add((InviteItem)new InviteEntranceItem(new InviteEntrance(3)));
                    continue;
                }
                if (platform.equals("Messenger")) {
                    items.add((InviteItem)new InviteEntranceItem(new InviteEntrance(4)));
                    continue;
                }
                if (platform.equals("Line")) {
                    items.add((InviteItem)new InviteEntranceItem(new InviteEntrance(2)));
                    continue;
                }
                if (platform.equals("Facebook")) {
                    items.add((InviteItem)new InviteEntranceItem(new InviteEntrance(1)));
                    continue;
                }
                if (!platform.equals("vk")) continue;
                items.add((InviteItem)new InviteEntranceItem(new InviteEntrance(5)));
            }
        }
        this.showBottomInviteList(items);
    }

    private void showBottomInviteList(List<InviteItem> data) {
        if (this.mInviteAdapter == null) {
            this.mInviteAdapter = new InviteAdapter();
            this.mInviteAdapter.setCallback(this);
            this.mInviteList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 0, false));
            this.mInviteList.setAdapter((RecyclerView.Adapter)this.mInviteAdapter);
        }
        if (this.mTvInviteTitle.getVisibility() != 0) {
            this.mTvInviteTitle.setVisibility(0);
        }
        this.mInviteAdapter.setDatas(data);
    }
}

