/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.modecenter.helper;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yy.appbase.kvo.FindFriend;
import com.yy.game.gamemodule.teamgame.modecenter.ModeCenterContext;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.gamemode.GameModeInfo;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;

public class ModeCenterStatisHelper {
    public static void reportModeClick(ModeCenterContext context, GameModeInfo modeInfo, List<FindFriend> friends) {
        if (context == null) {
            return;
        }
        GameInfo gameInfo = context.getGameInfo();
        if (gameInfo == null) {
            return;
        }
        if (modeInfo == null) {
            return;
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025731").put("function_id", "mode_click").put("gid", gameInfo.getGid()).put("mid", "" + modeInfo.getId()).put("page_id", "middle_page").put("friend_info", ModeCenterStatisHelper.getFriendsStaticInfo(friends)).put("page_source", String.valueOf(context.getFrom().getId())));
    }

    public static void reportACardClick(ModeCenterContext context, List<FindFriend> friends) {
        if (context == null) {
            return;
        }
        GameInfo gameInfo = context.getGameInfo();
        if (gameInfo == null) {
            return;
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025731").put("function_id", "creat_team").put("gid", gameInfo.getGid()).put("page_id", "middle_page").put("friend_info", ModeCenterStatisHelper.getFriendsStaticInfo(friends)).put("page_source", String.valueOf(context.getFrom().getId())));
    }

    private static String getFriendsStaticInfo(List<FindFriend> datas) {
        JsonArray array2 = new JsonArray();
        int fbOnline = 0;
        int fbOffline = 0;
        int contactOnline = 0;
        int contactOffline = 0;
        int hagoOnline = 0;
        int hagoOffline = 0;
        int nearbyOnline = 0;
        int nearbyOffline = 0;
        if (datas != null && !datas.isEmpty()) {
            JsonObject jsonObject;
            for (FindFriend friend : datas) {
                long type = friend.getType();
                boolean online = friend.isOnline();
                if (type == 0L) {
                    if (online) {
                        ++fbOnline;
                        continue;
                    }
                    ++fbOffline;
                    continue;
                }
                if (type == 1L) {
                    if (online) {
                        ++contactOnline;
                        continue;
                    }
                    ++contactOffline;
                    continue;
                }
                if (type == 2L) {
                    if (online) {
                        ++nearbyOnline;
                        continue;
                    }
                    ++nearbyOffline;
                    continue;
                }
                if (type != 3L) continue;
                if (online) {
                    ++hagoOnline;
                    continue;
                }
                ++hagoOffline;
            }
            if (fbOnline > 0) {
                jsonObject = new JsonObject();
                jsonObject.addProperty("friend_type", "facebook");
                jsonObject.addProperty("friends_num", (Number)fbOnline);
                jsonObject.addProperty("online_flag", (Number)1);
                array2.add((JsonElement)jsonObject);
            }
            if (fbOffline > 0) {
                jsonObject = new JsonObject();
                jsonObject.addProperty("friend_type", "facebook");
                jsonObject.addProperty("friends_num", (Number)fbOffline);
                jsonObject.addProperty("online_flag", (Number)0);
                array2.add((JsonElement)jsonObject);
            }
            if (contactOnline > 0) {
                jsonObject = new JsonObject();
                jsonObject.addProperty("friend_type", "contact");
                jsonObject.addProperty("friends_num", (Number)contactOnline);
                jsonObject.addProperty("online_flag", (Number)1);
                array2.add((JsonElement)jsonObject);
            }
            if (contactOffline > 0) {
                jsonObject = new JsonObject();
                jsonObject.addProperty("friend_type", "contact");
                jsonObject.addProperty("friends_num", (Number)contactOffline);
                jsonObject.addProperty("online_flag", (Number)0);
                array2.add((JsonElement)jsonObject);
            }
            if (nearbyOnline > 0) {
                jsonObject = new JsonObject();
                jsonObject.addProperty("friend_type", "nearby");
                jsonObject.addProperty("friends_num", (Number)nearbyOnline);
                jsonObject.addProperty("online_flag", (Number)1);
                array2.add((JsonElement)jsonObject);
            }
            if (nearbyOffline > 0) {
                jsonObject = new JsonObject();
                jsonObject.addProperty("friend_type", "nearby");
                jsonObject.addProperty("friends_num", (Number)nearbyOffline);
                jsonObject.addProperty("online_flag", (Number)0);
                array2.add((JsonElement)jsonObject);
            }
            if (hagoOnline > 0) {
                jsonObject = new JsonObject();
                jsonObject.addProperty("friend_type", "hago");
                jsonObject.addProperty("friends_num", (Number)hagoOnline);
                jsonObject.addProperty("online_flag", (Number)1);
                array2.add((JsonElement)jsonObject);
            }
            if (hagoOffline > 0) {
                jsonObject = new JsonObject();
                jsonObject.addProperty("friend_type", "hago");
                jsonObject.addProperty("friends_num", (Number)hagoOffline);
                jsonObject.addProperty("online_flag", (Number)0);
                array2.add((JsonElement)jsonObject);
            }
        }
        return array2.toString();
    }
}

