/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.modecenter.adapter.viewholder;

import android.content.Context;
import android.graphics.Typeface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.google.android.flexbox.FlexboxLayoutManager;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.game.R;
import com.yy.game.gamemodule.teamgame.modecenter.adapter.viewholder.ModeCardViewHolder;
import com.yy.game.gamemodule.teamgame.modecenter.model.ModeShortCardData;
import com.yy.hiyo.game.base.gamemode.GameModeInfo;

public class ShortCardViewHolder
extends ModeCardViewHolder<ModeShortCardData> {
    private TextView mTitle;
    private TextView mDesc;
    private RecycleImageView mBgBase;
    private RecycleImageView mBgImg;

    private ShortCardViewHolder(View itemView) {
        super(itemView);
        this.mTitle = (TextView)itemView.findViewById(R.id.tv_title);
        this.mDesc = (TextView)itemView.findViewById(R.id.tv_desc);
        this.mBgBase = (RecycleImageView)itemView.findViewById(R.id.iv_bg_base);
        this.mBgImg = (RecycleImageView)itemView.findViewById(R.id.iv_bg_img);
        FontUtils.setFontType((TextView)this.mTitle, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        FontUtils.setFontType((TextView)this.mDesc, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
    }

    @Override
    public void bindData(ModeShortCardData data) {
        GameModeInfo gameModeInfo = data.getGameModeInfo();
        if (gameModeInfo == null) {
            return;
        }
        this.mTitle.setText((CharSequence)gameModeInfo.getName());
        this.mDesc.setText((CharSequence)gameModeInfo.getDesc());
        this.mBgBase.setAutoTransforToWebpFlag(false);
        ImageLoader.loadImage((RecycleImageView)this.mBgBase, (String)gameModeInfo.getBackgroundUrl());
        String bgImgUrl = gameModeInfo.getIconUrl() + YYImageUtils.getThumbnailPostfixPx((int)this.mBgImg.getWidth(), (int)this.mBgImg.getHeight(), (boolean)false);
        ImageLoader.loadImage((RecycleImageView)this.mBgImg, (String)bgImgUrl);
        this.updateStatusTag(data.getRealModeStatus(), gameModeInfo.getTagUrl());
        this.showGuide(data.isShowGuide());
    }

    public static ShortCardViewHolder create(ViewGroup parent) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.view_card_list_short_item, parent, false);
        if (itemView.getLayoutParams() instanceof FlexboxLayoutManager.LayoutParams) {
            FlexboxLayoutManager.LayoutParams layoutParams = (FlexboxLayoutManager.LayoutParams)itemView.getLayoutParams();
            layoutParams.setFlexBasisPercent(0.499f);
        }
        return new ShortCardViewHolder(itemView);
    }
}

