/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.modecenter.adapter.viewholder;

import android.view.View;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.ui.widget.NewTagSvgaPlayer;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.game.DR;
import com.yy.game.R;
import com.yy.game.gamemodule.teamgame.modecenter.adapter.viewholder.CardViewHolder;
import com.yy.game.gamemodule.teamgame.modecenter.model.CardData;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.dyres.inner.DResource;
import com.yy.hiyo.game.base.widget.GameTagView;

public abstract class ModeCardViewHolder<T extends CardData>
extends CardViewHolder<T> {
    private static final DResource NEW_TAG_SVGA = DR.new_tag_game_row;
    private GameTagView mModeTag;
    private SVGAImageView mGuideView;

    protected ModeCardViewHolder(View itemView) {
        super(itemView);
        this.mModeTag = (GameTagView)itemView.findViewById(R.id.mode_tag);
        this.mGuideView = (SVGAImageView)itemView.findViewById(R.id.svga_guide);
    }

    protected void updateStatusTag(int status, String tagUrl) {
        if (this.mModeTag == null) {
            return;
        }
        this.mModeTag.setSize(-2, -2);
        this.mModeTag.setBackgroundResource(R.drawable.game_tag_top_right_big);
        this.mModeTag.setTextSize(13.0f);
        this.mModeTag.setPadding(ResolutionUtils.dip2Px((float)7.0f), ResolutionUtils.dip2Px((float)2.0f), ResolutionUtils.dip2Px((float)4.0f), ResolutionUtils.dip2Px((float)5.0f));
        if (status == 0) {
            this.mModeTag.setVisibility(8);
        } else if (status == 3) {
            this.mModeTag.setVisibility(0);
            this.mModeTag.setText(R.string.home_game_new_tag);
            this.mModeTag.setContentBgColor(ResourceUtils.getColor((int)R.color.mode_tag_new));
            NewTagSvgaPlayer mTagSvgaPlayer = new NewTagSvgaPlayer(this.itemView, R.id.game_new_tag_anim_stub, NEW_TAG_SVGA);
            mTagSvgaPlayer.updateNewTag(true);
        } else if (status == 2) {
            this.mModeTag.setVisibility(0);
            this.mModeTag.setContentBgColor(ResourceUtils.getColor((int)R.color.mode_tag_fix));
            this.mModeTag.setText(R.string.btn_full);
        } else if (status == 1) {
            this.mModeTag.setVisibility(0);
            this.mModeTag.setText(R.string.home_game_fix_tag);
            this.mModeTag.setContentBgColor(ResourceUtils.getColor((int)R.color.mode_tag_fix));
        } else {
            this.mModeTag.setVisibility(0);
            this.mModeTag.setText(null);
            this.mModeTag.setSize(ResolutionUtils.dip2Px((float)37.0f), ResolutionUtils.dip2Px((float)21.0f));
            this.mModeTag.setBgUrl(tagUrl);
            this.mModeTag.setPadding(0, 0, 0, 0);
        }
    }

    protected void showGuide(boolean isShow) {
        if (this.mGuideView == null) {
            return;
        }
        if (isShow) {
            this.mGuideView.setVisibility(0);
            DyResLoader.INSTANCE.loadSvga(this.mGuideView, DR.match_guide, new ISvgaLoadCallback(){

                public void onFinished(SVGAVideoEntity entity) {
                    if (ModeCardViewHolder.this.mGuideView != null) {
                        ModeCardViewHolder.this.mGuideView.startAnimation();
                    }
                }

                public void onFailed(Exception e) {
                }
            });
        } else {
            this.mGuideView.setVisibility(8);
        }
    }
}

