/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.modecenter.adapter.viewholder;

import android.content.Context;
import android.graphics.Typeface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.flexbox.FlexboxLayoutManager;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.utils.FontUtils;
import com.yy.game.R;
import com.yy.game.gamemodule.teamgame.modecenter.adapter.InviteIconAdapter;
import com.yy.game.gamemodule.teamgame.modecenter.adapter.viewholder.CardViewHolder;
import com.yy.game.gamemodule.teamgame.modecenter.model.FriendIconData;
import com.yy.game.gamemodule.teamgame.modecenter.model.InviteCardData;
import com.yy.game.gamemodule.teamgame.modecenter.model.InviteIconData;
import com.yy.game.gamemodule.teamgame.modecenter.model.OnlineCountIconData;
import com.yy.game.gamemodule.teamgame.modecenter.model.PlatformIconData;
import com.yy.game.gamemodule.teamgame.teammatch.module.TeamInviteServicesController;
import com.yy.hiyo.game.base.teamgame.InviteFriendData;
import java.util.ArrayList;
import java.util.List;

public class InviteCardViewHolder
extends CardViewHolder<InviteCardData> {
    private static final int ICON_LIMIT = 4;
    private TextView mTitle;
    private RecyclerView mInviteIconList;
    private InviteIconAdapter mInviteIconAdapter;
    private View mBgBase;
    private List<String> mSharePlatformList;

    private InviteCardViewHolder(View itemView) {
        super(itemView);
        this.mTitle = (TextView)itemView.findViewById(R.id.tv_title);
        this.mInviteIconList = (RecyclerView)itemView.findViewById(R.id.invite_icon_list);
        this.mBgBase = itemView.findViewById(R.id.bg_base);
        FontUtils.setFontType((TextView)this.mTitle, (Typeface)FontUtils.getTypeFace((Context)itemView.getContext(), (FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.mInviteIconAdapter = new InviteIconAdapter();
        this.mInviteIconList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(itemView.getContext(), 0, false));
        this.mInviteIconList.setAdapter((RecyclerView.Adapter)this.mInviteIconAdapter);
    }

    @Override
    public void bindData(InviteCardData data) {
        this.mSharePlatformList = data.getShareConfig() != null ? data.getShareConfig().shareType : null;
        this.mBgBase.setBackgroundResource(R.drawable.shape_invite_card_bg);
        Kvo.addKvoBinding((KvoSource)data.getInviteFriendContainer(), (Object)((Object)this), (String)"onInviteFriendsChange");
    }

    public static InviteCardViewHolder create(ViewGroup parent) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.view_card_list_invite_item, parent, false);
        if (itemView.getLayoutParams() instanceof FlexboxLayoutManager.LayoutParams) {
            FlexboxLayoutManager.LayoutParams layoutParams = (FlexboxLayoutManager.LayoutParams)itemView.getLayoutParams();
            layoutParams.setFlexBasisPercent(0.998f);
        }
        return new InviteCardViewHolder(itemView);
    }

    @KvoMethodAnnotation(name="friends", sourceClass=TeamInviteServicesController.InviteFriendContainer.class, thread=1)
    public void onInviteFriendsChange(KvoEventIntent kvoEvent) {
        List friendDataList = (List)kvoEvent.caseNewValue(new ArrayList());
        if (friendDataList == null) {
            return;
        }
        ArrayList<InviteFriendData> onlineFriendList = new ArrayList<InviteFriendData>();
        for (Object friendData : friendDataList) {
            if (((InviteFriendData)friendData).mFriends == null || !((InviteFriendData)friendData).mFriends.isOnline()) continue;
            onlineFriendList.add((InviteFriendData)friendData);
        }
        ArrayList<InviteIconData> inviteIconDataList = new ArrayList<InviteIconData>(4);
        if (onlineFriendList.size() == 0) {
            if (this.mSharePlatformList != null) {
                for (String platformName : this.mSharePlatformList) {
                    PlatformIconData platformIconData = this.createPlatformByName(platformName);
                    if (platformIconData != null) {
                        inviteIconDataList.add(platformIconData);
                    }
                    if (inviteIconDataList.size() < 4) continue;
                    break;
                }
            }
        } else if (onlineFriendList.size() <= 4) {
            for (InviteFriendData friendData : onlineFriendList) {
                inviteIconDataList.add(new FriendIconData(friendData));
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                InviteFriendData friendData = (InviteFriendData)onlineFriendList.get(i);
                inviteIconDataList.add(new FriendIconData(friendData));
            }
            inviteIconDataList.add(new OnlineCountIconData(onlineFriendList.size()));
        }
        this.mInviteIconAdapter.setData(inviteIconDataList);
    }

    private PlatformIconData createPlatformByName(String name) {
        if ("Facebook".equals(name)) {
            return new PlatformIconData(1);
        }
        if ("Line".equals(name)) {
            return new PlatformIconData(2);
        }
        if ("Whatsapp".equals(name)) {
            return new PlatformIconData(3);
        }
        if ("Messenger".equals(name)) {
            return new PlatformIconData(4);
        }
        if ("vk".equals(name)) {
            return new PlatformIconData(5);
        }
        return null;
    }
}

