/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.modecenter.adapter.viewholder;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.yy.appbase.kvo.FindFriend;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.game.R;
import com.yy.game.gamemodule.teamgame.modecenter.adapter.viewholder.InviteIconViewHolder;
import com.yy.game.gamemodule.teamgame.modecenter.model.FriendIconData;

public class FriendIconViewHolder
extends InviteIconViewHolder<FriendIconData> {
    private RoundImageView mAvatar;
    private YYView mStatus;

    protected FriendIconViewHolder(View itemView) {
        super(itemView);
        this.mAvatar = (RoundImageView)itemView.findViewById(R.id.iv_avatar);
        this.mStatus = (YYView)itemView.findViewById(R.id.view_status);
    }

    @Override
    protected void bindData(FriendIconData data) {
        if (data.getFriendData() == null || data.getFriendData().mFriends == null) {
            return;
        }
        FindFriend friend = data.getFriendData().mFriends;
        String avatarUrl = friend.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75);
        ImageLoader.loadImage((RecycleImageView)this.mAvatar, (String)avatarUrl, (int)0, (int)AvatarUtils.getDefaultAvatar((int)friend.getSex()));
        Drawable drawable2 = null;
        if (friend.isInGame()) {
            drawable2 = ResourceUtils.getDrawable((int)R.drawable.shape_in_game_invite_card);
        } else if (friend.isMatching()) {
            drawable2 = ResourceUtils.getDrawable((int)R.drawable.shape_in_team_invite_card);
        } else if (friend.isOnline()) {
            drawable2 = ResourceUtils.getDrawable((int)R.drawable.shape_online_invite_card);
        }
        this.mStatus.setBackgroundDrawable(drawable2);
    }

    public static FriendIconViewHolder create(ViewGroup parent) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.view_invite_icon_friend, parent, false);
        return new FriendIconViewHolder(itemView);
    }
}

