/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.modecenter.adapter;

import android.animation.ObjectAnimator;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.flexbox.FlexboxLayoutManager;
import com.yy.game.gamemodule.teamgame.modecenter.adapter.viewholder.CardViewHolder;
import com.yy.game.gamemodule.teamgame.modecenter.adapter.viewholder.InviteCardViewHolder;
import com.yy.game.gamemodule.teamgame.modecenter.adapter.viewholder.LongCardViewHolder;
import com.yy.game.gamemodule.teamgame.modecenter.adapter.viewholder.ShortCardViewHolder;
import com.yy.game.gamemodule.teamgame.modecenter.adapter.viewholder.TitleViewHolder;
import com.yy.game.gamemodule.teamgame.modecenter.model.CardData;
import java.util.ArrayList;
import java.util.List;

public class ModeCardAdapter
extends RecyclerView.Adapter<CardViewHolder> {
    private List<CardData> cardList = new ArrayList<CardData>();
    private OnCardClickListener cardClickListener;
    private View.OnClickListener clickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (v.getTag() == null || !(v.getTag() instanceof Integer)) {
                return;
            }
            Integer position = (Integer)v.getTag();
            if (position < 0 || position >= ModeCardAdapter.this.cardList.size()) {
                return;
            }
            if (ModeCardAdapter.this.cardClickListener != null) {
                CardData cardData = (CardData)ModeCardAdapter.this.cardList.get(position);
                ModeCardAdapter.this.cardClickListener.onCardClick(cardData);
            }
        }
    };
    private View.OnTouchListener touchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getAction()) {
                case 0: {
                    ModeCardAdapter.this.animationDown(v);
                    break;
                }
                case 1: 
                case 3: {
                    ModeCardAdapter.this.animationUp(v);
                    break;
                }
            }
            return false;
        }
    };

    public void attachToRecyclerView(RecyclerView recyclerView) {
        if (recyclerView == null) {
            return;
        }
        FlexboxLayoutManager layoutManager = new FlexboxLayoutManager(recyclerView.getContext());
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        recyclerView.setAdapter((RecyclerView.Adapter)this);
    }

    @NonNull
    public CardViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == 0) {
            return TitleViewHolder.create(parent);
        }
        if (viewType == 1) {
            return LongCardViewHolder.create(parent);
        }
        if (viewType == 2) {
            return ShortCardViewHolder.create(parent);
        }
        if (viewType == 3) {
            return InviteCardViewHolder.create(parent);
        }
        return TitleViewHolder.create(parent);
    }

    public void onBindViewHolder(@NonNull CardViewHolder holder, int position) {
        if (position < 0 || position >= this.cardList.size()) {
            return;
        }
        CardData cardData = this.cardList.get(position);
        holder.bind(cardData);
        int type = cardData.getType();
        View itemView = holder.getItemView();
        if (type == 1 || type == 2 || type == 3) {
            this.setItemClickListener(position, itemView);
            this.setItemTouchListener(itemView);
        }
    }

    public int getItemCount() {
        return this.cardList.size();
    }

    public int getItemViewType(int position) {
        if (position >= 0 && position < this.cardList.size()) {
            return this.cardList.get(position).getType();
        }
        return -1;
    }

    public void setCardClickListener(OnCardClickListener cardClickListener) {
        this.cardClickListener = cardClickListener;
    }

    public void setData(List<CardData> data) {
        this.cardList.clear();
        if (data != null) {
            this.cardList.addAll(data);
        }
        this.notifyDataSetChanged();
    }

    private void setItemClickListener(int position, View itemView) {
        if (itemView == null) {
            return;
        }
        itemView.setTag((Object)position);
        itemView.setOnClickListener(this.clickListener);
    }

    private void setItemTouchListener(View itemView) {
        if (itemView == null) {
            return;
        }
        itemView.setOnTouchListener(this.touchListener);
    }

    private void animationDown(View view) {
        view.setPivotX((float)(view.getMeasuredWidth() / 2));
        view.setPivotY((float)(view.getMeasuredHeight() / 2));
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{1.0f, 0.9f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{1.0f, 0.9f});
        scaleX.setDuration(60L);
        scaleY.setDuration(60L);
        scaleX.start();
        scaleY.start();
    }

    private void animationUp(View view) {
        view.setPivotX((float)(view.getMeasuredWidth() / 2));
        view.setPivotY((float)(view.getMeasuredHeight() / 2));
        float x = view.getScaleX();
        float y = view.getScaleY();
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{x, 1.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{y, 1.0f});
        scaleX.setDuration(100L);
        scaleY.setDuration(100L);
        scaleX.start();
        scaleY.start();
    }

    public static interface OnCardClickListener {
        public void onCardClick(CardData var1);
    }
}

