/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.modecenter.adapter;

import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.game.gamemodule.teamgame.modecenter.adapter.viewholder.FriendIconViewHolder;
import com.yy.game.gamemodule.teamgame.modecenter.adapter.viewholder.InviteIconViewHolder;
import com.yy.game.gamemodule.teamgame.modecenter.adapter.viewholder.OnlineCountIconViewHolder;
import com.yy.game.gamemodule.teamgame.modecenter.adapter.viewholder.PlatformIconViewHolder;
import com.yy.game.gamemodule.teamgame.modecenter.model.InviteIconData;
import java.util.ArrayList;
import java.util.List;

public class InviteIconAdapter
extends RecyclerView.Adapter<InviteIconViewHolder> {
    private List<InviteIconData> iconList = new ArrayList<InviteIconData>();

    @NonNull
    public InviteIconViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == 0) {
            return PlatformIconViewHolder.create(parent);
        }
        if (viewType == 2) {
            return OnlineCountIconViewHolder.create(parent);
        }
        if (viewType == 1) {
            return FriendIconViewHolder.create(parent);
        }
        return FriendIconViewHolder.create(parent);
    }

    public void onBindViewHolder(@NonNull InviteIconViewHolder holder, int position) {
        if (position < 0 || position >= this.iconList.size()) {
            return;
        }
        InviteIconData data = this.iconList.get(position);
        holder.bind(data);
    }

    public int getItemCount() {
        return this.iconList.size();
    }

    public int getItemViewType(int position) {
        if (position >= 0 && position < this.iconList.size()) {
            return this.iconList.get(position).getType();
        }
        return -1;
    }

    public void setData(List<InviteIconData> data) {
        this.iconList.clear();
        if (data != null) {
            this.iconList.addAll(data);
        }
        this.notifyDataSetChanged();
    }
}

