/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.modecenter;

import android.content.Context;
import android.text.TextUtils;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.appbase.kvo.FindFriend;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.BasePanel;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.game.R;
import com.yy.game.gamemodule.teamgame.modecenter.IModeCenterCallback;
import com.yy.game.gamemodule.teamgame.modecenter.ModeCenterContext;
import com.yy.game.gamemodule.teamgame.modecenter.datamodel.WinPlayDataModel;
import com.yy.game.gamemodule.teamgame.modecenter.helper.ModeCenterStatisHelper;
import com.yy.game.gamemodule.teamgame.modecenter.model.CardData;
import com.yy.game.gamemodule.teamgame.modecenter.model.InviteABData;
import com.yy.game.gamemodule.teamgame.modecenter.model.ModeCardData;
import com.yy.game.gamemodule.teamgame.modecenter.model.ModeCenterAction;
import com.yy.game.gamemodule.teamgame.modecenter.model.WinPlayData;
import com.yy.game.gamemodule.teamgame.modecenter.popview.HagoInviteBottomPopView;
import com.yy.game.gamemodule.teamgame.modecenter.ui.AbsModeCenterWindow;
import com.yy.game.gamemodule.teamgame.modecenter.ui.IModeCenterUiCallbacks;
import com.yy.game.gamemodule.teamgame.modecenter.ui.ModeCenterWindow;
import com.yy.game.gamemodule.teamgame.teammatch.module.TeamInviteServicesController;
import com.yy.game.gamemodule.teamgame.teammatch.services.ITeamServiceManager;
import com.yy.game.module.gameinvite.panel.GameSharePanel;
import com.yy.game.module.gameinvite.panel.bean.GameShareChannelInfo;
import com.yy.game.module.gameinvite.panel.bean.GameShareFriendInfo;
import com.yy.game.module.gameinvite.panel.view.IGameShareItemClick;
import com.yy.hiyo.channel.base.bean.JoinedChannelInfo;
import com.yy.hiyo.game.base.config.GameShareConfig;
import com.yy.hiyo.game.base.gamemode.GameModeInfo;
import com.yy.hiyo.game.base.gamemode.MultiModeInfo;
import com.yy.hiyo.game.base.teamgame.InviteFriendData;
import com.yy.hiyo.game.base.teamgame.utils.GameModeSP;
import com.yy.hiyo.game.kvomodule.GameInfoModule;
import com.yy.webservice.WebEnvSettings;
import java.util.ArrayList;
import java.util.List;

public class ModeCenterController
extends DefaultWindowController
implements IModeCenterUiCallbacks {
    private static final String TAG = "ModeCenterController";
    private ModeCenterContext mModeCenterContext;
    private IModeCenterCallback mCallback;
    private AbsModeCenterWindow mModeCenterWindow;
    private ITeamServiceManager mTeamServiceManager;
    private WinPlayDataModel mWinPlayDataModel;
    private HagoInviteBottomPopView mHagoInviteBottomPopView;

    public ModeCenterController(Environment env, ModeCenterContext context, ITeamServiceManager mTeamServiceManager, IModeCenterCallback callback2) {
        super(env);
        this.mModeCenterContext = context;
        this.mCallback = callback2;
        this.mTeamServiceManager = mTeamServiceManager;
        this.mWinPlayDataModel = new WinPlayDataModel();
    }

    public void showModeCenter() {
        if (this.mModeCenterWindow != null) {
            MLog.error((Object)TAG, (String)"mode center is showing", (Object[])new Object[0]);
            return;
        }
        if (!this.contextAvailable()) {
            MLog.error((Object)TAG, (String)"context is not available", (Object[])new Object[0]);
            return;
        }
        if (this.mTeamServiceManager == null) {
            MLog.error((Object)TAG, (String)"team service manager is null", (Object[])new Object[0]);
            return;
        }
        this.mModeCenterWindow = this.createWindow();
        this.mWindowMgr.pushWindow((AbstractWindow)this.mModeCenterWindow, true);
        MultiModeInfo multiModeInfo = this.mModeCenterContext.getGameInfo().getMultiModeInfo();
        if (multiModeInfo != null) {
            this.mModeCenterWindow.setBackgound(multiModeInfo.getBgColor(), multiModeInfo.getMatchBgUrl());
        }
        this.showCardData();
        this.checkIfShowRuleBtn();
        this.showUserInfo();
        this.showWinPlayData();
    }

    public void closeModeCenter() {
        if (this.mModeCenterWindow != null) {
            this.mModeCenterWindow.stopRuleGuide();
            this.mWindowMgr.popWindow(false, (AbstractWindow)this.mModeCenterWindow);
        }
        this.mModeCenterWindow = null;
    }

    private boolean contextAvailable() {
        if (this.mModeCenterContext == null) {
            return false;
        }
        return this.mModeCenterContext.getGameInfo() != null;
    }

    private AbsModeCenterWindow createWindow() {
        return new ModeCenterWindow((Context)this.mContext, this, "ModeCenterWindow");
    }

    public void onWindowAttach(AbstractWindow abstractWindow) {
        super.onWindowAttach(abstractWindow);
        this.checkIfShowGuide();
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.mCallback != null) {
            this.mCallback.onModeCenterDestroy();
        }
    }

    protected boolean onWindowBackKeyEvent() {
        if (this.mCallback != null) {
            this.mCallback.onModeCenterBackExit();
        }
        return true;
    }

    @Override
    public void onBackClicked() {
        if (this.mCallback != null) {
            this.mCallback.onModeCenterBackExit();
        }
    }

    @Override
    public void onRuleClicked() {
        if (this.mModeCenterWindow == null) {
            return;
        }
        this.mModeCenterWindow.stopRuleGuide();
        if (this.mModeCenterContext == null) {
            return;
        }
        String gid = this.mModeCenterContext.getGameInfo().getGid();
        final String guideUrl = this.mTeamServiceManager.getGameDataProvider().getModeCenterGuide(gid);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                WebEnvSettings wes = new WebEnvSettings();
                wes.url = guideUrl;
                wes.usePageTitle = true;
                wes.isFullScreen = false;
                wes.disablePullRefresh = true;
                wes.backBtnResId = R.drawable.icon_nav_back;
                wes.webviewFeature = 1;
                IWebService iWebService = (IWebService)ModeCenterController.this.getServiceManager().getService(IWebService.class);
                if (iWebService != null) {
                    iWebService.loadUrl(wes);
                }
            }
        });
    }

    @Override
    public void onCardClick(CardData cardData) {
        int type = cardData.getType();
        if (type == 3) {
            if (this.mCallback != null) {
                ModeCenterAction action = new ModeCenterAction(0);
                this.mCallback.onInviteAction(action);
            }
            ModeCenterStatisHelper.reportACardClick(this.mModeCenterContext, this.getFriendList());
        } else if ((type == 1 || type == 2) && cardData instanceof ModeCardData) {
            ModeCardData modeCardData = (ModeCardData)cardData;
            GameModeInfo modeInfo = modeCardData.getGameModeInfo();
            if (modeInfo != null) {
                if (modeInfo.getStatus() == 2) {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_game_full), (int)0);
                } else if (modeInfo.getStatus() == 1) {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.game_maintening), (int)0);
                } else if (this.mCallback != null) {
                    this.mCallback.onModeSelected(modeInfo);
                }
            }
            ModeCenterStatisHelper.reportModeClick(this.mModeCenterContext, modeInfo, this.getFriendList());
        }
        if (this.mModeCenterWindow != null) {
            this.mModeCenterWindow.stopRuleGuide();
        }
    }

    @Override
    public void onInviteClick(InviteFriendData data) {
        if (this.mCallback == null) {
            return;
        }
        ModeCenterAction action = new ModeCenterAction(2);
        action.setFriendData(data);
        this.mCallback.onInviteAction(action);
        if (this.mModeCenterWindow != null) {
            this.mModeCenterWindow.stopRuleGuide();
        }
    }

    @Override
    public void onInviteChannelClick(JoinedChannelInfo channelItem) {
        if (this.mCallback == null) {
            return;
        }
        ModeCenterAction action = new ModeCenterAction(4);
        action.setChannelInfo(channelItem);
        this.mCallback.onInviteAction(action);
        if (this.mModeCenterWindow != null) {
            this.mModeCenterWindow.stopRuleGuide();
        }
    }

    @Override
    public void onSharePlatformClick(int platForm) {
        if (this.mCallback == null) {
            return;
        }
        ModeCenterAction action = new ModeCenterAction(1);
        action.setPlatform(platForm);
        this.mCallback.onInviteAction(action);
        if (this.mModeCenterWindow != null) {
            this.mModeCenterWindow.stopRuleGuide();
        }
    }

    @Override
    public void onHagoClick() {
        this.showHagoFriendsPopView();
        if (this.mModeCenterWindow != null) {
            this.mModeCenterWindow.stopRuleGuide();
        }
    }

    @Override
    public void checkModeCardData(ModeCardData modeCardData) {
        if (modeCardData == null) {
            return;
        }
        boolean isNewUser = this.checkIsNewUser();
        int lastSelectedMode = GameModeSP.getGameSelectedMode((String)this.mModeCenterContext.getGameInfo().getGid());
        boolean canShowGuide = lastSelectedMode == -1;
        GameModeInfo modeInfo = modeCardData.getGameModeInfo();
        int realStatus = modeInfo.getStatus();
        if (realStatus == 0 || realStatus == 3) {
            realStatus = canShowGuide && !isNewUser && modeInfo.getGuideType() == 2 ? 3 : 0;
        }
        modeCardData.setRealModeStatus(realStatus);
        boolean realShowGuide = false;
        if (canShowGuide && realStatus != 2 && realStatus != 1) {
            realShowGuide = isNewUser && modeInfo.getGuideType() == 1;
        }
        modeCardData.setShowGuide(realShowGuide);
    }

    private boolean checkIsNewUser() {
        boolean isNewUser = true;
        GameInfoModule gameInfoModule = (GameInfoModule)KvoModuleManager.getModule(GameInfoModule.class);
        if (gameInfoModule != null) {
            isNewUser = !gameInfoModule.hasGamePlayed(this.mModeCenterContext.getGameInfo().getGid());
        }
        return isNewUser;
    }

    private void showUserInfo() {
        UserInfoKS userInfo = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(AccountUtil.getUid(), null);
        this.mModeCenterWindow.setUserInfo(userInfo);
    }

    private void showWinPlayData() {
        String gid = this.mModeCenterContext.getGameInfo().getGid();
        this.mWinPlayDataModel.requestWinPlayData(gid, new WinPlayDataModel.WinPlayDataCallback(){

            @Override
            public void onSuccess(WinPlayData data) {
                if (ModeCenterController.this.mModeCenterWindow == null) {
                    return;
                }
                ModeCenterController.this.mModeCenterWindow.setWinPlayData(data.getWinCount(), data.getTotalCount());
            }

            @Override
            public void onFail(String msg) {
                if (ModeCenterController.this.mModeCenterWindow == null) {
                    return;
                }
                ModeCenterController.this.mModeCenterWindow.setWinPlayData(0, 0);
            }
        });
    }

    private void showHagoFriendsPopView() {
        final GameSharePanel mGameSharePanel = this.mTeamServiceManager.getTeamGameInviteService().getTeamMatcherSharePanel(false, (Context)this.mContext, this.mModeCenterContext.getGameInfo().getGid(), true);
        mGameSharePanel.setItemClick(new IGameShareItemClick(){

            @Override
            public void onFriendInviteClick(GameShareFriendInfo info) {
                ModeCenterController.this.onInviteClick(info.mInviteFriendData);
                ((DefaultWindow)ModeCenterController.this.getCurrentWindow()).getPanelLayer().hidePanel((BasePanel)mGameSharePanel, false);
            }

            @Override
            public void onChannelItemInviteClick(GameShareChannelInfo info) {
                ModeCenterController.this.onInviteChannelClick(info.mChannelInfo);
                ((DefaultWindow)ModeCenterController.this.getCurrentWindow()).getPanelLayer().hidePanel((BasePanel)mGameSharePanel, false);
            }
        });
        ((DefaultWindow)this.getCurrentWindow()).getPanelLayer().showPanel((BasePanel)mGameSharePanel, true);
    }

    private void showCardData() {
        MultiModeInfo multiModeInfo = this.mModeCenterContext.getGameInfo().getMultiModeInfo();
        List modeInfoList = multiModeInfo.getModeList();
        TeamInviteServicesController.InviteFriendContainer container = this.mTeamServiceManager.getTeamGameInviteService().getInviteFriendContainer();
        GameShareConfig shareConfig = this.mTeamServiceManager.getTeamGameInviteService().getSharePlatforms();
        InviteABData inviteABData = new InviteABData();
        inviteABData.setFriendContainer(container);
        inviteABData.setShareConfig(shareConfig);
        this.mModeCenterWindow.setData(modeInfoList, inviteABData);
    }

    private void checkIfShowRuleBtn() {
        String gid = this.mModeCenterContext.getGameInfo().getGid();
        String guideUrl = this.mTeamServiceManager.getGameDataProvider().getModeCenterGuide(gid);
        if (TextUtils.isEmpty((CharSequence)guideUrl)) {
            this.mModeCenterWindow.setGuideVisiable(false);
        } else {
            this.mModeCenterWindow.setGuideVisiable(true);
        }
    }

    private void checkIfShowGuide() {
        String gid = this.mModeCenterContext.getGameInfo().getGid();
        String guideUrl = this.mTeamServiceManager.getGameDataProvider().getModeCenterGuide(gid);
        if (!TextUtils.isEmpty((CharSequence)guideUrl) && SettingFlags.getBoolean((String)"team_tip_show", (boolean)true)) {
            this.mModeCenterWindow.startRuleGuide();
            SettingFlags.setBoolean((String)"team_tip_show", (boolean)false);
        }
    }

    private List<FindFriend> getFriendList() {
        if (this.mTeamServiceManager == null || this.mTeamServiceManager.getTeamGameInviteService() == null) {
            return null;
        }
        TeamInviteServicesController.InviteFriendContainer container = this.mTeamServiceManager.getTeamGameInviteService().getInviteFriendContainer();
        if (container.friends == null) {
            return null;
        }
        ArrayList<InviteFriendData> friendDataList = new ArrayList<InviteFriendData>();
        friendDataList.addAll(container.friends);
        ArrayList<FindFriend> findFriendList = new ArrayList<FindFriend>();
        for (InviteFriendData friendData : friendDataList) {
            findFriendList.add(friendData.mFriends);
        }
        return findFriendList;
    }
}

