/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame.helper;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.view.View;
import android.view.animation.LinearInterpolator;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;

public class RuleGuideAnimHelper {
    private View ruleBtnView;
    private View guideCoverView;
    private View guideTipView;
    private ObjectAnimator ruleTipAnim;
    private AnimatorSet ruleIconAnimSet;
    private boolean isAnimShow = false;
    private Runnable ruleTipAnimRunable = new Runnable(){

        @Override
        public void run() {
            if (!RuleGuideAnimHelper.this.checkAvailable()) {
                return;
            }
            if (RuleGuideAnimHelper.this.ruleTipAnim == null) {
                if (LanguageUtils.isLtr()) {
                    RuleGuideAnimHelper.this.ruleTipAnim = ObjectAnimator.ofFloat((Object)RuleGuideAnimHelper.this.guideTipView, (String)"translationX", (float[])new float[]{ResolutionUtils.dip2Px((float)5.0f), -ResolutionUtils.dip2Px((float)15.0f), ResolutionUtils.dip2Px((float)5.0f)});
                } else {
                    RuleGuideAnimHelper.this.ruleTipAnim = ObjectAnimator.ofFloat((Object)RuleGuideAnimHelper.this.guideTipView, (String)"translationX", (float[])new float[]{-ResolutionUtils.dip2Px((float)5.0f), ResolutionUtils.dip2Px((float)15.0f), -ResolutionUtils.dip2Px((float)5.0f)});
                }
                RuleGuideAnimHelper.this.ruleTipAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
                RuleGuideAnimHelper.this.ruleTipAnim.setDuration(800L);
                RuleGuideAnimHelper.this.ruleTipAnim.addListener(new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                    }

                    public void onAnimationEnd(Animator animation) {
                        if (RuleGuideAnimHelper.this.ruleIconAnimSet == null) {
                            ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)RuleGuideAnimHelper.this.ruleBtnView, (String)"scaleX", (float[])new float[]{1.0f, 1.3f, 1.0f});
                            ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)RuleGuideAnimHelper.this.ruleBtnView, (String)"scaleY", (float[])new float[]{1.0f, 1.3f, 1.0f});
                            RuleGuideAnimHelper.this.ruleIconAnimSet = new AnimatorSet();
                            RuleGuideAnimHelper.this.ruleIconAnimSet.playTogether(new Animator[]{scaleX, scaleY});
                            RuleGuideAnimHelper.this.ruleIconAnimSet.setInterpolator((TimeInterpolator)new LinearInterpolator());
                            RuleGuideAnimHelper.this.ruleIconAnimSet.setDuration(500L);
                        }
                        RuleGuideAnimHelper.this.ruleIconAnimSet.start();
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
            }
            RuleGuideAnimHelper.this.ruleTipAnim.start();
            YYTaskExecutor.postToMainThread((Runnable)this, (long)2000L);
        }
    };

    public RuleGuideAnimHelper(View ruleBtn, View guideCover, View guideTip) {
        this.ruleBtnView = ruleBtn;
        this.guideCoverView = guideCover;
        this.guideTipView = guideTip;
    }

    private boolean checkAvailable() {
        return this.ruleBtnView != null && this.guideTipView != null && this.guideCoverView != null;
    }

    public void startGuideAnim() {
        if (!this.checkAvailable()) {
            return;
        }
        this.guideTipView.setVisibility(0);
        this.guideCoverView.setVisibility(0);
        YYTaskExecutor.postToMainThread((Runnable)this.ruleTipAnimRunable);
        this.isAnimShow = true;
    }

    public void stopGuideAnim() {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.ruleTipAnimRunable);
        this.guideTipView.setVisibility(8);
        this.guideCoverView.setVisibility(8);
        this.isAnimShow = false;
    }
}

