/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.teamgame;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Message;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import com.google.gson.Gson;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.appsflyer.AppsFlyerEvent;
import com.yy.appbase.appsflyer.AppsFlyerHelper;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.cocosproxy.CocosProxyType;
import com.yy.appbase.service.model.RoomUserMicStatus;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ImeUtil;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.R;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.game.R;
import com.yy.game.bean.EmojiBean;
import com.yy.game.bean.GameDataModel;
import com.yy.game.bean.OpenSceneBean;
import com.yy.game.bean.QueueBean;
import com.yy.game.gamemodule.GameLoger;
import com.yy.game.gamemodule.base.NormalGamePlayer;
import com.yy.game.gamemodule.base.gameview.WindowGameView;
import com.yy.game.gamemodule.teamgame.ITeamGameUICallback;
import com.yy.game.gamemodule.teamgame.TeamGameStatisHelper;
import com.yy.game.gamemodule.teamgame.teammatch.model.JsTeamExitBean;
import com.yy.game.gamemodule.teamgame.teammatch.model.JsTeamPlayAgainBean;
import com.yy.game.gamemodule.teamgame.teammatch.provider.TeamGameDataModel;
import com.yy.game.gamemodule.teamgame.teammatch.services.IGameDataProvider;
import com.yy.game.growth.GameExitHelper;
import com.yy.game.module.gameload.LoadGamePageManager;
import com.yy.game.module.gameroom.barrageview.IBarrageViewUiCallback;
import com.yy.game.module.gameroom.barrageview.MessageBarrageView;
import com.yy.game.module.gameroom.barrageview.MessageBarrageViewController;
import com.yy.game.module.gameroom.expressionbar.ExpressBarController;
import com.yy.game.module.gameroom.expressionbar.IExpressBarUiCallback;
import com.yy.game.module.gameroom.topbar.ITopBarUiCallback;
import com.yy.game.module.gameroom.topbar.TopBarController;
import com.yy.game.module.gameroom.ui.AbsGameWindow;
import com.yy.game.module.gameroom.ui.AbstractFunctionLayer;
import com.yy.game.module.gameroom.ui.CustomerFuntionLayer;
import com.yy.game.module.gameroom.ui.EmptyFuntionLayer;
import com.yy.game.module.gameroom.ui.GameWindowConfig;
import com.yy.game.module.gameroom.ui.HorizontalFuntionLayer;
import com.yy.game.module.gameroom.ui.IFunctionLayerCallback;
import com.yy.game.module.gameroom.ui.VerticalFuntionLayer;
import com.yy.game.module.jscallappmodule.model.GetRelationBean;
import com.yy.game.utils.GameReportHelper;
import com.yy.game.utils.GameStateDef;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.game.base.BarrageInfo;
import com.yy.hiyo.game.base.DefaultBarrageResBean;
import com.yy.hiyo.game.base.GameModel;
import com.yy.hiyo.game.base.GameNotificationDef;
import com.yy.hiyo.game.base.IGameMsgListener;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.IGameDialogCallback;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameMessageService;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.bean.GameTeamMatchContext;
import com.yy.hiyo.game.service.bean.teamgame.TeamGamePlayContext;
import com.yy.hiyo.game.service.callback.IGameMessageBarrageListener;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.voice.base.bean.GameUserSpeakStatus;
import com.yy.hiyo.voice.base.bean.MicStatusBean;
import com.yy.hiyo.voice.base.bean.UserSpeakStatus;
import com.yy.hiyo.voice.base.roomvoice.AbsVoiceRoom;
import com.yy.hiyo.voice.base.roomvoice.IRoomLifeCycleCallback;
import com.yy.hiyo.voice.base.roomvoice.IRoomManagerService;
import com.yy.hiyo.voice.base.roomvoice.MultiplayerRoom;
import com.yy.hiyo.voice.base.roomvoice.RoomSlot;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeamGamePlayer
extends NormalGamePlayer
implements ITeamGameUICallback,
IFunctionLayerCallback {
    private TopBarController mTopBarController;
    private ExpressBarController mExpressBarController;
    private MessageBarrageViewController mMessageBarrageViewController;
    public IRoomManagerService mRoomService;
    private IGameDataProvider mGameDataProvider;
    public RoomSlot<MultiplayerRoom> mRoomSlot;
    private int mSeatNumber;
    private long mGameStartTime;
    volatile boolean mIsHiddenFinish = false;
    private boolean mIsMyMicOpenWhenEnter;
    private IGameMsgListener mGameMsgListener = new IGameMsgListener(){

        public void onExpressNotify(long senderUid, String value) {
        }

        public void onExpressBrocstNotify(String barcastId, long uid, String value) {
        }

        public void onSendMsgRes() {
        }

        public void onJoinRoomSuccess() {
        }

        public void onJoinRoomFail(long code) {
        }

        public void onBarrageNotify(final BarrageInfo value, final String id2, final int type) {
            try {
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!(type != 1 || TextUtils.isEmpty((CharSequence)id2) || TextUtils.isEmpty((CharSequence)TeamGamePlayer.this.gameRunningContext.getRoomId()) || id2.equals(TeamGamePlayer.this.gameRunningContext.getRoomId()))) {
                            return;
                        }
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                MessageBarrageView messageBarrageView = null;
                                if (value != null && value.user != null && value.mDanmu != null && TeamGamePlayer.this.mMessageBarrageViewController != null && (messageBarrageView = TeamGamePlayer.this.mMessageBarrageViewController.getMessageBarrageView(TeamGamePlayer.this.gameRunningContext.getGameInfo())) != null) {
                                    messageBarrageView.showBarrageView(value.user.avatar, value.mDanmu.txt, -16126);
                                }
                            }
                        });
                    }
                });
            }
            catch (Exception e) {
                GameLoger.error("teamGame", e);
            }
        }
    };
    private final KvoBinder mBinder = new KvoBinder((Object)this);
    public static final String GAME_ID = "game_id";
    public static final String CRASH = "Crash_";

    public TeamGamePlayer(Environment env, IGameLifecycle callback2) {
        super(env, callback2);
    }

    @Override
    public int preLoadGame(GamePlayContext context) {
        GameLoger.info("teamGame", "onPreloadGame", new Object[0]);
        GameInfo gameInfo = context.getGameInfo();
        if (gameInfo == null) {
            return 1;
        }
        return 0;
    }

    @Override
    public void onPreloadGameInner(@NotNull GamePlayContext context) {
        super.onPreloadGameInner(context);
        if (this.gameRunningContext.getGameInfo().getVoiceType() == 2) {
            // empty if block
        }
        this.mRoomService = (IRoomManagerService)this.getServiceManager().getService(IRoomManagerService.class);
        this.mGameDataProvider = new TeamGameDataModel(this.getEnvironment(), this.gameRunningContext.getGameInfo().getGid());
        this.mGameStartTime = System.currentTimeMillis();
        this.getBaseGameView().showGameView();
        this.getBaseGameView().loadGameView();
        this.initViewByData();
        GameReportHelper.reportGameInfo(this.gameRunningContext.buildGameModel(), (int)(System.currentTimeMillis() - this.mGameStartTime), this.gameRunningContext.getFrom().getId(), GameStateDef.GAME_FINISH_REASON.GAME_START.value(), 0, this.isGoldGame);
    }

    private void initViewByData() {
        ((IGameMessageService)this.getServiceManager().getService(IGameMessageService.class)).getMessagePool(this.gameRunningContext.getGameInfo().getGid(), new IGameMessageBarrageListener(){

            public void onMessageBarrageRes(DefaultBarrageResBean bean) {
                if (TeamGamePlayer.this.mMessageBarrageViewController != null) {
                    TeamGamePlayer.this.mMessageBarrageViewController.setMessageList(bean.msgs);
                }
            }
        });
        ((IGameMessageService)this.getServiceManager().getService(IGameMessageService.class)).registerGameMsgListener(this.mGameMsgListener);
        GameInfo gameInfo = this.gameRunningContext.getGameInfo();
        String roomId = this.gameRunningContext.getRoomId();
        if (gameInfo.getVoiceType() == 1) {
            IRoomLifeCycleCallback roomLifeCycleCallback = new IRoomLifeCycleCallback(){

                public void onRoomCreate(RoomSlot room, int type, Object ... e) {
                }

                public void onRoomRestart(RoomSlot room, int type) {
                }

                public void onRoomResume(RoomSlot room, int type) {
                }

                public void onRoomPause(RoomSlot room, int type) {
                }

                public void onRoomDestory(RoomSlot room, int type) {
                }
            };
            this.mRoomSlot = this.mRoomService.joinRoom(roomId, 8, roomLifeCycleCallback);
            this.mIsMyMicOpenWhenEnter = ((MultiplayerRoom)this.mRoomSlot.room).mMyStatus.isMicOpen();
            this.bindingRoomData(this.mRoomSlot);
        } else {
            this.getTopBarController().showMicBtn(false);
        }
        if (gameInfo.getVoiceType() != 1) {
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)GameNotificationDef.TEAM_GAME_START, (Object)this.gameRunningContext.buildGameModel()));
        }
        if (!this.mGameDataProvider.getTeamBackShow(gameInfo.getGid())) {
            this.getTopBarController().showBackBtn(false);
        }
    }

    @Override
    public void onQueueStatusChanged(@NotNull String status, @Nullable QueueBean data) {
    }

    @Override
    public void onLoadGameFinishInner(GamePlayContext context, int finishType) {
        GameLoger.info("teamGame", "onLoadGameFinishInner, finishType = " + finishType, new Object[0]);
        if (finishType == 2) {
            if (RuntimeContext.sIsDebuggable) {
                boolean isGameFirstPageOpen = SettingFlags.getBoolean((String)"gameautofirstpage", (boolean)false);
                boolean isGameAutoOpen = SettingFlags.getBoolean((String)"gameautoopen", (boolean)false);
                if (isGameFirstPageOpen) {
                    this.exitRoom(5);
                } else if (isGameAutoOpen) {
                    this.exitRoom(5);
                } else {
                    this.onLoadFailToIM();
                }
            } else {
                this.onLoadFailToIM();
            }
        } else if (finishType == 3) {
            GameReportHelper.reportGameInfo(this.gameRunningContext.buildGameModel(), (int)(System.currentTimeMillis() - this.mGameStartTime), this.gameRunningContext.getFrom().getId(), GameStateDef.GAME_FINISH_REASON.OVER_TIME.value(), 0, this.isGoldGame);
            if (this.getBaseGameView() == null) {
                return;
            }
            if (RuntimeContext.sIsDebuggable) {
                boolean isGameFirstPageOpen = SettingFlags.getBoolean((String)"gameautofirstpage", (boolean)false);
                boolean isGameAutoOpen = SettingFlags.getBoolean((String)"gameautoopen", (boolean)false);
                if (isGameFirstPageOpen) {
                    this.exitRoom(5);
                } else if (isGameAutoOpen) {
                    this.exitRoom(5);
                } else {
                    this.exitRoom(5);
                }
            } else {
                this.exitRoom(5);
            }
        }
        if (finishType != 0) {
            TeamGameStatisHelper.reportLoadFailed((TeamGamePlayContext)this.gameRunningContext, this.mGameStartTime);
        }
    }

    private void onLoadFailToIM() {
        GameLoger.info("teamGame", "onLoadFailToIM", new Object[0]);
        TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.game_loading_fail), (int)0);
        this.exitRoom(4);
        GameReportHelper.reportGameInfo(this.gameRunningContext.buildGameModel(), (int)(System.currentTimeMillis() - this.mGameStartTime), this.gameRunningContext.getFrom().getId(), GameStateDef.GAME_FINISH_REASON.LOAD_FAIL.value(), 0, this.isGoldGame);
    }

    @Override
    public void onPlayGameStartInner(GamePlayContext context) {
        super.onPlayGameStartInner(context);
        GameDataModel.instance.postGameJoin(this.gameRunningContext.buildGameModel(), this.gameRunningContext.getFrom().getId());
    }

    @Override
    public void onPlayGameFinishInner(GamePlayContext context, int finishType) {
        super.onPlayGameFinishInner(context, finishType);
        if (finishType == 2) {
            GameReportHelper.reportGameInfo(context.buildGameModel(), (int)(System.currentTimeMillis() - this.mGameStartTime), context.getFrom().getId(), GameStateDef.GAME_FINISH_REASON.EXECPTION_FINISH.value(), 0, this.isGoldGame);
            this.exitRoom(5);
        } else if (finishType == 1) {
            String result = context.getGameResult();
            GameLoger.info("teamGame", "GAME_PK_FINISH:" + result, new Object[0]);
            GameReportHelper.reportGameInfo(context.buildGameModel(), (int)(System.currentTimeMillis() - this.mGameStartTime), context.getFrom().getId(), GameStateDef.GAME_FINISH_REASON.FINISH.value(), 0, result, this.isGoldGame);
            if (RuntimeContext.sIsDebuggable) {
                boolean isGameRandom = SettingFlags.getBoolean((String)"gameautofirstpagerandom", (boolean)false);
                boolean mEnableAutoTouch = SettingFlags.getBoolean((String)"gameautofirstpage", (boolean)false);
                boolean isGameAutoOpen = SettingFlags.getBoolean((String)"gameautoopen", (boolean)false);
                if (isGameRandom || mEnableAutoTouch) {
                    this.exitRoom(5);
                }
            }
        }
    }

    @Override
    public void onGameExitedInner(GamePlayContext context, int exitType) {
        GameLoger.info("teamGame", "onGameExited, exitType: " + exitType, new Object[0]);
        GameInfo gameInfo = context.getGameInfo();
        this.reportGame(false);
        if (this.getBaseGameView() != null) {
            this.mIsHiddenFinish = false;
            if (context.mFrom == GameContextDef.JoinFrom.FROM_HAGO_GROUP) {
                this.mIsHiddenFinish = true;
                this.goToChannel(context);
            } else if (exitType == 5) {
                this.mIsHiddenFinish = false;
                if (this.getBaseGameView() != null) {
                    this.getBaseGameView().destroyGameView();
                    if (this.gameRunningContext.getGameInfo().getVoiceType() != 1) {
                        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)GameNotificationDef.TEAM_GAME_DESTORY, (Object)context.buildGameModel()));
                    }
                    this.autoJoinGameForTest(true);
                }
            } else if (exitType == 9) {
                GameTeamMatchContext teamMatchContext = new GameTeamMatchContext(GameContextDef.JoinFrom.FROM_GAME);
                teamMatchContext.setGameInfo(gameInfo);
                teamMatchContext.setMultiModeCode(((TeamGamePlayContext)context).getModeId());
                teamMatchContext.addExtendValue("coins_game_exit", (Object)this.isGoldGame);
                ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).teamMatchGame(gameInfo, teamMatchContext);
                this.mIsHiddenFinish = true;
            } else if (exitType == 10) {
                GameTeamMatchContext teamMatchContext = new GameTeamMatchContext(GameContextDef.JoinFrom.FROM_PLAY_AGAIN);
                teamMatchContext.setGameInfo(gameInfo);
                teamMatchContext.setMultiModeCode(((TeamGamePlayContext)context).getModeId());
                teamMatchContext.addExtendValue("coins_game_exit", (Object)this.isGoldGame);
                teamMatchContext.setRoomId(context.getRoomId());
                teamMatchContext.setSeatNumber(this.mSeatNumber);
                ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).teamMatchGame(gameInfo, teamMatchContext);
                this.getBaseGameView().destroyGameView();
            } else {
                if (gameInfo.getVoiceType() != 1) {
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)GameNotificationDef.TEAM_GAME_DESTORY, (Object)context.buildGameModel()));
                }
                this.getBaseGameView().destroyGameView();
            }
        }
        super.onGameExitedInner(context, exitType);
    }

    private void goToChannel(@NonNull GamePlayContext context) {
        String channelId = (String)context.getExtendValue("extend_channel_id", (Object)"");
        Message message = Message.obtain();
        message.what = AppbaseMsgDef.ChannelMsgDef.ENTRY_CHANNEL;
        EnterParam enterParam = EnterParam.obtain((String)channelId, (int)29);
        enterParam.pwdToken = (String)this.gameRunningContext.getExtendValue("KEY_CHANNEL_INVITE_TOKEN", (Object)"");
        boolean isFromGameHall = (Boolean)context.getExtendValue("from_game_hall", (Object)false);
        enterParam.subPage = isFromGameHall ? 1 : 0;
        message.obj = enterParam;
        this.sendMessage(message);
    }

    private void autoJoinGameForTest(Boolean isNormalFinish) {
        if (RuntimeContext.sIsDebuggable) {
            boolean isGameRandom = SettingFlags.getBoolean((String)"gameautofirstpagerandom", (boolean)false);
            boolean mEnableAutoTouch = SettingFlags.getBoolean((String)"gameautofirstpage", (boolean)false);
            boolean isGameAutoOpen = SettingFlags.getBoolean((String)"gameautoopen", (boolean)false);
            if (isGameRandom || mEnableAutoTouch) {
                Message message = new Message();
                message.what = BaseMsgDef.MSG_GAME_FIRST_PAGE_AUTO_TEST;
                message.obj = this.gameRunningContext.getGameInfo().getGid();
                this.sendMessage(message);
                return;
            }
        }
    }

    @Override
    public void onGameLoadingFinishInner() {
        super.onGameLoadingFinishInner();
        TeamGameStatisHelper.reportLoadSuccess((TeamGamePlayContext)this.gameRunningContext, this.mGameStartTime);
        TeamGameStatisHelper.reportGameShow((TeamGamePlayContext)this.gameRunningContext);
        GameReportHelper.reportGameInfo(this.gameRunningContext.buildGameModel(), (int)(System.currentTimeMillis() - this.mGameStartTime), this.gameRunningContext.getFrom().getId(), GameStateDef.GAME_FINISH_REASON.LOAD_FINISH.value(), 0, this.isGoldGame);
    }

    @Override
    public void exitRoom(int flag) {
        super.exitRoom(flag);
        GameModel gameModel = this.gameRunningContext.buildGameModel();
        GameDataModel.instance.postGameForceExit(gameModel, this.gameRunningContext.getFrom().getId());
        TeamGameStatisHelper.reportGameExit((TeamGamePlayContext)this.gameRunningContext);
    }

    @Override
    public void onWindowAttach(AbstractWindow abstractWindow) {
        super.onWindowAttach(abstractWindow);
    }

    @Override
    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        ((IGameMessageService)this.getServiceManager().getService(IGameMessageService.class)).unRegisterGameMsgListener(this.mGameMsgListener);
        GameInfo gameInfo = this.gameRunningContext.getGameInfo();
        if (gameInfo.getVoiceType() == 1 && this.mRoomSlot != null && this.mRoomSlot.room != null) {
            boolean isMyMicOpenWhenExit = ((MultiplayerRoom)this.mRoomSlot.room).mMyStatus.isMicOpen();
            this.unBindingRoomData();
            this.mRoomService.leaveRoom(this.mRoomSlot, 5);
            TeamGameStatisHelper.reportMikeStatus((TeamGamePlayContext)this.gameRunningContext, this.mIsMyMicOpenWhenEnter, isMyMicOpenWhenExit);
        }
        if (this.mMessageBarrageViewController != null && this.getBaseGameView() != null) {
            this.mMessageBarrageViewController.onWindowDetach((AbstractWindow)this.getBaseGameView().getGameWindow());
            this.mMessageBarrageViewController = null;
        }
    }

    @Override
    public void onWindowHidden(AbstractWindow abstractWindow) {
        super.onWindowHidden(abstractWindow);
        GameLoger.info("teamGame", "onWindowHidden mIsHiddenFinish\uff1a" + this.mIsHiddenFinish, new Object[0]);
        if (abstractWindow == this.getBaseGameView().getGameWindow() && this.mIsHiddenFinish) {
            AbstractWindow window = abstractWindow;
            YYTaskExecutor.postToMainThread(() -> {
                if (window != null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"teamGame", (String)"onWindowHidden_popWindow", (Object[])new Object[0]);
                    }
                    this.getBaseGameView().destroyGameView();
                }
            });
            this.mIsHiddenFinish = false;
        }
    }

    @Override
    public boolean onWindowKeyEvent(int keyCode, KeyEvent event) {
        boolean retVal = false;
        if (keyCode == 4 && event.getAction() == 1) {
            return true;
        }
        return super.onWindowKeyEvent(keyCode, event);
    }

    @Override
    public void onReceiveGameEvent(final String context, final long seqId, int event, Vector<String> args) {
        super.onReceiveGameEvent(context, seqId, event, args);
        String arg = "";
        if (args != null && args.size() > 0) {
            arg = args.get(0);
        }
        final String reqJson = arg;
        GameLoger.info("teamGame", "JScall type = %s,reqJson=%S", event, reqJson);
        if (CocosProxyType.teamExit.getEvent() == event) {
            YYTaskExecutor.execute((Runnable)new YYTaskExecutor.RunnableEx(){

                public void run() {
                    try {
                        final JsTeamExitBean jsTeamExitBean = (JsTeamExitBean)new Gson().fromJson(reqJson, JsTeamExitBean.class);
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (jsTeamExitBean.getType() == 1) {
                                    TeamGamePlayer.this.exitRoom(9);
                                } else {
                                    TeamGamePlayer.this.exitRoom(5);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        GameLoger.error("teamGame", e);
                    }
                }
            });
        } else if (CocosProxyType.teamPlayAgain.getEvent() == event) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        JsTeamPlayAgainBean jsTeamExitBean = (JsTeamPlayAgainBean)new Gson().fromJson(reqJson, JsTeamPlayAgainBean.class);
                        TeamGamePlayer.this.mSeatNumber = jsTeamExitBean.getSeatNumber();
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TeamGamePlayer.this.exitRoom(10);
                            }
                        });
                    }
                    catch (Throwable e) {
                        YYTaskExecutor.postToMainThread((Runnable)new YYTaskExecutor.RunnableEx(){

                            public void run() {
                                TeamGamePlayer.this.exitRoom(5);
                                GameLoger.error("teamGame", e);
                            }
                        });
                    }
                }
            });
        } else if (CocosProxyType.hideKeyboard.getEvent() == event) {
            GameLoger.info("teamGame", "hideKeyboard event = %s", event);
            YYTaskExecutor.postToMainThread((Runnable)new YYTaskExecutor.RunnableEx(){

                public void run() {
                    ImeUtil.hideIME((Activity)TeamGamePlayer.this.mContext);
                }
            });
        } else if (CocosProxyType.getOpenScene.getEvent() == event) {
            OpenSceneBean openSceneBean = new OpenSceneBean();
            openSceneBean.setOpenScene(this.gameRunningContext.getFrom().getId());
            this.getCocosMessageProxy().getCocosProxyController().callGameFunction(context, seqId, CocosProxyType.getOpenSceneCallBack, (Object)openSceneBean);
        } else if (CocosProxyType.hideBackBtn.getEvent() == event) {
            YYTaskExecutor.postToMainThread((Runnable)new YYTaskExecutor.RunnableEx(){

                public void run() {
                    if (TeamGamePlayer.this.getBaseGameView() != null) {
                        TeamGamePlayer.this.getTopBarController().showBackBtn(false);
                    }
                }
            });
        } else if (CocosProxyType.gameForceExit.getEvent() == event) {
            this.exitRoom(9);
        } else if (CocosProxyType.micStatusQuery.getEvent() == event) {
            YYTaskExecutor.execute((Runnable)new YYTaskExecutor.RunnableEx(){

                public void run() {
                    if (TeamGamePlayer.this.mRoomSlot != null && TeamGamePlayer.this.mRoomSlot.room != null) {
                        try {
                            final long tUid = ((GetRelationBean)JsonParser.parseJsonObject((String)reqJson, GetRelationBean.class)).getUid();
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if (TeamGamePlayer.this.mRoomSlot != null && TeamGamePlayer.this.mRoomSlot.room != null) {
                                        boolean isHaveUser = false;
                                        for (RoomUserMicStatus roomUserMicStatus : ((MultiplayerRoom)TeamGamePlayer.this.mRoomSlot.room).getRoomUserMicStatusList()) {
                                            if (roomUserMicStatus.getUid() != tUid) continue;
                                            isHaveUser = true;
                                            MicStatusBean micStatusBean = new MicStatusBean(Long.valueOf(roomUserMicStatus.getUid()), roomUserMicStatus.isMicOpen() ? 1 : 0);
                                            TeamGamePlayer.this.getCocosMessageProxy().getCocosProxyController().callGameFunction(context, seqId, CocosProxyType.micStatusQueryCallBack, (Object)micStatusBean);
                                        }
                                        if (!isHaveUser) {
                                            MicStatusBean micStatusBean = new MicStatusBean(Long.valueOf(tUid), 0);
                                            TeamGamePlayer.this.getCocosMessageProxy().getCocosProxyController().callGameFunction(context, seqId, CocosProxyType.micStatusQueryCallBack, (Object)micStatusBean);
                                        }
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            GameLoger.error("teamGame", e.getMessage());
                        }
                    }
                }
            });
        } else if (CocosProxyType.showInputBarrageView.getEvent() == event) {
            if (this.mMessageBarrageViewController != null) {
                this.mMessageBarrageViewController.showInputView();
            }
        } else if (CocosProxyType.updateBarrageViewTopPosition.getEvent() == event) {
            if (this.mMessageBarrageViewController != null) {
                this.mMessageBarrageViewController.updateBarrageViewPosition(reqJson);
            }
        } else if (CocosProxyType.postGameResult.getEvent() == event) {
            // empty if block
        }
    }

    @Override
    public CocosProxyType[] getSupportedCocosProxyType() {
        return new CocosProxyType[]{CocosProxyType.teamExit, CocosProxyType.teamPlayAgain, CocosProxyType.hideKeyboard, CocosProxyType.getOpenScene, CocosProxyType.hideBackBtn, CocosProxyType.micStatusQuery, CocosProxyType.gameForceExit, CocosProxyType.showInputBarrageView, CocosProxyType.updateBarrageViewTopPosition, CocosProxyType.postGameResult};
    }

    public void bindingRoomData(RoomSlot<MultiplayerRoom> roomSlot) {
        GameLoger.info("teamGame", "bindingRoomData", new Object[0]);
        if (roomSlot.room != null) {
            if (roomSlot.room != null) {
                this.mBinder.singleBindSourceTo((KvoSource)((MultiplayerRoom)roomSlot.room).mMyStatus);
            }
            this.mBinder.singleBindSourceTo((KvoSource)roomSlot.room);
            if (((TeamGamePlayContext)this.gameRunningContext).getTeamUserInfoList() != null) {
                List teamUserInfos = ((TeamGamePlayContext)this.gameRunningContext).getTeamUserInfoList();
                for (UserInfoKS teamUserInfo : teamUserInfos) {
                    this.bindSpeak(teamUserInfo.getUid(), "onSpeakStatusChange");
                }
            }
        }
    }

    public void unBindingRoomData() {
        GameLoger.info("teamGame", "unRoomDataBinding", new Object[0]);
        this.mBinder.clearAllKvoConnections();
    }

    @KvoMethodAnnotation(sourceClass=RoomUserMicStatus.class, thread=1, name="micOpen")
    public void onMyMicStatusChange(KvoEventIntent event) {
        RoomUserMicStatus roomUserMicStatus = (RoomUserMicStatus)event.source();
        if (roomUserMicStatus == null) {
            return;
        }
        GameLoger.debug("teamGame", "RoomUserMicStatus %s", roomUserMicStatus.isMicOpen());
        this.getTopBarController().updateMicView(roomUserMicStatus.isMicOpen());
        this.sendMicStatus();
    }

    @KvoMethodAnnotation(sourceClass=AbsVoiceRoom.class, name="mRoomUserMicStatusList", thread=1)
    public void onRoomMicStatusChanged(KvoEventIntent event) {
        this.sendMicStatus();
    }

    @KvoMethodAnnotation(name="state", sourceClass=UserSpeakStatus.class, thread=1)
    public void onSpeakStatusChange(KvoEventIntent event) {
        UserSpeakStatus userSpeakStatus = (UserSpeakStatus)event.source();
        if (this.mRoomSlot != null && this.mRoomSlot.room != null) {
            this.sendSpeakingStatus(userSpeakStatus);
        }
    }

    public void bindSpeak(long uid, String targetName) {
        UserSpeakStatus userSpeakBean = (UserSpeakStatus)this.mRoomService.getSpeaks().get(uid);
        if (userSpeakBean == null) {
            userSpeakBean = new UserSpeakStatus(uid, 0);
            this.mRoomService.getSpeaks().put(uid, userSpeakBean);
        }
        this.mBinder.singleBindSourceTo(uid + "", (KvoSource)userSpeakBean);
    }

    public void sendMicStatus() {
        if (this.gameRunningContext.getGameInfo().getVoiceType() != 1) {
            return;
        }
        ArrayList<MicStatusBean> micStatusBeanList = new ArrayList<MicStatusBean>();
        if (this.mRoomSlot != null && this.mRoomSlot.room != null) {
            for (RoomUserMicStatus roomUserMicStatus : ((MultiplayerRoom)this.mRoomSlot.room).getRoomUserMicStatusList()) {
                micStatusBeanList.add(new MicStatusBean(Long.valueOf(roomUserMicStatus.getUid()), roomUserMicStatus.isMicOpen() ? 1 : 0));
            }
        }
        this.getCocosMessageProxy().getCocosProxyController().appNotifyGame(this.gameRunningContext.getRoomId(), CocosProxyType.onMicStatusChange.getEvent(), micStatusBeanList);
    }

    public synchronized void sendSpeakingStatus(UserSpeakStatus speakStatuses) {
        if (speakStatuses == null) {
            return;
        }
        ArrayList<GameUserSpeakStatus> speakStatusesList = new ArrayList<GameUserSpeakStatus>();
        GameUserSpeakStatus gameUserSpeakStatus = new GameUserSpeakStatus(speakStatuses.getUid(), speakStatuses.getStatus());
        speakStatusesList.add(gameUserSpeakStatus);
        if (!this.isExitIng()) {
            this.getCocosMessageProxy().getCocosProxyController().appNotifyGame(this.gameRunningContext.getRoomId(), CocosProxyType.appStateSpeaking.getEvent(), speakStatusesList);
        }
    }

    private void onMicClicked() {
        if (this.mRoomSlot != null && this.mRoomSlot.room != null) {
            if (!((MultiplayerRoom)this.mRoomSlot.room).mMyStatus.isMicOpen()) {
                PermissionHelper.requestRecordAudioPermission((Activity)this.mContext, (IPermissionListener)new IPermissionListener(){

                    public void onPermissionGranted(@NonNull String[] permission) {
                        if (TeamGamePlayer.this.mRoomSlot != null && TeamGamePlayer.this.mRoomSlot.room != null && !((MultiplayerRoom)TeamGamePlayer.this.mRoomSlot.room).mMyStatus.isMicOpen()) {
                            ((MultiplayerRoom)TeamGamePlayer.this.mRoomSlot.room).changeMicStatus(!((MultiplayerRoom)TeamGamePlayer.this.mRoomSlot.room).mMyStatus.isMicOpen());
                        }
                    }

                    public void onPermissionDenied(@NonNull String[] permission) {
                    }
                });
            } else if (this.mRoomSlot != null) {
                ((MultiplayerRoom)this.mRoomSlot.room).changeMicStatus(!((MultiplayerRoom)this.mRoomSlot.room).mMyStatus.isMicOpen());
            }
        }
    }

    @Override
    protected void onBackClick() {
        super.onBackClick();
        String gid = "";
        if (this.gameRunningContext != null && this.gameRunningContext.getGameInfo() != null) {
            gid = this.gameRunningContext.getGameInfo().getGid();
        }
        GameExitHelper.INSTANCE.callBeforeExit(gid, (Function1<? super Boolean, Unit>)new Function1<Boolean, Unit>(){

            public Unit invoke(Boolean needConfirm) {
                if (needConfirm.booleanValue()) {
                    if (TeamGamePlayer.this.getBaseGameView() != null) {
                        String gameExitConfirm = ResourceUtils.getString((int)R.string.team_game_exit_confirm);
                        String ok = ResourceUtils.getString((int)R.string.dialog_btn_yes);
                        String cancel = ResourceUtils.getString((int)R.string.dialog_btn_no);
                        TeamGamePlayer.this.getBaseGameView().showExitConfirmDialog(gameExitConfirm, ok, cancel, new IGameDialogCallback(){

                            public void onOk() {
                                TeamGamePlayer.this.getCocosMessageProxy().getGameProxyService().getBaseService().appGameExit(TeamGamePlayer.this.gameRunningContext.getRoomId());
                            }

                            public void onCancel() {
                            }
                        });
                    }
                } else {
                    TeamGamePlayer.this.getCocosMessageProxy().getGameProxyService().getBaseService().appGameExit(TeamGamePlayer.this.gameRunningContext.getRoomId());
                }
                return null;
            }
        });
    }

    @Override
    public TopBarController getTopBarController() {
        if (this.mTopBarController == null) {
            this.mTopBarController = new TopBarController(new ITopBarUiCallback(){

                @Override
                public void onBackClick() {
                    TeamGamePlayer.this.onBackClick();
                }

                @Override
                public void onMicClick() {
                    TeamGamePlayer.this.onMicClicked();
                }

                @Override
                public void onUserClick(long uid) {
                    if (uid != AccountUtil.getUid()) {
                        TeamGamePlayer.this.showProfileCard(uid);
                    }
                }
            }, this.getEnvironment());
        }
        return this.mTopBarController;
    }

    @Override
    public ExpressBarController getExpressBarController() {
        if (this.mExpressBarController == null) {
            this.mExpressBarController = new ExpressBarController(new IExpressBarUiCallback(){

                @Override
                public void onSendEmotionClick(EmojiBean bean) {
                }
            }, this.getEnvironment());
        }
        return this.mExpressBarController;
    }

    private void sendBarrageMsg(String msg) {
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return;
        }
        UserInfoBean myUserInfo = ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid(), null);
        if (myUserInfo != null) {
            ((IGameMessageService)this.getServiceManager().getService(IGameMessageService.class)).sendMsgReq(this.gameRunningContext.getRoomId(), myUserInfo, msg);
        }
    }

    @Override
    public MessageBarrageViewController getMessageBarrageViewController() {
        if (this.mMessageBarrageViewController == null) {
            this.mMessageBarrageViewController = new MessageBarrageViewController(new IBarrageViewUiCallback(){

                @Override
                public void onSendMessageBarrage(String barrageMsg) {
                    TeamGamePlayer.this.sendBarrageMsg(barrageMsg);
                }
            }, this.getEnvironment());
        }
        return this.mMessageBarrageViewController;
    }

    @Override
    public void initFunViews(RelativeLayout container) {
        GameInfo gameInfo = this.gameRunningContext.getGameInfo();
        AbstractFunctionLayer abstractFunctionLayer = null;
        if (gameInfo.getScreenDire() == 1) {
            abstractFunctionLayer = gameInfo.getRoomTemplate() == 1 ? new VerticalFuntionLayer((Activity)this.mContext, container) : (gameInfo.getRoomTemplate() == 3 ? new EmptyFuntionLayer((Activity)this.mContext, container) : new CustomerFuntionLayer((Activity)this.mContext, container));
        } else if (gameInfo.getScreenDire() == 2) {
            abstractFunctionLayer = gameInfo.getRoomTemplate() == 1 ? new HorizontalFuntionLayer((Activity)this.mContext, container) : (gameInfo.getRoomTemplate() == 3 ? new EmptyFuntionLayer((Activity)this.mContext, container) : new CustomerFuntionLayer((Activity)this.mContext, container));
        }
        if (abstractFunctionLayer != null) {
            abstractFunctionLayer.setCallback(this);
            abstractFunctionLayer.showViews(gameInfo);
        }
    }

    @Override
    public void leaveGameExt() {
        this.exitRoom(5);
    }

    private void reportGame(boolean isStart) {
        String gameId = SharedPreferencesUtils.INSTANCE.getSharedPreferences((Context)this.mContext, GAME_ID, 0).getString(GAME_ID, "");
        if (isStart) {
            if (StringUtils.isNotEmpty((String)gameId)) {
                HiidoStatis.reportReturnCode((String)(CRASH + SharedPreferencesUtils.INSTANCE.getSharedPreferences((Context)this.mContext, GAME_ID, 0).getString(GAME_ID, "")), (long)0L, (String)"");
            }
            GameInfo gameInfo = this.gameRunningContext.getGameInfo();
            gameId = gameInfo.getGid();
            TeamGameStatisHelper.reportGameLoad((TeamGamePlayContext)this.gameRunningContext);
            GameDataModel.instance.postGameMatch(this.gameRunningContext.buildGameModel());
            AppsFlyerHelper.INSTANCE.reportEvent(new AppsFlyerEvent().eventId("entergame"));
        } else {
            gameId = "";
            GameDataModel.instance.postGameLeave(this.gameRunningContext.buildGameModel(), this.gameRunningContext.getFrom().getId());
        }
        SharedPreferences mSharedPreferences = SharedPreferencesUtils.INSTANCE.getSharedPreferences((Context)this.mContext, GAME_ID, 0);
        SharedPreferences.Editor edit = mSharedPreferences.edit();
        edit.putString(GAME_ID, gameId);
        edit.apply();
    }

    public WindowGameView initGameView() {
        GameWindowConfig gameWindowConfig = new GameWindowConfig(this.gameRunningContext.getGameInfo().isSupportFullScreen());
        AbsGameWindow teamGameWindow = new AbsGameWindow((Context)this.mContext, (UICallBacks)this, AbstractWindow.WindowLayerType.USE_ALL_LAYER, gameWindowConfig){

            @Override
            public void initCusFuncView(RelativeLayout container) {
                TeamGamePlayer.this.initFunViews(container);
            }

            @Override
            public void onLoadGameBg(RecycleImageView bgView) {
                LoadGamePageManager.getInstance().loadGameLoadingPage(bgView, sCurGameId);
            }
        };
        if (this.gameRunningContext.getGameInfo().getScreenDire() == 2) {
            teamGameWindow.setScreenOrientationType(0);
        } else {
            teamGameWindow.setScreenOrientationType(3);
        }
        return new WindowGameView(teamGameWindow, this.mIWindowGameViewCallback);
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface JsExitType {
        public static final int EXIT_HOME = 0;
        public static final int EXIT_TEAM = 1;
    }
}

