/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.source;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.game.R;
import com.yy.game.gamemodule.source.GameSourceInfo;
import com.yy.game.gamemodule.source.GameSourceListAdapter;
import com.yy.game.gamemodule.source.IGameSourceUiCallback;
import com.yy.game.gamemodule.source.SourceFilterType;
import com.yy.game.gamemodule.source.filter.FilterView;
import com.yy.game.gamemodule.source.filter.IFilterListener;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0002J\b\u0010 \u001a\u00020\u001eH\u0016J\u001d\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0000\u00a2\u0006\u0002\b&J#\u0010'\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0000\u00a2\u0006\u0002\b+J\b\u0010,\u001a\u00020\u001eH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/yy/game/gamemodule/source/GameSourceWindow;", "Lcom/yy/framework/core/ui/DefaultWindow;", "context", "Landroid/content/Context;", "callBacks", "Lcom/yy/framework/core/ui/UICallBacks;", "name", "", "(Landroid/content/Context;Lcom/yy/framework/core/ui/UICallBacks;Ljava/lang/String;)V", "mAdapter", "Lcom/yy/game/gamemodule/source/GameSourceListAdapter;", "mCallback", "Lcom/yy/game/gamemodule/source/IGameSourceUiCallback;", "mFilterMark", "Landroid/view/View;", "mFilterView", "Lcom/yy/game/gamemodule/source/filter/FilterView;", "mLastY", "", "mListView", "Landroidx/recyclerview/widget/RecyclerView;", "mScrollChangeY", "mTipsBottom", "", "mTipsView", "Landroid/widget/TextView;", "mTipsY", "mTitleBar", "Lcom/yy/appbase/ui/widget/bar/SimpleTitleBar;", "hideFilter", "", "initTitleBar", "onShown", "select", "type", "Lcom/yy/game/gamemodule/source/SourceFilterType;", "desc", "", "select$game_debug", "setDownloadGame", "list", "", "Lcom/yy/game/gamemodule/source/GameSourceInfo;", "setDownloadGame$game_debug", "showFilter", "game_debug"})
public final class GameSourceWindow
extends DefaultWindow {
    private final SimpleTitleBar mTitleBar;
    private final RecyclerView mListView;
    private final TextView mTipsView;
    private final FilterView mFilterView;
    private final View mFilterMark;
    private IGameSourceUiCallback mCallback;
    private float mTipsY;
    private float mTipsBottom;
    private int mScrollChangeY;
    private int mLastY;
    private GameSourceListAdapter mAdapter;
    private HashMap _$_findViewCache;

    public void onShown() {
        super.onShown();
        this.setBackgroundToNull();
    }

    public final void setDownloadGame$game_debug(@NotNull SourceFilterType type, @NotNull List<GameSourceInfo> list) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        this.mAdapter.setData(type, list);
    }

    public final void select$game_debug(@NotNull SourceFilterType type, boolean desc) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        this.mFilterView.select(type, desc);
    }

    private final void initTitleBar() {
        this.mTitleBar.setLeftTitle(ResourceUtils.getString((int)R.string.title_source_manager));
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(this){
            final /* synthetic */ GameSourceWindow this$0;

            public final void onClick(View it) {
                block0: {
                    IGameSourceUiCallback iGameSourceUiCallback = GameSourceWindow.access$getMCallback$p(this.this$0);
                    if (iGameSourceUiCallback == null) break block0;
                    iGameSourceUiCallback.goBack();
                }
            }
            {
                this.this$0 = gameSourceWindow;
            }
        });
        this.mTitleBar.setRightBtn(R.drawable.icon_game_source_filter, new View.OnClickListener(this){
            final /* synthetic */ GameSourceWindow this$0;

            public final void onClick(View it) {
                GameSourceWindow.access$showFilter(this.this$0);
            }
            {
                this.this$0 = gameSourceWindow;
            }
        });
    }

    private final void showFilter() {
        this.mFilterMark.setVisibility(0);
        this.mFilterView.setVisibility(0);
    }

    private final void hideFilter() {
        this.mFilterMark.setVisibility(8);
        this.mFilterView.setVisibility(8);
    }

    public GameSourceWindow(@NotNull Context context, @NotNull UICallBacks callBacks, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)callBacks, (String)"callBacks");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        super(context, callBacks, name);
        if (callBacks instanceof IGameSourceUiCallback) {
            this.mCallback = (IGameSourceUiCallback)callBacks;
        }
        this.setBackgroundColor(-1);
        View rootView = LayoutInflater.from((Context)context).inflate(R.layout.layout_game_source_page, this.getBaseLayer(), true);
        View view = rootView.findViewById(R.id.title_bar);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"rootView.findViewById(R.id.title_bar)");
        this.mTitleBar = (SimpleTitleBar)view;
        View view2 = rootView.findViewById(R.id.list_view);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"rootView.findViewById(R.id.list_view)");
        this.mListView = (RecyclerView)view2;
        View view3 = rootView.findViewById(R.id.bottom_tips);
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"rootView.findViewById(R.id.bottom_tips)");
        this.mTipsView = (TextView)view3;
        View view4 = rootView.findViewById(R.id.filter_view);
        Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"rootView.findViewById(R.id.filter_view)");
        this.mFilterView = (FilterView)view4;
        View view5 = rootView.findViewById(R.id.filter_mark);
        Intrinsics.checkExpressionValueIsNotNull((Object)view5, (String)"rootView.findViewById(R.id.filter_mark)");
        this.mFilterMark = view5;
        this.mListView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        this.mTipsView.post(new Runnable(){

            @Override
            public final void run() {
                mTipsY = mTipsView.getTranslationY();
                mTipsBottom = mTipsY + (float)mTipsView.getHeight();
            }
        });
        this.initTitleBar();
        IGameSourceUiCallback iGameSourceUiCallback = this.mCallback;
        if (iGameSourceUiCallback == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.yy.game.gamemodule.source.IHolderListener");
        }
        this.mAdapter = new GameSourceListAdapter(iGameSourceUiCallback);
        this.mListView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mFilterMark.setOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                this.hideFilter();
            }
        });
        this.mFilterView.setListener(new IFilterListener(){

            @Override
            public void onSelected(@NotNull SourceFilterType type, boolean isDesc) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
                IGameSourceUiCallback iGameSourceUiCallback = mCallback;
                if (iGameSourceUiCallback != null) {
                    iGameSourceUiCallback.onSelected(type, isDesc);
                }
                this.hideFilter();
            }
        });
        this.mListView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
                Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
                super.onScrolled(recyclerView, dx, dy);
                if (mTipsView.getTranslationY() >= mTipsBottom && mLastY > 0 && dy < 0) {
                    mScrollChangeY = dy;
                } else if (mTipsView.getTranslationY() <= mTipsY && mLastY < 0 && dy > 0) {
                    mScrollChangeY = dy;
                }
                mLastY = dy;
                GameSourceWindow gameSourceWindow = this;
                gameSourceWindow.mScrollChangeY = gameSourceWindow.mScrollChangeY + dy;
                float scrollY = (float)mScrollChangeY + mTipsView.getTranslationY();
                if (scrollY < mTipsY) {
                    scrollY = mTipsY;
                } else if (scrollY > mTipsBottom) {
                    scrollY = mTipsBottom;
                }
                mTipsView.setTranslationY(scrollY);
            }

            public void onScrollStateChanged(@NotNull RecyclerView recyclerView, int newState) {
                Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
                super.onScrollStateChanged(recyclerView, newState);
                if (newState == 0) {
                    if (mLastY < 0) {
                        mTipsView.setTranslationY(mTipsY);
                    } else if (mLastY > 0) {
                        mTipsView.setTranslationY(mTipsBottom);
                    }
                }
            }
        });
    }

    public static final /* synthetic */ void access$setMCallback$p(GameSourceWindow $this, IGameSourceUiCallback iGameSourceUiCallback) {
        $this.mCallback = iGameSourceUiCallback;
    }

    public static final /* synthetic */ void access$showFilter(GameSourceWindow $this) {
        $this.showFilter();
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

