/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.source;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.game.R;
import com.yy.game.gamemodule.source.GameSourceHolder$WhenMappings;
import com.yy.game.gamemodule.source.GameSourceInfo;
import com.yy.game.gamemodule.source.IHolderListener;
import com.yy.game.gamemodule.source.SourceFilterType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0016\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/yy/game/gamemodule/source/GameSourceHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "listener", "Lcom/yy/game/gamemodule/source/IHolderListener;", "itemView", "Landroid/view/View;", "(Lcom/yy/game/gamemodule/source/IHolderListener;Landroid/view/View;)V", "delete", "Landroid/widget/ImageView;", "gameDesc", "Landroid/widget/TextView;", "gameIcon", "Lcom/yy/appbase/ui/widget/image/RoundImageView;", "gameName", "mBinder", "Lcom/yy/base/event/kvo/helper/KvoBinder;", "sourceInfo", "Lcom/yy/game/gamemodule/source/GameSourceInfo;", "type", "Lcom/yy/game/gamemodule/source/SourceFilterType;", "onUpdateCount", "", "event", "Lcom/yy/base/event/kvo/KvoEventIntent;", "update", "info", "game_debug"})
public final class GameSourceHolder
extends RecyclerView.ViewHolder {
    private final RoundImageView gameIcon;
    private final TextView gameName;
    private final TextView gameDesc;
    private final ImageView delete;
    private GameSourceInfo sourceInfo;
    private SourceFilterType type;
    private final KvoBinder mBinder;

    public final void update(@NotNull SourceFilterType type, @NotNull GameSourceInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)((Object)info), (String)"info");
        if (type == SourceFilterType.PLAY_COUNT && (this.sourceInfo == null || info != this.sourceInfo)) {
            this.mBinder.singleBindSourceTo((KvoSource)info);
        }
        this.type = type;
        this.sourceInfo = info;
        ImageLoader.loadImage((RecycleImageView)((RecycleImageView)this.gameIcon), (String)info.getIconUrl());
        this.gameName.setText((CharSequence)info.getName());
        switch (GameSourceHolder$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                this.gameDesc.setText((CharSequence)ResourceUtils.getString((int)R.string.title_source_size, (Object[])new Object[]{info.getFileSize()}));
                break;
            }
            case 2: {
                this.gameDesc.setText((CharSequence)ResourceUtils.getString((int)R.string.title_source_last_play, (Object[])new Object[]{info.getPlayTime()}));
                break;
            }
            case 3: {
                this.gameDesc.setText((CharSequence)ResourceUtils.getString((int)R.string.title_source_play_count, (Object[])new Object[]{info.getPlayCount()}));
            }
        }
    }

    @KvoMethodAnnotation(sourceClass=GameSourceInfo.class, name="playCount", thread=1)
    public final void onUpdateCount(@NotNull KvoEventIntent event) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            MLog.debug((Object)"GameSourceHolder", (String)"onUpdateCount old: %d, %d", (Object[])new Object[]{event.oldValue(), event.newValue()});
            GameSourceInfo gameSourceInfo = this.sourceInfo;
            if (gameSourceInfo == null) break block2;
            GameSourceInfo gameSourceInfo2 = gameSourceInfo;
            boolean bl = false;
            boolean bl2 = false;
            GameSourceInfo it = gameSourceInfo2;
            boolean bl3 = false;
            if (this.type == null || this.type != SourceFilterType.PLAY_COUNT) {
                return;
            }
            if (Intrinsics.areEqual((Object)((GameSourceInfo)event.source()).getGid(), (Object)it.getGid())) {
                this.gameDesc.setText((CharSequence)ResourceUtils.getString((int)R.string.title_source_play_count, (Object[])new Object[]{it.getPlayCount()}));
            }
        }
    }

    public GameSourceHolder(final @Nullable IHolderListener listener, @NotNull View itemView) {
        Intrinsics.checkParameterIsNotNull((Object)itemView, (String)"itemView");
        super(itemView);
        View view = itemView.findViewById(R.id.game_icon);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView.findViewById(R.id.game_icon)");
        this.gameIcon = (RoundImageView)view;
        View view2 = itemView.findViewById(R.id.game_name);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"itemView.findViewById(R.id.game_name)");
        this.gameName = (TextView)view2;
        View view3 = itemView.findViewById(R.id.source_des);
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"itemView.findViewById(R.id.source_des)");
        this.gameDesc = (TextView)view3;
        View view4 = itemView.findViewById(R.id.delete_icon);
        Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"itemView.findViewById(R.id.delete_icon)");
        this.delete = (ImageView)view4;
        this.mBinder = new KvoBinder((Object)this);
        itemView.setOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                block1: {
                    GameSourceInfo gameSourceInfo = sourceInfo;
                    if (gameSourceInfo == null) break block1;
                    GameSourceInfo gameSourceInfo2 = gameSourceInfo;
                    boolean bl = false;
                    boolean bl2 = false;
                    GameSourceInfo it2 = gameSourceInfo2;
                    boolean bl3 = false;
                    IHolderListener iHolderListener = listener;
                    if (iHolderListener != null) {
                        iHolderListener.onClick(it2);
                    }
                }
            }
        });
        this.delete.setOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                block1: {
                    GameSourceInfo gameSourceInfo = sourceInfo;
                    if (gameSourceInfo == null) break block1;
                    GameSourceInfo gameSourceInfo2 = gameSourceInfo;
                    boolean bl = false;
                    boolean bl2 = false;
                    GameSourceInfo it2 = gameSourceInfo2;
                    boolean bl3 = false;
                    IHolderListener iHolderListener = listener;
                    if (iHolderListener != null) {
                        iHolderListener.onDelete(it2);
                    }
                }
            }
        });
    }

    public static final /* synthetic */ void access$setSourceInfo$p(GameSourceHolder $this, GameSourceInfo gameSourceInfo) {
        $this.sourceInfo = gameSourceInfo;
    }
}

