/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.source;

import android.content.Context;
import android.os.Message;
import androidx.fragment.app.FragmentActivity;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.GameHistoryBean;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.callback.OnGameHistoryCallback;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.appbase.ui.dialog.OkCancelTitleDialog;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.game.R;
import com.yy.game.download.version.GameVersion;
import com.yy.game.download.version.GameVersionInfo;
import com.yy.game.gamemodule.source.GameSourceController;
import com.yy.game.gamemodule.source.GameSourceController$WhenMappings;
import com.yy.game.gamemodule.source.GameSourceInfo;
import com.yy.game.gamemodule.source.GameSourceWindow;
import com.yy.game.gamemodule.source.IGameSourceUiCallback;
import com.yy.game.gamemodule.source.SourceFilterType;
import com.yy.hiyo.game.base.bean.BasicGameInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tH\u0002J\b\u0010\u001c\u001a\u00020\u001aH\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0002J\b\u0010\u001e\u001a\u00020\u001aH\u0016J\u0012\u0010\u001f\u001a\u00020\u001a2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\fH\u0016J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\fH\u0016J\u0018\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u0012\u0010'\u001a\u00020\u001a2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0012\u0010*\u001a\u00020\u001a2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\fH\u0002J\u0018\u0010,\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\f2\u0006\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020\u001aH\u0002J,\u00100\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\f022\u0006\u0010&\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\u0016\u00103\u001a\u00020\u001a2\f\u00101\u001a\b\u0012\u0004\u0012\u00020402H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/yy/game/gamemodule/source/GameSourceController;", "Lcom/yy/appbase/core/DefaultController;", "Lcom/yy/game/gamemodule/source/IGameSourceUiCallback;", "env", "Lcom/yy/framework/core/Environment;", "(Lcom/yy/framework/core/Environment;)V", "MB", "", "TAG", "", "mGameList", "", "Lcom/yy/game/gamemodule/source/GameSourceInfo;", "mSelectedDesc", "", "mSelectedType", "Lcom/yy/game/gamemodule/source/SourceFilterType;", "mWindow", "Lcom/yy/game/gamemodule/source/GameSourceWindow;", "compareDouble", "", "dif", "isDesc", "compareLong", "", "deleteGame", "", "gid", "fetchAlreadyDownloadGame", "fetchGameHistory", "goBack", "handleMessage", "msg", "Landroid/os/Message;", "onClick", "info", "onDelete", "onSelected", "type", "onWindowDetach", "abstractWindow", "Lcom/yy/framework/core/ui/AbstractWindow;", "onWindowShown", "showDeleteDialog", "showEnterDialog", "gameInfo", "Lcom/yy/hiyo/game/base/bean/GameInfo;", "showPage", "sortSource", "list", "", "updateCount", "Lcom/yy/appbase/data/GameHistoryBean;", "game_debug"})
public final class GameSourceController
extends DefaultController
implements IGameSourceUiCallback {
    private final String TAG = "GameSourceController";
    private final double MB = 1048576.0;
    private SourceFilterType mSelectedType;
    private boolean mSelectedDesc;
    private GameSourceWindow mWindow;
    private List<GameSourceInfo> mGameList;

    public void handleMessage(@Nullable Message msg) {
        block1: {
            super.handleMessage(msg);
            Message message = msg;
            if (message == null) break block1;
            Message message2 = message;
            boolean bl = false;
            boolean bl2 = false;
            Message it = message2;
            boolean bl3 = false;
            int n = msg.what;
            if (n == AppbaseMsgDef.OPEN_GAME_SOURCE_PAGE) {
                this.showPage();
            }
        }
    }

    @Override
    public void onDelete(@NotNull GameSourceInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)info), (String)"info");
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20035113").put("function_id", "delete_game").put("gid", info.getGid()).put("sort_size", "" + (double)GameVersion.INSTANCE.getTotalSize() / this.MB));
        this.showDeleteDialog(info);
    }

    @Override
    public void onClick(@NotNull GameSourceInfo info) {
        GameInfo gameInfo;
        Intrinsics.checkParameterIsNotNull((Object)((Object)info), (String)"info");
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20035113").put("function_id", "enter_game").put("gid", info.getGid()));
        IServiceManager iServiceManager = this.getServiceManager();
        GameInfo gameInfo2 = iServiceManager != null && (iServiceManager = (IGameInfoService)iServiceManager.getService(IGameInfoService.class)) != null ? iServiceManager.getGameInfoByGid(info.getGid()) : (gameInfo = null);
        if (gameInfo == null || !GameVersion.INSTANCE.isGameInfoValid((BasicGameInfo)gameInfo)) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_need_update, (int)0);
        } else {
            this.showEnterDialog(info, gameInfo);
        }
    }

    @Override
    public void onSelected(@NotNull SourceFilterType type, boolean isDesc) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        this.mSelectedDesc = this.mSelectedType == type ? !isDesc : isDesc;
        this.mSelectedType = type;
        GameSourceWindow gameSourceWindow = this.mWindow;
        if (gameSourceWindow != null) {
            GameSourceWindow gameSourceWindow2 = gameSourceWindow;
            boolean bl = false;
            boolean bl2 = false;
            GameSourceWindow it = gameSourceWindow2;
            boolean bl3 = false;
            it.select$game_debug(this.mSelectedType, this.mSelectedDesc);
            this.fetchAlreadyDownloadGame();
        }
        switch (GameSourceController$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                if (isDesc) {
                    string2 = "1";
                    break;
                }
                string2 = "2";
                break;
            }
            case 2: {
                if (isDesc) {
                    string2 = "3";
                    break;
                }
                string2 = "4";
                break;
            }
            case 3: {
                if (isDesc) {
                    string2 = "5";
                    break;
                }
                string2 = "6";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String sortType = string2;
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20035113").put("function_id", "sort").put("sort_type", sortType));
    }

    @Override
    public void goBack() {
        block0: {
            GameSourceWindow gameSourceWindow = this.mWindow;
            if (gameSourceWindow == null) break block0;
            GameSourceWindow gameSourceWindow2 = gameSourceWindow;
            boolean bl = false;
            boolean bl2 = false;
            GameSourceWindow it = gameSourceWindow2;
            boolean bl3 = false;
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
        }
    }

    private final void showPage() {
        if (this.mWindow == null) {
            FragmentActivity fragmentActivity = this.mContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity, (String)"mContext");
            this.mWindow = new GameSourceWindow((Context)fragmentActivity, (UICallBacks)this, "GameSource");
            this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
            GameSourceWindow gameSourceWindow = this.mWindow;
            if (gameSourceWindow != null) {
                gameSourceWindow.select$game_debug(this.mSelectedType, this.mSelectedDesc);
            }
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20035113").put("function_id", "show"));
        }
    }

    public void onWindowShown(@Nullable AbstractWindow abstractWindow) {
        super.onWindowShown(abstractWindow);
        if (this.mWindow == null) {
            return;
        }
        this.fetchAlreadyDownloadGame();
    }

    private final void fetchAlreadyDownloadGame() {
        block4: {
            List<GameVersionInfo> list = GameVersion.INSTANCE.getDownloadGame();
            boolean bl = false;
            List sourceList = new ArrayList();
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GameInfo gameInfo;
                GameVersionInfo it = (GameVersionInfo)element$iv;
                boolean bl2 = false;
                GameInfo gameInfo2 = ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(it.getGameId$game_debug());
                if (gameInfo2 == null) {
                    MLog.error((Object)this.TAG, (String)"game info is null gid: %s", (Object[])new Object[]{it.getGameId$game_debug()});
                }
                if (gameInfo2 == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                GameInfo info = gameInfo;
                boolean bl5 = false;
                String date = it.getLastPlay$game_debug() > 0L ? DateUtils.dateToString((long)it.getLastPlay$game_debug(), (String)"yyyy.MM.dd") : "";
                double size = (double)it.getSize$game_debug() / this.MB;
                String string2 = it.getGameId$game_debug();
                String string3 = info.getIconUrl();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"info.iconUrl");
                String string4 = info.getGname();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"info.gname");
                long l = it.getLastPlay$game_debug();
                String string5 = date;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"date");
                GameSourceInfo source = new GameSourceInfo(string2, string3, string4, l, string5, size, it.getCount$game_debug());
                sourceList.add(source);
            }
            this.mGameList = this.sortSource(sourceList, this.mSelectedType, this.mSelectedDesc);
            if (this.mSelectedType == SourceFilterType.PLAY_COUNT) {
                this.fetchGameHistory();
            }
            List<GameSourceInfo> list2 = this.mGameList;
            if (list2 == null) break block4;
            List<GameSourceInfo> list3 = list2;
            boolean bl6 = false;
            boolean bl7 = false;
            List<GameSourceInfo> it = list3;
            boolean bl8 = false;
            GameSourceWindow gameSourceWindow = this.mWindow;
            if (gameSourceWindow != null) {
                gameSourceWindow.setDownloadGame$game_debug(this.mSelectedType, it);
            }
        }
    }

    private final void fetchGameHistory() {
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getGameHistory(AccountUtil.getUid(), new OnGameHistoryCallback(this){
            final /* synthetic */ GameSourceController this$0;

            public void onError(@Nullable Call call, @Nullable Exception e, int id2) {
                MLog.error((Object)GameSourceController.access$getTAG$p(this.this$0), (String)"fetchGameHistory ", (Throwable)e, (Object[])new Object[0]);
            }

            public void onResponseError(int id2, @Nullable String message, @Nullable String response) {
                MLog.error((Object)GameSourceController.access$getTAG$p(this.this$0), (String)"fetchGameHistory message: %s", (Object[])new Object[]{message});
            }

            public void onUISuccess(@Nullable List<GameHistoryBean> list, int id2) {
                block0: {
                    List<GameHistoryBean> list2 = list;
                    if (list2 == null) break block0;
                    List<GameHistoryBean> list3 = list2;
                    boolean bl = false;
                    boolean bl2 = false;
                    List<GameHistoryBean> it = list3;
                    boolean bl3 = false;
                    GameSourceController.access$updateCount(this.this$0, it);
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void updateCount(List<GameHistoryBean> list) {
        if (FP.empty((Collection)this.mGameList)) {
            return;
        }
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List<GameSourceInfo> list2;
            GameHistoryBean history = (GameHistoryBean)element$iv;
            boolean bl = false;
            boolean changed = false;
            if (this.mGameList == null) continue;
            boolean bl2 = false;
            boolean bl3 = false;
            List<GameSourceInfo> gameList = list2;
            boolean bl4 = false;
            Iterable $this$forEach$iv2 = gameList;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                GameSourceInfo it = (GameSourceInfo)((Object)element$iv2);
                boolean bl5 = false;
                if (!Intrinsics.areEqual((Object)history.gameId, (Object)it.getGid())) continue;
                MLog.debug((Object)this.TAG, (String)"updateCount gid: %s, playCount: %d, totalCount: %d", (Object[])new Object[]{it.getGid(), it.getPlayCount(), history.totalCount});
                if (it.getPlayCount() == history.totalCount) continue;
                it.setValue("playCount", history.totalCount);
                changed = true;
            }
            if (!changed) continue;
            boolean bl6 = false;
            List sortList = new ArrayList();
            sortList.addAll((Collection)gameList);
            this.mGameList = this.sortSource(sortList, this.mSelectedType, this.mSelectedDesc);
            GameSourceWindow gameSourceWindow = this.mWindow;
            if (gameSourceWindow == null) continue;
            List<GameSourceInfo> list3 = this.mGameList;
            if (list3 == null) {
                Intrinsics.throwNpe();
            }
            gameSourceWindow.setDownloadGame$game_debug(this.mSelectedType, list3);
        }
    }

    private final List<GameSourceInfo> sortSource(List<GameSourceInfo> list, SourceFilterType type, boolean isDesc) {
        CollectionsKt.sortWith(list, (Comparator)new Comparator<GameSourceInfo>(this, isDesc, type){
            final /* synthetic */ GameSourceController this$0;
            final /* synthetic */ boolean $isDesc;
            final /* synthetic */ SourceFilterType $type;

            public int compare(@Nullable GameSourceInfo o1, @Nullable GameSourceInfo o2) {
                if (Intrinsics.areEqual((Object)((Object)o1), (Object)((Object)o2))) {
                    return 0;
                }
                if (o1 == null) {
                    return this.$isDesc ? -1 : 1;
                }
                if (o2 == null) {
                    return this.$isDesc ? 1 : -1;
                }
                switch (GameSourceController$WhenMappings.$EnumSwitchMapping$1[this.$type.ordinal()]) {
                    case 1: {
                        double dif = o1.getFileSize() - o2.getFileSize();
                        return GameSourceController.access$compareDouble(this.this$0, dif, this.$isDesc);
                    }
                    case 2: {
                        long dif = o1.getPlayStamp() - o2.getPlayStamp();
                        return GameSourceController.access$compareLong(this.this$0, dif, this.$isDesc);
                    }
                    case 3: {
                        int dif = o1.getPlayCount() - o2.getPlayCount();
                        return GameSourceController.access$compareLong(this.this$0, dif, this.$isDesc);
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            {
                this.this$0 = $outer;
                this.$isDesc = $captured_local_variable$1;
                this.$type = $captured_local_variable$2;
            }
        });
        return list;
    }

    private final int compareDouble(double dif, boolean isDesc) {
        return dif > 0.0 ? (isDesc ? -1 : 1) : (dif < 0.0 ? (isDesc ? 1 : -1) : 0);
    }

    private final int compareLong(long dif, boolean isDesc) {
        return dif > 0L ? (isDesc ? -1 : 1) : (dif < 0L ? (isDesc ? 1 : -1) : 0);
    }

    public void onWindowDetach(@Nullable AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (Intrinsics.areEqual((Object)((Object)this.mWindow), (Object)abstractWindow)) {
            this.mWindow = null;
        }
    }

    private final void showDeleteDialog(GameSourceInfo info) {
        OkCancelTitleDialog dialog2 = OkCancelTitleDialog.newBuilder().title((CharSequence)ResourceUtils.getString((int)R.string.title_delete, (Object[])new Object[]{info.getName()})).message((CharSequence)ResourceUtils.getString((int)R.string.tips_delete)).okLabel((CharSequence)ResourceUtils.getString((int)R.string.btn_ok)).setCancelLabel((CharSequence)ResourceUtils.getString((int)R.string.cancel)).listener(new OkCancelDialogListener(this, info){
            final /* synthetic */ GameSourceController this$0;
            final /* synthetic */ GameSourceInfo $info;

            public void onCancel() {
            }

            public void onOk() {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20035113").put("function_id", "delete_confirm").put("gid", this.$info.getGid()).put("sort_size", "" + (double)GameVersion.INSTANCE.getTotalSize() / GameSourceController.access$getMB$p(this.this$0)));
                GameSourceController.access$deleteGame(this.this$0, this.$info.getGid());
            }
            {
                this.this$0 = $outer;
                this.$info = $captured_local_variable$1;
            }
        }).build();
        this.mDialogLinkManager.showDialog((BaseDialog)dialog2);
    }

    private final void showEnterDialog(GameSourceInfo info, GameInfo gameInfo) {
        OkCancelDialog dialog2 = new OkCancelDialog(new OkCancelDialog.Builder().message((CharSequence)ResourceUtils.getString((int)R.string.title_enter, (Object[])new Object[]{info.getName()})).okLabel((CharSequence)ResourceUtils.getString((int)R.string.btn_ok)).setCancelLabel((CharSequence)ResourceUtils.getString((int)R.string.cancel)).cancelable(true).outSideCancelable(false).withCloseBtn(false).listener(new OkCancelDialogListener(this, info){
            final /* synthetic */ GameSourceController this$0;
            final /* synthetic */ GameSourceInfo $info;

            public void onCancel() {
            }

            public void onOk() {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20035113").put("function_id", "enter_confirm").put("gid", this.$info.getGid()));
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
                    final /* synthetic */ showEnterDialog.dialog.1 this$0;

                    public final void run() {
                        Message msg = Message.obtain();
                        msg.what = BaseMsgDef.MSG_GAME_JUMP_MAIN_PAGE;
                        msg.obj = this.this$0.$info.getGid();
                        this.this$0.this$0.sendMessage(msg);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, (long)500L);
            }
            {
                this.this$0 = $outer;
                this.$info = $captured_local_variable$1;
            }
        }));
        this.mDialogLinkManager.showDialog((BaseDialog)dialog2);
    }

    private final void deleteGame(String gid) {
        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_source_delete_game, (int)0);
        YYTaskExecutor.execute((Runnable)new Runnable(this, gid){
            final /* synthetic */ GameSourceController this$0;
            final /* synthetic */ String $gid;

            public final void run() {
                GameVersion.deleteGame$default(GameVersion.INSTANCE, this.$gid, false, false, 6, null);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
                    final /* synthetic */ deleteGame.1 this$0;

                    public final void run() {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_source_delete_game_finish, (int)0);
                        GameSourceController.access$fetchAlreadyDownloadGame(this.this$0.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = gameSourceController;
                this.$gid = string2;
            }
        });
    }

    public GameSourceController(@NotNull Environment env) {
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        super(env);
        this.TAG = "GameSourceController";
        this.MB = 1048576.0;
        this.mSelectedType = SourceFilterType.SIZE;
        this.mSelectedDesc = true;
    }

    public static final /* synthetic */ String access$getTAG$p(GameSourceController $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ void access$updateCount(GameSourceController $this, List list) {
        $this.updateCount(list);
    }

    public static final /* synthetic */ int access$compareDouble(GameSourceController $this, double dif, boolean isDesc) {
        return $this.compareDouble(dif, isDesc);
    }

    public static final /* synthetic */ int access$compareLong(GameSourceController $this, long dif, boolean isDesc) {
        return $this.compareLong(dif, isDesc);
    }

    public static final /* synthetic */ double access$getMB$p(GameSourceController $this) {
        return $this.MB;
    }

    public static final /* synthetic */ void access$deleteGame(GameSourceController $this, String gid) {
        $this.deleteGame(gid);
    }

    public static final /* synthetic */ void access$fetchAlreadyDownloadGame(GameSourceController $this) {
        $this.fetchAlreadyDownloadGame();
    }
}

