/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.single.list.widget;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ViewGroup;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.game.R;
import com.yy.game.gamemodule.simplegame.single.list.data.SingleGameMiddleInfo;

public class SingleGameRecordItemView
extends YYLinearLayout {
    private static final int alphaWhite = Color.parseColor((String)"#80ffffff");
    private YYTextView mTop;
    private YYTextView mBottom;

    public SingleGameRecordItemView(Context context) {
        this(context, null);
    }

    public SingleGameRecordItemView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SingleGameRecordItemView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        SingleGameRecordItemView.inflate((Context)this.getContext(), (int)R.layout.layout_single_game_record_item_view, (ViewGroup)this);
        this.mTop = (YYTextView)this.findViewById(R.id.tv_top);
        this.mBottom = (YYTextView)this.findViewById(R.id.tv_bottom);
        this.mTop.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
    }

    public void refreshUI(SingleGameMiddleInfo gameMiddleInfo, int itemType) {
        if (gameMiddleInfo == null) {
            return;
        }
        if (itemType == 0) {
            if (TextUtils.isEmpty((CharSequence)gameMiddleInfo.recentPlayDate)) {
                this.mTop.setText((CharSequence)"-");
            } else {
                this.mTop.setText((CharSequence)String.valueOf(gameMiddleInfo.recentScore));
            }
            this.mTop.setTextSize(2, 35.0f);
            this.mBottom.setVisibility(0);
            this.mBottom.setTextSize(2, 13.0f);
            if (!TextUtils.isEmpty((CharSequence)gameMiddleInfo.scoreType)) {
                this.mBottom.setText((CharSequence)gameMiddleInfo.scoreType.toUpperCase());
            } else {
                this.mBottom.setText(R.string.single_game_middle_page_record_stages);
            }
            this.mBottom.setTextColor(alphaWhite);
        } else if (itemType == 1) {
            this.mTop.setText((CharSequence)ResourceUtils.getString((int)R.string.single_game_list_no_recent_record));
            this.mTop.setTextSize(2, 15.0f);
            this.mBottom.setVisibility(8);
        } else if (itemType == 2) {
            this.mTop.setText((CharSequence)String.valueOf(gameMiddleInfo.todayBest));
            this.mTop.setTextSize(2, 35.0f);
            this.mBottom.setVisibility(0);
            this.mBottom.setTextSize(2, 13.0f);
            if (!TextUtils.isEmpty((CharSequence)gameMiddleInfo.scoreType)) {
                this.mBottom.setText((CharSequence)gameMiddleInfo.scoreType.toUpperCase());
            } else {
                this.mBottom.setText(R.string.single_game_middle_page_record_stages);
            }
            this.mBottom.setTextColor(alphaWhite);
        } else if (itemType == 3) {
            if (TextUtils.isEmpty((CharSequence)gameMiddleInfo.recentPlayDate)) {
                this.mTop.setText((CharSequence)"-");
            } else {
                this.mTop.setText((CharSequence)String.valueOf(gameMiddleInfo.recentPlayDate));
            }
            this.mTop.setTextSize(2, 35.0f);
            this.mBottom.setVisibility(0);
            this.mBottom.setBackgroundToNull();
            this.mBottom.setTextSize(2, 13.0f);
            this.mBottom.setText(R.string.single_game_middle_page_record_date);
            this.mBottom.setTextColor(alphaWhite);
        } else if (itemType == 4) {
            this.mTop.setText((CharSequence)String.valueOf(gameMiddleInfo.rank));
            this.mTop.setTextSize(2, 35.0f);
            this.mBottom.setVisibility(0);
            this.mBottom.setTextSize(2, 11.0f);
            this.mBottom.setText(R.string.single_game_middle_page_rank_top_three);
            this.mBottom.setTextColor(-1);
            this.mBottom.setBackgroundResource(R.drawable.single_game_list_middle_item_rank_top_three);
        } else if (itemType == 5) {
            this.mTop.setText((CharSequence)String.valueOf(gameMiddleInfo.rank));
            this.mTop.setTextSize(2, 35.0f);
            this.mBottom.setVisibility(0);
            this.mBottom.setTextSize(2, 11.0f);
            this.mBottom.setText(R.string.single_game_middle_page_rank_top_ten);
            this.mBottom.setTextColor(-1);
            this.mBottom.setBackgroundResource(R.drawable.single_game_list_middle_item_rank_top_ten);
        } else if (itemType == 6) {
            this.mTop.setText((CharSequence)String.valueOf(gameMiddleInfo.rank));
            this.mTop.setTextSize(2, 35.0f);
            this.mBottom.setVisibility(0);
            this.mBottom.setTextSize(2, 11.0f);
            this.mBottom.setText(R.string.single_game_middle_page_rank_other);
            this.mBottom.setTextColor(-1);
            this.mBottom.setBackgroundResource(R.drawable.single_game_llist_middle_item_rank_other);
        }
    }
}

