/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.single.list.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.game.R;
import com.yy.game.gamemodule.simplegame.single.list.TouchEffector;

public class SingleGamePlayButton
extends YYFrameLayout {
    private ImageView progressIV;
    private YYTextView mProgressText;
    private Button playBtn;
    private AnimatorSet appearAnim;
    private AnimatorSet disappearAnim;
    private int progressWidth = ResourceUtils.getDimen((int)R.dimen.game_single_game_list_item_w);

    public SingleGamePlayButton(Context context) {
        this(context, null);
    }

    public SingleGamePlayButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SingleGamePlayButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_single_game_play_btn, (ViewGroup)this);
        this.playBtn = (Button)this.findViewById(R.id.btn_single_game_play);
        this.playBtn.setClickable(false);
        this.playBtn.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.progressIV = (ImageView)this.findViewById(R.id.iv_single_game_download_progress);
        this.mProgressText = (YYTextView)this.findViewById(R.id.tv_single_game_downloading_text);
        this.mProgressText.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
    }

    private void showPlayBtn() {
        TouchEffector.addButtonTouchEffect((View)this);
        this.setClickable(true);
        if (this.disappearAnim != null && this.disappearAnim.isRunning()) {
            this.disappearAnim.cancel();
            this.playBtn.setScaleY(0.2f);
        }
        if (this.playBtn.getScaleY() < 1.0f) {
            if (this.appearAnim == null) {
                ObjectAnimator scaleAnim = ObjectAnimator.ofFloat((Object)this.playBtn, (Property)View.SCALE_Y, (float[])new float[]{1.0f});
                ObjectAnimator alphaAnim = ObjectAnimator.ofFloat((Object)this.playBtn, (Property)View.ALPHA, (float[])new float[]{1.0f});
                this.appearAnim = new AnimatorSet();
                this.appearAnim.playTogether(new Animator[]{scaleAnim, alphaAnim});
            }
            if (!this.appearAnim.isRunning()) {
                this.appearAnim.start();
            }
        }
    }

    private void hidePlayBtn() {
        this.setOnTouchListener(null);
        this.setClickable(false);
        if (this.appearAnim != null && this.appearAnim.isRunning()) {
            this.appearAnim.cancel();
            this.playBtn.setScaleY(1.0f);
        }
        if (this.playBtn.getScaleY() == 1.0f) {
            if (this.disappearAnim == null) {
                ObjectAnimator scaleAnim = ObjectAnimator.ofFloat((Object)this.playBtn, (Property)View.SCALE_Y, (float[])new float[]{0.2f});
                ObjectAnimator alphaAnim = ObjectAnimator.ofFloat((Object)this.playBtn, (Property)View.ALPHA, (float[])new float[]{0.0f});
                this.disappearAnim = new AnimatorSet();
                this.disappearAnim.playTogether(new Animator[]{scaleAnim, alphaAnim});
            }
            if (!this.disappearAnim.isRunning()) {
                this.disappearAnim.start();
            }
        }
    }

    public void showPlayButton() {
        this.showPlayBtn();
    }

    public void showProgress(float progress) {
        this.hidePlayBtn();
        progress = Math.max(0.0f, progress);
        progress = Math.min(1.0f, progress);
        int uiProgress = (int)(progress * 100.0f);
        this.mProgressText.setText((CharSequence)StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.single_game_middle_page_download), (Object[])new Object[]{uiProgress + "%"}));
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.progressIV.getLayoutParams();
        params.width = (int)((float)this.progressWidth * progress);
        this.progressIV.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public Button getPlayBtn() {
        return this.playBtn;
    }
}

