/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.single.list.widget;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.game.R;
import com.yy.game.gamemodule.simplegame.single.list.data.SingleGameMiddleInfo;
import com.yy.game.gamemodule.simplegame.single.list.widget.SingleGameEncourageView;
import com.yy.game.gamemodule.simplegame.single.list.widget.SingleGameRecordItemView;

public class SingleGameMiddleView
extends YYFrameLayout
implements View.OnClickListener {
    private static final String TAG = "SingleGameMiddleView";
    private View mCardView;
    private View mTopContainer;
    private View mTopBgView;
    private YYTextView mTvRecordTip;
    private SingleGameRecordItemView mLeftItemView;
    private SingleGameRecordItemView mRightItemView;
    private SingleGameEncourageView mEncourageView;
    private YYLinearLayout mLlDailyBoardView;
    private YYTextView mTvDisconnectTipView;
    private OnSingleGameMiddleItemClickListener mItemClickListener;

    public SingleGameMiddleView(Context context) {
        this(context, null);
    }

    public SingleGameMiddleView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SingleGameMiddleView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public void setItemClickListener(OnSingleGameMiddleItemClickListener itemClickListener) {
        this.mItemClickListener = itemClickListener;
    }

    private void init() {
        SingleGameMiddleView.inflate((Context)this.getContext(), (int)R.layout.layout_single_game_middle_view, (ViewGroup)this);
        this.mCardView = this.findViewById(R.id.card_view);
        this.mTopContainer = this.findViewById(R.id.top_container);
        this.mTopBgView = this.findViewById(R.id.middle_view_top);
        this.mTvRecordTip = (YYTextView)this.findViewById(R.id.tv_tip_record);
        this.mLeftItemView = (SingleGameRecordItemView)this.findViewById(R.id.first_item_view);
        this.mRightItemView = (SingleGameRecordItemView)this.findViewById(R.id.second_item_view);
        this.mEncourageView = (SingleGameEncourageView)this.findViewById(R.id.single_game_encourage_view);
        this.mLlDailyBoardView = (YYLinearLayout)this.findViewById(R.id.ll_daily_board);
        this.mLlDailyBoardView.setOnClickListener((View.OnClickListener)this);
        this.mTvDisconnectTipView = (YYTextView)this.findViewById(R.id.tv_disconnect_tip);
    }

    private void resetLayoutParams(boolean showEncourageView) {
        if (showEncourageView) {
            LinearLayout.LayoutParams topParams = new LinearLayout.LayoutParams(ResolutionUtils.dip2Px((float)271.0f), ResolutionUtils.dip2Px((float)190.0f));
            this.mTopBgView.setLayoutParams((ViewGroup.LayoutParams)topParams);
            FrameLayout.LayoutParams topContainerParams = new FrameLayout.LayoutParams(-2, -2);
            this.mTopContainer.setLayoutParams((ViewGroup.LayoutParams)topContainerParams);
            FrameLayout.LayoutParams cardParams = new FrameLayout.LayoutParams(-2, -2);
            this.mCardView.setLayoutParams((ViewGroup.LayoutParams)cardParams);
        } else {
            LinearLayout.LayoutParams topParams = new LinearLayout.LayoutParams(ResolutionUtils.dip2Px((float)271.0f), ResolutionUtils.dip2Px((float)150.0f));
            this.mTopBgView.setLayoutParams((ViewGroup.LayoutParams)topParams);
            FrameLayout.LayoutParams topContainerParams = new FrameLayout.LayoutParams(-2, -2);
            this.mTopContainer.setLayoutParams((ViewGroup.LayoutParams)topContainerParams);
            FrameLayout.LayoutParams cardParams = new FrameLayout.LayoutParams(-2, -2);
            this.mCardView.setLayoutParams((ViewGroup.LayoutParams)cardParams);
        }
    }

    public void refreshUI(SingleGameMiddleInfo middleInfo) {
        this.refreshMiddleItemUI(middleInfo);
        this.refreshEncourageViewUI(middleInfo);
        this.refreshBgColor(middleInfo);
    }

    public void refreshMiddleItemUI(final SingleGameMiddleInfo middleInfo) {
        int middlePageType = this.getMiddlePageType(middleInfo);
        this.mTvDisconnectTipView.setVisibility(8);
        if (middlePageType == 1) {
            this.mTvRecordTip.setVisibility(0);
            this.mTvRecordTip.setText(R.string.single_game_middle_page_played_ever);
            this.mLeftItemView.setVisibility(0);
            this.mLeftItemView.refreshUI(middleInfo, 0);
            this.mRightItemView.setVisibility(0);
            this.mRightItemView.refreshUI(middleInfo, 3);
        } else if (middlePageType == 2) {
            this.mTvRecordTip.setVisibility(0);
            this.mTvRecordTip.setText(R.string.single_game_middle_page_played_ever);
            this.mLeftItemView.setVisibility(0);
            this.mLeftItemView.refreshUI(middleInfo, 0);
            this.mRightItemView.setVisibility(0);
            this.mRightItemView.refreshUI(middleInfo, 3);
        } else if (middlePageType == 3) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    SingleGameMiddleView.this.mRightItemView.setVisibility(8);
                    SingleGameMiddleView.this.mTvRecordTip.setVisibility(0);
                    SingleGameMiddleView.this.mTvRecordTip.setText(R.string.single_game_middle_page_played_today);
                    SingleGameMiddleView.this.mLeftItemView.setVisibility(0);
                    SingleGameMiddleView.this.mLeftItemView.refreshUI(middleInfo, 2);
                }
            });
        } else if (middlePageType == 4) {
            this.mTvRecordTip.setVisibility(0);
            this.mTvRecordTip.setText(R.string.single_game_middle_page_played_today);
            int middleItemRankType = this.getMiddleItemRankType(middleInfo);
            if (middleItemRankType == 4) {
                this.mLeftItemView.setVisibility(0);
                this.mLeftItemView.refreshUI(middleInfo, 2);
                this.mRightItemView.setVisibility(0);
                this.mRightItemView.refreshUI(middleInfo, 4);
            } else if (middleItemRankType == 5) {
                this.mLeftItemView.setVisibility(0);
                this.mLeftItemView.refreshUI(middleInfo, 2);
                this.mRightItemView.setVisibility(0);
                this.mRightItemView.refreshUI(middleInfo, 5);
            } else if (middleItemRankType == 6) {
                this.mLeftItemView.setVisibility(0);
                this.mLeftItemView.refreshUI(middleInfo, 2);
                this.mRightItemView.setVisibility(0);
                this.mRightItemView.refreshUI(middleInfo, 6);
            }
        } else if (middlePageType == 5) {
            this.mTvRecordTip.setVisibility(8);
            this.mLeftItemView.setVisibility(8);
            this.mRightItemView.setVisibility(8);
            this.mEncourageView.setVisibility(8);
            this.mTvDisconnectTipView.setVisibility(0);
        }
    }

    public void refreshEncourageViewUI(SingleGameMiddleInfo middleInfo) {
        int middleEvaluationType = this.getMiddleEvaluationType(middleInfo);
        if (middleEvaluationType == -1 || middleEvaluationType == 4) {
            this.mEncourageView.setVisibility(8);
            this.resetLayoutParams(false);
        } else {
            this.mEncourageView.setVisibility(0);
            this.resetLayoutParams(true);
            this.mEncourageView.refreshUI(middleInfo, middleEvaluationType);
        }
    }

    private void refreshBgColor(SingleGameMiddleInfo info) {
        int topBgColor = 0xE5000000 | 0xFFFFFF & info.bgColor;
        int bottomBgColor = 0xB2000000 | 0xFFFFFF & info.bgColor;
        this.mTopBgView.setBackgroundColor(topBgColor);
        this.mLlDailyBoardView.setBackgroundColor(bottomBgColor);
    }

    private int getMiddlePageType(SingleGameMiddleInfo info) {
        if (info == null) {
            return -1;
        }
        if (info.isDisconnect) {
            return 5;
        }
        if (!info.havePlayed) {
            return 0;
        }
        if (!info.todayPlayed && !TextUtils.isEmpty((CharSequence)info.recentPlayDate) && info.recentScore != 0) {
            return 1;
        }
        if (!info.todayPlayed && TextUtils.isEmpty((CharSequence)info.recentPlayDate) && info.recentScore == 0) {
            return 2;
        }
        if (info.rank == -1) {
            return 3;
        }
        return 4;
    }

    private int getMiddleItemRankType(SingleGameMiddleInfo info) {
        if (info == null) {
            return -1;
        }
        if (info.todayPlayed && info.rank != -1) {
            int currentRank = info.rank;
            int top10 = (int)((double)info.totalRankCount * 0.1);
            if (currentRank > 0 && currentRank <= 3) {
                return 4;
            }
            if (currentRank >= 4 && currentRank <= top10) {
                return 5;
            }
            return 6;
        }
        return -1;
    }

    private int getMiddleEvaluationType(SingleGameMiddleInfo info) {
        if (info == null) {
            return -1;
        }
        if (info.isDisconnect) {
            return 4;
        }
        if (info.havePlayed && !info.todayPlayed) {
            if (info.rank > 0 && info.rank <= info.ranklimit) {
                return 0;
            }
            if (info.rank > info.ranklimit && info.rank <= info.biggerRank) {
                return 1;
            }
            if (info.rank == -1 && info.overPeople != 0) {
                return 2;
            }
            if (!TextUtils.isEmpty((CharSequence)info.encouragementText)) {
                return 3;
            }
        }
        return -1;
    }

    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.ll_daily_board && this.mItemClickListener != null) {
            this.mItemClickListener.onSingleGameDailyEntranceClick();
        }
    }

    public static interface OnSingleGameMiddleItemClickListener {
        public void onSingleGameDailyEntranceClick();
    }
}

