/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.single.list.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.game.R;
import com.yy.game.gamemodule.simplegame.single.list.data.SingleGameMiddleInfo;
import java.text.DecimalFormat;

public class SingleGameMiddleEvaluationView
extends YYConstraintLayout {
    private YYTextView mEvaluationTip;
    private YYTextView mEvaluationNumber;
    private DecimalFormat mDecimalFormat;

    public SingleGameMiddleEvaluationView(Context context) {
        this(context, null);
    }

    public SingleGameMiddleEvaluationView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SingleGameMiddleEvaluationView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        SingleGameMiddleEvaluationView.inflate((Context)this.getContext(), (int)R.layout.layout_single_game_middle_evaluation_view, (ViewGroup)this);
        this.mEvaluationTip = (YYTextView)this.findViewById(R.id.tv_evaluation_tip);
        this.mEvaluationNumber = (YYTextView)this.findViewById(R.id.tv_evaluation_number);
        this.mEvaluationTip.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        if (this.mEvaluationTip != null && this.mEvaluationTip.getPaint() != null) {
            this.mEvaluationTip.getPaint().setStrokeWidth((float)ResolutionUtils.dip2Px((float)2.0f));
        }
        this.mEvaluationNumber.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
    }

    public void refreshUI(SingleGameMiddleInfo middleInfo, int evaluationType) {
        if (middleInfo == null) {
            return;
        }
        if (evaluationType == 0) {
            this.setBackgroundResource(R.drawable.single_game_list_middle_evaluation_ranked);
            this.mEvaluationTip.setTextSize(2, 9.0f);
            this.mEvaluationTip.setText(R.string.single_game_middle_page_evaluation_ranked_tip);
            this.mEvaluationNumber.setVisibility(0);
            String rank = this.getFormatedNumber(middleInfo.rank);
            this.mEvaluationNumber.setText((CharSequence)StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.single_game_middle_page_evaluation_rank), (Object[])new Object[]{rank}));
        } else if (evaluationType == 1) {
            this.mEvaluationNumber.setVisibility(8);
            this.setBackgroundResource(R.drawable.single_game_list_middle_evaluation_other);
            this.mEvaluationTip.setTextSize(2, 12.0f);
            int willInRankCount = Math.abs(middleInfo.rank - 500);
            String rankCount = this.getFormatedNumber(willInRankCount);
            this.mEvaluationTip.setText((CharSequence)StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.single_game_middle_page_evaluation_will_in_rank_tip), (Object[])new Object[]{rankCount}));
        } else if (evaluationType == 2) {
            this.setBackgroundResource(R.drawable.single_game_list_middle_evaluation_surpassed);
            this.mEvaluationTip.setTextSize(2, 9.0f);
            this.mEvaluationTip.setText(R.string.single_game_middle_page_evaluation_surpassed_tip);
            this.mEvaluationNumber.setVisibility(0);
            String overPeople = this.getFormatedNumber(middleInfo.overPeople);
            this.mEvaluationNumber.setText((CharSequence)overPeople);
        } else if (evaluationType == 3) {
            this.mEvaluationNumber.setVisibility(8);
            this.setBackgroundResource(R.drawable.single_game_list_middle_evaluation_other);
            this.mEvaluationTip.setTextSize(2, 12.0f);
            this.mEvaluationTip.setText((CharSequence)middleInfo.encouragementText);
        }
    }

    private String getFormatedNumber(int num) {
        if (this.mDecimalFormat == null) {
            this.mDecimalFormat = StringUtils.getDecimalFormat((String)"###,###");
        }
        return this.mDecimalFormat.format(num);
    }
}

