/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.single.list.widget;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import androidx.core.view.ViewCompat;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.widget.barrage.Barrage;
import com.yy.appbase.widget.barrage.BarrageShowView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.game.R;
import com.yy.game.gamemodule.simplegame.SimpleGameHiidoReporter;
import com.yy.game.gamemodule.simplegame.single.list.SingleGameListAdapter;
import com.yy.game.gamemodule.simplegame.single.list.callback.ISingleGameListViewCallback;
import com.yy.game.gamemodule.simplegame.single.list.data.SingleGameMiddleInfo;
import com.yy.game.gamemodule.simplegame.single.list.widget.CustomViewPager;
import com.yy.game.gamemodule.simplegame.single.list.widget.SingleGameItemAnimView;
import com.yy.hiyo.game.base.SingleGameExtInfo;
import java.util.List;

public class SingleGameListView
extends YYFrameLayout
implements ViewPager.OnPageChangeListener,
SingleGameListAdapter.ISingleGameItemClickListener,
View.OnClickListener {
    private static final String TAG = "SingleGameListView";
    private CustomViewPager gameListVP;
    private BarrageShowView mBarrageView;
    private SingleGameListAdapter gameListAdapter;
    private ISingleGameSwitchCallback switchCallback;
    private boolean isFirstTime;
    private ISingleGameListViewCallback callback;
    private LinearLayout mIndicatorContainer;
    private int mDots;
    private CircleImageView[] mCircleImageView;
    private boolean hasSetUpIndicator = false;
    private String mCurrentGameId;
    private int mCurrentPosition;
    private int mPreviousPosition;
    private SingleGameItemAnimView gameItemAnimView;
    private YYTextView mShortcutTipView;
    private YYImageView mShortcutView;
    private Runnable mDismissShortcutTipViewRunnable = new Runnable(){

        @Override
        public void run() {
            SingleGameListView.this.dismissShortcutTipView();
        }
    };

    public SingleGameListView(Context context) {
        this(context, null);
    }

    public SingleGameListView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SingleGameListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_single_game_list_new, (ViewGroup)this);
        this.setClipChildren(false);
        this.findAllViews();
        this.gameListAdapter = new SingleGameListAdapter(this.getContext(), this);
        this.gameListVP.setAdapter(this.gameListAdapter);
        this.gameListVP.setOffscreenPageLimit(2);
        this.gameListVP.addOnPageChangeListener(this);
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return SingleGameListView.this.gameListVP.onTouchEvent(event);
            }
        });
        this.isFirstTime = true;
    }

    public ViewPager getGameListVP() {
        return this.gameListVP;
    }

    private void setUpViewPagerIndicator(List<SingleGameMiddleInfo> gameList) {
        if (gameList == null || gameList.isEmpty()) {
            return;
        }
        if (this.mCircleImageView != null && this.mCircleImageView.length > 0 && this.mIndicatorContainer != null) {
            for (CircleImageView indicator : this.mCircleImageView) {
                if (indicator == null) continue;
                this.mIndicatorContainer.removeView((View)indicator);
            }
        }
        int size = gameList.size();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"game list size %s", (Object[])new Object[]{size});
        }
        String avatarUrl = "";
        this.mCircleImageView = new CircleImageView[size];
        int indicatorColor = ResourceUtils.getColor((int)R.color.single_game_list_indicator_unselected_color);
        for (int i = 0; i < size; ++i) {
            this.mCircleImageView[i] = new CircleImageView(this.getContext());
            this.mCircleImageView[i].setRotationY((float)this.getResources().getInteger(R.integer.locale_rotate_icon));
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(ResolutionUtils.dip2Px((float)13.0f), ResolutionUtils.dip2Px((float)13.0f));
            if (i != 0) {
                params.leftMargin = ResolutionUtils.dip2Px((float)10.0f);
                if (Build.VERSION.SDK_INT >= 17) {
                    params.setMarginStart(params.leftMargin);
                }
            }
            this.mIndicatorContainer.addView((View)this.mCircleImageView[i], (ViewGroup.LayoutParams)params);
            avatarUrl = gameList.get((int)i).circleIconUrl;
            if (TextUtils.isEmpty((CharSequence)avatarUrl)) {
                ImageLoader.loadImage((RecycleImageView)this.mCircleImageView[i], (int)R.drawable.icon_avatar_default_male);
            } else {
                ImageLoader.loadImage((RecycleImageView)this.mCircleImageView[i], (String)avatarUrl);
            }
            this.mCircleImageView[i].setBorderColor(indicatorColor);
            this.mCircleImageView[i].setBorderWidth(4);
            this.mCircleImageView[i].setTag((Object)gameList.get((int)i).gameId);
            this.mCircleImageView[i].setOnClickListener((View.OnClickListener)this);
            this.hasSetUpIndicator = true;
        }
    }

    public void setCallback(ISingleGameListViewCallback callback2) {
        this.callback = callback2;
    }

    private void findAllViews() {
        this.gameListVP = (CustomViewPager)this.findViewById(R.id.vp_single_game);
        this.gameItemAnimView = (SingleGameItemAnimView)this.findViewById(R.id.single_game_item_anim);
        this.mBarrageView = (BarrageShowView)this.findViewById(R.id.single_game_barrage_view);
        this.mIndicatorContainer = (LinearLayout)this.findViewById(R.id.indicator_container);
    }

    public void setGameList(List<SingleGameMiddleInfo> gameList, String curGameId) {
        if (!FP.empty(gameList)) {
            this.setUpViewPagerIndicator(gameList);
            int curIndex = this.gameListVP.getCurrentItem();
            SingleGameMiddleInfo info = this.gameListAdapter.getSingleGameInPosition(curIndex);
            this.gameListAdapter.setData(gameList);
            int index = this.gameListAdapter.getFirstShowIndex(curGameId);
            if (index > 0) {
                int currentPosition = this.gameListAdapter.getRealPosition(index);
                this.scaleCurrentIndicator(currentPosition);
            }
            if (!(info != null && curGameId != null && curGameId.equals(info.gameId) || index < 0)) {
                this.gameListVP.setCurrentItem(index);
                if (this.switchCallback != null) {
                    this.switchCallback.onSingleGameSwitch(this.gameListAdapter.getCurSingleGameInfo());
                }
            }
        }
    }

    public void indexToGame(String gameId) {
        int index;
        if (!TextUtils.isEmpty((CharSequence)gameId) && (index = this.gameListAdapter.getFirstShowIndex(gameId)) >= 0) {
            this.gameListVP.setCurrentItem(index);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        boolean isLargeEnd;
        boolean isLittleEnd = positionOffset >= 0.0f && (double)positionOffset <= 0.1;
        boolean bl = isLargeEnd = (double)positionOffset >= 0.9 && positionOffset <= 1.0f;
        if (isLittleEnd || isLargeEnd) {
            int curPos = isLittleEnd ? position : position + 1;
            this.setGameItemAnimViewPos(curPos);
            float translate = isLittleEnd ? positionOffset : 1.0f - positionOffset;
            this.gameItemAnimView.swapAnim(translate);
        } else {
            this.gameItemAnimView.swapAnim(positionOffset);
        }
    }

    public void onPageSelected(int position) {
        SingleGameMiddleInfo curSingleGameInfo;
        if (this.mCurrentPosition != this.gameListAdapter.getRealPosition(position)) {
            this.dismissShortcutTipView();
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mDismissShortcutTipViewRunnable);
        }
        if (this.switchCallback != null) {
            this.switchCallback.onSingleGameSwitch(this.gameListAdapter.getSingleGameInPosition(position));
        }
        this.gameListAdapter.onPageSelected(position);
        this.mPreviousPosition = this.mCurrentPosition;
        this.mCurrentPosition = this.gameListAdapter.getRealPosition(position);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onPageSelected current real position: %s,selected position: %s", (Object[])new Object[]{this.mCurrentPosition, position});
        }
        if ((curSingleGameInfo = this.gameListAdapter.getCurSingleGameInfo()) != null) {
            this.mCurrentGameId = curSingleGameInfo.gameId;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onPageSelected current gameId: %s", (Object[])new Object[]{this.mCurrentGameId});
        }
        this.scaleIndicator(this.mCurrentPosition, this.mPreviousPosition);
        if (this.isFirstTime) {
            this.isFirstTime = false;
            this.setGameItemAnimViewPos(position);
            this.gameItemAnimView.startFloatingAnim();
        }
        if (this.gameListAdapter != null && this.gameListAdapter.getCurSingleGameInfo() != null) {
            SimpleGameHiidoReporter.reportSingleGameType(this.gameListAdapter.getCurSingleGameInfo().gameId);
        }
    }

    private void setGameItemAnimViewPos(int pos) {
        if (this.gameItemAnimView.getCurPosition() != pos) {
            SingleGameExtInfo extInfo;
            SingleGameMiddleInfo gameInfo = this.gameListAdapter.getSingleGameInPosition(pos);
            SingleGameExtInfo singleGameExtInfo = extInfo = gameInfo == null ? null : gameInfo.extInfo;
            if (extInfo == null) {
                extInfo = new SingleGameExtInfo();
            }
            this.gameItemAnimView.updatePosition(pos, extInfo);
        }
    }

    private void scaleIndicator(int currentPosition, int previousPosition) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"scaleIndicator currentPosition: %s , previousPosition: %s", (Object[])new Object[]{currentPosition, previousPosition});
        }
        if (currentPosition == previousPosition && currentPosition != 0) {
            return;
        }
        if (this.mCircleImageView == null || this.mCircleImageView.length <= 0 || this.mCircleImageView.length <= currentPosition || this.mCircleImageView.length <= previousPosition) {
            return;
        }
        if (this.mCircleImageView[previousPosition] != null) {
            ViewCompat.animate((View)this.mCircleImageView[previousPosition]).scaleX(1.0f).scaleY(1.0f).setInterpolator((Interpolator)new AccelerateInterpolator()).setDuration(300L).start();
            this.mCircleImageView[previousPosition].setBorderColor(ResourceUtils.getColor((int)R.color.single_game_list_indicator_unselected_color));
        }
        if (this.mCircleImageView[currentPosition] != null) {
            ViewCompat.animate((View)this.mCircleImageView[currentPosition]).scaleX(1.5f).scaleY(1.5f).setInterpolator((Interpolator)new AccelerateInterpolator()).setDuration(300L).start();
            this.mCircleImageView[currentPosition].setBorderColor(ResourceUtils.getColor((int)R.color.single_game_list_indicator_selected_color));
        }
    }

    private void scaleCurrentIndicator(int currentPosition) {
        if (currentPosition < 0) {
            return;
        }
        if (this.mCircleImageView == null || this.mCircleImageView.length <= currentPosition) {
            return;
        }
        if (this.mCircleImageView[currentPosition] != null) {
            ViewCompat.animate((View)this.mCircleImageView[currentPosition]).scaleX(1.5f).scaleY(1.5f).setInterpolator((Interpolator)new AccelerateInterpolator()).setDuration(300L).start();
            this.mCircleImageView[currentPosition].setBorderColor(ResourceUtils.getColor((int)R.color.single_game_list_indicator_selected_color));
        }
    }

    public void onPageScrollStateChanged(int state) {
        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"[onPageScrollStateChanged] state: %d", (Object[])new Object[]{state});
        }
        if (state == 0) {
            this.gameItemAnimView.startFloatingAnim();
        } else {
            this.gameItemAnimView.stopFloatingAnim();
        }
        this.gameListAdapter.onPageScrollStateChange(state);
    }

    public SingleGameMiddleInfo getCurGameInfo() {
        return this.gameListAdapter.getCurSingleGameInfo();
    }

    public void setSingleGameSwitchCallback(ISingleGameSwitchCallback callback2) {
        this.switchCallback = callback2;
    }

    @Override
    public void onSingleGameBottomBarClick(String gameId) {
        if (this.callback != null) {
            this.callback.onSingleGameBottomBarClick(gameId);
        }
    }

    @Override
    public void onSingleGameBackClick() {
        if (this.callback != null) {
            this.callback.onSingleGameBackClick();
        }
    }

    @Override
    public void onSingleGameShareClick(String gameId) {
        if (this.callback != null) {
            this.callback.onSingleGameShareClick(gameId);
        }
        this.dismissShortcutTipView();
    }

    public void onClick(View v) {
        String gameId = (String)v.getTag();
        if (!TextUtils.isEmpty((CharSequence)gameId) && !gameId.equals(this.mCurrentGameId)) {
            this.indexToGame(gameId);
        }
    }

    public void initBarrageView(int count) {
        if (this.mBarrageView != null) {
            this.mBarrageView.initBarrageView(count);
        }
    }

    public void addBarrageView(String avatarUrl, String msg, int bgColor) {
        if (this.mBarrageView != null) {
            this.mBarrageView.addBarrage(Barrage.builder().avatar(avatarUrl).msg(msg).bgColor(bgColor).build());
        }
    }

    public void clearBarrageView() {
        if (this.mBarrageView != null) {
            this.mBarrageView.clear();
            this.hasSetUpIndicator = false;
        }
    }

    public void startBarrageView() {
        if (this.mBarrageView != null) {
            this.mBarrageView.start();
        }
    }

    public void pauseBarrageView() {
        if (this.mBarrageView != null) {
            this.mBarrageView.pause();
        }
    }

    public void dismissShortcutTipView() {
        if (this.mShortcutTipView != null) {
            this.removeView((View)this.mShortcutTipView);
            this.mShortcutTipView = null;
        }
    }

    public void setCanScroll(boolean disable) {
        this.gameListVP.setCanScroll(disable);
    }

    public static interface ISingleGameSwitchCallback {
        public void onSingleGameSwitch(SingleGameMiddleInfo var1);
    }
}

