/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.single.list.widget;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import androidx.annotation.FloatRange;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.utils.ScreenUtils;
import com.yy.game.R;
import com.yy.hiyo.game.base.SingleGameExtInfo;

public class SingleGameItemAnimView
extends YYRelativeLayout {
    private static final String TAG = "SingleGameItemAnimView";
    private RecycleImageView animLTIV;
    private RecycleImageView animLBIV;
    private RecycleImageView animRCIV;
    private RecycleImageView[] animItemArr;
    private Animator[][] floatingAnimArr;
    private int curPosition;
    private static final int EXPEND_DIST = ScreenUtils.getInstance().dip2px(20);

    public SingleGameItemAnimView(Context context) {
        this(context, null);
    }

    public SingleGameItemAnimView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SingleGameItemAnimView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_single_game_anim_view, (ViewGroup)this);
        this.animLTIV = (RecycleImageView)this.findViewById(R.id.iv_single_game_anim_item_lt);
        this.animLBIV = (RecycleImageView)this.findViewById(R.id.iv_single_game_anim_item_lb);
        this.animRCIV = (RecycleImageView)this.findViewById(R.id.iv_single_game_anim_item_rc);
        this.animItemArr = new RecycleImageView[]{this.animLTIV, this.animRCIV, this.animLBIV};
        this.initFloatingAnim();
        this.setClipChildren(false);
        this.initAnimPos();
    }

    private void initAnimPos() {
        double factor = Math.cos(0.7853981633974483);
        float transL = (float)((double)EXPEND_DIST * factor * -1.0);
        float transT = (float)((double)EXPEND_DIST * factor * -1.0);
        float transB = (float)((double)EXPEND_DIST * factor);
        float transR = (float)((double)EXPEND_DIST * factor);
        this.animLTIV.setTranslationX(transL);
        this.animLTIV.setTranslationY(transT);
        this.animLTIV.setAlpha(0.0f);
        this.animRCIV.setTranslationX(transR);
        this.animRCIV.setTranslationY(transB);
        this.animRCIV.setAlpha(0.0f);
        this.animLBIV.setTranslationX(transL);
        this.animLBIV.setTranslationY(transB);
        this.animLBIV.setAlpha(0.0f);
    }

    public int getCurPosition() {
        return this.curPosition;
    }

    public void updatePosition(int position, SingleGameExtInfo extInfo) {
        this.curPosition = position;
        this.animLTIV.setImageDrawable(null);
        this.animRCIV.setImageDrawable(null);
        this.animLBIV.setImageDrawable(null);
        if (extInfo != null) {
            ImageLoader.loadImage((RecycleImageView)this.animLTIV, (String)extInfo.animLeftTop);
            ImageLoader.loadImage((RecycleImageView)this.animRCIV, (String)extInfo.animRightCenter);
            ImageLoader.loadImage((RecycleImageView)this.animLBIV, (String)extInfo.animLeftBottom);
        }
    }

    public void swapAnim(@FloatRange(from=0.0, to=0.10000000149011612) float translate) {
        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"[swapAnim] translate: %f", (Object[])new Object[]{Float.valueOf(translate)});
        }
        translate = Math.min(0.1f, Math.abs(translate));
        float alpha = 1.0f - translate / 0.1f;
        float scale = 1.0f + translate / 0.2f;
        for (RecycleImageView item : this.animItemArr) {
            item.setAlpha(alpha);
            item.setScaleX(scale);
            item.setScaleY(scale);
        }
    }

    private void initFloatingAnim() {
        if (this.floatingAnimArr == null) {
            this.floatingAnimArr = new Animator[3][];
            if (this.animLTIV != null) {
                this.floatingAnimArr[0] = this.getFloatingAnim((View)this.animLTIV, ScreenUtils.getInstance().dip2px(8), 45.0f, 3500L);
            }
            if (this.animRCIV != null) {
                this.floatingAnimArr[1] = this.getFloatingAnim((View)this.animRCIV, ScreenUtils.getInstance().dip2px(12), 100.0f, 3000L);
            }
            if (this.animLBIV != null) {
                this.floatingAnimArr[2] = this.getFloatingAnim((View)this.animLBIV, ScreenUtils.getInstance().dip2px(12), 315.0f, 3000L);
            }
        }
    }

    private Animator[] getFloatingAnim(View target, float distance, @FloatRange(from=0.0, to=360.0) float angle, long duration) {
        float[] xy1 = new float[]{(float)((double)distance * Math.cos((double)(angle / 180.0f) * Math.PI)), (float)((double)distance * Math.sin((double)(angle / 180.0f) * Math.PI))};
        ObjectAnimator transX = ObjectAnimator.ofFloat((Object)target, (Property)View.TRANSLATION_X, (float[])new float[]{0.0f, xy1[0]});
        transX.setInterpolator((TimeInterpolator)new LinearInterpolator());
        transX.setRepeatCount(-1);
        transX.setRepeatMode(2);
        transX.setDuration(duration);
        ObjectAnimator transY = ObjectAnimator.ofFloat((Object)target, (Property)View.TRANSLATION_Y, (float[])new float[]{0.0f, xy1[1]});
        transY.setInterpolator((TimeInterpolator)new LinearInterpolator());
        transY.setRepeatCount(-1);
        transY.setRepeatMode(2);
        transY.setDuration(duration);
        return new Animator[]{transX, transY};
    }

    public void startFloatingAnim() {
        this.resetTranslate();
        if (this.floatingAnimArr != null) {
            for (Animator[] animArr : this.floatingAnimArr) {
                if (animArr == null) continue;
                for (Animator animator2 : animArr) {
                    if (animator2 == null) continue;
                    animator2.start();
                }
            }
        }
    }

    public void stopFloatingAnim() {
        if (this.floatingAnimArr != null) {
            for (Animator[] animArr : this.floatingAnimArr) {
                if (animArr == null) continue;
                for (Animator anim2 : animArr) {
                    if (anim2 == null) continue;
                    anim2.cancel();
                }
            }
        }
        this.resetTranslate();
    }

    private void resetTranslate() {
        for (RecycleImageView view : this.animItemArr) {
            if (view == null) continue;
            view.setTranslationX(0.0f);
            view.setTranslationY(0.0f);
        }
    }
}

