/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.single.list.widget;

import android.content.Context;
import android.text.Html;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.BounceInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.game.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public class SingleGameFloatingView
extends YYFrameLayout {
    private static final String TAG = "SingleGameFloatingView";
    private Context mContext;
    private View mRootView;
    private YYImageView mIvDecoration;
    private YYTextView mTvTip;
    private CircleImageView mIvAvatar1;
    private CircleImageView mIvAvatar2;
    private CircleImageView mIvAvatar3;
    private CircleImageView mIvAvatar4;
    private YYRelativeLayout mBgLayout;
    private boolean isInAnimation = false;
    private TranslateAnimation animation;
    public static final int TYPE_NONE = -1;
    public static final int TYPE_SURPASSED_FRIEND = 0;
    public static final int TYPE_RANK = 1;
    public static final int TYPE_SURPASSED_PLAYER = 2;

    public SingleGameFloatingView(Context context) {
        this(context, null);
    }

    public SingleGameFloatingView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SingleGameFloatingView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mContext = context;
        this.mRootView = LayoutInflater.from((Context)context).inflate(R.layout.single_game_floating_layer, (ViewGroup)this, true);
        this.initView();
    }

    private void initView() {
        this.mIvDecoration = (YYImageView)this.mRootView.findViewById(R.id.iv_single_game_floating_decoration);
        this.mTvTip = (YYTextView)this.mRootView.findViewById(R.id.tv_single_game_tip);
        this.mIvAvatar1 = (CircleImageView)this.mRootView.findViewById(R.id.iv_single_game_avatar_1);
        this.mIvAvatar2 = (CircleImageView)this.mRootView.findViewById(R.id.iv_single_game_avatar_2);
        this.mIvAvatar3 = (CircleImageView)this.mRootView.findViewById(R.id.iv_single_game_avatar_3);
        this.mIvAvatar4 = (CircleImageView)this.mRootView.findViewById(R.id.iv_single_game_avatar_4);
        this.mBgLayout = (YYRelativeLayout)this.mRootView.findViewById(R.id.ll_single_game_bg);
    }

    public void setSpannableStringAndBackground(int floatingType, int num) {
        switch (floatingType) {
            case 0: {
                this.mIvDecoration.setBackgroundResource(R.drawable.single_game_surpassed_icon);
                this.mBgLayout.setBackgroundResource(R.drawable.shape_single_game_surpassed);
                String surpassedFriendTip = StringUtils.getQuantityString((int)num, (int)R.plurals.single_game_surpassed_friend);
                this.mTvTip.setText((CharSequence)Html.fromHtml((String)surpassedFriendTip));
                break;
            }
            case 1: {
                this.mIvDecoration.setBackgroundResource(R.drawable.single_game_ranked_icon);
                this.mBgLayout.setBackgroundResource(R.drawable.shape_single_game_ranked);
                String rankTip = StringUtils.format((String)ResourceUtils.getString((int)R.string.single_game_floating_ranked), (Object[])new Object[]{num});
                this.mTvTip.setText((CharSequence)Html.fromHtml((String)rankTip));
                break;
            }
            case 2: {
                this.mIvDecoration.setBackgroundResource(R.drawable.single_game_surpassed_icon);
                this.mBgLayout.setBackgroundResource(R.drawable.shape_single_game_surpassed);
                String surpassedPlayerTip = StringUtils.getQuantityString((int)num, (int)R.plurals.single_game_surpassed_player);
                this.mTvTip.setText((CharSequence)Html.fromHtml((String)surpassedPlayerTip));
                break;
            }
        }
    }

    public void setSurpassedFriendAvatar(List<String> avatarUrlList) {
        if (avatarUrlList == null) {
            return;
        }
        int surpassedFriends = avatarUrlList.size();
        if (surpassedFriends <= 0) {
            return;
        }
        if (surpassedFriends >= 4) {
            this.mIvAvatar1.setVisibility(0);
            ImageLoader.loadImage((RecycleImageView)this.mIvAvatar1, (String)avatarUrlList.get(0));
            this.mIvAvatar2.setVisibility(0);
            ImageLoader.loadImage((RecycleImageView)this.mIvAvatar2, (String)avatarUrlList.get(1));
            this.mIvAvatar3.setVisibility(0);
            ImageLoader.loadImage((RecycleImageView)this.mIvAvatar3, (String)avatarUrlList.get(2));
            this.mIvAvatar4.setVisibility(0);
            this.mIvAvatar4.setBackgroundResource(R.drawable.single_game_more_friends_avatar_icon);
        } else if (surpassedFriends == 3) {
            this.mIvAvatar2.setVisibility(0);
            ImageLoader.loadImage((RecycleImageView)this.mIvAvatar2, (String)avatarUrlList.get(0));
            this.mIvAvatar3.setVisibility(0);
            ImageLoader.loadImage((RecycleImageView)this.mIvAvatar3, (String)avatarUrlList.get(1));
            this.mIvAvatar4.setVisibility(0);
            ImageLoader.loadImage((RecycleImageView)this.mIvAvatar4, (String)avatarUrlList.get(2));
        } else if (surpassedFriends == 2) {
            this.mIvAvatar3.setVisibility(0);
            ImageLoader.loadImage((RecycleImageView)this.mIvAvatar3, (String)avatarUrlList.get(0));
            this.mIvAvatar4.setVisibility(0);
            ImageLoader.loadImage((RecycleImageView)this.mIvAvatar4, (String)avatarUrlList.get(1));
        } else {
            this.mIvAvatar4.setVisibility(0);
            ImageLoader.loadImage((RecycleImageView)this.mIvAvatar4, (String)avatarUrlList.get(0));
        }
    }

    public void playEnterAnim() {
        if (this.isInAnimation) {
            return;
        }
        this.animation = new TranslateAnimation(0.0f, 0.0f, (float)(-ResolutionUtils.dip2Px((float)60.0f)), 0.0f);
        this.animation.setInterpolator((Interpolator)new BounceInterpolator());
        this.animation.setDuration(800L);
        this.animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                SingleGameFloatingView.this.isInAnimation = true;
            }

            public void onAnimationEnd(Animation animation) {
                SingleGameFloatingView.this.isInAnimation = false;
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.mRootView.setAnimation((Animation)this.animation);
    }

    public void removeAnim() {
        if (this.animation != null) {
            this.animation.cancel();
            this.animation = null;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SingleGameFloatingType {
    }
}

