/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.single.list.widget;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Html;
import android.text.Spanned;
import android.util.AttributeSet;
import android.view.ViewGroup;
import androidx.annotation.StringRes;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.game.R;
import com.yy.game.gamemodule.simplegame.single.list.data.SingleGameMiddleInfo;
import java.text.DecimalFormat;

public class SingleGameEncourageView
extends YYConstraintLayout {
    private YYImageView mIconView;
    private YYTextView mTextView;
    private DecimalFormat mDecimalFormat;

    public SingleGameEncourageView(Context context) {
        this(context, null);
    }

    public SingleGameEncourageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SingleGameEncourageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.createView();
    }

    private void createView() {
        SingleGameEncourageView.inflate((Context)this.getContext(), (int)R.layout.layout_single_game_middle_encourage_view, (ViewGroup)this);
        this.mIconView = (YYImageView)this.findViewById(R.id.single_game_middle_icon);
        this.mTextView = (YYTextView)this.findViewById(R.id.single_game_middle_text);
    }

    public void refreshUI(SingleGameMiddleInfo middleInfo, int evaluationType) {
        if (middleInfo == null) {
            return;
        }
        this.setBackgroud(evaluationType);
        if (evaluationType == 0) {
            this.mIconView.setBackgroundResource(R.drawable.single_game_middle_have_encourage_icon);
            String rank = this.getFormatedNumber(middleInfo.rank);
            Spanned text = this.getHtmlText(R.string.single_game_middle_page_evaluation_ranked_tip, rank);
            this.mTextView.setText((CharSequence)text);
        } else if (evaluationType == 1) {
            this.mIconView.setBackgroundResource(R.drawable.single_game_middle_have_encourage_icon);
            int willInRankCount = Math.abs(middleInfo.rank - 500);
            String rankCount = this.getFormatedNumber(willInRankCount);
            Spanned text = this.getHtmlText(R.string.single_game_middle_page_evaluation_will_in_rank_tip, rankCount);
            this.mTextView.setText((CharSequence)text);
        } else if (evaluationType == 2) {
            this.mIconView.setBackgroundResource(R.drawable.single_game_middle_have_encourage_icon);
            String overPeople = this.getFormatedNumber(middleInfo.overPeople);
            Spanned text = this.getHtmlText(R.string.single_game_middle_page_evaluation_surpassed_tip, overPeople);
            this.mTextView.setText((CharSequence)text);
        } else if (evaluationType == 3) {
            this.mIconView.setBackgroundResource(R.drawable.single_game_middle_no_encourage_icon);
            this.mTextView.setText((CharSequence)middleInfo.encouragementText);
        }
    }

    private String getFormatedNumber(int num) {
        if (this.mDecimalFormat == null) {
            this.mDecimalFormat = StringUtils.getDecimalFormat((String)"###,###");
        }
        return this.mDecimalFormat.format(num);
    }

    private void setBackgroud(int evaluationType) {
        if (this.mTextView == null) {
            return;
        }
        Drawable drawable2 = ResourceUtils.getDrawable((int)R.drawable.single_game_middle_bg);
        if (drawable2 != null) {
            drawable2.setColorFilter(this.getBgColor(evaluationType), PorterDuff.Mode.SRC_IN);
            this.mTextView.setBackgroundDrawable(drawable2);
        }
    }

    private int getBgColor(int evaluationType) {
        int bgColor = evaluationType == 0 ? ResourceUtils.getColor((int)R.color.single_game_middle_ranked_bg) : (evaluationType == 1 ? ResourceUtils.getColor((int)R.color.single_game_middle_will_in_rank_bg) : (evaluationType == 2 ? ResourceUtils.getColor((int)R.color.single_game_middle_surpass_bg) : (evaluationType == 3 ? ResourceUtils.getColor((int)R.color.single_game_middle_encourage_bg) : ResourceUtils.getColor((int)R.color.single_game_middle_ranked_bg))));
        return bgColor;
    }

    private Spanned getHtmlText(@StringRes int stringResId, String number) {
        Spanned text = Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)ResourceUtils.getString((int)stringResId, (Object[])new Object[]{number}), (int)0) : Html.fromHtml((String)ResourceUtils.getString((int)stringResId, (Object[])new Object[]{number}));
        return text;
    }
}

