/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.single.list.request;

import android.content.Context;
import android.os.SystemClock;
import com.google.gson.reflect.TypeToken;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.game.gamemodule.simplegame.single.list.data.SingleGameListRsp;
import com.yy.game.gamemodule.simplegame.single.list.request.ISingleGameListRequestCallBack;
import com.yy.hiyo.game.base.GameDataBean;
import com.yy.hiyo.game.base.bean.GamePlayInfo;
import com.yy.hiyo.game.base.bean.SingleGameListItem;
import com.yy.hiyo.game.base.helper.ModifyJsGameHelper;
import com.yy.hiyo.game.kvomodule.GameInfoModule;
import com.yy.hiyo.game.kvomodule.GameInfoModuleData;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import okhttp3.Call;

public class SingleGameRequestManager {
    private static final String TAG = "SingleGameRequestManager";
    private static final String FILE_NAME = "singlegamelist";
    private ISingleGameListRequestCallBack mListCallBack;
    private volatile boolean mListRequesting = false;
    private long mListLastResponseTime = -1L;
    private volatile String mListResponse = null;
    private boolean hasReceivedServerSingleGameList = false;
    private boolean hasReceivedLocalSingleGameList = false;
    private List<GamePlayInfo> mLocalGamePlayInfo = new ArrayList<GamePlayInfo>();
    private String mVersoin = "";
    private CopyOnWriteArrayList<SingleGameListItem> mServerSingleGameList = new CopyOnWriteArrayList();
    private boolean hasLoadData = false;
    private Comparator<SingleGameListItem> mComparator = new Comparator<SingleGameListItem>(){

        @Override
        public int compare(SingleGameListItem o1, SingleGameListItem o2) {
            long lastPlayTime2;
            int playCount2;
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            }
            if (o2 == null) {
                return -1;
            }
            GamePlayInfo info1 = o1.playInfo;
            GamePlayInfo info2 = o2.playInfo;
            if (info1 == null) {
                return info2 == null ? 0 : 1;
            }
            if (info2 == null) {
                return -1;
            }
            int playCount1 = info1.getPlayCount();
            if (playCount1 > (playCount2 = info2.getPlayCount())) {
                return -1;
            }
            if (playCount1 < playCount2) {
                return 1;
            }
            long lastPlayTime1 = info1.getLatestPlayTs();
            return lastPlayTime1 - (lastPlayTime2 = info2.getLatestPlayTs()) > 0L ? -1 : 1;
        }
    };

    public SingleGameRequestManager(ISingleGameListRequestCallBack callBack) {
        this.mListCallBack = callBack;
    }

    public void requestSingleGameListIfNeed() {
        this.requestSingleGameListInner(this.mListCallBack, false);
    }

    private void requestSingleGameListInner(final ISingleGameListRequestCallBack callBack, final boolean retryed) {
        if (this.mListRequesting) {
            return;
        }
        long nowTime = SystemClock.uptimeMillis();
        if (nowTime > 0L && this.mListLastResponseTime > 0L && nowTime - this.mListLastResponseTime < 30000L) {
            if (callBack != null) {
                callBack.onDataNoChange();
            }
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"[requestSingleGameList]", (Object[])new Object[0]);
        }
        this.mListRequesting = true;
        if (AccountUtil.getUid() > 0L) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    Type type;
                    BaseResponseBean res;
                    String data;
                    if ((SingleGameRequestManager.this.mServerSingleGameList == null || SingleGameRequestManager.this.mServerSingleGameList.size() <= 0) && StringUtils.isNotEmpty((String)(data = FileStorageUtils.getInstance().getStrFromFile(true, SingleGameRequestManager.FILE_NAME))) && (res = (BaseResponseBean)JsonParser.parseJsonObject((String)data, (Type)(type = new TypeToken<BaseResponseBean<SingleGameListRsp>>(){}.getType()))) != null && res.isSuccess() && res.data != null && ((SingleGameListRsp)res.data).list != null) {
                        SingleGameRequestManager.this.mServerSingleGameList.clear();
                        SingleGameRequestManager.this.mServerSingleGameList.addAll(((SingleGameListRsp)res.data).list);
                        if (SingleGameRequestManager.this.mServerSingleGameList.size() > 0) {
                            SingleGameRequestManager.this.mVersoin = ((SingleGameListRsp)res.data).version;
                        }
                    }
                    HashMap<String, String> params = new HashMap<String, String>(2);
                    params.put("gameMode", "3");
                    params.put("version", SingleGameRequestManager.this.mVersoin);
                    HttpUtil.httpReq((String)UriProvider.generateGameListApiUrl((String)"/gameMeta/go/getListByMode"), params, (int)2, (INetRespCallback)new INetRespCallback<SingleGameListRsp>(){

                        public void onError(Call call, Exception e, int id2) {
                            MLog.error((Object)SingleGameRequestManager.TAG, (String)("[requestSingleGameList] retryed:" + (retryed ? "1" : "0")), (Throwable)e, (Object[])new Object[0]);
                            if (retryed || !NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                                if (callBack != null) {
                                    callBack.onError(e);
                                }
                                SingleGameRequestManager.this.mListRequesting = false;
                            } else {
                                SingleGameRequestManager.this.mListRequesting = false;
                                SingleGameRequestManager.this.requestSingleGameListInner(callBack, true);
                            }
                        }

                        public void onResponse(final String response, BaseResponseBean<SingleGameListRsp> res, int id2) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)SingleGameRequestManager.TAG, (String)"[requestSingleGameList] response: %s", (Object[])new Object[]{response});
                            }
                            SingleGameRequestManager.this.hasReceivedServerSingleGameList = true;
                            if (res != null && res.isSuccess() && res.data != null && ((SingleGameListRsp)res.data).list != null) {
                                SingleGameRequestManager.this.mListLastResponseTime = SystemClock.uptimeMillis();
                                if (callBack != null && ((SingleGameListRsp)res.data).list.size() > 0 && !StringUtils.equal((String)SingleGameRequestManager.this.mListResponse, (String)response)) {
                                    SingleGameRequestManager.this.mServerSingleGameList.clear();
                                    SingleGameRequestManager.this.mServerSingleGameList.addAll(((SingleGameListRsp)res.data).list);
                                    SingleGameRequestManager.this.mVersoin = ((SingleGameListRsp)res.data).version;
                                    SingleGameRequestManager.this.notifyDataSortStart();
                                    SingleGameRequestManager.this.mListResponse = response;
                                    YYTaskExecutor.execute((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            FileStorageUtils.getInstance().saveToFile(true, response, SingleGameRequestManager.FILE_NAME);
                                        }
                                    });
                                } else if (callBack != null && SingleGameRequestManager.this.mServerSingleGameList != null) {
                                    SingleGameRequestManager.this.notifyDataSortStart();
                                } else if (callBack != null) {
                                    callBack.onDataNoChange();
                                }
                            } else {
                                MLog.error((Object)SingleGameRequestManager.TAG, (String)"[requestSingleGameList] request error, msg: %s", (Object[])new Object[]{res == null ? "null res" : res.message});
                                if (callBack != null) {
                                    callBack.onError(new RuntimeException("onResponse error:" + (res == null ? "null res" : res.message)));
                                }
                            }
                            SingleGameRequestManager.this.mListRequesting = false;
                        }
                    });
                }
            });
        } else {
            this.mListRequesting = false;
            MLog.error((Object)TAG, (String)"[requestSingleGameList] wrong uid: %d", (Object[])new Object[]{AccountUtil.getUid()});
            if (callBack != null) {
                callBack.onError(new RuntimeException("not logined!"));
            }
        }
    }

    private void notifyDataSortStart() {
        if (this.hasReceivedLocalSingleGameList && this.hasReceivedServerSingleGameList) {
            if (FP.empty(this.mLocalGamePlayInfo)) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"notifyDataSortStart no record", (Object[])new Object[0]);
                }
                this.notifyDataSortCompleted();
            } else {
                for (GamePlayInfo playInfo : this.mLocalGamePlayInfo) {
                    if (playInfo == null) continue;
                    for (SingleGameListItem item : this.mServerSingleGameList) {
                        if (item == null || !StringUtils.isNotEmpty((String)playInfo.getGameId()) || !StringUtils.isNotEmpty((String)item.getGameId()) || !playInfo.getGameId().equals(item.getGameId())) continue;
                        item.playInfo = playInfo;
                    }
                }
                this.notifyDataSortCompleted();
            }
        }
    }

    private void notifyDataSortCompleted() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"notifyDataSortCompleted single game list: %s", (Object[])new Object[]{this.mServerSingleGameList});
        }
        List<SingleGameListItem> tempList = this.modifyGameList(this.mServerSingleGameList);
        this.mServerSingleGameList.clear();
        this.mServerSingleGameList.addAll(tempList);
        if (this.mListCallBack != null) {
            this.mListCallBack.onSuccess(this.mServerSingleGameList);
        }
    }

    public void getLocalGamePlayInfo() {
        GameInfoModule gameInfoModule;
        if (this.hasLoadData) {
            return;
        }
        this.hasLoadData = true;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"getLocalGamePlayInfo", (Object[])new Object[0]);
        }
        if ((gameInfoModule = (GameInfoModule)KvoModuleManager.getModule(GameInfoModule.class)) == null) {
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalStateException("getLocalGamePlayInfo GameInfoModule == null");
            }
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"getLocalGamePlayInfo GameInfoModule == null", (Object[])new Object[0]);
            }
            this.hasReceivedLocalSingleGameList = true;
            this.notifyDataSortStart();
        } else {
            gameInfoModule.getSelectGameModelData(3, new GameInfoModuleData.MatchCallback(){

                public void onGetResult(List<GamePlayInfo> gamePlayInfos) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)SingleGameRequestManager.TAG, (String)"getLocalGamePlayInfo onGetResult game play info:%s", (Object[])new Object[]{gamePlayInfos});
                    }
                    SingleGameRequestManager.this.hasReceivedLocalSingleGameList = true;
                    if (!FP.empty(gamePlayInfos)) {
                        for (GamePlayInfo playInfo : gamePlayInfos) {
                            if (playInfo == null || playInfo.getGameModel() != 3) continue;
                            SingleGameRequestManager.this.mLocalGamePlayInfo.add(playInfo);
                        }
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)SingleGameRequestManager.TAG, (String)("cache game play info list: " + SingleGameRequestManager.this.mLocalGamePlayInfo), (Object[])new Object[0]);
                        }
                    }
                    SingleGameRequestManager.this.notifyDataSortStart();
                }
            });
        }
    }

    private List<SingleGameListItem> modifyGameList(List<SingleGameListItem> list) {
        ArrayList<SingleGameListItem> tempOriginList;
        block3: {
            tempOriginList = new ArrayList<SingleGameListItem>(list);
            CopyOnWriteArrayList<GameDataBean> gameList = new CopyOnWriteArrayList<GameDataBean>();
            for (SingleGameListItem dataItem : tempOriginList) {
                gameList.add(dataItem.dataItem);
            }
            try {
                ModifyJsGameHelper.Companion.modifyJsGame(gameList, tempOriginList);
            }
            catch (Exception e) {
                if (!RuntimeContext.sIsDebuggable) break block3;
                throw new RuntimeException(e);
            }
        }
        return tempOriginList;
    }
}

