/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.single.list.data;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.text.TextUtils;
import com.google.gson.annotations.Expose;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DontProguardClass;
import com.yy.hiyo.game.base.SingleGameExtInfo;
import com.yy.hiyo.game.base.bean.SingleGameListItem;

@DontProguardClass
public class SingleGameMiddleInfo {
    private static final String TAG = "SingleGameMiddleInfo";
    public String gameId;
    public String gameName;
    public String gameIcon;
    public boolean havePlayed;
    public boolean todayPlayed;
    public int recentScore;
    public int rank;
    public int overPeople;
    public int historyBest;
    public int todayBest;
    public int totalRankCount;
    public String recentPlayDate;
    public String encouragementText;
    public String circleIconUrl;
    public SingleGameExtInfo extInfo;
    public String describeText;
    public String bgUrl;
    public boolean fixing;
    public int bgColor;
    public int bottomBarColor;
    public int biggerRank;
    public int ranklimit;
    public String scoreType;
    @Expose(serialize=false, deserialize=false)
    public String tempBgUrl;
    @Expose(serialize=false, deserialize=false)
    public Bitmap tempBitmap;
    public boolean isFull;
    public boolean isBetaTest;
    public boolean isWaitingOffline;
    public boolean isDisconnect = false;

    public static SingleGameMiddleInfo create(SingleGameListItem item) {
        SingleGameMiddleInfo info = new SingleGameMiddleInfo();
        if (item != null && item.dataItem != null) {
            info.gameId = item.dataItem.getId();
            info.gameName = item.dataItem.getTitle();
            info.describeText = item.dataItem.getDesc();
            info.circleIconUrl = item.dataItem.getIconUrl();
            info.scoreType = item.dataItem.getScoreType();
            if (item.dataItem.singleGameExt != null) {
                info.bgUrl = item.dataItem.singleGameExt.tmpBackGroundUrl;
            }
            info.fixing = item.dataItem.isFixing();
            info.isFull = item.dataItem.isFull();
            info.isBetaTest = item.dataItem.isBetaTest();
            info.isWaitingOffline = item.dataItem.isWaitingOffline();
            try {
                if (!TextUtils.isEmpty((CharSequence)item.dataItem.getBannerImgColor())) {
                    info.bgColor = item.dataItem.getBannerColor();
                }
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"[create] bgColor %d", (Throwable)e, (Object[])new Object[]{info.bgColor});
            }
            try {
                if (!TextUtils.isEmpty((CharSequence)item.dataItem.singleGameExt.viewColor)) {
                    info.bottomBarColor = Color.parseColor((String)item.dataItem.singleGameExt.viewColor);
                }
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"[create] bottomBarColor", (Throwable)e, (Object[])new Object[0]);
            }
            info.extInfo = item.dataItem.singleGameExt;
        }
        return info;
    }

    public void updateMiddleInfo(SingleGameMiddleInfo info) {
        if (info != null && TextUtils.equals((CharSequence)this.gameId, (CharSequence)info.gameId)) {
            this.havePlayed = info.havePlayed;
            this.todayPlayed = info.todayPlayed;
            this.recentScore = info.recentScore;
            this.recentPlayDate = info.recentPlayDate;
            this.rank = info.rank;
            this.overPeople = info.overPeople;
            this.historyBest = info.historyBest;
            this.todayBest = info.todayBest;
            this.totalRankCount = info.totalRankCount;
            this.encouragementText = info.encouragementText;
            this.biggerRank = info.biggerRank;
            this.ranklimit = info.ranklimit;
        }
    }

    public void recycleTempBitmap() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SingleGameMiddleInfo.this.tempBgUrl = null;
                SingleGameMiddleInfo.this.tempBitmap = null;
            }
        }, (long)10000L);
    }

    public String toString() {
        return "SingleGameMiddleInfo{gameId='" + this.gameId + '\'' + ", gameName='" + this.gameName + '\'' + ", gameIcon='" + this.gameIcon + '\'' + ", havePlayed=" + this.havePlayed + ", todayPlayed=" + this.todayPlayed + ", recentScore=" + this.recentScore + ", rank=" + this.rank + ", overPeople=" + this.overPeople + ", historyBest=" + this.historyBest + ", todayBest=" + this.todayBest + ", totalRankCount=" + this.totalRankCount + ", recentPlayDate='" + this.recentPlayDate + '\'' + ", encouragementText='" + this.encouragementText + '\'' + '}';
    }
}

