/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.single.list;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.util.Property;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;

public class TouchEffector {
    public static final float BUTTON_DOWN_SCALE = 0.9f;
    public static final float BUTTON_UP_SCALE = 1.0f;

    public static void addButtonTouchEffect(View v) {
        if (v != null) {
            v.setOnTouchListener(new View.OnTouchListener(){
                private AnimatorSet downAnim;
                private AnimatorSet upAnim;

                public void playDownEffect(View v) {
                    if (v != null) {
                        if (this.downAnim == null) {
                            ObjectAnimator scaleXAnim = ObjectAnimator.ofFloat((Object)v, (Property)View.SCALE_X, (float[])new float[]{1.0f, 0.9f});
                            scaleXAnim.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
                            ObjectAnimator scaleYAnim = ObjectAnimator.ofFloat((Object)v, (Property)View.SCALE_Y, (float[])new float[]{1.0f, 0.9f});
                            scaleYAnim.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
                            this.downAnim = new AnimatorSet();
                            this.downAnim.playTogether(new Animator[]{scaleXAnim, scaleYAnim});
                            this.downAnim.setDuration(200L);
                        }
                        this.downAnim.start();
                    }
                }

                public void stopDownEffect() {
                    if (this.downAnim != null) {
                        this.downAnim.cancel();
                    }
                }

                public void playUpEffect(View v) {
                    if (v != null) {
                        if (this.upAnim == null) {
                            ObjectAnimator scaleXAnim = ObjectAnimator.ofFloat((Object)v, (Property)View.SCALE_X, (float[])new float[]{0.9f, 1.0f});
                            scaleXAnim.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
                            ObjectAnimator scaleYAnim = ObjectAnimator.ofFloat((Object)v, (Property)View.SCALE_Y, (float[])new float[]{0.9f, 1.0f});
                            scaleYAnim.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
                            this.upAnim = new AnimatorSet();
                            this.upAnim.playTogether(new Animator[]{scaleXAnim, scaleYAnim});
                            this.upAnim.setDuration(200L);
                        }
                        this.upAnim.start();
                    }
                }

                public void stopUpEffect() {
                    if (this.upAnim != null) {
                        this.upAnim.cancel();
                    }
                }

                public boolean onTouch(View v, MotionEvent event) {
                    switch (event.getAction()) {
                        case 0: {
                            this.stopUpEffect();
                            this.playDownEffect(v);
                            break;
                        }
                        case 1: 
                        case 3: {
                            this.stopDownEffect();
                            this.playUpEffect(v);
                            break;
                        }
                    }
                    return false;
                }
            });
        }
    }
}

