/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.single.list;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.animation.LinearInterpolator;
import androidx.annotation.ColorInt;
import com.yy.appbase.permission.AndPermission;
import com.yy.appbase.permission.SettingService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.appbase.ui.widget.status.IRequestCallback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.game.R;
import com.yy.game.download.GameDownloadUtils;
import com.yy.game.gamemodule.simplegame.single.list.ActionInterval;
import com.yy.game.gamemodule.simplegame.single.list.callback.ISingleGameListCallbackNew;
import com.yy.game.gamemodule.simplegame.single.list.callback.ISingleGameListViewCallback;
import com.yy.game.gamemodule.simplegame.single.list.data.SingleGameMiddleBullet;
import com.yy.game.gamemodule.simplegame.single.list.data.SingleGameMiddleInfo;
import com.yy.game.gamemodule.simplegame.single.list.widget.SingleGameListView;
import com.yy.game.gamemodule.simplegame.single.list.widget.SingleGamePlayButton;
import com.yy.hago.gamesdk.remotedebug.RemoteGameDebugService;
import com.yy.hiyo.game.base.singlegame.SingleGamePref;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class SingleGameListWindow
extends DefaultWindow
implements View.OnClickListener,
SingleGameListView.ISingleGameSwitchCallback,
ISingleGameListViewCallback {
    private static final long LOADING_TIMEOUT = 5000L;
    private ISingleGameListCallbackNew gameListCallback;
    private SingleGameListView gameListView;
    private CommonStatusLayout mStatusLayout;
    private SingleGamePlayButton singleGamePlayBtn;
    private YYImageView mBackView;
    private YYImageView mShareView;
    private ViewStub mNewGuideViewStub;
    private RecycleImageView mFingerView;
    private View mContentView;
    private View mGuideView;
    private ObjectAnimator mAnimator;
    private SingleGameMiddleInfo curGameInfo;
    private boolean isHiding = false;
    private boolean pendingUpdate = false;
    private ActionInterval clickInterval = new ActionInterval(300);
    private String mAutoStartGid;
    private boolean mSwitchToAutoStartGame = false;
    private YYImageView mplBottomView;
    private boolean isTransitionMode = false;
    private boolean isNewGuideShowing = false;
    private Context mContext;
    private Runnable mLoadingTimeout = new Runnable(){

        @Override
        public void run() {
            if (SingleGameListWindow.this.mStatusLayout != null) {
                SingleGameListWindow.this.mStatusLayout.showError();
            }
        }
    };
    private List<Runnable> mSendBarrageTaskList = new ArrayList<Runnable>(20);
    private Animator.AnimatorListener mSimpleAnimatorListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            SingleGameListWindow.this.removeGuideAndStopAnim();
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    };

    public SingleGameListWindow(Context context, UICallBacks callBacks, ISingleGameListCallbackNew gameListCallback) {
        super(context, callBacks, "SingleGameList");
        this.mContext = context;
        this.gameListCallback = gameListCallback;
        this.init();
        this.setWindowType(110);
        this.setNeedFullScreen(true);
    }

    private void init() {
        this.mContentView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.window_single_game_list_new, null);
        this.getBaseLayer().addView(this.mContentView, new ViewGroup.LayoutParams(-1, -1));
        this.gameListView = (SingleGameListView)this.mContentView.findViewById(R.id.single_game_list_view);
        this.gameListView.setCallback(this);
        this.gameListView.setSingleGameSwitchCallback(this);
        this.gameListView.initBarrageView(2);
        this.singleGamePlayBtn = (SingleGamePlayButton)this.mContentView.findViewById(R.id.single_game_item_play);
        this.singleGamePlayBtn.setOnClickListener(this);
        this.mBackView = (YYImageView)this.mContentView.findViewById(R.id.single_game_item_back);
        this.mBackView.setOnClickListener((View.OnClickListener)this);
        this.mShareView = (YYImageView)this.mContentView.findViewById(R.id.single_game_item_share);
        this.mShareView.setOnClickListener((View.OnClickListener)this);
        this.createGuideLayout(this.mContentView);
        this.mplBottomView = (YYImageView)this.findViewById(R.id.iv_mpl_banner);
        this.mStatusLayout = (CommonStatusLayout)this.findViewById(R.id.status_layout);
        this.mStatusLayout.setRequestCallback(new IRequestCallback(){

            public void onRequest(int type) {
                if (SingleGameListWindow.this.checkNetAndLoading()) {
                    SingleGameListWindow.this.gameListCallback.requestSingleGameList();
                }
            }
        });
        this.setGameList(this.gameListCallback.getSingleGameList(), this.gameListCallback.getCurGameId());
    }

    private void createGuideLayout(View rootView) {
        if (rootView == null) {
            return;
        }
        boolean hasShowedGuide = SingleGamePref.getBoolean((String)"has_showed_guide", (boolean)false);
        if (!hasShowedGuide) {
            this.isNewGuideShowing = true;
            this.mNewGuideViewStub = (ViewStub)rootView.findViewById(R.id.single_game_new_guide_layout);
            this.mGuideView = this.mNewGuideViewStub.inflate();
            if (this.mGuideView == null) {
                return;
            }
            this.mGuideView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MotionEvent event = MotionEvent.obtain((long)SystemClock.uptimeMillis(), (long)SystemClock.uptimeMillis(), (int)1, (float)500.0f, (float)200.0f, (int)0);
                    if (SingleGameListWindow.this.gameListView.getGameListVP() != null) {
                        SingleGameListWindow.this.gameListView.getGameListVP().dispatchTouchEvent(event);
                    }
                    event.recycle();
                    SingleGameListWindow.this.removeGuideAndStopAnim();
                }
            });
            this.mFingerView = (RecycleImageView)this.mGuideView.findViewById(R.id.single_game_guide_finger);
            this.playGuideAnim();
            SingleGamePref.setBoolean((String)"has_showed_guide", (boolean)true);
        }
    }

    private void playGuideAnim() {
        if (this.mFingerView == null) {
            return;
        }
        this.mFingerView.post(new Runnable(){

            @Override
            public void run() {
                float moveInstance = SingleGameListWindow.this.mFingerView.getTranslationX() - (float)ResolutionUtils.dip2Px((float)30.0f);
                SingleGameListWindow.this.mAnimator = ObjectAnimator.ofFloat((Object)SingleGameListWindow.this.mFingerView, (Property)View.TRANSLATION_X, (float[])new float[]{SingleGameListWindow.this.mFingerView.getTranslationX(), moveInstance, SingleGameListWindow.this.mFingerView.getTranslationX()});
                SingleGameListWindow.this.mAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
                SingleGameListWindow.this.mAnimator.setDuration(3000L);
                SingleGameListWindow.this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
                    MotionEvent event;
                    long downTime;

                    public void onAnimationUpdate(ValueAnimator animation) {
                        try {
                            Float value = (Float)animation.getAnimatedValue();
                            if (this.event == null) {
                                this.downTime = SystemClock.uptimeMillis();
                                this.event = MotionEvent.obtain((long)this.downTime, (long)SystemClock.uptimeMillis(), (int)0, (float)500.0f, (float)200.0f, (int)0);
                                if (SingleGameListWindow.this.gameListView.getGameListVP() != null) {
                                    SingleGameListWindow.this.gameListView.getGameListVP().dispatchTouchEvent(this.event);
                                }
                                this.event.recycle();
                            } else if (value.floatValue() != 0.0f) {
                                this.event = MotionEvent.obtain((long)this.downTime, (long)SystemClock.uptimeMillis(), (int)2, (float)(500.0f + value.floatValue()), (float)200.0f, (int)0);
                                if (SingleGameListWindow.this.gameListView.getGameListVP() != null) {
                                    SingleGameListWindow.this.gameListView.getGameListVP().dispatchTouchEvent(this.event);
                                }
                                this.event.recycle();
                            } else {
                                this.event = MotionEvent.obtain((long)this.downTime, (long)SystemClock.uptimeMillis(), (int)1, (float)(500.0f + value.floatValue()), (float)200.0f, (int)0);
                                if (SingleGameListWindow.this.gameListView.getGameListVP() != null) {
                                    SingleGameListWindow.this.gameListView.getGameListVP().dispatchTouchEvent(this.event);
                                }
                                this.event.recycle();
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)"AbstractWindow", (String)"onAnimationUpdate error: %s", (Object[])new Object[]{e.toString()});
                        }
                    }
                });
                SingleGameListWindow.this.mAnimator.addListener(SingleGameListWindow.this.mSimpleAnimatorListener);
                SingleGameListWindow.this.mAnimator.start();
            }
        });
    }

    private void removeGuideAndStopAnim() {
        if (this.mAnimator != null) {
            this.mAnimator.cancel();
            this.mAnimator = null;
        }
        if (this.mContentView != null && this.mGuideView != null) {
            ((YYFrameLayout)this.mContentView).removeView(this.mGuideView);
        }
        this.isNewGuideShowing = false;
        if (this.gameListCallback != null) {
            this.setBulletData(this.gameListCallback.getSingleBulletList());
        }
    }

    public void setGameList(List<SingleGameMiddleInfo> singleGameInfos, String curGameId) {
        if (FP.empty(singleGameInfos)) {
            this.checkNetAndLoading();
        } else {
            YYTaskExecutor.removeTask((Runnable)this.mLoadingTimeout);
            if (this.mStatusLayout != null) {
                this.mStatusLayout.hideAllStatus();
            }
            if (!this.isHiding) {
                this.gameListView.setGameList(singleGameInfos, curGameId);
            } else {
                this.pendingUpdate = true;
            }
        }
    }

    public void setBulletData(List<SingleGameMiddleBullet> bulletList) {
        if (!this.isHiding && !this.isNewGuideShowing) {
            if (bulletList == null || bulletList.isEmpty()) {
                return;
            }
            this.showBarrageViewDelayed(bulletList);
        }
    }

    private void showBarrageViewDelayed(List<SingleGameMiddleBullet> bullets) {
        if (bullets == null || bullets.isEmpty()) {
            return;
        }
        Random random = new Random(5L);
        long currentDelayTime = 0L;
        int size = bullets.size();
        for (int i = 0; i < size; ++i) {
            SingleGameMiddleBullet bullet = bullets.get(i);
            if (bullet == null) continue;
            String avatar = bullet.avatar;
            String barrageMessage = "";
            int barrageType = this.getSingleGameBarrageType(bullet);
            int barrageColor = ResourceUtils.getColor((int)R.color.barrage_default);
            if (barrageType == 0) {
                barrageMessage = StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.single_game_middle_page_barrage_friend_champion), (Object[])new Object[]{bullet.nickName, bullet.gameName});
                barrageColor = ResourceUtils.getColor((int)R.color.barrage_friend_champion);
            } else if (barrageType == 1) {
                barrageMessage = StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.single_game_middle_page_barrage_friend_ranked), (Object[])new Object[]{bullet.nickName, bullet.rank, bullet.gameName});
                barrageColor = ResourceUtils.getColor((int)R.color.barrage_friend_ranked);
            } else if (barrageType == 2) {
                barrageMessage = StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.single_game_middle_page_barrage_friend_playing), (Object[])new Object[]{bullet.nickName});
                barrageColor = ResourceUtils.getColor((int)R.color.barrage_friend_play);
            } else if (barrageType == 3) {
                barrageMessage = StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.single_game_middle_page_barrage_other_champion), (Object[])new Object[]{bullet.nickName, bullet.gameName});
                barrageColor = ResourceUtils.getColor((int)R.color.barrage_other_champion);
            } else if (barrageType == 4) {
                barrageMessage = StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.single_game_middle_page_barrage_other_ranked), (Object[])new Object[]{bullet.nickName, bullet.rank, bullet.gameName});
                barrageColor = ResourceUtils.getColor((int)R.color.barrage_other_ranked);
            } else if (barrageType == 5) {
                barrageMessage = StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.single_game_middle_page_barrage_other_played), (Object[])new Object[]{bullet.nickName});
                barrageColor = ResourceUtils.getColor((int)R.color.barrage_other_play);
            }
            int nextInt = random.nextInt(8);
            this.addBarrageView(avatar, barrageMessage, barrageColor, currentDelayTime += (long)(nextInt * 1000));
        }
    }

    private void addBarrageView(final String avatar, final String msg, final @ColorInt int color2, long delayMills) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                if (SingleGameListWindow.this.gameListView != null) {
                    SingleGameListWindow.this.gameListView.addBarrageView(avatar, msg, color2);
                }
            }
        };
        this.mSendBarrageTaskList.add(task);
        YYTaskExecutor.postToMainThread((Runnable)task, (long)delayMills);
    }

    private void removeAllSendBarrageTask() {
        for (Runnable task : this.mSendBarrageTaskList) {
            if (task == null) continue;
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)task);
        }
    }

    private int getSingleGameBarrageType(SingleGameMiddleBullet bullet) {
        if (bullet == null) {
            return -1;
        }
        int bulletType = bullet.bulletType;
        switch (bulletType) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 4;
            }
        }
        return -1;
    }

    public void onAttach() {
        super.onAttach();
    }

    public void onDetached() {
        this.removeAllSendBarrageTask();
        if (this.gameListView != null) {
            this.gameListView.clearBarrageView();
            this.gameListView.dismissShortcutTipView();
        }
        super.onDetached();
    }

    public void onShown() {
        super.onShown();
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024337").put("function_id", "show").put("page_id", "1").put("token", ServiceManagerProxy.getServiceManager() == null ? null : ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getAlgorithmTokenUrlencode()));
        this.isHiding = false;
        if (FP.empty(this.gameListCallback.getSingleGameList())) {
            this.checkNetAndLoading();
        } else {
            YYTaskExecutor.removeTask((Runnable)this.mLoadingTimeout);
            if (this.mStatusLayout != null) {
                this.mStatusLayout.hideAllStatus();
            }
            if (this.pendingUpdate) {
                this.setGameList(this.gameListCallback.getSingleGameList(), this.gameListCallback.getCurGameId());
                this.pendingUpdate = false;
            }
        }
        this.gameListView.startBarrageView();
    }

    public void onHidden() {
        super.onHidden();
        this.isHiding = true;
        this.gameListView.pauseBarrageView();
    }

    public void setAutoStartGid(String gid) {
        this.mAutoStartGid = gid;
        this.mSwitchToAutoStartGame = TextUtils.equals((CharSequence)this.gameListCallback.getCurGameId(), (CharSequence)this.getCurGame());
    }

    public void onClick(View v) {
        if (!this.clickInterval.checkAction()) {
            return;
        }
        this.clickInterval.markAction();
        long id2 = v.getId();
        if (id2 == (long)R.id.single_game_item_play) {
            this.onPlayClick();
            this.gameListCallback.onSingleGamePlayClick();
        } else if (id2 == (long)R.id.single_game_item_back) {
            this.mAutoStartGid = "";
            this.mSwitchToAutoStartGame = false;
            if (this.gameListCallback != null) {
                this.gameListCallback.closeWindow();
            }
        } else if (id2 == (long)R.id.single_game_item_share) {
            this.mAutoStartGid = "";
            this.mSwitchToAutoStartGame = false;
            if (this.gameListCallback != null) {
                this.gameListCallback.onShareBtnClicked(this.getCurGame());
            }
        }
    }

    private void onPlayClick() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024337").put("function_id", "play_click").put("page_id", "1").put("gid", this.getCurGame()).put("token", ServiceManagerProxy.getServiceManager() == null ? null : ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getAlgorithmTokenUrlencode()));
        if (this.curGameInfo == null || !this.gameListCallback.checkMinSupportAppVersion(this.curGameInfo.gameId)) {
            return;
        }
        if (this.curGameInfo.isBetaTest) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_beta_test_game), (int)1);
        } else {
            if (this.curGameInfo.isFull) {
                TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_game_full), (int)1);
                return;
            }
            if (this.curGameInfo.fixing) {
                TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.game_maintening), (int)1);
                return;
            }
        }
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.str_network_not_capable), (int)0);
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.getCurGame())) {
            boolean canPlay;
            boolean useRemote = RemoteGameDebugService.Companion.useRemoteIp(this.getCurGame());
            if (useRemote) {
                GameDownloadUtils.deleteAllGameDebug();
            }
            boolean bl = canPlay = !useRemote && this.gameListCallback.playGame(this.curGameInfo.gameId);
            if (!canPlay) {
                this.gameListCallback.downloadGame(this.curGameInfo.gameId);
                this.singleGamePlayBtn.showProgress(Math.max(0.1f, this.gameListCallback.getDownloadProgress(this.getCurGame())));
                this.gameListCallback.preloadGameLoadingPage(this.curGameInfo.gameId);
                ToastUtils.showToast((Activity)((Activity)this.getContext()), (int)R.string.single_game_download_tip, (int)0);
                this.setAutoStartGid(this.curGameInfo.gameId);
            }
        } else if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"AbstractWindow", (String)"[onClick] wrong game, id: %s", (Object[])new Object[]{this.curGameInfo == null ? "null" : this.curGameInfo.gameId});
        }
    }

    public String getCurGame() {
        return this.curGameInfo == null || this.curGameInfo.gameId == null ? "" : this.curGameInfo.gameId;
    }

    public void updateGameDownloadProgress(String gameId, float progress) {
        if (!TextUtils.isEmpty((CharSequence)this.getCurGame()) && TextUtils.equals((CharSequence)gameId, (CharSequence)this.getCurGame())) {
            if (progress > 1.0f) {
                this.singleGamePlayBtn.showPlayButton();
                if (!TextUtils.isEmpty((CharSequence)this.mAutoStartGid)) {
                    this.mAutoStartGid = "";
                    this.mSwitchToAutoStartGame = false;
                    this.gameListCallback.playGame(this.getCurGame());
                }
            } else {
                this.singleGamePlayBtn.showProgress(Math.max(0.1f, progress));
            }
        }
    }

    @Override
    public void onSingleGameSwitch(SingleGameMiddleInfo curGameInfo) {
        if (curGameInfo == null) {
            MLog.error((Object)"AbstractWindow", (String)"[onSingleGameSwitch] empty game info", (Object[])new Object[0]);
        }
        if (curGameInfo != null && !TextUtils.equals((CharSequence)this.getCurGame(), (CharSequence)curGameInfo.gameId) && TextUtils.equals((CharSequence)this.mAutoStartGid, (CharSequence)curGameInfo.gameId)) {
            if (this.mSwitchToAutoStartGame) {
                this.mSwitchToAutoStartGame = false;
                this.mAutoStartGid = "";
            } else {
                this.mSwitchToAutoStartGame = true;
            }
        }
        this.curGameInfo = curGameInfo;
        if (!TextUtils.isEmpty((CharSequence)this.getCurGame()) && !TextUtils.equals((CharSequence)this.gameListCallback.getCurGameId(), (CharSequence)this.getCurGame())) {
            this.gameListCallback.updateCurGameId(this.getCurGame());
        }
        if (this.gameListCallback.isDownloading(this.getCurGame())) {
            float progress = this.gameListCallback.getDownloadProgress(this.getCurGame());
            this.singleGamePlayBtn.showProgress(Math.max(0.1f, progress));
        } else {
            this.singleGamePlayBtn.showPlayButton();
        }
        this.singleGamePlayBtn.setVisibility(this.curGameInfo == null || this.isTransitionMode ? 8 : 0);
        if (curGameInfo != null) {
            if (curGameInfo.isBetaTest) {
                this.singleGamePlayBtn.getPlayBtn().setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.game_single_game_list_play_btn_bg));
                this.singleGamePlayBtn.getPlayBtn().setText((CharSequence)ResourceUtils.getString((int)R.string.single_game_btn_play));
            } else if (curGameInfo.isFull) {
                this.singleGamePlayBtn.getPlayBtn().setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.selector_game_card_mentaining_btn_bg));
                this.singleGamePlayBtn.getPlayBtn().setText((CharSequence)ResourceUtils.getString((int)R.string.btn_full));
            } else if (curGameInfo.fixing) {
                this.singleGamePlayBtn.getPlayBtn().setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.selector_game_card_mentaining_btn_bg));
                this.singleGamePlayBtn.getPlayBtn().setText((CharSequence)ResourceUtils.getString((int)R.string.maintaining));
            } else {
                this.singleGamePlayBtn.getPlayBtn().setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.game_single_game_list_play_btn_bg));
                this.singleGamePlayBtn.getPlayBtn().setText((CharSequence)ResourceUtils.getString((int)R.string.single_game_btn_play));
            }
        }
    }

    public void indexTo(String gameId) {
        if (!TextUtils.isEmpty((CharSequence)gameId)) {
            this.setAutoStartGid(gameId);
            this.gameListView.indexToGame(gameId);
        }
    }

    @Override
    public void onSingleGameBottomBarClick(String gameId) {
        if (this.clickInterval.checkAction()) {
            this.mSwitchToAutoStartGame = false;
            this.mAutoStartGid = "";
            this.gameListCallback.toRankList(gameId);
            this.clickInterval.markAction();
        }
    }

    @Override
    public void onSingleGameItemClick(String gameId) {
    }

    @Override
    public void onSingleGameBackClick() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"AbstractWindow", (String)"onSingleGameBackClick clicked", (Object[])new Object[0]);
        }
        if (this.gameListCallback != null) {
            this.gameListCallback.closeWindow();
        }
    }

    @Override
    public void onSingleGameShareClick(String gameId) {
        if (this.gameListCallback != null) {
            this.gameListCallback.onShareBtnClicked(gameId);
        }
    }

    @Override
    public void onSingleGameAddShortcutClick(String gameId, String gameName, String iconUrl) {
        boolean hasShowedGuideToSettings;
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024337").put("function_id", "short_cut_click").put("page_id", "1").put("gid", this.getCurGame()).put("token", ServiceManagerProxy.getServiceManager() == null ? null : ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getAlgorithmTokenUrlencode()));
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"AbstractWindow", (String)"onSingleGameAddShortcutClick game id %s , game name: %s", (Object[])new Object[]{gameId, gameName});
        }
        if (hasShowedGuideToSettings = SingleGamePref.getBoolean((String)"guide_to_settings", (boolean)false)) {
            if (this.gameListCallback != null) {
                this.gameListCallback.onCreateShortcut(gameId, gameName, iconUrl);
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024337").put("function_id", "create_click").put("page_id", "1").put("gid", this.getCurGame()).put("token", ServiceManagerProxy.getServiceManager() == null ? null : ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getAlgorithmTokenUrlencode()));
            }
        } else {
            final SettingService settingService = AndPermission.permissionSetting((Activity)((Activity)this.mContext));
            this.getDialogLinkManager().showDialog((BaseDialog)new OkCancelDialog((CharSequence)ResourceUtils.getString((int)R.string.single_game_create_shortcut_settings_tip), (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_yes), (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_no), new OkCancelDialogListener(){

                public void onCancel() {
                    settingService.cancel();
                }

                public void onOk() {
                    SingleGamePref.setBoolean((String)"guide_to_settings", (boolean)true);
                    settingService.execute();
                }
            }));
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024337").put("function_id", "popup_show").put("page_id", "1").put("gid", this.getCurGame()).put("token", ServiceManagerProxy.getServiceManager() == null ? null : ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getAlgorithmTokenUrlencode()));
        }
    }

    private boolean checkNetAndLoading() {
        if (this.mStatusLayout == null) {
            return true;
        }
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            this.mStatusLayout.showNetworkError();
            return false;
        }
        this.mStatusLayout.showLoading();
        YYTaskExecutor.removeTask((Runnable)this.mLoadingTimeout);
        YYTaskExecutor.postToMainThread((Runnable)this.mLoadingTimeout, (long)5000L);
        return true;
    }

    public void switchToMplTransitionMode(final String gameId, final String mplId, final int mplType, final String activityId, final int rewardType) {
        if (StringUtils.isEmpty((String)gameId)) {
            MLog.error((Object)"AbstractWindow", (String)"switchToMplTransitionMode: gameId is empty", (Object[])new Object[0]);
            return;
        }
        if (StringUtils.isEmpty((String)mplId)) {
            MLog.error((Object)"AbstractWindow", (String)"switchToMplTransitionMode: roomId is empty", (Object[])new Object[0]);
            return;
        }
        if (mplType == 0) {
            MLog.error((Object)"AbstractWindow", (String)"switchToMplTransitionMode: mplType is null", (Object[])new Object[0]);
            return;
        }
        this.isTransitionMode = true;
        this.singleGamePlayBtn.setVisibility(8);
        this.gameListView.setCanScroll(false);
        if (this.mNewGuideViewStub != null) {
            this.mNewGuideViewStub.setVisibility(8);
        }
        if (this.mFingerView != null) {
            this.mFingerView.setVisibility(8);
        }
        if (this.mFingerView != null) {
            this.mGuideView.setVisibility(8);
        }
        this.mplBottomView.setVisibility(0);
        this.indexTo(gameId);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SingleGameListWindow.this.gameListCallback.playMplSingleGame(gameId, mplId, mplType, activityId, rewardType);
                SingleGameListWindow.this.gameListCallback.closeWindow();
            }
        }, (long)2000L);
    }
}

