/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.single.list;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import com.bumptech.glide.load.DecodeFormat;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.deeplink.data.SingleGameLinkParam;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.callback.OnProfileListCallback;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.transform.YYBitmapTransformation;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.game.R;
import com.yy.game.gamemodule.simplegame.single.list.SingleGameListWindow;
import com.yy.game.gamemodule.simplegame.single.list.callback.ISingleGameListCallbackNew;
import com.yy.game.gamemodule.simplegame.single.list.data.SingleGameMiddleBullet;
import com.yy.game.gamemodule.simplegame.single.list.data.SingleGameMiddleBulletList;
import com.yy.game.gamemodule.simplegame.single.list.data.SingleGameMiddleInfo;
import com.yy.game.gamemodule.simplegame.single.list.data.SingleGameMiddlePageInfo;
import com.yy.game.gamemodule.simplegame.single.list.data.SingleGameReliveInfo;
import com.yy.game.gamemodule.simplegame.single.list.request.ISingleGameListRequestCallBack;
import com.yy.game.gamemodule.simplegame.single.list.request.SingleGameRequestManager;
import com.yy.game.gamemodule.simplegame.single.model.SingleGameResultData;
import com.yy.game.module.gameload.LoadGamePageManager;
import com.yy.game.msg.GameMsgDef;
import com.yy.hiyo.game.base.GameDataBean;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameInfoSource;
import com.yy.hiyo.game.base.bean.SingleGameListItem;
import com.yy.hiyo.game.base.singlegame.SingleGamePref;
import com.yy.hiyo.game.kvomodule.GameInfoModule;
import com.yy.hiyo.game.kvomodule.GameInfoModuleData;
import com.yy.hiyo.game.kvomodule.SingleGameBestHistoryInfo;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameResultShareService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.bean.singlegame.SingleGamePlayContext;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.base.ISharePage;
import com.yy.hiyo.share.base.ShareItemClickListener;
import com.yy.socialplatformbase.callback.IShareCallBack;
import com.yy.socialplatformbase.data.ShareData;
import com.yy.webservice.WebEnvSettings;
import com.yy.webservice.webwindow.AbsWebWindow;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import org.jetbrains.annotations.NotNull;

public class SingleGameListController
extends DefaultWindowController
implements ISingleGameListCallbackNew,
INotify,
ISharePage {
    private static final String TAG = "SingleGameListController";
    public static final String KEY_AUTO_DOWNLOAD = "KEY_AUTO_DOWNLOAD";
    public static final String KEY_AUTO_START = "KEY_AUTO_START";
    private Context ctx;
    private SingleGameListWindow gameListWindow;
    private Map<String, SingleGameListItem> singleGameDataMap;
    private Map<String, SingleGameMiddleInfo> mServerMiddleInfo = new HashMap<String, SingleGameMiddleInfo>();
    private List<SingleGameMiddleInfo> singleGameInfoList = new ArrayList<SingleGameMiddleInfo>();
    private List<String> mSingleGameIdList = new ArrayList<String>();
    private Map<String, Float> singleGameDownloadMap = new HashMap<String, Float>();
    private List<String> mPendingDownloadGameList;
    private List<GameInfo> mSingleGameInfo;
    private String curGameId = "";
    private boolean mIsSharing;
    private AbstractWindow rankWindow;
    private boolean isFromSingleGameResultWindow = false;
    private boolean isNeedUpdateBulletInfo = false;
    private Message mDelayMsg;
    private String mWebGameId;
    private float mLastWebGameProgress;
    private Map<String, String> mExt;
    private static final long CACHE_BARRAGE_INFO_EXPIRE_TIME = 300000L;
    private long mLastRequestBarrageInfoTime = 0L;
    private List<SingleGameMiddleBullet> mCacheBulletList = new ArrayList<SingleGameMiddleBullet>();
    private SingleGameRequestManager mRequestManager;
    private String mDisconnectGameId = "";
    private SingleGameMiddleInfo mMiddleInfo;

    public SingleGameListController(Environment env) {
        super(env);
        this.ctx = env.getContext();
        this.registerMsg();
        this.requestSingleGameList();
    }

    private void registerMsg() {
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_SUCCESS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_ACCOUNT_CHANGED, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.GAME_DOWNLOAD_FINISH, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.GAME_DOWNLOAD_ERROR, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.SINGLE_GAME_SCORE_UPDATE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_NETWORK_STATE_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED, (INotify)this);
    }

    private void showWindow() {
        if (this.gameListWindow == null) {
            this.preloadBitmap(true);
            this.gameListWindow = new SingleGameListWindow(this.ctx, (UICallBacks)this, this);
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (SingleGameListController.this.gameListWindow != null) {
                        SingleGameListController.this.mWindowMgr.pushWindow((AbstractWindow)SingleGameListController.this.gameListWindow, true);
                    }
                }
            }, (long)100L);
            this.gameListWindow.indexTo(this.getCurGameId());
        } else if (this.mWindowMgr.getCurrentWindow() instanceof SingleGameListWindow) {
            this.gameListWindow.indexTo(this.getCurGameId());
        } else {
            if (this.rankWindow != null) {
                this.mWindowMgr.popWindow(false, this.rankWindow);
                this.rankWindow = null;
            }
            this.mWindowMgr.popWindow(false, (AbstractWindow)this.gameListWindow);
            this.gameListWindow = new SingleGameListWindow(this.ctx, (UICallBacks)this, this);
            this.mWindowMgr.pushWindow((AbstractWindow)this.gameListWindow, true);
        }
    }

    private void preloadBitmap(final boolean loadFirstGameImage) {
        List<SingleGameMiddleInfo> list = this.getSingleGameList();
        if (!FP.empty(list)) {
            if (loadFirstGameImage) {
                this.mMiddleInfo = list.get(0);
            } else {
                for (SingleGameMiddleInfo info : list) {
                    if (info == null || StringUtils.isEmpty((String)info.gameId) || !info.gameId.equals(this.curGameId)) continue;
                    this.mMiddleInfo = info;
                    break;
                }
            }
            if (this.mMiddleInfo != null && StringUtils.isNotEmpty((String)this.mMiddleInfo.bgUrl)) {
                this.mMiddleInfo.tempBgUrl = this.mMiddleInfo.bgUrl;
                ImageLoader.loadBitmap((Context)RuntimeContext.sApplicationContext, (String)this.mMiddleInfo.bgUrl, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                    public void onLoadFailed(Exception e) {
                    }

                    public void onResourceReady(Bitmap bitmap) {
                        if (bitmap != null) {
                            ((SingleGameListController)SingleGameListController.this).mMiddleInfo.tempBgUrl = ((SingleGameListController)SingleGameListController.this).mMiddleInfo.bgUrl;
                            ((SingleGameListController)SingleGameListController.this).mMiddleInfo.tempBitmap = bitmap;
                            if (loadFirstGameImage) {
                                SingleGameListController.this.mMiddleInfo.recycleTempBitmap();
                            }
                        }
                    }
                }, (int)ScreenUtils.getInstance().getWidthPixels(), (int)ScreenUtils.getInstance().getHeightPixels(), (boolean)false, (DecodeFormat)DecodeFormat.PREFER_ARGB_8888, (YYBitmapTransformation[])null);
            }
        }
    }

    @Override
    public void closeWindow() {
        boolean fromShare;
        if (this.gameListWindow != null) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.gameListWindow);
            this.gameListWindow = null;
        }
        if (fromShare = SingleGamePref.getBoolean((String)"download_from_share", (boolean)false)) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    Message msg = Message.obtain();
                    msg.what = BaseMsgDef.SINGLE_GAME_SCROLL_TO_ENTRANCE;
                    SingleGameListController.this.sendMessage(msg);
                }
            }, (long)300L);
        }
    }

    public void onWindowAttach(AbstractWindow abstractWindow) {
        super.onWindowAttach(abstractWindow);
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.gameListWindow == abstractWindow) {
            this.gameListWindow = null;
        }
    }

    @Override
    public List<SingleGameMiddleInfo> getSingleGameList() {
        return this.singleGameInfoList;
    }

    public Object handleMessageSync(Message msg) {
        if (msg.what == GameMsgDef.MSG_NOTIFY_SINGLE_GAME_LIST_DISCONNECT) {
            if (!NetworkUtils.isNetworkAvailable((Context)this.mContext)) {
                if (!FP.empty(this.singleGameInfoList) && StringUtils.isNotEmpty((String)this.curGameId)) {
                    for (SingleGameMiddleInfo info : this.singleGameInfoList) {
                        if (info == null || !this.curGameId.equals(info.gameId)) continue;
                        info.isDisconnect = true;
                        this.mDisconnectGameId = info.gameId;
                        this.notifyUpdate();
                        break;
                    }
                }
            } else {
                this.refreshSingleGameRecord();
                TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.tips_single_game_middle_update_score), (int)5000, (int)-15152314, (boolean)false);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)SingleGameListController.TAG, (String)"refresh game record after 5 seconds.", (Object[])new Object[0]);
                        }
                        SingleGameListController.this.refreshSingleGameRecord();
                    }
                }, (long)5000L);
            }
        } else if (msg.what == GameMsgDef.MSG_OPEN_SINGLE_GAME_LIST_WINDOW_IMMEDIATELY && !((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).isPlaying()) {
            this.curGameId = (String)msg.obj;
            if (this.gameListWindow == null) {
                this.gameListWindow = new SingleGameListWindow((Context)this.mContext, (UICallBacks)this, this);
            }
            this.mWindowMgr.pushWindow((AbstractWindow)this.gameListWindow, false);
            this.preloadBitmap(false);
        }
        return super.handleMessageSync(msg);
    }

    public void handleMessage(Message msg) {
        if (msg.what == BaseMsgDef.MSG_OPEN_SINGLE_GAME_LIST_WINDOW) {
            String targetGameId;
            if (((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).isPlaying()) {
                MLog.error((Object)TAG, (String)"[handleMessage] gaming, can not open", (Object[])new Object[0]);
                return;
            }
            this.isNeedUpdateBulletInfo = true;
            this.requestSingleGameList();
            Bundle bundle = msg.getData();
            if (bundle != null) {
                String autoDownloadId = bundle.getString("game_id", "");
                this.curGameId = TextUtils.isEmpty((CharSequence)autoDownloadId) ? this.curGameId : autoDownloadId;
            }
            this.showWindow();
            if (bundle != null && StringUtils.isNotEmpty((String)(targetGameId = bundle.getString("mpl_game_id", ""))) && this.gameListWindow != null) {
                String mplId = bundle.getString("mpl_id", "");
                int mplType = bundle.getInt("mpl_playType", 0);
                String activityId = bundle.getString("key_activity", "");
                int rewardType = bundle.getInt("mpl_award_type", 0);
                this.gameListWindow.switchToMplTransitionMode(targetGameId, mplId, mplType, activityId, rewardType);
            }
            if (this.gameListWindow != null && this.mWindowMgr.getCurrentWindow() == this.gameListWindow) {
                this.handleOpenGame(msg);
            } else {
                this.mDelayMsg = msg;
            }
        } else if (msg.what == GameMsgDef.MSG_REQ_SINGLE_GAME_LIST) {
            this.requestSingleGameList();
        } else if (msg.what == GameMsgDef.MSG_OPEN_SINGLE_GAME_RANK_LIST) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"toRankList", (Object[])new Object[0]);
            }
            this.isFromSingleGameResultWindow = (Boolean)msg.obj;
            this.toRankList(this.getCurGameId());
        } else if (msg.what == GameMsgDef.MSG_REQ_SINGLE_GAME_LIST_MIDDLE_INFO) {
            this.isNeedUpdateBulletInfo = true;
            this.refreshSingleGameRecord();
        } else if (msg.what == BaseMsgDef.SINGLE_GAME_RELIVE_SHARE) {
            final String requestJson = (String)msg.obj;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"game call app share request json: %s", (Object[])new Object[]{requestJson});
            }
            if (TextUtils.isEmpty((CharSequence)requestJson)) {
                return;
            }
            final SingleGameReliveInfo[] reliveInfo = new SingleGameReliveInfo[1];
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    reliveInfo[0] = (SingleGameReliveInfo)JsonParser.parseJsonObject((String)requestJson, SingleGameReliveInfo.class);
                }
            }, (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (reliveInfo[0] == null) {
                        return;
                    }
                    String gameId = reliveInfo[0].mGameId;
                    if (TextUtils.isEmpty((CharSequence)gameId)) {
                        return;
                    }
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)SingleGameListController.TAG, (String)"game call app share game id: %s", (Object[])new Object[]{gameId});
                    }
                    SingleGameListController.this.onReliveShareClicked(gameId);
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20027257").put("event", "click").put("event_id", "app_revival"));
                }
            });
        }
    }

    private void handleOpenGame(Message msg) {
        if (msg.obj instanceof SingleGameLinkParam) {
            SingleGameLinkParam param = (SingleGameLinkParam)msg.obj;
            String businessId = param.businessId;
            String gameId = param.gameId;
            if (!TextUtils.isEmpty((CharSequence)gameId)) {
                this.curGameId = gameId;
                if ("download_from_h5".equals(businessId) && param.isFirstLaunch) {
                    SingleGamePref.setBoolean((String)("buff_" + gameId), (boolean)true);
                    SingleGamePref.setBoolean((String)"download_from_share", (boolean)true);
                }
            }
        }
        Bundle bundle = msg.getData();
        boolean autoDownload = false;
        boolean autoStart = false;
        String autoDownloadId = this.getCurGameId();
        if (bundle != null) {
            autoDownload = bundle.getBoolean(KEY_AUTO_DOWNLOAD, false);
            autoStart = bundle.getBoolean(KEY_AUTO_START, false);
        }
        if (!FP.empty((CharSequence)autoDownloadId)) {
            if (autoStart) {
                this.startSingleGameDefault(autoDownloadId);
            } else if (autoDownload) {
                this.downloadGame(autoDownloadId);
            }
        }
    }

    public void notify(Notification notification) {
        int notifyId = notification.id;
        if (notifyId == NotificationDef.N_LOGIN_SUCCESS || notification.id == NotificationDef.N_LOGIN_ACCOUNT_CHANGED) {
            this.mServerMiddleInfo.clear();
            this.mCacheBulletList.clear();
        } else if (notifyId == NotificationIdDef.GAME_DOWNLOAD_FINISH) {
            if (notification.extObj instanceof GameInfo) {
                GameInfo info = (GameInfo)notification.extObj;
                if (this.isDownloading(info.getGid())) {
                    this.updateDownloadProgress(info.getGid(), 10.0f);
                }
                this.unWatchDownload(info);
            }
        } else if (notifyId == NotificationIdDef.GAME_DOWNLOAD_ERROR) {
            if (notification.extObj instanceof GameInfo) {
                GameInfo info = (GameInfo)notification.extObj;
                this.unWatchDownload(info);
            }
        } else if (notifyId == NotificationIdDef.SINGLE_GAME_SCORE_UPDATE) {
            if (notification.extObj instanceof SingleGameResultData) {
                SingleGameResultData record = (SingleGameResultData)notification.extObj;
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"single game record score insertIfNewUserNotExist: %s", (Object[])new Object[]{record});
                }
                this.refreshSingleGameRecord();
            }
        } else if (notifyId == NotificationDef.N_NETWORK_STATE_CHANGE) {
            if (NetworkUtils.isNetworkAvailable((Context)this.mContext) && this.gameListWindow != null && !((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).isPlaying() && !FP.empty(this.singleGameInfoList) && StringUtils.isNotEmpty((String)this.mDisconnectGameId)) {
                for (SingleGameMiddleInfo info : this.singleGameInfoList) {
                    if (info == null || !this.mDisconnectGameId.equals(info.gameId)) continue;
                    info.isDisconnect = false;
                    this.mDisconnectGameId = "";
                    this.refreshSingleGameRecord();
                    break;
                }
            }
        } else if (notifyId == NotificationDef.N_STARTUP_FINISHED) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"N_STARTUP_FINISHED:started:%b,mRequestManager:%s", (Object[])new Object[]{RuntimeContext.sIsAppStartFinished, this.mRequestManager});
            }
            if (this.mRequestManager != null) {
                this.mRequestManager.getLocalGamePlayInfo();
            }
            this.updateSingleGameInfo();
        }
    }

    public void onWindowShown(AbstractWindow abstractWindow) {
        super.onWindowShown(abstractWindow);
        if (abstractWindow == this.gameListWindow && this.mDelayMsg != null) {
            final Message msg = this.mDelayMsg;
            this.mDelayMsg = null;
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    SingleGameListController.this.handleOpenGame(msg);
                }
            }, (long)200L);
        }
    }

    @Override
    public void requestSingleGameList() {
        if (this.mRequestManager == null) {
            this.mRequestManager = new SingleGameRequestManager(new ISingleGameListRequestCallBack(){

                @Override
                public void onSuccess(List<SingleGameListItem> data) {
                    SingleGameListController.this.notifySingleGameListLoadFinish(data);
                    SingleGameListController.this.checkWaitingOffline(data);
                    SingleGameListController.this.onSingleGameListChange(data);
                }

                @Override
                public void onError(Exception e) {
                }

                @Override
                public void onDataNoChange() {
                    SingleGameListController.this.refreshSingleGameRecord();
                }
            });
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"requestSingleGameList:started:%b", (Object[])new Object[]{RuntimeContext.sIsAppStartFinished});
        }
        if (RuntimeContext.sIsAppStartFinished) {
            this.mRequestManager.getLocalGamePlayInfo();
        }
        this.mRequestManager.requestSingleGameListIfNeed();
    }

    private void notifySingleGameListLoadFinish(List<SingleGameListItem> data) {
        Message message = Message.obtain();
        message.what = BaseMsgDef.SINGLE_GAME_LIST_GET;
        message.obj = data;
        this.sendMessage(message);
    }

    @Override
    public void onSingleGamePlayClick() {
        this.sendMessage(BaseMsgDef.SINGLE_GAME_PLAY);
    }

    @Override
    public void onCreateShortcut(String gameId, String gameName, String iconUrl) {
        Message msg = Message.obtain();
        msg.what = BaseMsgDef.SINGLE_GAME_CREATE_SHORTCUT;
        Bundle data = new Bundle();
        data.putString("gameId", gameId);
        data.putString("gameName", gameName);
        data.putString("iconUrl", iconUrl);
        msg.setData(data);
        this.sendMessage(msg);
    }

    @Override
    public void onShareBtnClicked(final String gameId) {
        IIntlShareService shareService = (IIntlShareService)this.getServiceManager().getService(IIntlShareService.class);
        if (shareService == null) {
            return;
        }
        shareService.showShareBottomDialog((ISharePage)this, new ShareItemClickListener(){

            public void onShareItemClick(int channelId) {
                SingleGameListController.this.onShareItemClicked(gameId, channelId, false);
            }
        });
    }

    @Override
    public List<SingleGameMiddleBullet> getSingleBulletList() {
        return this.mCacheBulletList;
    }

    @Override
    public void onReliveShareClicked(final String gameId) {
        IIntlShareService shareService = (IIntlShareService)this.getServiceManager().getService(IIntlShareService.class);
        if (shareService == null) {
            return;
        }
        shareService.showShareBottomDialog((ISharePage)this, new ShareItemClickListener(){

            public void onShareItemClick(int channelId) {
                SingleGameListController.this.onShareItemClicked(gameId, channelId, true);
            }
        });
    }

    @Override
    public boolean checkMinSupportAppVersion(String gameId) {
        return ((IGameService)this.getServiceManager().getService(IGameService.class)).checkMinSupportVersion(gameId);
    }

    @Override
    public boolean playMplSingleGame(String gameId, String mplId, int mplType, String activityId, int rewardType) {
        boolean canPlay = false;
        if (this.singleGameDataMap == null) {
            return false;
        }
        SingleGameListItem item = this.singleGameDataMap.get(gameId);
        if (item != null) {
            GameInfo gameInfo = item.generateGameInfo();
            if (gameInfo != null) {
                canPlay = ((IGameService)this.getServiceManager().getService(IGameService.class)).isGameValid(gameInfo);
                if (canPlay) {
                    SingleGamePlayContext playContext = new SingleGamePlayContext.Builder(GameContextDef.JoinFrom.FROM_DEFAULT).roomId("").build();
                    playContext.addExtendValue("mpl_id", (Object)mplId);
                    playContext.addExtendValue("mpl_playType", (Object)mplType);
                    playContext.addExtendValue("mpl_game_id", (Object)gameId);
                    playContext.addExtendValue("key_activity", (Object)activityId);
                    playContext.addExtendValue("mpl_award_type", (Object)rewardType);
                    ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).joinGame(gameInfo, (GamePlayContext)playContext);
                } else if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"[playGame] game: %s, not validate, maybe need download", (Object[])new Object[]{gameId});
                }
            } else {
                MLog.error((Object)TAG, (String)"[playGame] can not create gameInfo for game: %s", (Object[])new Object[]{gameId});
            }
        } else {
            MLog.error((Object)TAG, (String)"[playGame] can not find game: %d", (Object[])new Object[]{gameId});
        }
        return canPlay;
    }

    private void checkWaitingOffline(List<SingleGameListItem> list) {
        HashMap<String, Integer> gameIdMap = new HashMap<String, Integer>();
        if (!FP.empty(list)) {
            for (int i = 0; i < list.size(); ++i) {
                SingleGameListItem item = list.get(i);
                if (item == null || item.dataItem == null || !item.dataItem.isWaitingOffline()) continue;
                gameIdMap.put(item.getGameId(), i);
            }
        }
        if (!FP.empty(gameIdMap)) {
            for (Map.Entry entry : gameIdMap.entrySet()) {
                if (entry == null) continue;
                int position = (Integer)entry.getValue();
                if (((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).isOftenPlayUser((String)entry.getKey())) {
                    SingleGameListItem dataItem = list.remove(position);
                    list.add(dataItem);
                    continue;
                }
                list.remove(position);
            }
        }
    }

    private void onShareItemClicked(String gameId, int channelId, boolean singleGameReliveShare) {
        boolean result;
        int reportType;
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
                }
            }
        });
        String channelName = "";
        switch (channelId) {
            case 5: {
                reportType = 1;
                channelName = "share_fb";
                break;
            }
            case 1: {
                reportType = 2;
                channelName = "share_line";
                break;
            }
            case 2: {
                reportType = 3;
                channelName = "share_wa";
                break;
            }
            case 3: {
                reportType = 4;
                channelName = "ins";
                break;
            }
            case 13: {
                reportType = 6;
                channelName = "hago";
                break;
            }
            default: {
                reportType = 5;
            }
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023801").put("function_id", "1").put("page_id", "4").put("gid", gameId).put("share_channel", String.valueOf(reportType)));
        if (singleGameReliveShare) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20027257").put("event", "click").put("event_id", channelName));
        }
        if (channelId == 3 && !(result = ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).checkAppNeedInstalledOrToast(channelId))) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)gameId)) {
            this.share(channelId, gameId, singleGameReliveShare);
        } else {
            MLog.error((Object)TAG, (String)"[onShareItemClick] can not get gameId", (Object[])new Object[0]);
        }
    }

    @Override
    public String getCurGameId() {
        return this.curGameId;
    }

    @Override
    public void updateCurGameId(String gameId) {
        this.curGameId = gameId;
    }

    public void refreshSingleGameRecord() {
        if (this.singleGameDataMap != null) {
            ArrayList<String> gameIdList = new ArrayList<String>(this.singleGameDataMap.keySet());
            this.requestSingleGameRecord(gameIdList);
        }
    }

    public void requestSingleGameRecord(List<String> gameIdList) {
        StringBuilder idListStr = new StringBuilder("");
        if (gameIdList != null) {
            for (int i = 0; i < gameIdList.size(); ++i) {
                String id2 = gameIdList.get(i);
                if (TextUtils.isEmpty((CharSequence)id2)) continue;
                if (!TextUtils.isEmpty((CharSequence)idListStr) && i > 0) {
                    idListStr.append(",");
                }
                idListStr.append(id2);
            }
        }
        if (gameIdList != null && gameIdList.size() > 0) {
            if (AccountUtil.getUid() > 0L) {
                this.requestMiddlePageInfo(idListStr.toString());
                if (this.isNeedUpdateBulletInfo) {
                    this.requestBarrageInfo(idListStr.toString());
                    this.isNeedUpdateBulletInfo = false;
                }
            } else {
                MLog.error((Object)TAG, (String)"[requestSingleGameRecord] wrong uid: %d", (Object[])new Object[]{AccountUtil.getUid()});
            }
        } else {
            MLog.error((Object)TAG, (String)"[requestBestDay] list: %s", (Object[])new Object[]{idListStr.toString()});
        }
    }

    private void requestMiddlePageInfo(String gameIds) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"requestMiddlePageInfo gameIds %s", (Object[])new Object[]{gameIds});
        }
        if (gameIds == null) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("gameIds", gameIds);
        HttpUtil.httpReq((String)UriProvider.getSingleGameMiddlePageInfo(), params, (int)2, (INetRespCallback)new INetRespCallback<SingleGameMiddlePageInfo>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)SingleGameListController.TAG, (String)"requestMiddlePageInfo onError", (Object[])new Object[0]);
                if (e != null) {
                    MLog.error((Object)SingleGameListController.TAG, (String)"requestMiddlePageInfo onError: %s", (Object[])new Object[]{e.toString()});
                }
            }

            public void onResponse(String response, BaseResponseBean<SingleGameMiddlePageInfo> res, int id2) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)SingleGameListController.TAG, (String)"requestMiddlePageInfo onResponse %s", (Object[])new Object[]{response});
                }
                if (res != null && res.isSuccess()) {
                    if (res.data != null) {
                        List<SingleGameMiddleInfo> gameMiddleInfos = ((SingleGameMiddlePageInfo)res.data).gameMiddleInfos;
                        if (gameMiddleInfos == null) {
                            return;
                        }
                        GameInfoModuleData gameInfoModuleData = (GameInfoModuleData)KvoModuleManager.getModuleData(GameInfoModule.class);
                        for (SingleGameMiddleInfo info : gameMiddleInfos) {
                            if (info == null || TextUtils.isEmpty((CharSequence)info.gameId)) continue;
                            info.biggerRank = ((SingleGameMiddlePageInfo)res.data).biggerRank;
                            info.ranklimit = ((SingleGameMiddlePageInfo)res.data).ranklimit;
                            SingleGameListController.this.mServerMiddleInfo.put(info.gameId, info);
                            gameInfoModuleData.updateSingleGameBestScore(new SingleGameBestHistoryInfo(info.gameId, info.historyBest));
                        }
                        YYTaskExecutor.execute((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                HiidoEvent hiidoEvent = HiidoEvent.obtain().eventId("20027427").put("function_id", "2").put("event_time", String.valueOf(System.currentTimeMillis())).put("error_code", "0").put("game_type", "1");
                                if (MLog.isLogLevelBlowInfo()) {
                                    MLog.info((Object)SingleGameListController.TAG, (String)JsonParser.toJson((Object)hiidoEvent), (Object[])new Object[0]);
                                }
                                HiidoStatis.reportEvent((HiidoEvent)hiidoEvent);
                            }
                        });
                        SingleGameListController.this.onSingleGameMiddleInfoChanged();
                    } else {
                        MLog.error((Object)SingleGameListController.TAG, (String)"requestMiddlePageInfo onResponse res data is null", (Object[])new Object[0]);
                    }
                } else {
                    MLog.error((Object)SingleGameListController.TAG, (String)"requestMiddlePageInfo onResponse msg: %s", (Object[])new Object[]{res == null ? "res == null" : res.message});
                }
            }
        });
    }

    private void requestBarrageInfo(String gameIds) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"requestBarrageInfo game id list: %s", (Object[])new Object[]{gameIds});
        }
        if (TextUtils.isEmpty((CharSequence)gameIds)) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long timeDiff = currentTime - this.mLastRequestBarrageInfoTime;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"requestBarrageInfo time diff: %s", (Object[])new Object[]{timeDiff});
        }
        if (timeDiff <= 300000L) {
            this.showBarrageWithCache();
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("gameIds", gameIds);
        HttpUtil.httpReq((String)UriProvider.getSingleGameBarrageInfo(), params, (int)2, (INetRespCallback)new INetRespCallback<SingleGameMiddleBulletList>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)SingleGameListController.TAG, (String)"requestBarrageInfo onError", (Object[])new Object[0]);
                if (e != null) {
                    MLog.error((Object)SingleGameListController.TAG, (String)"requestBarrageInfo onError: %s", (Object[])new Object[]{e.toString()});
                }
            }

            public void onResponse(String response, BaseResponseBean<SingleGameMiddleBulletList> res, int id2) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)SingleGameListController.TAG, (String)"requestBarrageInfo onResponse %s", (Object[])new Object[]{response});
                }
                if (res != null && res.isSuccess()) {
                    if (res.data != null) {
                        SingleGameListController.this.mapBulletData(((SingleGameMiddleBulletList)res.data).bullets);
                        SingleGameListController.this.mLastRequestBarrageInfoTime = System.currentTimeMillis();
                    } else {
                        MLog.error((Object)SingleGameListController.TAG, (String)"requestBarrageInfo onResponse res data is null", (Object[])new Object[0]);
                    }
                } else {
                    MLog.error((Object)SingleGameListController.TAG, (String)"requestBarrageInfo onResponse msg: %s", (Object[])new Object[]{res == null ? "res == null" : res.message});
                }
            }
        });
    }

    private void mapBulletData(final List<SingleGameMiddleBullet> bullets) {
        if (bullets == null || bullets.isEmpty()) {
            return;
        }
        int size = bullets.size();
        ArrayList<Long> uids = new ArrayList<Long>(size);
        this.mCacheBulletList = bullets;
        for (int i = 0; i < size; ++i) {
            SingleGameMiddleBullet bullet = bullets.get(i);
            if (bullet == null) continue;
            uids.add(bullet.uid);
        }
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(uids, new OnProfileListCallback(){

            public void onUISuccess(List<UserInfoBean> userInfoList) {
                if (userInfoList == null || userInfoList.isEmpty()) {
                    return;
                }
                int size = userInfoList.size();
                for (int i = 0; i < size; ++i) {
                    UserInfoBean userInfo = userInfoList.get(i);
                    if (userInfo == null) continue;
                    int count = bullets.size();
                    for (int j = 0; j < count; ++j) {
                        SingleGameMiddleBullet bullet = (SingleGameMiddleBullet)bullets.get(j);
                        if (bullet == null || userInfo.getUid() != bullet.uid) continue;
                        ((SingleGameMiddleBullet)((SingleGameListController)SingleGameListController.this).mCacheBulletList.get((int)j)).avatar = userInfo.getAvatar();
                        ((SingleGameMiddleBullet)((SingleGameListController)SingleGameListController.this).mCacheBulletList.get((int)j)).nickName = userInfo.getNick();
                    }
                }
                SingleGameListController.this.onSingleGameBarrageInfoChanged(SingleGameListController.this.mCacheBulletList);
            }

            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)SingleGameListController.TAG, (String)"mapBulletData getUserInfo onError: %s", (Throwable)e, (Object[])new Object[0]);
            }

            public void onResponseError(int id2, String message, String response) {
                MLog.error((Object)SingleGameListController.TAG, (String)"mapBulletData getUserInfo onResponseError: %s", (Object[])new Object[]{response});
            }
        });
    }

    private void onSingleGameListChange(List<SingleGameListItem> data) {
        if (FP.empty(data)) {
            return;
        }
        this.singleGameDataMap = new HashMap<String, SingleGameListItem>();
        ArrayList<GameDataBean> gameDataList = new ArrayList<GameDataBean>();
        if (this.singleGameInfoList != null) {
            this.singleGameInfoList.clear();
        }
        if (!FP.empty(this.mSingleGameIdList)) {
            this.mSingleGameIdList.clear();
        }
        for (SingleGameListItem item : data) {
            if (item == null) continue;
            this.singleGameDataMap.put(item.getGameId(), item);
            SingleGameMiddleInfo info = SingleGameMiddleInfo.create(item);
            if (item.dataItem != null) {
                gameDataList.add(item.dataItem);
            }
            if (TextUtils.isEmpty((CharSequence)info.gameId) || this.mSingleGameIdList.contains(info.gameId)) continue;
            this.singleGameInfoList.add(info);
            this.mSingleGameIdList.add(info.gameId);
        }
        this.parseGameInfo(gameDataList);
        this.refreshSingleGameRecord();
        this.handlePendingDownloadGame();
    }

    private void updateSingleGameInfo() {
        if (!FP.empty(this.mSingleGameInfo) && this.getServiceManager() != null && this.getServiceManager().getService(IGameInfoService.class) != null) {
            ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).updateSingleGameInfo(this.mSingleGameInfo);
            this.mSingleGameInfo = null;
        }
    }

    private void parseGameInfo(List<GameDataBean> gameDataList) {
        if (FP.empty(gameDataList)) {
            return;
        }
        if (this.mSingleGameInfo == null) {
            this.mSingleGameInfo = new ArrayList<GameInfo>(gameDataList.size());
        }
        for (GameDataBean item : gameDataList) {
            this.mSingleGameInfo.add(GameDataBean.toGameInfo((GameDataBean)item, (GameInfoSource)GameInfoSource.SINGLE, (int)-1));
        }
        this.updateSingleGameInfo();
    }

    private void handlePendingDownloadGame() {
        if (FP.empty(this.mPendingDownloadGameList)) {
            return;
        }
        for (String gid : this.mPendingDownloadGameList) {
            this.downloadGame(gid);
        }
        this.mPendingDownloadGameList = null;
    }

    private boolean isNeedRemoveShortcut(String gameId) {
        boolean isNotContains = true;
        if (TextUtils.isEmpty((CharSequence)gameId)) {
            return false;
        }
        if (FP.empty(this.mSingleGameIdList)) {
            return false;
        }
        for (String serverGameId : this.mSingleGameIdList) {
            if (TextUtils.isEmpty((CharSequence)serverGameId) || !serverGameId.equals(gameId)) continue;
            isNotContains = false;
            break;
        }
        return isNotContains;
    }

    private void removeShortcut(String gameId, String gameName) {
        Message msg = Message.obtain();
        msg.what = BaseMsgDef.SINGLE_GAME_REMOVE_SHORTCUT;
        Bundle data = new Bundle();
        data.putString("gameId", gameId);
        data.putString("gameName", gameName);
        msg.setData(data);
        this.sendMessage(msg);
    }

    private void onSingleGameMiddleInfoChanged() {
        for (SingleGameMiddleInfo info : this.singleGameInfoList) {
            if (info == null || TextUtils.isEmpty((CharSequence)info.gameId)) continue;
            info.updateMiddleInfo(this.mServerMiddleInfo.get(info.gameId));
        }
        this.notifyUpdate();
    }

    private void onSingleGameBarrageInfoChanged(List<SingleGameMiddleBullet> bulletList) {
        if (!this.isNeedUpdateBulletInfo) {
            return;
        }
        if (this.gameListWindow != null) {
            this.gameListWindow.setBulletData(bulletList);
            this.isNeedUpdateBulletInfo = false;
        }
    }

    private void showBarrageWithCache() {
        if (this.mCacheBulletList == null || this.mCacheBulletList.isEmpty()) {
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"show barrage with cache", (Object[])new Object[0]);
        }
        if (this.gameListWindow != null) {
            this.gameListWindow.setBulletData(this.mCacheBulletList);
        }
    }

    private void notifyUpdate() {
        if (this.gameListWindow != null) {
            this.gameListWindow.setGameList(this.singleGameInfoList, this.getCurGameId());
        }
    }

    @Override
    public boolean isDownloading(String gameId) {
        return this.singleGameDownloadMap.keySet().contains(gameId) && this.singleGameDownloadMap.get(gameId) != null;
    }

    @Override
    public void downloadGame(String gameId) {
        GameInfo gameInfo;
        if (FP.empty(this.singleGameDataMap)) {
            if (this.mPendingDownloadGameList == null) {
                this.mPendingDownloadGameList = new ArrayList<String>();
            }
            this.mPendingDownloadGameList.add(gameId);
            return;
        }
        SingleGameListItem item = this.singleGameDataMap.get(gameId);
        if (item != null && (gameInfo = item.generateGameInfo()) != null && !((IGameService)this.getServiceManager().getService(IGameService.class)).isGameValid(gameInfo)) {
            this.singleGameDownloadMap.put(gameInfo.getGid(), Float.valueOf(0.0f));
            gameInfo.downloadInfo.setFrom(GameDownloadInfo.DownloadFrom.single);
            ((IGameService)this.getServiceManager().getService(IGameService.class)).downloadGame(gameInfo);
            Kvo.autoBindingTo((KvoSource)gameInfo.downloadInfo, (Object)this);
        }
    }

    @KvoMethodAnnotation(name="progress", sourceClass=GameDownloadInfo.class, thread=1)
    public void onUpdateProgress(KvoEventIntent event) {
        GameDownloadInfo info = (GameDownloadInfo)event.source();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onUpdateProgress gid: %s, state: %s, cur: %s, total: %s", (Object[])new Object[]{info.gameId, info.getState(), info.getProgress(), info.getTotalBytes()});
        }
        if (info.getState() != GameDownloadInfo.DownloadState.downloading || this.isSilentDownload(info)) {
            return;
        }
        this.updateProgress(info);
    }

    private boolean isSilentDownload(GameDownloadInfo info) {
        return info.downloadType == GameDownloadInfo.DownloadType.silent;
    }

    private void updateProgress(GameDownloadInfo info) {
        if (info != null) {
            float progress = info.getTotalBytes() == 0L ? 0.0f : (float)info.getProgress() / (float)info.getTotalBytes();
            this.updateDownloadProgress(info.gameId, progress);
        }
    }

    private void unWatchDownload(GameInfo info) {
        if (info != null) {
            Kvo.autoUnbindingFrom((KvoSource)info.downloadInfo, (Object)this);
        }
    }

    private void updateDownloadProgress(String gameId, float progress) {
        if (progress > 1.0f) {
            this.singleGameDownloadMap.remove(gameId);
        } else {
            this.singleGameDownloadMap.put(gameId, Float.valueOf(progress));
        }
        if (this.gameListWindow != null && TextUtils.equals((CharSequence)gameId, (CharSequence)this.gameListWindow.getCurGame())) {
            this.gameListWindow.updateGameDownloadProgress(gameId, progress);
        }
    }

    @Override
    public float getDownloadProgress(String gameId) {
        Float progress = this.singleGameDownloadMap.get(gameId);
        return progress != null ? progress.floatValue() : 0.0f;
    }

    @Override
    public boolean playGame(String gameId) {
        boolean canPlay = false;
        SingleGameListItem item = this.singleGameDataMap.get(gameId);
        if (item != null) {
            GameInfo gameInfo = item.generateGameInfo();
            if (gameInfo != null) {
                canPlay = ((IGameService)this.getServiceManager().getService(IGameService.class)).isGameValid(gameInfo);
                if (canPlay) {
                    SingleGamePlayContext playContext = new SingleGamePlayContext.Builder(GameContextDef.JoinFrom.FROM_DEFAULT).roomId("").build();
                    ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).joinGame(gameInfo, (GamePlayContext)playContext);
                } else if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"[playGame] game: %s, not validate, maybe need download", (Object[])new Object[]{gameId});
                }
            } else {
                MLog.error((Object)TAG, (String)"[playGame] can not create gameInfo for game: %s", (Object[])new Object[]{gameId});
            }
        } else {
            MLog.error((Object)TAG, (String)"[playGame] can not find game: %d", (Object[])new Object[]{gameId});
        }
        return canPlay;
    }

    @Override
    public void share(int shareType, String gameId, boolean singleGameReliveShare) {
        if (!TextUtils.isEmpty((CharSequence)gameId)) {
            SingleGameMiddleInfo gameInfo = null;
            if (this.singleGameInfoList != null) {
                for (SingleGameMiddleInfo info : this.singleGameInfoList) {
                    if (info == null || !TextUtils.equals((CharSequence)gameId, (CharSequence)info.gameId)) continue;
                    gameInfo = info;
                    break;
                }
            }
            if (gameInfo != null) {
                boolean isDailyBest;
                boolean isHistoryBest;
                int score;
                this.mIsSharing = true;
                if (singleGameReliveShare) {
                    score = Math.max(0, gameInfo.historyBest);
                    isHistoryBest = score > 0;
                    isDailyBest = false;
                } else {
                    score = gameInfo.todayBest > 0 ? gameInfo.todayBest : Math.max(0, gameInfo.historyBest);
                    isHistoryBest = gameInfo.todayBest <= 0;
                    isDailyBest = gameInfo.todayBest > 0;
                }
                String shareBgUrl = gameInfo.extInfo == null || gameInfo.extInfo.shareBGUrl == null ? "" : gameInfo.extInfo.shareBGUrl;
                ((IGameResultShareService)this.getServiceManager().getService(IGameResultShareService.class)).share(shareType, gameId, gameInfo.gameName, shareBgUrl, score, isHistoryBest, isDailyBest, new IShareCallBack(){

                    public void onShareSuccess(ShareData data) {
                        SingleGameListController.this.mIsSharing = false;
                        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
                            MLog.debug((Object)SingleGameListController.TAG, (String)"[share] onShareSuccess", (Object[])new Object[0]);
                        }
                    }

                    public void onShareCanceled(ShareData data) {
                        SingleGameListController.this.mIsSharing = false;
                        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
                            MLog.debug((Object)SingleGameListController.TAG, (String)"[share] onShareCanceled", (Object[])new Object[0]);
                        }
                    }

                    public void onShareError(ShareData data, Exception e) {
                        SingleGameListController.this.mIsSharing = false;
                        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
                            MLog.debug((Object)SingleGameListController.TAG, (String)"[share] onShareError", (Object[])new Object[0]);
                        }
                    }
                }, singleGameReliveShare);
            } else {
                MLog.error((Object)TAG, (String)"[share] null gameInfo, type: %d, game: %s", (Object[])new Object[]{shareType, gameId});
            }
        } else {
            MLog.error((Object)TAG, (String)"[share] empty game id, type: %d, gameId: %s", (Object[])new Object[]{shareType, gameId});
        }
    }

    @Override
    public void toRankList(String gameId) {
        if (!TextUtils.isEmpty((CharSequence)gameId)) {
            SingleGameListItem item;
            WebEnvSettings wes = new WebEnvSettings();
            String bgColor = "";
            String viewColor = "";
            SingleGameListItem singleGameListItem = item = this.singleGameDataMap == null ? null : this.singleGameDataMap.get(gameId);
            if (item != null && item.dataItem != null) {
                bgColor = item.dataItem.getBannerImgColor();
                if (item.dataItem.singleGameExt != null) {
                    viewColor = item.dataItem.singleGameExt.viewColor;
                }
            }
            bgColor = bgColor == null ? "" : bgColor.replace("#", "%23");
            viewColor = viewColor == null ? "" : viewColor.replace("#", "%23");
            wes.url = UriProvider.getSingleGameRankUrl((String)gameId, (String)bgColor, (String)viewColor);
            wes.usePageTitle = false;
            wes.isFullScreen = true;
            if (this.isFromSingleGameResultWindow) {
                wes.isShowStatusBar = false;
            }
            wes.disablePullRefresh = true;
            wes.enableTranslucent = false;
            wes.backBtnResId = R.drawable.nav_back_white;
            ((IWebService)this.getServiceManager().getService(IWebService.class)).loadUrl(wes);
            if (this.mWindowMgr.getCurrentWindow() instanceof AbsWebWindow) {
                this.rankWindow = this.mWindowMgr.getCurrentWindow();
            }
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025737").put("gid", gameId).put("function_id", "rank_click").put("page_id", "middle_page"));
            this.isFromSingleGameResultWindow = false;
        } else {
            MLog.error((Object)TAG, (String)"[toRankList] empty game id", (Object[])new Object[0]);
        }
    }

    @Override
    public void preloadGameLoadingPage(String gameId) {
        LoadGamePageManager.getInstance().preLoadGamePage(gameId);
    }

    private void startSingleGameDefault(@NotNull String gameId) {
        if (TextUtils.isEmpty((CharSequence)gameId)) {
            return;
        }
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            MLog.error((Object)TAG, (String)"sorry the network is not available.", (Object[])new Object[0]);
            return;
        }
        this.downloadGame(gameId);
        if (this.gameListWindow != null) {
            this.gameListWindow.setAutoStartGid(gameId);
        }
        if (this.singleGameDataMap == null) {
            return;
        }
        SingleGameListItem item = this.singleGameDataMap.get(gameId);
        if (item == null) {
            return;
        }
        GameInfo gameInfo = item.generateGameInfo();
        if (gameInfo == null) {
            return;
        }
        boolean isGaming = ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).isPlaying();
        if (isGaming) {
            return;
        }
        boolean canPlay = ((IGameService)this.getServiceManager().getService(IGameService.class)).isGameValid(gameInfo);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"startSingleGameDefault game id: %s can play: %s", (Object[])new Object[]{gameId, canPlay});
        }
        if (canPlay) {
            if (gameInfo != null) {
                gameInfo.setExt(this.mExt);
            }
            SingleGamePlayContext playContext = new SingleGamePlayContext.Builder(GameContextDef.JoinFrom.FROM_H5).roomId("").build();
            ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).joinGame(gameInfo, (GamePlayContext)playContext);
            this.mExt = null;
        }
    }

    public String getPageName() {
        return "single_game_middle_page";
    }
}

