/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.single.list;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import com.bumptech.glide.load.DecodeFormat;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.game.R;
import com.yy.game.gamemodule.simplegame.single.list.data.SingleGameMiddleInfo;
import com.yy.game.gamemodule.simplegame.single.list.widget.SingleGameDescriptionItemView;
import com.yy.game.gamemodule.simplegame.single.list.widget.SingleGameMiddleView;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class SingleGameListAdapter
extends PagerAdapter {
    private static final String TAG = "SingleGameListAdapter";
    private Context ctx;
    private List<SingleGameMiddleInfo> gameList = new ArrayList<SingleGameMiddleInfo>();
    private LinkedList<View> dirtyViewList = new LinkedList();
    private List<View> showingList = new ArrayList<View>();
    private ISingleGameItemClickListener itemClickListener;
    private int curPos;
    private View curView;
    private int curScrollState = -1;

    public SingleGameListAdapter(Context ctx, ISingleGameItemClickListener listener) {
        this.ctx = ctx;
        this.itemClickListener = listener;
    }

    public void setData(List<SingleGameMiddleInfo> data) {
        this.gameList = new ArrayList<SingleGameMiddleInfo>();
        this.dirtyViewList.clear();
        if (data != null) {
            this.gameList.addAll(data);
        }
        this.notifyDataSetChanged();
        this.updateShowingView();
    }

    public int getCount() {
        return this.gameList.size() > 1 ? Math.max(this.gameList.size(), 1000) : this.gameList.size();
    }

    public void updateShowingView() {
        if (this.showingList != null && this.gameList != null) {
            block0: for (View view : this.showingList) {
                if (view == null || !(view.getTag() instanceof SingleGameViewHolder)) continue;
                SingleGameViewHolder holder = (SingleGameViewHolder)view.getTag();
                for (SingleGameMiddleInfo info : this.gameList) {
                    if (info == null || TextUtils.isEmpty((CharSequence)info.gameId) || !TextUtils.equals((CharSequence)info.gameId, (CharSequence)holder.gameId)) continue;
                    holder.updateGameInfo(info);
                    continue block0;
                }
            }
        }
    }

    public int getRealPosition(int pos) {
        int count = this.gameList.size();
        return count == 0 ? -1 : pos % count;
    }

    public int getFirstShowIndex(String curGameId) {
        int showIndex = -1;
        if (!FP.empty(this.gameList)) {
            int curIndex = 0;
            if (!TextUtils.isEmpty((CharSequence)curGameId)) {
                for (int i = 0; i < this.gameList.size(); ++i) {
                    SingleGameMiddleInfo info = this.gameList.get(i);
                    if (info == null || TextUtils.isEmpty((CharSequence)curGameId) || !TextUtils.equals((CharSequence)curGameId, (CharSequence)info.gameId)) continue;
                    curIndex = i;
                    break;
                }
            }
            int index = 400;
            showIndex = this.gameList.size() <= 1 ? 0 : index - index % this.gameList.size();
            showIndex += curIndex;
        }
        return showIndex;
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view == object;
    }

    @Nullable
    public SingleGameMiddleInfo getSingleGameInPosition(int pos) {
        int realPos = this.getRealPosition(pos);
        return realPos >= 0 ? this.gameList.get(realPos) : null;
    }

    @Nullable
    public SingleGameMiddleInfo getCurSingleGameInfo() {
        int realPos = this.getRealPosition(this.curPos);
        return realPos >= 0 ? this.gameList.get(realPos) : null;
    }

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        SingleGameViewHolder holder;
        View itemView;
        View view = itemView = this.dirtyViewList.size() > 0 ? this.dirtyViewList.pop() : null;
        if (itemView == null) {
            itemView = LayoutInflater.from((Context)this.ctx).inflate(R.layout.layout_single_game_list_item, null);
            holder = new SingleGameViewHolder(itemView, this.itemClickListener);
            itemView.setTag((Object)holder);
        } else {
            holder = (SingleGameViewHolder)itemView.getTag();
        }
        SingleGameMiddleInfo gameInfo = this.getSingleGameInPosition(position);
        if (gameInfo != null) {
            holder.updateGameInfo(gameInfo);
            holder.setPosition(position);
        }
        this.showingList.add(itemView);
        container.addView(itemView);
        return itemView;
    }

    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        container.removeView((View)object);
        this.dirtyViewList.add((View)object);
        this.showingList.remove(object);
    }

    public void onPageSelected(int position) {
        this.curPos = position;
        this.curView = null;
        SingleGameMiddleInfo info = this.getCurSingleGameInfo();
        if (info != null && !TextUtils.isEmpty((CharSequence)info.gameId)) {
            for (View view : this.showingList) {
                SingleGameViewHolder holder;
                if (view == null || (holder = (SingleGameViewHolder)view.getTag()) == null || !TextUtils.equals((CharSequence)holder.gameId, (CharSequence)info.gameId) || holder.position != position) continue;
                this.curView = view;
                break;
            }
        } else {
            MLog.error((Object)TAG, (String)"[onPageSelected] can not find game in: %d", (Object[])new Object[]{position});
        }
    }

    public void onPageScrollStateChange(int state) {
        this.curScrollState = state;
    }

    private String resizeImageUrl(String url) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"background url is: %s", (Object[])new Object[]{url});
        }
        if (StringUtils.isEmpty((String)url)) {
            return null;
        }
        int width = ScreenUtils.getInstance().getWidthPixels();
        int height = ScreenUtils.getInstance().getHeightPixels();
        return url + YYImageUtils.getThumbnailPostfixPx((int)width, (int)height, (boolean)false);
    }

    public static interface ISingleGameItemClickListener {
        public void onSingleGameBottomBarClick(String var1);

        public void onSingleGameBackClick();

        public void onSingleGameShareClick(String var1);
    }

    private class SingleGameViewHolder
    implements View.OnClickListener,
    SingleGameMiddleView.OnSingleGameMiddleItemClickListener {
        String gameId;
        int position;
        String mGameName = "";
        String mIconUrl = "";
        ISingleGameItemClickListener itemClickListener;
        RecycleImageView mBgImageView;
        View mItemContainerView;
        YYTextView mItemGameNameView;
        CircleImageView mItemCircleView;
        ViewStub mItemDescStubView;
        ViewStub mItemRecordStubView;
        YYTextView mItemBestHistoryView;
        SingleGameDescriptionItemView mItemDescView;
        SingleGameMiddleView mItemRecordView;
        YYImageView mItemLightView;

        SingleGameViewHolder(View rootView, ISingleGameItemClickListener listener) {
            this.itemClickListener = listener;
            this.mItemContainerView = rootView.findViewById(R.id.single_game_item_container);
            this.mItemGameNameView = (YYTextView)rootView.findViewById(R.id.single_game_item_game_name);
            this.mItemCircleView = (CircleImageView)rootView.findViewById(R.id.single_game_item_circle);
            this.mItemDescStubView = (ViewStub)rootView.findViewById(R.id.single_game_item_stub_game_description);
            this.mItemRecordStubView = (ViewStub)rootView.findViewById(R.id.single_game_item_stub_record);
            this.mItemBestHistoryView = (YYTextView)rootView.findViewById(R.id.single_game_item_best_history);
            this.mBgImageView = (RecycleImageView)rootView.findViewById(R.id.single_game_item_bg);
            this.mItemLightView = (YYImageView)rootView.findViewById(R.id.single_game_item_light);
        }

        void updateGameInfo(SingleGameMiddleInfo middleInfo) {
            if (middleInfo == null) {
                return;
            }
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)SingleGameListAdapter.TAG, (String)"updateGameInfo middleInfo %s", (Object[])new Object[]{middleInfo.toString()});
            }
            this.setGameId(middleInfo.gameId);
            this.setGameName(middleInfo.gameName);
            this.setIconUrl(middleInfo.circleIconUrl);
            if (Build.VERSION.SDK_INT >= 16) {
                this.mItemContainerView.setBackground(null);
            } else {
                this.mItemContainerView.setBackgroundDrawable(null);
            }
            this.mBgImageView.setAutoTransforToWebpFlag(false);
            if (StringUtils.equal((String)middleInfo.bgUrl, (String)middleInfo.tempBgUrl)) {
                Bitmap bitmapBg = middleInfo.tempBitmap;
                if (bitmapBg != null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)SingleGameListAdapter.TAG, (String)"use cache", (Object[])new Object[0]);
                    }
                    ImageLoader.Builder builder = ImageLoader.Builder.obtain((RecycleImageView)this.mBgImageView, null);
                    builder.placeholder((Drawable)new BitmapDrawable(bitmapBg));
                    builder.load();
                } else {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)SingleGameListAdapter.TAG, (String)"not use cache", (Object[])new Object[0]);
                    }
                    ImageLoader.Builder builder = ImageLoader.Builder.obtain((RecycleImageView)this.mBgImageView, (String)SingleGameListAdapter.this.resizeImageUrl(middleInfo.bgUrl));
                    builder.placeholder((Drawable)new ColorDrawable(middleInfo.bgColor));
                    builder.setDecodeFormat(DecodeFormat.PREFER_ARGB_8888);
                    builder.load();
                }
            } else {
                ImageLoader.Builder builder = ImageLoader.Builder.obtain((RecycleImageView)this.mBgImageView, (String)SingleGameListAdapter.this.resizeImageUrl(middleInfo.bgUrl));
                builder.placeholder((Drawable)new ColorDrawable(middleInfo.bgColor));
                builder.setDecodeFormat(DecodeFormat.PREFER_ARGB_8888);
                builder.load();
            }
            this.mItemGameNameView.setTextSize(2, 19.0f);
            this.mItemGameNameView.setText((CharSequence)middleInfo.gameName);
            ImageLoader.loadImage((RecycleImageView)this.mItemCircleView, (String)middleInfo.circleIconUrl);
            if (!middleInfo.havePlayed) {
                if (this.mItemRecordView != null) {
                    this.mItemRecordView.setVisibility(8);
                }
                if (this.mItemDescView == null) {
                    this.mItemDescView = (SingleGameDescriptionItemView)this.mItemDescStubView.inflate();
                }
                if (this.mItemDescView.getVisibility() == 8) {
                    this.mItemDescView.setVisibility(0);
                }
                this.mItemDescView.refreshUI(middleInfo.gameName, middleInfo.describeText);
            } else {
                if (this.mItemDescView != null) {
                    this.mItemDescView.setVisibility(8);
                }
                if (this.mItemRecordView == null) {
                    this.mItemRecordView = (SingleGameMiddleView)this.mItemRecordStubView.inflate();
                    this.mItemRecordView.setItemClickListener(this);
                }
                if (this.mItemRecordView.getVisibility() == 8) {
                    this.mItemRecordView.setVisibility(0);
                }
                this.mItemRecordView.refreshUI(middleInfo);
            }
            if (middleInfo.historyBest != 0) {
                this.mItemBestHistoryView.setVisibility(0);
                this.mItemBestHistoryView.setText((CharSequence)StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.single_game_middle_page_best_history, (Object[])new Object[]{String.valueOf(middleInfo.historyBest)}), (Object[])new Object[0]));
            } else {
                this.mItemBestHistoryView.setVisibility(8);
            }
            this.startAnim();
        }

        void setGameId(String gameId) {
            this.gameId = gameId;
        }

        String getGameId() {
            return this.gameId;
        }

        String getGameName() {
            return this.mGameName;
        }

        void setGameName(String gameName) {
            this.mGameName = gameName;
        }

        public String getIconUrl() {
            return this.mIconUrl;
        }

        public void setIconUrl(String iconUrl) {
            this.mIconUrl = iconUrl;
        }

        void setPosition(int pos) {
            this.position = pos;
        }

        private void startAnim() {
            RotateAnimation backLightAnim = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
            backLightAnim.setDuration(8000L);
            backLightAnim.setFillAfter(true);
            backLightAnim.setInterpolator((Interpolator)new LinearInterpolator());
            backLightAnim.setRepeatMode(1);
            backLightAnim.setRepeatCount(-1);
            this.mItemLightView.setAnimation((Animation)backLightAnim);
        }

        public void onClick(View v) {
            int vId = v.getId();
            if (vId == R.id.single_game_item_back) {
                if (this.itemClickListener != null) {
                    this.itemClickListener.onSingleGameBackClick();
                }
            } else if (vId == R.id.single_game_item_share && this.itemClickListener != null) {
                this.itemClickListener.onSingleGameShareClick(this.gameId);
            }
        }

        @Override
        public void onSingleGameDailyEntranceClick() {
            if (this.itemClickListener != null) {
                String gameId = this.getGameId();
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)SingleGameListAdapter.TAG, (String)"onSingleGameDailyEntranceClick game id %s", (Object[])new Object[]{gameId});
                }
                if (!TextUtils.isEmpty((CharSequence)gameId)) {
                    this.itemClickListener.onSingleGameBottomBarClick(gameId);
                }
            }
        }
    }
}

