/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.single.list;

import android.graphics.Color;
import android.text.TextUtils;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.game.R;
import com.yy.game.gamemodule.simplegame.single.list.data.SingleGameBestDayInfo;
import com.yy.hiyo.game.base.SingleGameExtInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.SingleGameListItem;
import com.yy.hiyo.game.kvomodule.SingleGameBestHistoryInfo;
import java.util.List;

public class SingleGameInfo {
    private static final String TAG = "SingleGameInfo";
    public String gameId;
    public String gameName;
    public String gameDesc;
    public int bestRecord;
    public int weeklyScore;
    public int weeklyRank;
    public String bgUrl;
    public int bgColor;
    public int bottomBarColor;
    public String scoreUnit;
    public SingleGameExtInfo extInfo;
    public boolean fixing;
    public String defLang;
    public List<String> langList;
    public GameInfo gameInfo;
    public boolean isFull;
    public boolean isBetaTest;
    public boolean isWaitingOffline;

    public static SingleGameInfo create(SingleGameListItem item) {
        SingleGameInfo info = new SingleGameInfo();
        if (item != null && item.dataItem != null) {
            info.gameInfo = item.generateGameInfo();
            info.gameId = item.dataItem.getId();
            info.gameName = item.dataItem.getTitle();
            info.gameDesc = item.dataItem.getDesc();
            info.bgUrl = item.dataItem.getBannerImgUrl();
            info.scoreUnit = item.dataItem.getScoreType();
            info.fixing = item.dataItem.isFixing();
            info.defLang = item.dataItem.getDefLang();
            info.langList = item.dataItem.getLangList();
            info.isFull = item.dataItem.isFull();
            info.isBetaTest = item.dataItem.isBetaTest();
            info.isWaitingOffline = item.dataItem.isWaitingOffline();
            if (TextUtils.isEmpty((CharSequence)info.scoreUnit)) {
                info.scoreUnit = ResourceUtils.getString((int)R.string.single_game_score_unit_score);
            }
            try {
                if (!TextUtils.isEmpty((CharSequence)item.dataItem.getBannerImgColor())) {
                    info.bgColor = item.dataItem.getBannerColor();
                }
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"[create] bgColor", (Throwable)e, (Object[])new Object[0]);
            }
            try {
                if (!TextUtils.isEmpty((CharSequence)item.dataItem.singleGameExt.viewColor)) {
                    info.bottomBarColor = Color.parseColor((String)item.dataItem.singleGameExt.viewColor);
                }
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"[create] bottomBarColor", (Throwable)e, (Object[])new Object[0]);
            }
            info.extInfo = item.dataItem.singleGameExt;
        }
        return info;
    }

    public void updateBestHistory(SingleGameBestHistoryInfo info) {
        if (info != null && TextUtils.equals((CharSequence)this.gameId, (CharSequence)info.gameId)) {
            this.bestRecord = info.bestHistory;
        }
    }

    public void updateBestWeek(SingleGameBestDayInfo info) {
        if (info != null && TextUtils.equals((CharSequence)this.gameId, (CharSequence)info.gameId)) {
            this.weeklyRank = info.rank;
            this.weeklyScore = info.bestScore;
        }
    }

    public String toString() {
        return "SingleGameInfo{gameId='" + this.gameId + '\'' + ", gameName='" + this.gameName + '\'' + ", gameDesc='" + this.gameDesc + '\'' + ", bestRecord=" + this.bestRecord + ", weeklyScore=" + this.weeklyScore + ", weeklyRank=" + this.weeklyRank + ", bgUrl='" + this.bgUrl + '\'' + ", bgColor=" + this.bgColor + ", bottomBarColor=" + this.bottomBarColor + ", scoreUnit='" + this.scoreUnit + '\'' + ", extInfo=" + this.extInfo + '}';
    }
}

