/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.single.list;

import android.content.Context;
import android.view.View;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.callback.OnProfileListCallback;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.game.gamemodule.simplegame.single.list.data.SingleGameExcitInfo;
import com.yy.game.gamemodule.simplegame.single.list.widget.SingleGameFloatingView;
import com.yy.hiyo.game.base.GameNotificationDef;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameAudioService;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.protocol.GameLifeWrapper;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class SingleGameFloatingController
extends DefaultController
implements INotify {
    private SingleGameFloatingView mSingleGameFloatingView;
    private SingleGameExcitInfo mSingleGameExcitInfo;
    private boolean hasReceivedGameFinishNotify = false;
    private int mOverFriend;
    private int mRank;
    private boolean isFloatingViewShowing = false;
    private static final String TAG = "SingleGameController";
    private String mGameId;
    private YYTaskExecutor.RunnableEx mRemoveFloatingViewRunnable = new YYTaskExecutor.RunnableEx(){

        public void run() {
            SingleGameFloatingController.this.hideFloatingView();
        }
    };
    private GameLifeWrapper mGameLifeWrapper = new GameLifeWrapper(){

        public void onPlayGameStart(GamePlayContext context) {
            super.onPlayGameStart(context);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)SingleGameFloatingController.TAG, (String)"[SingleGameFloatingController] game start", (Object[])new Object[0]);
            }
            SingleGameFloatingController.this.hasReceivedGameFinishNotify = false;
        }

        public void onPlayGameFinish(GamePlayContext context, int finishType) {
            super.onPlayGameFinish(context, finishType);
            if (finishType == 1 || finishType == 2) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)SingleGameFloatingController.TAG, (String)"[SingleGameFloatingController] game pk finish or game room destroyed,remove floatingView", (Object[])new Object[0]);
                }
                SingleGameFloatingController.this.hasReceivedGameFinishNotify = true;
                SingleGameFloatingController.this.mOverFriend = 0;
                SingleGameFloatingController.this.mRank = 0;
                SingleGameFloatingController.this.hideFloatingView();
                YYTaskExecutor.removeRunnableFromMainThread((Runnable)SingleGameFloatingController.this.mRemoveFloatingViewRunnable);
            }
        }

        public void onGameExited(GamePlayContext context, int gameExitType) {
            super.onGameExited(context, gameExitType);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)SingleGameFloatingController.TAG, (String)"[SingleGameFloatingController] game pk finish or game room destroyed,remove floatingView", (Object[])new Object[0]);
            }
            SingleGameFloatingController.this.hasReceivedGameFinishNotify = true;
            SingleGameFloatingController.this.mOverFriend = 0;
            SingleGameFloatingController.this.mRank = 0;
            SingleGameFloatingController.this.hideFloatingView();
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)SingleGameFloatingController.this.mRemoveFloatingViewRunnable);
        }
    };

    public SingleGameFloatingController(Environment env) {
        super(env);
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).registerGameLifecycle((IGameLifecycle)this.mGameLifeWrapper);
    }

    public void notify(Notification notification) {
        if (notification.id == GameNotificationDef.SINGLE_GAME_SHOW_TOAST_VIEW) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)("[SingleGameFloatingController] single game show toast view, notify id: " + notification.id), (Object[])new Object[0]);
            }
            if (this.hasReceivedGameFinishNotify) {
                return;
            }
            GameInfo playingGameInfo = ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).getCurPlayingGame();
            String gameId = playingGameInfo != null ? playingGameInfo.getGid() : "";
            String reportResult = (String)notification.extObj;
            this.requestSingleGameExcitationInfo(gameId, reportResult);
        }
    }

    private void showFloatingView(SingleGameExcitInfo excitInfo) {
        if (this.getCurrentWindow() == null || this.isFloatingViewShowing) {
            return;
        }
        int windowType = this.getCurrentWindow().getWindowType();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("current window type is: " + windowType), (Object[])new Object[0]);
        }
        if (windowType == 102) {
            return;
        }
        if (windowType == 103) {
            int overFriendSize;
            if (excitInfo == null) {
                return;
            }
            int floatingType = -1;
            int surpassedOrRankNum = 0;
            List<Long> overFriendList = excitInfo.overFriends;
            if (overFriendList != null && (overFriendSize = overFriendList.size()) > 0 && this.mOverFriend != overFriendSize) {
                floatingType = 0;
                surpassedOrRankNum = overFriendSize;
                this.mOverFriend = overFriendSize;
            }
            if (excitInfo.ranks > 0 && this.mRank != excitInfo.ranks && floatingType == -1) {
                floatingType = 1;
                surpassedOrRankNum = excitInfo.ranks;
                this.mRank = excitInfo.ranks;
            }
            if (excitInfo.overPeoples > 0 && floatingType == -1) {
                floatingType = 2;
                surpassedOrRankNum = excitInfo.overPeoples;
            }
            if (floatingType == -1 || surpassedOrRankNum == 0) {
                return;
            }
            this.mSingleGameFloatingView = new SingleGameFloatingView((Context)this.mContext);
            this.mSingleGameFloatingView.setSpannableStringAndBackground(floatingType, surpassedOrRankNum);
            if (floatingType == 0 && overFriendList != null) {
                this.getOverFriendsAvatarList(overFriendList);
            } else {
                this.addSingleFloatingView();
            }
        }
    }

    private void reportShow() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024337").put("gid", this.mGameId).put("function_id", "show_float_layer").put("page_id", "3").put("token", ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getAlgorithmTokenUrlencode()));
    }

    private void hideFloatingView() {
        if (this.mSingleGameFloatingView != null && this.mWindowMgr != null) {
            this.mSingleGameFloatingView.removeAnim();
            this.mWindowMgr.removeExtLayerContent((View)this.mSingleGameFloatingView);
            ((IGameAudioService)this.getServiceManager().getService(IGameAudioService.class)).stopAudio("singleGameExcitationShow");
            this.isFloatingViewShowing = false;
            this.mSingleGameFloatingView = null;
        }
    }

    private void addSingleFloatingView() {
        if (this.mSingleGameFloatingView == null || this.isFloatingViewShowing) {
            return;
        }
        this.mWindowMgr.addExtLayerContent((View)this.mSingleGameFloatingView);
        this.mSingleGameFloatingView.playEnterAnim();
        this.isFloatingViewShowing = true;
        ((IGameAudioService)this.getServiceManager().getService(IGameAudioService.class)).play("singleGameExcitationShow");
        YYTaskExecutor.postToMainThread((Runnable)this.mRemoveFloatingViewRunnable, (long)5000L);
        this.reportShow();
    }

    private void getOverFriendsAvatarList(List<Long> overFriendsUids) {
        if (overFriendsUids == null) {
            return;
        }
        IUserInfoService userInfoService = (IUserInfoService)this.getServiceManager().getService(IUserInfoService.class);
        if (userInfoService == null) {
            return;
        }
        final ArrayList friendsAvatarUrls = new ArrayList(4);
        userInfoService.getUserInfo(overFriendsUids, new OnProfileListCallback(){

            public void onUISuccess(List<UserInfoBean> userInfo) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)SingleGameFloatingController.TAG, (String)("get user info onUISuccess userInfo: " + userInfo), (Object[])new Object[0]);
                }
                if (userInfo != null) {
                    for (UserInfoBean userInfoBean : userInfo) {
                        String avatar = userInfoBean.getAvatar();
                        if (!StringUtils.isNotEmpty((String)avatar)) continue;
                        friendsAvatarUrls.add(avatar);
                    }
                    SingleGameFloatingController.this.addSingleFloatingView();
                    if (SingleGameFloatingController.this.mSingleGameFloatingView != null) {
                        SingleGameFloatingController.this.mSingleGameFloatingView.setSurpassedFriendAvatar(friendsAvatarUrls);
                    }
                }
            }

            public void onError(Call call, Exception e, int id2) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)SingleGameFloatingController.TAG, (String)("get user info onError: " + e), (Object[])new Object[0]);
                }
            }

            public void onResponseError(int id2, String message, String response) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)SingleGameFloatingController.TAG, (String)("get user info onResponseError: message = " + message + ",response = " + response), (Object[])new Object[0]);
                }
            }
        });
    }

    public void requestSingleGameExcitationInfo(String gameId, String result) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"[requestSingleGameExcitationInfo] gameId: %s, result: %s", (Object[])new Object[]{gameId, result});
        }
        if (StringUtils.isEmpty((String)gameId) || StringUtils.isEmpty((String)result)) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("gameId", gameId);
        params.put("result", result);
        this.mGameId = gameId;
        HttpUtil.httpReq((String)UriProvider.getSingleGameExcitationInfo(), params, (int)2, (INetRespCallback)new INetRespCallback<SingleGameExcitInfo>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)SingleGameFloatingController.TAG, (String)"[requestSingleGameExcitationInfo] onError exception: %s", (Object[])new Object[]{e.getMessage()});
            }

            public void onResponse(String response, BaseResponseBean<SingleGameExcitInfo> res, int id2) {
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)SingleGameFloatingController.TAG, (String)"[requestSingleGameExcitationInfo] onResponse response: %s", (Object[])new Object[]{response});
                }
                if (res != null && res.isSuccess() && res.data != null) {
                    if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)SingleGameFloatingController.TAG, (String)"[requestSingleGameExcitationInfo] onResponse res.data: %s", (Object[])new Object[]{res.data});
                    }
                    SingleGameFloatingController.this.mSingleGameExcitInfo = new SingleGameExcitInfo();
                    ((SingleGameFloatingController)SingleGameFloatingController.this).mSingleGameExcitInfo.overFriends = ((SingleGameExcitInfo)res.data).overFriends;
                    ((SingleGameFloatingController)SingleGameFloatingController.this).mSingleGameExcitInfo.ranks = ((SingleGameExcitInfo)res.data).ranks;
                    ((SingleGameFloatingController)SingleGameFloatingController.this).mSingleGameExcitInfo.toRank = ((SingleGameExcitInfo)res.data).toRank;
                    ((SingleGameFloatingController)SingleGameFloatingController.this).mSingleGameExcitInfo.overPeoples = ((SingleGameExcitInfo)res.data).overPeoples;
                    ((SingleGameFloatingController)SingleGameFloatingController.this).mSingleGameExcitInfo.actReward = ((SingleGameExcitInfo)res.data).actReward;
                    SingleGameFloatingController.this.showFloatingView(SingleGameFloatingController.this.mSingleGameExcitInfo);
                } else {
                    MLog.error((Object)SingleGameFloatingController.TAG, (String)"sorry,have not got anything from server.", (Object[])new Object[0]);
                }
            }
        });
    }
}

