/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.single.list;

import android.os.SystemClock;
import androidx.annotation.IntRange;
import com.yy.base.logger.MLog;

public class ActionInterval {
    private static final String TAG = "ActionInterval";
    long interval = 0L;
    long lastTimestamp = 0L;

    public ActionInterval(@IntRange(from=0L) int intervalMs) {
        this.interval = Math.max(0, intervalMs);
        if (intervalMs < 0) {
            MLog.error((Object)TAG, (String)"[ActionInterval] wrong interval: %d", (Object[])new Object[]{intervalMs});
        }
    }

    public boolean checkAction() {
        return SystemClock.uptimeMillis() - this.lastTimestamp >= this.interval;
    }

    public void markAction() {
        this.lastTimestamp = SystemClock.uptimeMillis();
    }
}

