/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.single.gameresult.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.os.Build;
import android.text.Html;
import android.text.Spanned;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.OvershootInterpolator;
import android.view.animation.TranslateAnimation;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.FloatRange;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.view.ViewCompat;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.press.ClickScaleAnimProvider;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.game.R;
import com.yy.game.gamemodule.simplegame.single.gameresult.ISingleGameResultUICallbacks;
import com.yy.game.gamemodule.simplegame.single.gameresult.ui.SingleGameResultRankView;
import com.yy.game.gamemodule.simplegame.single.model.SingleGameResultData;
import com.yy.game.gamemodule.simplegame.single.model.SingleGameResultRankItem;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SingleGameResultWindow
extends DefaultWindow {
    private static final String NEW_RECORD_SVGA = "single_game_result_new_record.svga";
    private static final String TAG = "SingleGameResultWindow";
    private static final long TIPS_TIME_OUT = 4000L;
    private ISingleGameResultUICallbacks mGameCallback;
    private View mBgTopGuideLine;
    private View mBgBottomGuideLine;
    private View mResultScoreBg;
    private SVGAImageView mResultSvga;
    private YYTextView mRecordTitleText;
    private YYTextView mResultScore;
    private YYTextView mResultBtnShare;
    private YYTextView mStageLabel;
    private YYTextView mBestOfTodayText;
    private YYTextView mResultBeatHistory;
    private ViewStub mResultRankStub;
    private SingleGameResultRankView mRankView;
    private ConstraintLayout mConstraintLayout;
    private ConstraintLayout mTopConstraintLayout;
    private YYTextView mPlayAgainBtn;
    private View mTipsLayout;
    private ImageView mTipsIcon;
    private TextView mTipsText;
    private View mShareLightAnimView;
    private View mShareLayout;
    private TranslateAnimation mLightAnim;
    private Set<View> mTopAnimViews = new HashSet<View>(4);
    private Set<View> mBottomAnimViews = new HashSet<View>(2);
    private static final int TOBE_ANIM_VISIBILITY = 0;
    private SingleGameResultData mGameData;
    private int mScreenHeight;

    public SingleGameResultWindow(Context context, ISingleGameResultUICallbacks callBacks) {
        super(context, (UICallBacks)callBacks, "SingleGameResult");
        this.setWindowType(102);
        this.mGameCallback = callBacks;
        this.mScreenHeight = ResolutionUtils.getScreenHeight((Context)this.getContext());
        this.createView();
        this.setNeedFullScreen(true);
    }

    private void createView() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.single_game_result_layout, this.getBaseLayer());
        this.mConstraintLayout = (ConstraintLayout)this.findViewById(R.id.constraint_layout);
        this.mTopConstraintLayout = (ConstraintLayout)this.findViewById(R.id.top_layout);
        this.mBgTopGuideLine = this.findViewById(R.id.top_guide_line);
        this.mBgBottomGuideLine = this.findViewById(R.id.result_score_bg_bottom_line);
        this.mResultScoreBg = this.findViewById(R.id.result_score_bg);
        this.mResultSvga = (SVGAImageView)this.findViewById(R.id.result_svga);
        this.mRecordTitleText = (YYTextView)this.findViewById(R.id.result_title);
        this.mResultScore = (YYTextView)this.findViewById(R.id.result_score);
        this.mResultBtnShare = (YYTextView)this.findViewById(R.id.result_btn_share);
        this.mShareLayout = this.findViewById(R.id.result_share_layout);
        ClickScaleAnimProvider.apply((View)this.mShareLayout);
        this.mStageLabel = (YYTextView)this.findViewById(R.id.result_stage);
        this.mBestOfTodayText = (YYTextView)this.findViewById(R.id.result_best_of_today);
        this.mBestOfTodayText.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.mResultBeatHistory = (YYTextView)this.findViewById(R.id.result_beat_history);
        this.mResultRankStub = (ViewStub)this.findViewById(R.id.result_rank_layout);
        this.mShareLightAnimView = this.findViewById(R.id.result_btn_light);
        this.mPlayAgainBtn = (YYTextView)this.findViewById(R.id.btn_again);
        ClickScaleAnimProvider.apply((View)this.mPlayAgainBtn);
        this.mPlayAgainBtn.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.mRecordTitleText.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.mResultScore.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.initListener();
    }

    private void initListener() {
        this.mShareLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SingleGameResultWindow.this.showShareView();
            }
        });
        this.findViewById(R.id.img_btn_back).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SingleGameResultWindow.this.mGameCallback != null) {
                    SingleGameResultWindow.this.mGameCallback.onBackClick();
                }
            }
        });
        this.mPlayAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SingleGameResultWindow.this.mGameCallback != null) {
                    SingleGameResultWindow.this.mGameCallback.playAgain();
                }
            }
        });
        this.findViewById(R.id.result_rank_daily_board_entry_bg).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)SingleGameResultWindow.TAG, (String)"mRankView onClick", (Object[])new Object[0]);
                }
                if (SingleGameResultWindow.this.mGameCallback != null) {
                    SingleGameResultWindow.this.mGameCallback.toRankList();
                }
            }
        });
    }

    public void update(SingleGameResultData data) {
        this.mTopAnimViews.add(this.findViewById(R.id.top_layout));
        this.mGameData = data;
        this.updateScoreBackground(data);
        this.updateHeaderUi(data);
        this.updateBestOfToday(data);
        this.updateBottomUi(data);
        this.startEnterAnim();
    }

    private void updateTipsUi(final SingleGameResultData data) {
        final String tipsText = this.getTipsText(data);
        if (StringUtils.isEmpty((String)tipsText)) {
            return;
        }
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                SingleGameResultWindow.this.showTipsView(tipsText, data);
            }
        }, 200L);
    }

    public void updateRankUi(SingleGameResultData data) {
        if (data == null) {
            return;
        }
        List<SingleGameResultRankItem> rankItems = data.ranks;
        if (rankItems == null || rankItems.isEmpty()) {
            return;
        }
        if (this.isInRank(data) && this.mRankView == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"show rank ui", (Object[])new Object[0]);
            }
            this.mRankView = (SingleGameResultRankView)this.mResultRankStub.inflate();
            this.mRankView.setAlpha(0.0f);
            ViewCompat.animate((View)this.mRankView).alpha(1.0f).start();
            this.setRankData(rankItems);
        }
    }

    private void updateHeaderUi(SingleGameResultData data) {
        boolean showRecord = this.canShowRecord(data);
        this.mRecordTitleText.setVisibility(showRecord ? 0 : 8);
        this.mShareLayout.setVisibility(showRecord ? 0 : 8);
        if (showRecord) {
            this.mRecordTitleText.setBackgroundResource(data.bestHistoryScore ? R.drawable.game_result_best_record : R.drawable.game_result_daily_new_record);
            this.mRecordTitleText.setText(data.bestHistoryScore ? R.string.game_result_best_record : R.string.game_result_new_record);
            SvgaLoader.load((SVGAImageView)this.mResultSvga, (String)NEW_RECORD_SVGA, (ISvgaLoadCallback)new ISvgaLoadCallback(){

                public void onFinished(SVGAVideoEntity entity) {
                    if (SingleGameResultWindow.this.mResultSvga != null) {
                        SingleGameResultWindow.this.mResultSvga.setVisibility(0);
                        SingleGameResultWindow.this.mResultSvga.startAnimation();
                    }
                }

                public void onFailed(Exception e) {
                    MLog.error((Object)SingleGameResultWindow.TAG, (Throwable)e);
                }
            });
        } else {
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.mResultScore.getLayoutParams();
            params.topMargin = ResolutionUtils.dip2Px((float)32.0f);
        }
        this.mShareLayout.setVisibility(showRecord ? 0 : 8);
        this.mResultScore.setText((CharSequence)String.valueOf(data.score));
        this.mResultBeatHistory.setText((CharSequence)ResourceUtils.getString((int)R.string.game_result_best_history, (Object[])new Object[]{data.bestHistory}));
        this.mStageLabel.setVisibility(showRecord ? 8 : 0);
        if (showRecord) {
            this.mShareLayout.setVisibility(0);
            this.mResultScore.setVisibility(0);
            this.mRecordTitleText.setVisibility(0);
        } else {
            this.mResultScore.setVisibility(0);
            this.mStageLabel.setVisibility(0);
        }
    }

    private void updateBestOfToday(SingleGameResultData data) {
        boolean hideBestOfToday = this.canShowRecord(data) || this.isInRank(data);
        this.mBestOfTodayText.setVisibility(hideBestOfToday ? 8 : 0);
        if (!hideBestOfToday) {
            Spanned text = Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)ResourceUtils.getString((int)R.string.game_result_best_of_today, (Object[])new Object[]{data.bestDay}), (int)0) : Html.fromHtml((String)ResourceUtils.getString((int)R.string.game_result_best_of_today, (Object[])new Object[]{data.bestDay}));
            this.mBestOfTodayText.setText((CharSequence)text);
            this.mBestOfTodayText.setVisibility(0);
        }
    }

    private void updateScoreBackground(SingleGameResultData data) {
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.mBgTopGuideLine.getLayoutParams();
        params.topMargin = this.getBgMarginTop(data);
        this.mBgTopGuideLine.requestLayout();
        View bottomTo = this.canShowRecord(data) ? this.mShareLayout : this.mBestOfTodayText;
        try {
            ConstraintSet constraintSet = new ConstraintSet();
            constraintSet.clone(this.mTopConstraintLayout);
            constraintSet.connect(this.mBgBottomGuideLine.getId(), 3, bottomTo.getId(), 4);
            constraintSet.applyTo(this.mTopConstraintLayout);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    private void updateBottomUi(SingleGameResultData data) {
        this.mResultBeatHistory.setText((CharSequence)ResourceUtils.getString((int)R.string.game_result_best_history, (Object[])new Object[]{data.bestHistory}));
        this.mBottomAnimViews.add((View)this.mPlayAgainBtn);
        this.mBottomAnimViews.add((View)this.mResultBeatHistory);
    }

    private void showShareView() {
        this.mGameCallback.onShareRecordBtnClick();
    }

    private void setRankData(List<SingleGameResultRankItem> ranks) {
        if (this.mRankView != null) {
            this.mRankView.setData(ranks);
        }
    }

    private void showTipsView(String tips, SingleGameResultData data) {
        if (this.mTipsLayout == null) {
            ViewStub tipsStub = (ViewStub)this.findViewById(R.id.result_tips);
            this.mTipsLayout = tipsStub.inflate();
            this.mTipsIcon = (ImageView)this.mTipsLayout.findViewById(R.id.result_tips_icon);
            this.mTipsText = (TextView)this.mTipsLayout.findViewById(R.id.result_tips_msg);
        }
        int[] location = new int[2];
        this.mTipsLayout.getLocationOnScreen(location);
        int translateY = ResolutionUtils.getScreenHeight((Context)this.getContext()) - location[1];
        this.mTipsLayout.setTranslationY((float)translateY);
        this.mTipsLayout.setVisibility(0);
        this.mTipsIcon.setImageResource(this.isInRank(data) ? R.drawable.single_game_ranked_icon : R.drawable.single_game_surpassed_icon);
        this.mTipsText.setText((CharSequence)tips);
        ViewCompat.animate((View)this.mTipsLayout).translationY(0.0f).setInterpolator((Interpolator)new FastOutSlowInInterpolator()).setDuration(500L).start();
        this.postDelayed(new HideTipsTask(this), 4000L);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024337").put("function_id", "show_float_layer").put("gid", data.gameId).put("page_id", "2").put("token", ServiceManagerProxy.getServiceManager() == null ? null : ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getAlgorithmTokenUrlencode()));
    }

    private void hideTips() {
        ViewCompat.animate((View)this.mTipsLayout).alpha(0.0f).setInterpolator((Interpolator)new LinearInterpolator()).setDuration(300L).start();
    }

    private int getBgMarginTop(SingleGameResultData data) {
        if (this.canShowRecord(data)) {
            return (int)(this.isInRank(data) ? (float)this.mScreenHeight * 0.15f : (float)this.mScreenHeight * 0.2f);
        }
        if (this.isInRank(data)) {
            return (int)((float)this.mScreenHeight * 0.1f);
        }
        return (int)((float)this.mScreenHeight * 0.25f);
    }

    private String getTipsText(SingleGameResultData data) {
        if (data == null) {
            return "";
        }
        if (data.globalRank != -1) {
            return "";
        }
        if (data.willInRank != 0) {
            return ResourceUtils.getString((int)R.string.game_result_tips_close_to_rank, (Object[])new Object[]{data.willInRank});
        }
        if (data.overPeople > 0) {
            return ResourceUtils.getString((int)R.string.game_result_tips_surpassed_people, (Object[])new Object[]{data.overPeople});
        }
        if (data.advances) {
            return ResourceUtils.getString((int)R.string.game_result_tips_make_progress);
        }
        return "";
    }

    private void startLightAnim(int animWidth) {
        this.mShareLightAnimView.setVisibility(0);
        this.mShareLightAnimView.setBackgroundResource(R.drawable.icon_game_invite_accept_light);
        this.mLightAnim = new TranslateAnimation(0.0f, (float)(animWidth + ResolutionUtils.dip2Px((float)80.0f)), 0.0f, 0.0f);
        this.mLightAnim.setFillAfter(false);
        this.mLightAnim.setRepeatCount(-1);
        this.mLightAnim.setDuration(500L);
        this.mLightAnim.setStartOffset(1000L);
        this.mShareLightAnimView.startAnimation((Animation)this.mLightAnim);
    }

    public void onDetached() {
        super.onDetached();
        if (this.mLightAnim != null) {
            this.mLightAnim.cancel();
        }
    }

    private void startEnterAnim() {
        ValueAnimator animator2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                for (View item : SingleGameResultWindow.this.mTopAnimViews) {
                    item.setAlpha(0.0f);
                    item.setTranslationY((float)(-item.getMeasuredHeight()));
                    item.setVisibility(0);
                }
                for (View item : SingleGameResultWindow.this.mBottomAnimViews) {
                    item.setAlpha(0.0f);
                    item.setTranslationY((float)item.getMeasuredHeight());
                    item.setVisibility(0);
                }
                SingleGameResultWindow.this.mResultScoreBg.setAlpha(0.0f);
                SingleGameResultWindow.this.mConstraintLayout.setVisibility(0);
            }

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                SingleGameResultWindow.this.onStartAnimEnd();
            }
        });
        animator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            private float lastAlphaValue = 0.0f;
            private final float minAlpha = 0.01f;

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                this.animTop(value);
                this.animBottom(value);
                this.animBackground(value);
            }

            private void animTop(@FloatRange(from=0.0, to=1.0) float value) {
                for (View item : SingleGameResultWindow.this.mTopAnimViews) {
                    item.setAlpha(value);
                    item.setTranslationY((float)(-item.getMeasuredHeight()) * (1.0f - value));
                }
            }

            private void animBottom(@FloatRange(from=0.0, to=1.0) float value) {
                for (View item : SingleGameResultWindow.this.mBottomAnimViews) {
                    item.setAlpha(value);
                    item.setTranslationY((float)item.getMeasuredHeight() * (1.0f - value));
                }
            }

            private void animBackground(@FloatRange(from=0.0, to=1.0) float value) {
                if (value - this.lastAlphaValue >= 0.01f) {
                    this.lastAlphaValue = value;
                    SingleGameResultWindow.this.mResultScoreBg.setAlpha(value);
                }
            }
        });
        animator2.setDuration(700L).setInterpolator((TimeInterpolator)new OvershootInterpolator());
        animator2.start();
    }

    private void onStartAnimEnd() {
        if (this.canShowRecord(this.mGameData)) {
            this.startLightAnim(this.mResultBtnShare.getWidth());
        }
        this.updateTipsUi(this.mGameData);
    }

    private boolean isInRank(SingleGameResultData data) {
        return data != null && data.globalRank != -1;
    }

    private boolean isNewRecord(SingleGameResultData data) {
        return data != null && !this.isBestCord(data) && data.bestDayScore;
    }

    private boolean isBestCord(SingleGameResultData data) {
        return data != null && data.bestHistoryScore;
    }

    private boolean canShowRecord(SingleGameResultData data) {
        return this.isBestCord(data) || this.isNewRecord(data);
    }

    private static class HideTipsTask
    implements Runnable {
        private WeakReference<SingleGameResultWindow> mTargetRef;

        HideTipsTask(SingleGameResultWindow target) {
            this.mTargetRef = new WeakReference<SingleGameResultWindow>(target);
        }

        @Override
        public void run() {
            SingleGameResultWindow target;
            if (this.mTargetRef != null && (target = (SingleGameResultWindow)((Object)this.mTargetRef.get())) != null) {
                target.hideTips();
            }
        }
    }
}

