/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.single.gameresult.ui;

import android.animation.LayoutTransition;
import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.game.R;
import com.yy.game.gamemodule.simplegame.single.gameresult.ui.SingleGameResultRankItemView;
import com.yy.game.gamemodule.simplegame.single.model.SingleGameResultRankItem;
import java.util.ArrayList;
import java.util.List;

public class SingleGameResultRankView
extends YYConstraintLayout {
    private SingleGameResultRankItemView mRankLeft;
    private SingleGameResultRankItemView mRankCenter;
    private SingleGameResultRankItemView mRankRight;
    private List<SingleGameResultRankItemView> mVisibleViews = new ArrayList<SingleGameResultRankItemView>(3);

    public SingleGameResultRankView(Context context) {
        super(context);
        this.createView();
    }

    public SingleGameResultRankView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView();
    }

    public SingleGameResultRankView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.createView();
    }

    private void createView() {
        SingleGameResultRankView.inflate((Context)this.getContext(), (int)R.layout.game_result_rank, (ViewGroup)this);
        this.setClipChildren(false);
        this.mRankLeft = (SingleGameResultRankItemView)this.findViewById(R.id.result_rank_1);
        this.mRankCenter = (SingleGameResultRankItemView)this.findViewById(R.id.result_rank_2);
        this.mRankRight = (SingleGameResultRankItemView)this.findViewById(R.id.result_rank_3);
    }

    public void setData(@Nullable List<SingleGameResultRankItem> rankItems) {
        if (rankItems == null || rankItems.isEmpty()) {
            return;
        }
        int size = rankItems.size();
        switch (size) {
            case 1: {
                this.mRankLeft.setVisibility(0);
                this.mRankLeft.setData(rankItems.get(0));
                break;
            }
            case 2: {
                this.setHorizonMargin();
                this.mRankLeft.setData(rankItems.get(0));
                this.mRankCenter.setData(rankItems.get(1));
                this.mRankLeft.setVisibility(4);
                this.mRankCenter.setVisibility(4);
                this.mVisibleViews.add(this.mRankLeft);
                this.mVisibleViews.add(this.mRankCenter);
                break;
            }
            case 3: {
                this.setHorizonMargin();
                this.mRankLeft.setData(rankItems.get(0));
                this.mRankCenter.setData(rankItems.get(1));
                this.mRankRight.setData(rankItems.get(2));
                this.mRankLeft.setVisibility(4);
                this.mRankCenter.setVisibility(4);
                this.mRankRight.setVisibility(4);
                this.mVisibleViews.add(this.mRankLeft);
                this.mVisibleViews.add(this.mRankCenter);
                this.mVisibleViews.add(this.mRankRight);
                break;
            }
        }
        this.startAnim();
    }

    private void setHorizonMargin() {
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.mRankLeft.getLayoutParams();
        params.leftMargin = ResolutionUtils.dip2Px((float)16.0f);
        this.mRankLeft.setLayoutParams((ViewGroup.LayoutParams)params);
        params = (ViewGroup.MarginLayoutParams)this.mRankRight.getLayoutParams();
        params.rightMargin = ResolutionUtils.dip2Px((float)16.0f);
        this.mRankRight.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void startAnim() {
        if (!FP.empty(this.mVisibleViews)) {
            this.setLayoutTransition(new LayoutTransition());
            for (SingleGameResultRankItemView item : this.mVisibleViews) {
                if (!item.isMe()) continue;
                item.setVisibility(0);
                item.setRankItemListener(new SingleGameResultRankItemView.IRankItemListener(){

                    @Override
                    public void onRankItemSvgaFinished() {
                        SingleGameResultRankView.this.setAllVisible();
                    }
                });
                break;
            }
        }
    }

    private void setAllVisible() {
        for (SingleGameResultRankItemView item : this.mVisibleViews) {
            item.setVisibility(0);
        }
    }
}

